//=======================================================================================
/**
 * @file wazawasure_Lower.cpp
 * @brief ZY(  )
 * @author obata_toshihiro
 * @date 2011.08.27
 */
//=======================================================================================
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include "wazawasure_Lower.h"

#include <message/msg_waza_wasure.h>
#include <arc/arc_def.h>
#include <arc/waza_wasure.gaix>
#include "waza_wasure_lower.h"
#include "waza_wasure_lower_pane.h"



namespace app {
  namespace wazawasure {



    // q[vTCY
    const u32 Lower::APP_HEAPSIZE = 0x1000;
    const u32 Lower::DEVICE_HEAPSIZE = 0x100000;

    // ľ
    const u32 Lower::LV_PLACE_COUNT = 3;
    const u32 Lower::PP_PLACE_COUNT = 2;



    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp Lower::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, -290, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),        // scale
      gfl::math::VEC3( 0, 0, 0 ),     // rotate
      1,                              // priority
    };



    // Aj[Vf[^e[u
    const gfl::grp::g2d::LytArcIndex Lower::ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUM ] = 
    {
      /* ANIMATION_DATA_STATUS_NORMAL */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_STATUS_NORMAL_BCLAN,
      /* ANIMATION_DATA_STATUS_MAHI */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_STATUS_MAHI_BCLAN,
      /* ANIMATION_DATA_STATUS_NEMURI */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_STATUS_NEMURI_BCLAN,
      /* ANIMATION_DATA_STATUS_KOORI */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_STATUS_KOORI_BCLAN,
      /* ANIMATION_DATA_STATUS_YAKEDO */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_STATUS_YAKEDO_BCLAN,
      /* ANIMATION_DATA_STATUS_DOKU */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_STATUS_DOKU_BCLAN,
      /* ANIMATION_DATA_STATUS_POKERUS */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_STATUS_POKERUS_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA0 */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_CURSOR_ON_WAZA0_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA1 */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_CURSOR_ON_WAZA1_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA2 */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_CURSOR_ON_WAZA2_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA3 */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_CURSOR_ON_WAZA3_BCLAN,
      /* ANIMATION_DATA_DUMMY_WAZATYPE */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_DUMMY_WAZATYPE_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_HOLD */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_DUMMY_BUTTON_HOLD_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_RELEASE */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_DUMMY_BUTTON_RELEASE_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_SELECT */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_DUMMY_BUTTON_SELECT_BCLAN,
      /* ANIMATION_DATA_UP_BUTTON_ACTIVE */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_UP_BUTTON_ACTIVE_BCLAN,
      /* ANIMATION_DATA_UP_BUTTON_PASSIVE */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_UP_BUTTON_PASSIVE_BCLAN,
      /* ANIMATION_DATA_DOWN_BUTTON_ACTIVE */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_DOWN_BUTTON_ACTIVE_BCLAN,
      /* ANIMATION_DATA_DOWN_BUTTON_PASSIVE */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_DOWN_BUTTON_PASSIVE_BCLAN,
      /* ANIMATION_DATA_SCENE_SELECT */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_SCENE_SELECT_BCLAN,
      /* ANIMATION_DATA_SCENE_CONFIRM */ LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_SCENE_CONFIRM_BCLAN,
    };



    // LAj[VƂ̐ݒ
    const Lower::ShareAnimationDesc Lower::SHARE_ANIMATION_DESC[ SHARE_ANIMATION_NUM ] = 
    {
      /* SHARE_ANIMATION_WAZATYPE */
      {
        ANIMATION_WAZATYPE,
        ANIMATION_DATA_DUMMY_WAZATYPE,
        WAZA_BUTTON_NUM,
        PANENAME_WAZA_WASURE_LOWER_GROUP_WAZATYPE,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_BUTTON_HOLD */ 
      {
        ANIMATION_BUTTON_HOLD,
        ANIMATION_DATA_DUMMY_BUTTON_HOLD, 
        TOTAL_BUTTON_NUM,
        PANENAME_WAZA_WASURE_LOWER_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_BUTTON_RELEASE */ 
      {
        ANIMATION_BUTTON_RELEASE,
        ANIMATION_DATA_DUMMY_BUTTON_RELEASE, 
        TOTAL_BUTTON_NUM,
        PANENAME_WAZA_WASURE_LOWER_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_BUTTON_SELECT */ 
      {
        ANIMATION_BUTTON_SELECT,
        ANIMATION_DATA_DUMMY_BUTTON_SELECT, 
        TOTAL_BUTTON_NUM,
        PANENAME_WAZA_WASURE_LOWER_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
    };




    // J[\ړf[^
    const tool::CursorManager::MOVE_DATA Lower::CURSOR_MOVE_DATA[ WAZA_BUTTON_NUM ] = 
    {
      /*   id              up                 down              left              right  */
      { WAZA_BUTTON_WAZA0,  { WAZA_BUTTON_WAZA0,  WAZA_BUTTON_WAZA1,  WAZA_BUTTON_WAZA0,  WAZA_BUTTON_WAZA0 } },
      { WAZA_BUTTON_WAZA1,  { WAZA_BUTTON_WAZA0,  WAZA_BUTTON_WAZA2,  WAZA_BUTTON_WAZA1,  WAZA_BUTTON_WAZA1 } },
      { WAZA_BUTTON_WAZA2,  { WAZA_BUTTON_WAZA1,  WAZA_BUTTON_WAZA3,  WAZA_BUTTON_WAZA2,  WAZA_BUTTON_WAZA2 } },
      { WAZA_BUTTON_WAZA3,  { WAZA_BUTTON_WAZA2,  WAZA_BUTTON_WAZA3,  WAZA_BUTTON_WAZA3,  WAZA_BUTTON_WAZA3 } },
    };





    // {^Ƃ̐ݒ( BUTTON_GROUP_WAZA )
    const Lower::ButtonDesc Lower::BUTTON_DESC_WAZA[ WAZA_BUTTON_NUM ] = 
    {
      /* WAZA_BUTTON_WAZA0 */ 
      {
        PANENAME_WAZA_WASURE_LOWER_PANE_W0_PLATE,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + WAZA_BUTTON_WAZA0 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + WAZA_BUTTON_WAZA0 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + WAZA_BUTTON_WAZA0 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA0,
      },
      /* WAZA_BUTTON_WAZA1 */ 
      {
        PANENAME_WAZA_WASURE_LOWER_PANE_W1_PLATE,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + WAZA_BUTTON_WAZA1 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + WAZA_BUTTON_WAZA1 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + WAZA_BUTTON_WAZA1 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA1,
      },
      /* WAZA_BUTTON_WAZA2 */ 
      {
        PANENAME_WAZA_WASURE_LOWER_PANE_W2_PLATE,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + WAZA_BUTTON_WAZA2 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + WAZA_BUTTON_WAZA2 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + WAZA_BUTTON_WAZA2 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA2,
      },
      /* WAZA_BUTTON_WAZA3 */ 
      {
        PANENAME_WAZA_WASURE_LOWER_PANE_W3_PLATE,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + WAZA_BUTTON_WAZA3 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + WAZA_BUTTON_WAZA3 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + WAZA_BUTTON_WAZA3 ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_CURSOR_ON_WAZA3,
      },
    };




    // {^Ƃ̐ݒ( BUTTON_GROUP_CONFIRM )
    const Lower::ButtonDesc Lower::BUTTON_DESC_CONFIRM[ Lower::CONFIRM_BUTTON_NUM ] = 
    {
      /* WAZA_BUTTON_FORGET */ 
      {
        PANENAME_WAZA_WASURE_LOWER_PANE_FORGET_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + WAZA_BUTTON_NUM + CONFIRM_BUTTON_FORGET ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + WAZA_BUTTON_NUM + CONFIRM_BUTTON_FORGET ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + WAZA_BUTTON_NUM + CONFIRM_BUTTON_FORGET ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_NULL,
      },
    };




    // {^Ƃ̐ݒ( BUTTON_GROUP_TOUCH )
    const Lower::ButtonDesc Lower::BUTTON_DESC_TOUCH[ TOUCH_BUTTON_NUM ] = 
    {
      /* TOUCH_BUTTON_UP */ 
      {
        PANENAME_WAZA_WASURE_LOWER_PANE_UP_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_UP ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_UP ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_UP ),
        ANIMATION_UP_BUTTON_ACTIVE,
        ANIMATION_UP_BUTTON_PASSIVE,
        ANIMATION_NULL,
      },
      /* TOUCH_BUTTON_DOWN */ 
      {
        PANENAME_WAZA_WASURE_LOWER_PANE_DOWN_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_DOWN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_DOWN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_DOWN ),
        ANIMATION_DOWN_BUTTON_ACTIVE,
        ANIMATION_DOWN_BUTTON_PASSIVE,
        ANIMATION_NULL,
      },
      /* TOUCH_BUTTON_RETURN */ 
      {
        PANENAME_WAZA_WASURE_LOWER_PANE_RETURN_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + WAZA_BUTTON_NUM + CONFIRM_BUTTON_NUM + TOUCH_BUTTON_RETURN ),
        ANIMATION_NULL,
        ANIMATION_NULL,
        ANIMATION_NULL,
      },
    };





    // Z{^Ƃ̐ݒ
    const Lower::WazaButtonDesc Lower::WAZA_BUTTON_DESC[ Lower::WAZA_BUTTON_NUM ] =
    {
      /* WAZA_BUTTON_WAZA0 */
      {
        0,
        PANENAME_WAZA_WASURE_LOWER_PANE_W0_NAME_VALUE,
        PANENAME_WAZA_WASURE_LOWER_PANE_W0_MAX_PP_VALUE,
        PANENAME_WAZA_WASURE_LOWER_PANE_W0_PP_VALUE,
        static_cast<AnimationIndex>( ANIMATION_WAZATYPE + WAZA_BUTTON_WAZA0 ),
      },
      /* WAZA_BUTTON_WAZA1 */
      {
        1,
        PANENAME_WAZA_WASURE_LOWER_PANE_W1_NAME_VALUE,
        PANENAME_WAZA_WASURE_LOWER_PANE_W1_MAX_PP_VALUE,
        PANENAME_WAZA_WASURE_LOWER_PANE_W1_PP_VALUE,
        static_cast<AnimationIndex>( ANIMATION_WAZATYPE + WAZA_BUTTON_WAZA1 ),
      },
      /* WAZA_BUTTON_WAZA2 */
      {
        2,
        PANENAME_WAZA_WASURE_LOWER_PANE_W2_NAME_VALUE,
        PANENAME_WAZA_WASURE_LOWER_PANE_W2_MAX_PP_VALUE,
        PANENAME_WAZA_WASURE_LOWER_PANE_W2_PP_VALUE,
        static_cast<AnimationIndex>( ANIMATION_WAZATYPE + WAZA_BUTTON_WAZA2 ),
      },
      /* WAZA_BUTTON_WAZA3 */
      {
        3,
        PANENAME_WAZA_WASURE_LOWER_PANE_W3_NAME_VALUE,
        PANENAME_WAZA_WASURE_LOWER_PANE_W3_MAX_PP_VALUE,
        PANENAME_WAZA_WASURE_LOWER_PANE_W3_PP_VALUE,
        static_cast<AnimationIndex>( ANIMATION_WAZATYPE + WAZA_BUTTON_WAZA3 ),
      },
    };





    // {bNX}[ÑyC
    const gfl::grp::g2d::LytPaneIndex Lower::BOXMARK_PANE[ pml::pokepara::BOX_MARK_NUM ] = 
    {
      PANENAME_WAZA_WASURE_LOWER_PANE_BOX_MARK_00,
      PANENAME_WAZA_WASURE_LOWER_PANE_BOX_MARK_01,
      PANENAME_WAZA_WASURE_LOWER_PANE_BOX_MARK_02,
      PANENAME_WAZA_WASURE_LOWER_PANE_BOX_MARK_03,
      PANENAME_WAZA_WASURE_LOWER_PANE_BOX_MARK_04,
      PANENAME_WAZA_WASURE_LOWER_PANE_BOX_MARK_05,
    };



    // ԈُɑΉAj[Vԍ
    const Lower::AnimationIndex Lower::SICK_ANIMATION[ pml::pokepara::SICK_MAX ] =
    {
      ANIMATION_STATUS_NORMAL,
      ANIMATION_STATUS_MAHI,
      ANIMATION_STATUS_NEMURI,
      ANIMATION_STATUS_KOORI,
      ANIMATION_STATUS_YAKEDO,
      ANIMATION_STATUS_DOKU,
    };






    //---------------------------------------------------------------------------------
    // RXgN^
    //---------------------------------------------------------------------------------
    Lower::Lower( 
        gfl::heap::HeapBase* parent_heap,
        gfl::heap::HeapBase* parent_device_heap, 
        gfl::grp::g2d::LytSys* layout_system, 
        const pml::pokepara::PokemonParam* pokeparam ) : 
      Base( 
          parent_heap, HEAPID_WAZAWASURE_UPPER, APP_HEAPSIZE,
          parent_device_heap, HEAPID_WAZAWASURE_UPPER_DEVICE, DEVICE_HEAPSIZE,
          layout_system, pokeparam ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 ),
      m_button_manager(),
      m_cursor_manager( NULL ),
      m_result( RESULT_NULL ),
      m_seq( SEQ_SELECT_WAIT ),
      m_next_seq( SEQ_SELECT_WAIT ),
      m_wait_animation_index( ANIMATION_NULL )
    {
      for( u8 i=0; i<BUTTON_GROUP_NUM; i++ ) {
        m_button_manager[i] = NULL;
      }
      this->CreateLayoutWork();
      this->CreateShareAnimation();
      this->CreateCursorManager();
      this->CreateButtonManager();
      this->SetupButtonManager();
      this->InitializeCursorPos(); 
      this->SetupDisplay();

#if 1 // q[vcʃ`FbN
      gfl::heap::HeapBase* app_heap = this->GetHeap();
      gfl::heap::HeapBase* dev_heap = this->GetDeviceHeap();
      GFL_PRINT( "HEAPID_WAZAWASURE_UPPER: 0x%x/0x%x, 0x%x/0x%x\n", 
          app_heap->GetTotalFreeSize(), app_heap->GetTotalSize(),
          dev_heap->GetTotalFreeSize(), dev_heap->GetTotalSize() );
#endif
    }



    // CAEg[N𐶐
    void Lower::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( ARCID_WAZAWASURE, heap );
      m_layout_resource_id = layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_waza_wasure_waza_wasure_lower_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id,
          LYTRES_WAZA_WASURE_LOWER_WAZA_WASURE_LOWER_BCLYT,
          ANIMATION_DATA_TABLE, ANIMATION_DATA_NUM, ANIMATION_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ

      m_layout_work->SetAutoDrawFlag( false );  // ōXV, `悷
    }



    // VFAAj[V𐶐
    void Lower::CreateShareAnimation( void )
    {
      for( u32 i=0; i<SHARE_ANIMATION_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIMATION_DESC[i].start_animation_index,
            ANIMATION_DATA_TABLE[ SHARE_ANIMATION_DESC[i].animation_data_index ],
            SHARE_ANIMATION_DESC[i].max_share_num,
            SHARE_ANIMATION_DESC[i].share_group_index,
            SHARE_ANIMATION_DESC[i].share_pane_index );
      }
    }



    // J[\}l[W𐶐
    void Lower::CreateCursorManager( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_cursor_manager = GFL_NEW( heap ) 
        ::app::tool::CursorManager( CURSOR_MOVE_DATA, WAZA_BUTTON_NUM, heap, 0 );
    }



    // {^}l[W𐶐
    void Lower::CreateButtonManager( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap(); 
      const gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      m_button_manager[ BUTTON_GROUP_WAZA ] = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, WAZA_BUTTON_NUM, ANIMATION_NULL );
      m_button_manager[ BUTTON_GROUP_CONFIRM ] = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, CONFIRM_BUTTON_NUM, ANIMATION_NULL );
      m_button_manager[ BUTTON_GROUP_TOUCH ] = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, TOUCH_BUTTON_NUM, ANIMATION_NULL );
    }


    // {^}l[W̃ZbgAbv
    void Lower::SetupButtonManager( void )
    {
      for( u32 i=0; i<WAZA_BUTTON_NUM; i++ ) {
        WazaButtonIndex button_index = static_cast<WazaButtonIndex>(i);
        const ButtonDesc& desc = BUTTON_DESC_WAZA[i];
        m_button_manager[ BUTTON_GROUP_WAZA ]->AddButton( 
            this->GetHeap(), 
            i,  // ID ̓{^̃CfbNX
            m_layout_work,
            desc.pane_index,
            desc.hold_animation,
            desc.release_animation,
            desc.select_animation,
            desc.active_animation,
            desc.passive_animation,
            NULL );  // R[obNȂ
      }

      for( u32 i=0; i<CONFIRM_BUTTON_NUM; i++ ) {
        WazaButtonIndex button_index = static_cast<WazaButtonIndex>(i);
        const ButtonDesc& desc = BUTTON_DESC_CONFIRM[i];
        m_button_manager[ BUTTON_GROUP_CONFIRM ]->AddButton( 
            this->GetHeap(), 
            i,  // ID ̓{^̃CfbNX
            m_layout_work,
            desc.pane_index,
            desc.hold_animation,
            desc.release_animation,
            desc.select_animation,
            desc.active_animation,
            desc.passive_animation,
            NULL );  // R[obNȂ
      }

      for( u32 i=0; i<TOUCH_BUTTON_NUM; i++ ) {
        TouchButtonIndex button_index = static_cast<TouchButtonIndex>(i);
        const ButtonDesc& desc = BUTTON_DESC_TOUCH[i];
        m_button_manager[ BUTTON_GROUP_TOUCH ]->AddButton( 
            this->GetHeap(), 
            i,  // ID ̓{^̃CfbNX
            m_layout_work,
            desc.pane_index,
            desc.hold_animation,
            desc.release_animation,
            desc.select_animation,
            desc.active_animation,
            desc.passive_animation,
            NULL );  // R[obNȂ
      }
    }



    // J[\ʒu
    void Lower::InitializeCursorPos( void )
    {
      WazaButtonIndex cursor_pos = WAZA_BUTTON_WAZA0;
      m_cursor_manager->SetPos( cursor_pos );
      this->StartAnimation( m_layout_work, BUTTON_DESC_WAZA[ cursor_pos ].cursor_animation );
    }






    // \XV
    void Lower::SetupDisplay( void )
    {
      const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam();
      this->SetupParamDisplay_Name( pokeparam );
      this->SetupParamDisplay_Sex( pokeparam );
      this->SetupParamDisplay_Level( pokeparam );
      this->SetupParamDisplay_Status( pokeparam );
      this->SetupParamDisplay_Item( pokeparam );
      this->SetupParamDisplay_BoxMark( pokeparam );
      this->SetupParamDisplay_RareIcon( pokeparam );
      this->SetupParamDisplay_AntiPokerusIcon( pokeparam );
      for( u8 i=0; i<WAZA_BUTTON_NUM; i++ ) {
        this->SetupWazaButtonDisplay( static_cast<WazaButtonIndex>(i), pokeparam );
      }
      this->SetStrings();
    }


    // O̕\XV
    void Lower::SetupParamDisplay_Name( const pml::pokepara::PokemonParam* pokeparam )
    {
      gfl::str::StrBuf* temp_buf = this->GetTempStrBuf();
      pokeparam->GetNickName( temp_buf );
      this->SetTextboxPaneString( m_layout_work, 
          PANENAME_WAZA_WASURE_LOWER_PANE_NICKNAME_VALUE, temp_buf );
    }


    // ʂ̕\XV
    void Lower::SetupParamDisplay_Sex( const pml::pokepara::PokemonParam* pokeparam )
    {
      pml::Sex sex = pokeparam->GetSex();
      this->SetTextboxPaneSex( 
          m_layout_work, PANENAME_WAZA_WASURE_LOWER_PANE_SEX_VALUE, sex ); 
    }


    // x̕\XV
    void Lower::SetupParamDisplay_Level( const pml::pokepara::PokemonParam* pokeparam )
    {
      u32 level = pokeparam->GetLevel();
      this->SetTextboxPaneNumber( 
          m_layout_work, PANENAME_WAZA_WASURE_LOWER_PANE_LEVEL_VALUE, level, LV_PLACE_COUNT );
    }


    // Xe[^XACR̕\XV
    void Lower::SetupParamDisplay_Status( const pml::pokepara::PokemonParam* pokeparam )
    {
      AnimationIndex anime = ANIMATION_NULL;
      if( pokeparam->HavePokerusJustNow() ) {
        anime = ANIMATION_STATUS_POKERUS;  // Ԉُł|PXD
      }
      else {
        pml::pokepara::Sick sick = pokeparam->GetSick();
        anime = SICK_ANIMATION[ sick ];
      }
      this->StartAnimation( m_layout_work, anime );
    }


    // ACe̕\XV
    void Lower::SetupParamDisplay_Item( const pml::pokepara::PokemonParam* pokeparam )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::str::StrBuf* temp_buf = this->GetTempStrBuf();

      u16 itemno = pokeparam->GetParam( pml::pokepara::PARAM_ID_item );
      if( ITEM_DATA_MAX < itemno ) { itemno = 0; }
      item::ITEM_DATA item_data( itemno, heap );

      item_data.ITEM_GetItemName( temp_buf, heap );
      this->SetTextboxPaneString( m_layout_work, 
          PANENAME_WAZA_WASURE_LOWER_PANE_ITEM_NAME, temp_buf );

      item_data.ITEM_GetInfo( temp_buf, heap );
      this->SetTextboxPaneString( m_layout_work, 
          PANENAME_WAZA_WASURE_LOWER_PANE_ITEM_VALUE, temp_buf );
    }


    // {bNX}[N̕\XV
    void Lower::SetupParamDisplay_BoxMark( const pml::pokepara::PokemonParam* pokeparam )
    {
      u32 boxmark_value = pokeparam->GetParam( pml::pokepara::PARAM_ID_box_mark );
      for( u32 i=0; i<pml::pokepara::BOX_MARK_NUM; i++ ) {
        u32 check_bit = 1 << i;
        bool visibility = ( ( boxmark_value & check_bit ) != 0 );
        this->SetPaneVisibility( m_layout_work, BOXMARK_PANE[i], visibility );
      }
    }


    // AACR̕\XV
    void Lower::SetupParamDisplay_RareIcon( const pml::pokepara::PokemonParam* pokeparam )
    {
      bool is_rare = pokeparam->IsRare();
      this->SetPaneVisibility( 
          m_layout_work, PANENAME_WAZA_WASURE_LOWER_PANE_RARE_ICON, is_rare );
    }


    // |PXR̃ACR̕\XV
    void Lower::SetupParamDisplay_AntiPokerusIcon( const pml::pokepara::PokemonParam* pokeparam )
    {
      bool icon_visibility = pokeparam->HavePokerusUntilNow();
      this->SetPaneVisibility( 
          m_layout_work, PANENAME_WAZA_WASURE_LOWER_PANE_ANTI_POKERUS_ICN, icon_visibility );
    }




    // Z{^̕\XV
    void Lower::SetupWazaButtonDisplay( 
        WazaButtonIndex button_index, const pml::pokepara::PokemonParam* pokeparam )
    {
      this->SetupWazaButtonDisplay_Name( button_index, pokeparam );
      this->SetupWazaButtonDisplay_Type( button_index, pokeparam );
      this->SetupWazaButtonDisplay_PP( button_index, pokeparam );
    }


    // Z̕\XV
    void Lower::SetupWazaButtonDisplay_Name( 
        WazaButtonIndex button_index, const pml::pokepara::PokemonParam* pokeparam )
    {
      gfl::str::StrBuf* temp_buf = this->GetTempStrBuf();
      u8 waza_index = WAZA_BUTTON_DESC[ button_index ].waza_index;
      WazaNo wazano = pokeparam->GetWazaNo( waza_index );
      pml::System::WazaDataSystem()->GetWazaName( wazano, temp_buf );
      this->SetTextboxPaneString( 
          m_layout_work, WAZA_BUTTON_DESC[ button_index ].name_pane, temp_buf );
    }


    // Z^Cv̕\XV
    void Lower::SetupWazaButtonDisplay_Type( 
        WazaButtonIndex button_index, const pml::pokepara::PokemonParam* pokeparam )
    {
      u8 waza_index = WAZA_BUTTON_DESC[ button_index ].waza_index;
      WazaNo wazano = pokeparam->GetWazaNo( waza_index );
      pml::PokeType type = pml::System::WazaDataSystem()->GetType( wazano );
      AnimationIndex anime = WAZA_BUTTON_DESC[ button_index ].type_animation;
      this->StartAnimation( m_layout_work, anime );
      this->PauseAnimation( m_layout_work, anime, false );
      this->SetAnimationFrame( m_layout_work, anime, type );
    }


    // PPl̕\XV
    void Lower::SetupWazaButtonDisplay_PP( 
        WazaButtonIndex button_index, const pml::pokepara::PokemonParam* pokeparam )
    {
      u8 waza_index = WAZA_BUTTON_DESC[ button_index ].waza_index;
      u8 max_pp = pokeparam->GetWazaMaxPP( waza_index );
      u8 now_pp = pokeparam->GetWazaPP( waza_index );
      this->SetTextboxPaneNumber( m_layout_work, 
          WAZA_BUTTON_DESC[ button_index ].max_pp_pane, max_pp, PP_PLACE_COUNT );
      this->SetTextboxPaneNumber( m_layout_work, 
          WAZA_BUTTON_DESC[ button_index ].now_pp_pane, now_pp, PP_PLACE_COUNT );
    }




    // e탁bZ[WZbg
    void Lower::SetStrings( void )
    {
      this->SetTextboxPaneMessage( 
          m_layout_work, PANENAME_WAZA_WASURE_LOWER_PANE_FORGET_LABEL, STR_WW_FORGET );
    }





    //---------------------------------------------------------------------------------
    // fXgN^
    //---------------------------------------------------------------------------------
    Lower::~Lower()
    {
      this->DeleteCursorManager();
      this->DeleteButtonManager();
      this->DeleteLayoutWork();
    } 


    // J[\}l[Wj
    void Lower::DeleteCursorManager( void )
    {
      if( m_cursor_manager ) {
        GFL_DELETE m_cursor_manager;
      }
    }


    // {^}l[Wj
    void Lower::DeleteButtonManager( void )
    {
      for( u8 i=0; i<BUTTON_GROUP_NUM; i++ ) {
        if( m_button_manager[i] ) {
          GFL_DELETE m_button_manager[i];
        }
      }
    }


    // CAEg[Nj
    void Lower::DeleteLayoutWork( void )
    {
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();
      layout_system->RemoveLytWk( m_layout_work );
      layout_system->ReleaseLytRes( m_layout_resource_id );
    }










    //---------------------------------------------------------------------------------
    // `揈
    //---------------------------------------------------------------------------------
    void Lower::Draw( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      gfl::grp::RenderTarget* lower_frame_buffer = 
        graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
      m_layout_work->Draw( graphics_system, gfl::grp::DISPLAY_LOWER, lower_frame_buffer );
    }







    //---------------------------------------------------------------------------------
    // 쌋ʂ擾
    //---------------------------------------------------------------------------------
    Lower::Result Lower::GetResult( void ) const
    {
      return m_result;
    } 



    //---------------------------------------------------------------------------------
    // XV
    //---------------------------------------------------------------------------------
    void Lower::Update( void )
    {
      for( u8 i=0; i<BUTTON_GROUP_NUM; i++ ) {
        m_button_manager[i]->Update();
      }
      m_layout_work->Update();
      this->UpdateSequence();
    } 



    // V[PX
    void Lower::UpdateSequence( void )
    {
      const gfl::ui::Button* ui_button = 
        this->GetUiDeviceManager()->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );

      switch( m_seq )
      {
      case SEQ_SELECT_WAIT:
        if( this->IsButtonSelected( BUTTON_GROUP_WAZA ) ) {
          WazaButtonIndex selected_button = this->GetSelectedButton();
          if( this->IsSelectEnable( selected_button ) ) {
            this->CursorMoveTo( selected_button );
            this->ChangeSeq( SEQ_CONFIRM_WAIT );
          }
        }
        else if( this->IsButtonSelected( BUTTON_GROUP_TOUCH ) ) {
          TouchButtonIndex selected_button = this->GetSelectedTouchButton();
          if( this->IsSelectEnable( selected_button ) ) {
            switch( selected_button ) {
            case TOUCH_BUTTON_UP:  // ^b`
              this->CursorMoveUp();
              break;
            case TOUCH_BUTTON_DOWN:  // ^b`
              this->CursorMoveDown();
              break;
            case TOUCH_BUTTON_RETURN:  //u߂v{^^b`
              m_result = RESULT_CANCEL;
              m_wait_animation_index = BUTTON_DESC_TOUCH[ TOUCH_BUTTON_RETURN ].select_animation;
              this->ChangeSeq( SEQ_ANIME_WAIT, SEQ_FINISH );
              break;
            }
          }
        }
        else if( this->IsButtonHolding( BUTTON_GROUP_WAZA ) ||
            this->IsButtonHolding( BUTTON_GROUP_TOUCH ) ) {
          // do nothing
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
          WazaButtonIndex selected_button = this->GetCurrentCursorPos();
          if( this->IsSelectEnable( selected_button ) ) {
            this->ChangeSeq( SEQ_CONFIRM_WAIT );
          }
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_B ) ) {
          m_result = RESULT_CANCEL;
          m_wait_animation_index = BUTTON_DESC_TOUCH[ TOUCH_BUTTON_RETURN ].select_animation;
          this->StartAnimation( m_layout_work, m_wait_animation_index );
          this->ChangeSeq( SEQ_ANIME_WAIT, SEQ_FINISH );
        }
        else if( this->UpdateCursorMove() ) {  // \L[ŃJ[\ړ
          WazaButtonIndex old_pos = this->GetPrevCursorPos();
          WazaButtonIndex new_pos = this->GetCurrentCursorPos();
          this->StartCursorMoveAnimation( old_pos, new_pos );
          this->OnCursorMoved( old_pos, new_pos );
        }
        break;


      case SEQ_CONFIRM_WAIT:
        if( this->IsButtonSelected( BUTTON_GROUP_CONFIRM ) ) {
          m_result = RESULT_SELECT;
          m_wait_animation_index = BUTTON_DESC_CONFIRM[ CONFIRM_BUTTON_FORGET ].select_animation;
          this->ChangeSeq( SEQ_ANIME_WAIT, SEQ_FINISH );
        }
        else if( this->IsButtonHolding( BUTTON_GROUP_CONFIRM ) ) {
          // do nothing
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
          m_result = RESULT_SELECT;
          m_wait_animation_index = BUTTON_DESC_CONFIRM[ CONFIRM_BUTTON_FORGET ].select_animation;
          this->StartAnimation( m_layout_work, m_wait_animation_index );
          this->ChangeSeq( SEQ_ANIME_WAIT, SEQ_FINISH );
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_B ) ) {
          this->ChangeSeq( SEQ_SELECT_WAIT );
        }
        break;


      case SEQ_ANIME_WAIT:
        if( this->IsAnimationFinished() ) {
          this->ChangeSeq( m_next_seq );
        }
        break;


      default:
        GFL_ASSERT(0);
        // fall through

      case SEQ_FINISH:
        GFL_ASSERT( this->GetResult() != RESULT_NULL );
        this->SetFinishFlag();
        break; 
      }
    }





    // V[PXύX
    void Lower::ChangeSeq( Sequence seq, Sequence next_seq )
    {
      switch( seq ) {
      case SEQ_SELECT_WAIT:
        m_button_manager[ BUTTON_GROUP_WAZA ]->SetButtonActive( WAZA_BUTTON_WAZA0 );
        m_button_manager[ BUTTON_GROUP_WAZA ]->SetButtonActive( WAZA_BUTTON_WAZA1 );
        m_button_manager[ BUTTON_GROUP_WAZA ]->SetButtonActive( WAZA_BUTTON_WAZA2 );
        m_button_manager[ BUTTON_GROUP_WAZA ]->SetButtonActive( WAZA_BUTTON_WAZA3 );
        this->StopAnimation( m_layout_work, ANIMATION_SCENE_CONFIRM );
        this->StartAnimation( m_layout_work, ANIMATION_SCENE_SELECT );
        break;
      case SEQ_CONFIRM_WAIT:
        this->StopAnimation( m_layout_work, ANIMATION_SCENE_SELECT );
        this->StartAnimation( m_layout_work, ANIMATION_SCENE_CONFIRM );
        break;
      }
      m_seq = seq;
      m_next_seq = next_seq;
    }





    // {^Ă邩ǂ𒲂ׂ
    bool Lower::IsButtonHolding( ButtonGroup button_group ) const
    {
      return m_button_manager[ button_group ]->IsButtonHolding();
    }

    // {^Iꂽǂ𒲂ׂ
    bool Lower::IsButtonSelected( ButtonGroup button_group ) const
    {
      return m_button_manager[ button_group ]->IsButtonSelected();
    }

    // Iꂽ{^擾
    Lower::WazaButtonIndex Lower::GetSelectedButton( void ) const
    {
      return static_cast<WazaButtonIndex>( 
          m_button_manager[ BUTTON_GROUP_WAZA ]->GetSelectedButtonId() );
    }

    // Iꂽ^b`{^擾
    Lower::TouchButtonIndex Lower::GetSelectedTouchButton( void ) const
    {
      return static_cast<TouchButtonIndex>( 
          m_button_manager[ BUTTON_GROUP_TOUCH ]->GetSelectedButtonId() );
    }




    // {^I\ǂ𒲂ׂ
    bool Lower::IsSelectEnable( WazaButtonIndex button_index ) const
    {
      return m_button_manager[ BUTTON_GROUP_WAZA ]->IsButtonActive( button_index );
    }

    // {^I\ǂ𒲂ׂ
    bool Lower::IsSelectEnable( TouchButtonIndex button_index ) const
    {
      return m_button_manager[ BUTTON_GROUP_TOUCH ]->IsButtonActive( button_index );
    }







    // J[\ֈړ
    void Lower::CursorMoveUp( void )
    {
      WazaButtonIndex old_pos = this->GetCurrentCursorPos();
      WazaButtonIndex new_pos = static_cast<WazaButtonIndex>( 
          ( old_pos + WAZA_BUTTON_NUM - 1 ) % WAZA_BUTTON_NUM );
      this->CursorMoveTo( new_pos );
    }


    // J[\ֈړ
    void Lower::CursorMoveDown( void )
    {
      WazaButtonIndex old_pos = this->GetCurrentCursorPos();
      WazaButtonIndex new_pos = static_cast<WazaButtonIndex>( ( old_pos + 1 ) % WAZA_BUTTON_NUM );
      this->CursorMoveTo( new_pos );
    }


    // J[\ړ
    void Lower::CursorMoveTo( WazaButtonIndex new_pos )
    {
      WazaButtonIndex old_pos = this->GetCurrentCursorPos();
      m_cursor_manager->SetPos( new_pos );
      this->StartCursorMoveAnimation( old_pos, new_pos );
      this->OnCursorMoved( old_pos, new_pos );
    }


    // J[\ړۂ̏
    void Lower::OnCursorMoved( WazaButtonIndex old_pos, WazaButtonIndex new_pos )
    {
      if( new_pos == WAZA_BUTTON_WAZA0 ) {
        m_button_manager[ BUTTON_GROUP_TOUCH ]->SetButtonPassive( TOUCH_BUTTON_UP );
      }
      else {
        m_button_manager[ BUTTON_GROUP_TOUCH ]->SetButtonActive( TOUCH_BUTTON_UP );
      }

      if( new_pos == WAZA_BUTTON_WAZA3 ) {
        m_button_manager[ BUTTON_GROUP_TOUCH ]->SetButtonPassive( TOUCH_BUTTON_DOWN );
      }
      else {
        m_button_manager[ BUTTON_GROUP_TOUCH ]->SetButtonActive( TOUCH_BUTTON_DOWN );
      }
    }


    // J[\ړAj[V
    void Lower::StartCursorMoveAnimation( WazaButtonIndex old_pos, WazaButtonIndex new_pos )
    {
      const ButtonDesc& old_desc = BUTTON_DESC_WAZA[ old_pos ];
      const ButtonDesc& new_desc = BUTTON_DESC_WAZA[ new_pos ];
      this->StopAnimation( m_layout_work, old_desc.cursor_animation );
      this->StartAnimation( m_layout_work, new_desc.cursor_animation );
    } 


    // ݂̃J[\ʒu擾
    Lower::WazaButtonIndex Lower::GetCurrentCursorPos( void ) const
    {
      return static_cast<WazaButtonIndex>( m_cursor_manager->GetID() );
    } 


    // ÕJ[\ʒu擾
    Lower::WazaButtonIndex Lower::GetPrevCursorPos( void ) const
    {
      return static_cast<WazaButtonIndex>( m_cursor_manager->GetOldID() );
    } 


    // J[\̓XV
    bool Lower::UpdateCursorMove( void )
    {
      ::app::tool::CursorManager::MOVE_RET move_result = m_cursor_manager->MainTrigger();
      return( move_result == ::app::tool::CursorManager::RET_MOVE ); // ړǂ
    } 






    // ҂Aj[VIǂ𒲂ׂ
    bool Lower::IsAnimationFinished( void ) const
    {
      if( m_wait_animation_index < ANIMATION_NUM ) {
        return m_layout_work->IsAnimeEnd( m_wait_animation_index );
      }
      return true;  // Aj[Vo^ȂIƂɂ
    }



  }  // namespace wazawasure
}  // namespace app 
