//=================================================================================================
/**
 * @file wazawasure_Base.h
 * @brief ZYʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.08.28
 */
//=================================================================================================
#ifndef __WAZAWASUREBASE_H__
#define __WAZAWASUREBASE_H__
#include <gflib.h>
#include <pmlib.h>


namespace app { 
  namespace wazawasure {


    class Base
    {
      GFL_FORBID_COPY_AND_ASSIGN( Base );  // Rs[֎~

      public:
      Base( 
          gfl::heap::HeapBase* parent_heap,
          gfl::heap::HEAPID app_heap_id, u32 app_heap_size, 
          gfl::heap::HeapBase* parent_device_heap, 
          gfl::heap::HEAPID device_heap_id, u32 device_heap_size,
          gfl::grp::g2d::LytSys* layout_system,
          const pml::pokepara::PokemonParam* poke_param );
      virtual ~Base();
      virtual void Update( void ) = 0;
      virtual void Draw( void ) = 0;
      bool IsFinished( void ) const;


      protected:
      gfl::heap::HeapBase* GetHeap( void ) const;
      gfl::heap::HeapBase* GetDeviceHeap( void ) const;
      gfl::heap::NwAllocator* GetNwAllocator( void ) const;
      gfl::heap::NwAllocator* GetNwDeviceAllocator( void ) const;
      gfl::grp::GraphicsSystem* GetGraphicsSystem( void ) const;
      gfl::grp::g2d::LytSys* GetLayoutSystem( void ) const;
      gfl::ui::DeviceManager* GetUiDeviceManager( void ) const; 
      const pml::pokepara::PokemonParam* GetPokeParam( void ) const;
      void SetFinishFlag( void );
      void ResetFinishFlag( void );


      private:
      void CreateHeap( 
          gfl::heap::HeapBase* parent_heap, 
          gfl::heap::HEAPID app_heap_id, u32 app_heap_size, 
          gfl::heap::HeapBase* parent_device_heap, 
          gfl::heap::HEAPID device_heap_id, u32 device_heap_size );
      void CreateNwAllocator( void );
      void DeleteHeap( void );
      void DeleteNwAllocator( void );
      gfl::heap::HeapBase* m_heap;
      gfl::heap::HeapBase* m_device_heap;
      gfl::heap::NwAllocator* m_nw_allocator;
      gfl::heap::NwAllocator* m_nw_device_allocator;
      gfl::grp::g2d::LytSys* m_layout_system;
      const pml::pokepara::PokemonParam* m_pokeparam;
      bool m_finish_flag;




      public:
        static void Initialize( gfl::heap::HeapBase* heap );
        static void Finalize( void );


      protected:
        virtual void SetPaneVisibility( 
            gfl::grp::g2d::LytWk* layout_work, 
            gfl::grp::g2d::LytPaneIndex pane_index, 
            bool visibility );

        virtual void SetPaneVisible(
            gfl::grp::g2d::LytWk* layout_work, 
            gfl::grp::g2d::LytPaneIndex pane_index );

        virtual void SetPaneInvisible(
            gfl::grp::g2d::LytWk* layout_work, 
            gfl::grp::g2d::LytPaneIndex pane_index );

        virtual void SetTextboxPaneMessage( 
            gfl::grp::g2d::LytWk* layout_work, 
            gfl::grp::g2d::LytPaneIndex pane_index, 
            u32 str_id );

        virtual void SetTextboxPaneString( 
            gfl::grp::g2d::LytWk* layout_work, 
            gfl::grp::g2d::LytPaneIndex pane_index, 
            const gfl::str::StrBuf* strbuf );

        virtual void SetTextboxPaneNumber( 
            gfl::grp::g2d::LytWk* layout_work, 
            gfl::grp::g2d::LytPaneIndex pane_index, 
            u32 value, u32 keta );

        virtual void SetTextboxPaneMonsName( 
            gfl::grp::g2d::LytWk* layout_work, 
            gfl::grp::g2d::LytPaneIndex pane_index, 
            MonsNo monsno );

        virtual void SetTextboxPaneSex( 
            gfl::grp::g2d::LytWk* layout_work, 
            gfl::grp::g2d::LytPaneIndex pane_index, 
            pml::Sex sex );

        virtual void SetTextboxPaneWazaName( 
            gfl::grp::g2d::LytWk* layout_work, 
            gfl::grp::g2d::LytPaneIndex pane_index, 
            WazaNo wazano );


        virtual void StartAnimation( 
            gfl::grp::g2d::LytWk* layout_work, u32 animation_index );

        virtual void StopAnimation( 
            gfl::grp::g2d::LytWk* layout_work, u32 animation_index );

        virtual void PauseAnimation( 
            gfl::grp::g2d::LytWk* layout_work, u32 animation_index, bool pause );

        virtual void SetAnimationFrame( 
            gfl::grp::g2d::LytWk* layout_work, u32 animation_index, u32 frame );


        gfl::str::StrBuf* GetTempStrBuf( void ) { return m_temp_strbuf; }


      private:
        static const u32 TEMP_STRBUF_LENGTH;
        static gfl::str::StrBuf* m_temp_strbuf;
        static gfl::str::MsgData* m_message_data;
    };


  } // namespace wazawasure 
} // namespace app


#endif // __WAZAWASUREBASE_H__
