//========================================================================================
/**
 * @file wazawasure_Process.h
 * @brief ZYvZX
 * @author obata_toshihiro
 * @date 2011.08.28
 */
//========================================================================================
#ifndef __WAZAWASUREPROCESS_H__
#define __WAZAWASUREPROCESS_H__
#include <gflib.h>
#include <pmlib.h>
#include <gamesystem/GameProc.h>


namespace app {
  namespace wazawasure {

    class Lower;


    class Process : public gamesystem::GameProc
    {
      public:

        //--------------------------------------------------------------------------------
        /**
         * @brief RXgN^
         */
        //--------------------------------------------------------------------------------
        Process( void );

        //--------------------------------------------------------------------------------
        /**
         * @brief fXgN^
         */
        //--------------------------------------------------------------------------------
        virtual ~Process();

        //--------------------------------------------------------------------------------
        /**
         * @brief \|Pݒ肷
         */
        //--------------------------------------------------------------------------------
        void SetPokeParam( const pml::pokepara::PokemonParam* pokeparam );




        // vZXƂĂ̓

        //--------------------------------------------------------------------------------
        /**
         * @brief	vZX̏
         * @param proc_manager  vZX̃}l[W
         * @retval RES_CONTINUE  p
         * @retval RES_FINISH    I
         */
        //--------------------------------------------------------------------------------
        virtual gfl::proc::Result InitFunc( gfl::proc::Manager* proc_manager );

        //--------------------------------------------------------------------------------
        /**
         * @brief vZX̍XV
         * @param proc_manager  vZX̃}l[W
         * @retval RES_CONTINUE  Cp
         * @retval RES_FINISH    CI
         */
        //--------------------------------------------------------------------------------
        virtual gfl::proc::Result UpdateFunc( gfl::proc::Manager* proc_manager );

        //--------------------------------------------------------------------------------
        /**
         * @brief vZX̕`揈
         * @param proc_manager  vZX̃}l[W
         */
        //--------------------------------------------------------------------------------
        virtual void DrawFunc( gfl::proc::Manager* proc_manager );

        //--------------------------------------------------------------------------------
        /**
         * @brief vZX̏I
         * @param proc_manager  vZX̃}l[W
         * @retval RES_CONTINUE  Ip
         * @retval RES_FINISH    II
         */
        //--------------------------------------------------------------------------------
        virtual gfl::proc::Result EndFunc( gfl::proc::Manager* proc_manager );






      protected:

        static const gfl::grp::g2d::LytSysSetUp LYTSYS_SETUP_DATA;
        static const char* SYSTEMFONT_FILENAME;

        gfl::heap::HeapBase* m_heap;
        gfl::heap::HeapBase* m_device_heap;
        gfl::heap::NwAllocator* m_nw_heap_allocator;
        gfl::heap::NwAllocator* m_nw_device_allocator;
        gfl::grp::g3d::System* m_g3d_system;
        gfl::grp::g2d::LytSys* m_layout_system;
        const pml::pokepara::PokemonParam* m_pokeparam; 
        wazawasure::Lower* m_lower;

        void CreateHeap( void ); 
        void CreateG3dSystem( void );
        void CreateLayoutSystem( void );
        void SetupFont( void );
        void CreateLower( void );

        void DeleteHeap( void );
        void DeleteG3dSystem( void );
        void DeleteLayoutSystem( void ); 
        void CleanupFont( void ); 
        void DeleteLower( void );
    };


  } // namespace wazawasure
} // namespace app


#endif // __WAZAWASUREPROCESS_H__
