//=======================================================================================
/**
 * @file CommandSelectBase.h
 * @brief R}hIʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.08.29
 */
//=======================================================================================
#ifndef __COMMANDSELECTBASE_H__
#define __COMMANDSELECTBASE_H__
#include <gflib.h>
#include "AppBase.h"


namespace btl {

  class BTL_PARTY;
  class BattleViewSystem;


  namespace app {

    class CommandSelectBase : public AppBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( CommandSelectBase );  // Rs[֎~

      public:


      //uꂩvR}h̎
      enum CommandMode {
        COMMAND_MODE_CHANGE,          //uꂩv
        COMMAND_MODE_ALREADY_BATTLE,  //uƂイv
        COMMAND_MODE_DEAD,            // m̂߁uȂv
        COMMAND_MODE_EGG,             // ^}Ŝ߁uȂv
      };

      // ݒ
      struct Setting {
        const BTL_POKEPARAM* btl_param;  // \Ώۂ̃|P
        CommandMode command_mode;        //uꂩvR}h̎
        bool repair_enable;              //uӂvIł邩ǂ
        bool status_view_enable;         //u悳݂vIł邩ǂ
        bool waza_view_enable;           //u킴݂vIł邩ǂ
      };

      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap          gpAvP[Vq[v
       * @param app_heap_size     gpAvP[Vq[ṽTCY
       * @param device_heap       gpfoCXq[v
       * @param device_heap_size  gpfoCXq[ṽTCY
       * @param btlv_system       og`RAVXe
       */
      //---------------------------------------------------------------------------------
      CommandSelectBase( 
          gfl::heap::HeapBase* app_heap, u32 app_heap_size,
          gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
          BattleViewSystem* btlv_system );

      //---------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //---------------------------------------------------------------------------------
      virtual ~CommandSelectBase();

      //---------------------------------------------------------------------------------
      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      //---------------------------------------------------------------------------------
      virtual void ChangeSetting( const Setting& new_setting ) = 0;



      // I
      enum Result {
        RESULT_RETURN,  //uǂvI
        RESULT_CHANGE,  //uꂩvI
        RESULT_REPAIR,  //uӂvI
        RESULT_STATUS,  //u悳݂vI
        RESULT_WAZA,    //u킴݂vI
        RESULT_NULL,
      };
      //---------------------------------------------------------------------------------
      /**
       * @brief ʂ擾
       */
      //---------------------------------------------------------------------------------
      Result GetResult( void ) const;




      protected:
      void SetSetting( const Setting& new_setting ) { m_settings = new_setting; }
      const Setting& GetSetting( void ) const { return m_settings; }
      const BTL_POKEPARAM* GetBtlParam( void ) const { return m_settings.btl_param; }
      CommandMode GetCommandMode( void ) const { return m_settings.command_mode; }
      bool IsRepairEnable( void ) const { return m_settings.repair_enable; }
      bool IsStatusViewEnable( void ) const { return m_settings.status_view_enable; }
      bool IsWazaViewEnable( void ) const { return m_settings.waza_view_enable; }

      void SetResult( Result result ) { m_result = result; }
      void ResetResult( void ) { m_result = RESULT_NULL; }


      private:
      Setting m_settings;
      Result m_result;
    };


  }  // namespace app
}  // namespace btl


#endif // __COMMANDSELECTBASE_H__ 
