//=======================================================================================
/**
 * @file CommandSelect.h
 * @brief R}hI
 * @author obata_toshihiro
 * @date 2011.08.29
 */
//=======================================================================================
#ifndef __COMMANDSELECT_H__
#define __COMMANDSELECT_H__
#include <gflib.h>
#include "AppDrawUtil.h"
#include "CommandSelectBase.h"


namespace btl {

  class BTL_PARTY;
  class BattleViewSystem;


  namespace app {

    class CommandSelect : public CommandSelectBase, public AppDrawUtil
    {
      GFL_FORBID_COPY_AND_ASSIGN( CommandSelect );  // Rs[֎~

      public:


      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap      gpAvP[Vq[v
       * @param device_heap   gpfoCXq[v
       * @param btlv_system   og`RAVXe
       */
      //---------------------------------------------------------------------------------
      CommandSelect( 
          gfl::heap::HeapBase* app_heap, gfl::heap::HeapBase* device_heap,
          BattleViewSystem* btlv_system );

      //---------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //---------------------------------------------------------------------------------
      virtual ~CommandSelect(); 

      //---------------------------------------------------------------------------------
      /**
       * @brief XV
       */
      //---------------------------------------------------------------------------------
      virtual void Update( void );

      //---------------------------------------------------------------------------------
      /**
       * @brief ŏĊJ( ݒ͈p )
       */
      //---------------------------------------------------------------------------------
      virtual void Restart( void );

      //---------------------------------------------------------------------------------
      /**
       * @brief I[g`tOZbg
       */
      //---------------------------------------------------------------------------------
      virtual void SetAutoDrawFlag( bool flag );

      //---------------------------------------------------------------------------------
      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      //---------------------------------------------------------------------------------
      virtual void ChangeSetting( const Setting& new_setting );




      private:
      static const u32 APP_HEAPSIZE;
      static const u32 DEVICE_HEAPSIZE;
    };


  }  // namespace app
}  // namespace btl


#endif // __COMMANDSELECT_H__ 
