//=======================================================================================
/**
 * @file	btlv_ui_poke_list.h
 * @brief	ogʐ( |PXg )
 * @author	obata
 * @data 2011.08.24
 */
//=======================================================================================
#ifndef __BTLVUIPOKELIST_H__
#define __BTLVUIPOKELIST_H__ 
#include "app/PokeListBase.h"
#include "app/PokeList.h"


namespace btl {

  class BattleViewSystem;
  class BtlvUi; 


  class BtlvUiPokeList
  {
    public:
      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param core  `RAVXe
       * @param ui    UIVXe
       */
      //---------------------------------------------------------------------------------
      BtlvUiPokeList( BattleViewSystem* core, BtlvUi* ui );

      //---------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //---------------------------------------------------------------------------------
      virtual ~BtlvUiPokeList();


      //---------------------------------------------------------------------------------
      // 쐬Ej
      //---------------------------------------------------------------------------------
      /**
       * @brief ݒ
       */
      struct Setting {
        u32 temp;
      };
      void Create( const Setting& setting );
      void Delete( void );


      //---------------------------------------------------------------------------------
      // 쐧
      //--------------------------------------------------------------------------------- 
      /**
       * @brief ʂ
       */
      void Close( void );

      /**
       * @brief ʂ̂Iǂ𒲂ׂ
       * @retval true   I
       * @retval false  ܂IĂȂ
       */
      bool IsCloseFinished( void ) const;

      /**
       * @brief XV
       */
      void Update( void ); 



      //--------------------------------------------------------------------------------- 
      // |PXg
      //--------------------------------------------------------------------------------- 
      /**
       * @brief |PXgJn
       * @param call_poke_index  ɂ|P̃CfbNX
       */
      void Start( u8 call_poke_index );

      /**
       * @brief |PXg̏Iǂ𒲂ׂ
       * @retval true   I
       * @retval false  ܂IĂȂ
       */
      bool IsFinished( void ) const;

      /**
       * @brief |PXg̑Iʂ擾
       */
      enum Result {
        RESULT_RETURN,  // Iɖ߂
        RESULT_CHANGE,  // ւ|PI
        RESULT_ITEM,    // gpACeI
        RESULT_ERROR,
      };
      Result GetResult( void ) const;

      /**
       * @brief ւɂĐVɏo|P̃CfbNX擾
       */
      u8 GetInPokeIndex( void ) const;

      /**
       * @brief ւɂďꂩo|P̃CfbNX擾
       */
      u8 GetOutPokeIndex( void ) const;

      /**
       * @brief gpACe̔ԍ擾
       */
      u32 GetUseItemId( void ) const; 




    private: 

      // 
      enum State {
        STATE_CLOSE,            // Ă
        STATE_LIST,             // |PXg
        STATE_COMMAND,          // R}hI
        STATE_REPAIR_COMMAND,   // 񕜃R}hI
        STATE_ITEM_LIST,        // ACeI
        STATE_ITEM_INFO,        // ACe
        STATE_STATUS,           // Xe[^X
        STATE_WAZA_LIST,        // 킴Xg
        STATE_WAZA_INFO,        // 킴
      };


      BattleViewSystem* m_btlv_core;
      BtlvUi* m_btlv_ui;
      Setting m_setting;

      State m_now_state;
      State m_next_state;
      btl::app::AppBase* m_now_app;
      btl::app::PokeList* m_pokelist;

      u8 m_call_poke_index;  // ɂ|P̃CfbNX
      u8 m_now_poke_index;   // I𒆂̃|P̃CfbNX
      Result m_result;



      void CreatePokeList( void );
      void DeletePokeList( void );
      void SetupPokeListSettings( btl::app::PokeListBase::Setting* dest );
      btl::app::PokeListBase::Mode GetPokeListSetting_Mode( void ) const;
      btl::app::PokeListBase::MessageKind GetPokeListSetting_MessageKind( void ) const;
      bool GetPokeListSetting_ReturnEnable( void ) const;

      State GetNextState( void ) const;
      Result DecideResult( void ) const;
      btl::app::AppBase* ChangeStateTo( State next_state );
      void ChangeState_CLOSE_to( State next_state );
  };


}  // namespace btl 


#endif  // __BTLVUIPOKELIST_H__ 
