//=======================================================================================
/**
 * @file	btlv_ui_poke_list.h
 * @brief	ogʐ( |PXg )
 * @author	obata
 * @data 2011.08.24
 */
//=======================================================================================
#include <gflib.h>
#include <grp/g2d/gfl_LytWkBase.h>
#include <grp/g2d/gfl_LytRes.h>

#include "btlv_core.h"
#include "btlv_types.h"
#include "btlv_ui.h"
#include "btlv_ui_poke_list.h"
#include "app/AppBase.h"
#include "app/PokeListBase.h"
#include "app/PokeList.h"


namespace btl { 




  //---------------------------------------------------------------------------------
  // RXgN^
  //---------------------------------------------------------------------------------
  BtlvUiPokeList::BtlvUiPokeList( BattleViewSystem* core, BtlvUi* ui ) :
    m_btlv_core( core ),
    m_btlv_ui( ui ),
    m_setting(),
    m_now_state( STATE_CLOSE ),
    m_next_state( STATE_CLOSE ),
    m_now_app( NULL ),
    m_pokelist( NULL ),
    m_call_poke_index( 0 ),
    m_now_poke_index( 0 )
  {
  }



  //---------------------------------------------------------------------------------
  // fXgN^
  //---------------------------------------------------------------------------------
  BtlvUiPokeList::~BtlvUiPokeList()
  {
  }




  //---------------------------------------------------------------------------------
  // |PXgʂ𐶐
  //---------------------------------------------------------------------------------
  void BtlvUiPokeList::Create( const Setting& setting )
  {
    m_setting = setting;
    this->CreatePokeList();
    m_pokelist->SetAutoDrawFlag( false );
  }

  // |PXgʂ𐶐
  void BtlvUiPokeList::CreatePokeList( void )
  {
    GFL_ASSERT( !m_pokelist );
    if( !m_pokelist ) {
      gfl::heap::HeapBase* heap = m_btlv_core->GetHeapMem();
      gfl::heap::HeapBase* device_heap = m_btlv_core->GetDeviceMem();
      m_pokelist = GFL_NEW( heap ) btl::app::PokeList( heap, device_heap, m_btlv_core );
    } 
  }



  //---------------------------------------------------------------------------------
  // |PXgʂj
  //---------------------------------------------------------------------------------
  void BtlvUiPokeList::Delete( void )
  {
    this->DeletePokeList();
  }

  // |PXgʂj
  void BtlvUiPokeList::DeletePokeList( void )
  {
    if( m_pokelist ) {
      GFL_DELETE m_pokelist;
      m_pokelist = NULL;
    }
  }







  //---------------------------------------------------------------------------------
  // ʂ
  //--------------------------------------------------------------------------------- 
  void BtlvUiPokeList::Close( void )
  {
    m_next_state = STATE_CLOSE;
  } 


  //--------------------------------------------------------------------------------- 
  // ʂ̂Iǂ𒲂ׂ
  //--------------------------------------------------------------------------------- 
  bool BtlvUiPokeList::IsCloseFinished( void ) const
  {
    return ( m_now_state == STATE_CLOSE );
  }







  //--------------------------------------------------------------------------------- 
  // |PXgʂJn
  //--------------------------------------------------------------------------------- 
  void BtlvUiPokeList::Start( u8 call_poke_index )
  {
    btl::app::PokeListBase::Setting setting;
    this->SetupPokeListSettings( &setting );
    m_pokelist->ChangeSetting( setting );
    m_call_poke_index = call_poke_index;
    m_now_poke_index = call_poke_index;
    m_now_app = NULL;
    m_now_state = STATE_CLOSE;
    m_next_state = STATE_LIST;
  }


  // |PXgʂ̓ݒ肷
  void BtlvUiPokeList::SetupPokeListSettings( btl::app::PokeListBase::Setting* dest )
  {
    dest->mode = this->GetPokeListSetting_Mode();
    dest->message_kind = this->GetPokeListSetting_MessageKind();
    dest->return_enable = this->GetPokeListSetting_ReturnEnable();
    dest->init_cursor_pos = m_now_poke_index;
    for( u32 i=0; i<BTL_PARTY_MEMBER_MAX; i++ ) {
      dest->party_setting[ app::PokeListBase::PARTY_PLAYER ].sorted_poke_index[i] = i;  
      // sI烊XgʂɑJڂꍇ, BTL_PARTŶ܂܂̕тŗǂ
    }
  }


  // |PXgʂ̓ݒ( [h )
  btl::app::PokeListBase::Mode BtlvUiPokeList::GetPokeListSetting_Mode( void ) const
  {
    // @todo }`Ή
    // }`̓p[gi[|PɈKv邽, ʃNXŊǗقǂ
    return btl::app::PokeListBase::MODE_NORMAL;
  }


  // |PXgʂ̓ݒ( \郁bZ[W )
  btl::app::PokeListBase::MessageKind BtlvUiPokeList::GetPokeListSetting_MessageKind( void ) const
  {
    return btl::app::PokeListBase::MESSAGE_KIND_POKE_SELECT;
  }

  // |PXgʂ̓ݒ(uǂv{^邩ǂ )
  bool BtlvUiPokeList::GetPokeListSetting_ReturnEnable( void ) const
  {
    return true;
  }



  //--------------------------------------------------------------------------------- 
  // |PXg̏Iǂ𒲂ׂ
  //--------------------------------------------------------------------------------- 
  bool BtlvUiPokeList::IsFinished( void ) const
  {
    return this->IsCloseFinished();
  }


  //--------------------------------------------------------------------------------- 
  // |PXg̑Iʂ擾
  //--------------------------------------------------------------------------------- 
  BtlvUiPokeList::Result BtlvUiPokeList::GetResult( void ) const
  {
    return m_result;
  }


  //--------------------------------------------------------------------------------- 
  // ւɂĐVɏo|P̃CfbNX擾
  //--------------------------------------------------------------------------------- 
  u8 BtlvUiPokeList::GetInPokeIndex( void ) const
  {
    GFL_ASSERT( this->IsFinished() );  // ܂IĂȂ̂ɌĂ΂̂͂
    GFL_ASSERT( m_pokelist );
    if( m_pokelist ) { 
      return m_pokelist->GetSelectedPokeOrder();  
      // I񂾃|P̕яƃCfbNX͈v
      // 0Ԗڂ̃|P̓p[eBCfbNX0
    }
    return 0;
  }


  //--------------------------------------------------------------------------------- 
  // ւɂďꂩo|P̃CfbNX擾
  //--------------------------------------------------------------------------------- 
  u8 BtlvUiPokeList::GetOutPokeIndex( void ) const
  {
    return m_call_poke_index;
  }


  //--------------------------------------------------------------------------------- 
  // gpACe̔ԍ擾
  //--------------------------------------------------------------------------------- 
  u32 BtlvUiPokeList::GetUseItemId( void ) const
  {
    return 0;  // @todo ͉
  }





  //--------------------------------------------------------------------------------- 
  // XV
  //--------------------------------------------------------------------------------- 
  void BtlvUiPokeList::Update( void )
  {
    // XV
    if( m_now_app ) {
      m_now_app->Update();
      if( m_now_app->IsFinished() ) {
        m_next_state = this->GetNextState();
      }
    }

    // ԑJ
    if( m_now_state != m_next_state ) {
      if( m_next_state == STATE_CLOSE ) {  // IۂɌʂ
        m_result = this->DecideResult();
      }
      if( m_now_app ) {  // Iʂ\ɂ
        m_now_app->SetAutoDrawFlag( false );
      }
      m_now_app = this->ChangeStateTo( m_next_state ); 
      if( m_now_app ) {  // Vʂ\
        m_now_app->SetAutoDrawFlag( true );
        m_now_app->Restart();
      }
    }
  }



  // ̏Ԃ肷
  BtlvUiPokeList::State BtlvUiPokeList::GetNextState( void ) const
  {
    switch( m_now_state ) {
    case STATE_LIST:  // Xg
      if( m_pokelist->GetResult() == app::PokeListBase::RESULT_RETURN ) {
        return STATE_CLOSE;  //uǂvIŏI
      }
      else if( m_pokelist->GetResult() == app::PokeListBase::RESULT_SELECT_PLAYER_POKE ) {
        //return STATE_COMMAND;  // |PIŃR}hʂ
        return STATE_CLOSE;  // @todo RR
      }
      break;
    }
    GFL_ASSERT(0);
    return STATE_CLOSE;
  }



  // ʂ肷
  BtlvUiPokeList::Result BtlvUiPokeList::DecideResult( void ) const
  {
    switch( m_now_state ) {
    case STATE_LIST:  // Xg
      GFL_ASSERT( m_pokelist->IsFinished() );
      if( m_pokelist->GetResult() == btl::app::PokeListBase::RESULT_RETURN ) {
        return RESULT_RETURN;  //uǂvI
      }
#if 1  // @todo  {̓RRɂ͗ȂB폜B
      else {
        return RESULT_CHANGE; 
      }
#else
      break;
#endif
    }
    GFL_ASSERT(0);
    return RESULT_ERROR;
  }



  // ̏Ԃ֑Jڂ
  // ̉ʂǗIuWFNgԂ
  btl::app::AppBase* BtlvUiPokeList::ChangeStateTo( State next_state ) 
  {
    GFL_ASSERT( m_now_state != next_state ); 
    btl::app::AppBase* next_app = NULL;

    switch( m_now_state ) 
    {
    case STATE_CLOSE:  // Ă
      switch( next_state ) {
      case STATE_LIST: 
        next_app = m_pokelist;
        m_now_poke_index = 0;
        break;
      }
      break;

    case STATE_LIST:  // |PXg
      switch( next_state ) {
      case STATE_CLOSE: 
        next_app = m_pokelist;
        break;
      }
      break;
    }

    m_now_state = next_state;
    return next_app;
  } 



}  // namespace btl 
