//=======================================================================================
/**
 * @file PokeListBase.h
 * @brief 퓬( |PXg̃C^[tF[X` )
 * @author obata_toshihiro
 * @date 2011.08.24
 */
//=======================================================================================
#ifndef __POKELISTBASE_H__
#define __POKELISTBASE_H__
#include <gflib.h>
#include <battle/btl_common.h>
#include "AppBase.h"


namespace btl {

  class BattleViewSystem;


  namespace app {

    class PokeListBase : public AppBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( PokeListBase );  // Rs[֎~

      public:


      // 샂[h
      enum Mode {
        MODE_NORMAL,    // ʏp( 6̂̒I )
        MODE_MULTI_L,   // }`p( 3̂̒I, ͍ )
        MODE_MULTI_R,   // }`p( 3̂̒I, ͉E )
      };

      // \郁bZ[W
      enum MessageKind {
        MESSAGE_KIND_POKE_SELECT,  //u|PIłBv
        MESSAGE_KIND_POKE_CHANGE,  //uǂ̃|PŐ키Hv 
        MESSAGE_KIND_ITEM_USE,     //uǂ̃|PɎg܂Hv
      };

      // \p[eB
      enum PartyId {
        PARTY_PLAYER,  // vC[̃p[eB
        PARTY_PARTNER, // p[gi[̃p[eB( }`ogp )
        PARTY_NUM,
      };

      // p[eBƂɐݒ肷p[^
      struct PartySetting {
        // 鏇Ԃɑ΂, BTL_PARTY ̉Ԗڂ̃|Pݒ肳Ă邩H
        // . sorted_poke_index[0] == 3 Ȃ, 0ԖڂBTL_PARTỸCfbNX3̃|P
        u8 sorted_poke_index[ BTL_PARTY_MEMBER_MAX ];
      };


      //---------------------------------------------------------------------------------
      // ݒ
      //---------------------------------------------------------------------------------
      struct Setting {
        Mode mode;                 // 샂[h
        MessageKind message_kind;  // \郁bZ[W
        bool return_enable;        //uǂv{^邩ǂ
        u8 init_cursor_pos;        // J[\̏ʒu( Ԗڂ̃|PH )
        PartySetting party_setting[ PARTY_NUM ]; // p[eBƂ̐ݒ


        //-----------------------------------
        /**
         * @brief ftHgRXgN^
         */
        //-----------------------------------
        Setting( void ) : 
          mode( MODE_NORMAL ),
          message_kind( MESSAGE_KIND_POKE_SELECT ),
          return_enable( true ),
          init_cursor_pos( 0 ),
          party_setting()
        {
          for( u8 i=0; i<PARTY_NUM; i++ ) {
            for( u8 j=0; j<BTL_PARTY_MEMBER_MAX; j++ ) {
              party_setting[i].sorted_poke_index[j] = j;
            }
          }
        }

        //-----------------------------------
        /**
         * @brief Rs[RXgN^
         */
        //-----------------------------------
        Setting( const Setting& src )
        {
          this->mode = src.mode;
          this->message_kind = src.message_kind;
          this->return_enable = src.return_enable;
          this->init_cursor_pos = src.init_cursor_pos;
          for( u8 i=0; i<PARTY_NUM; i++ ) {
            for( u8 j=0; j<BTL_PARTY_MEMBER_MAX; j++ ) {
              this->party_setting[i].sorted_poke_index[j] = 
                src.party_setting[i].sorted_poke_index[j];
            }
          }
        }
      };


      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap          gpAvP[Vq[v
       * @param app_heap_size     gpAvP[Vq[ṽTCY
       * @param device_heap       gpfoCXq[v
       * @param device_heap_size  gpfoCXq[ṽTCY
       * @param btlv_system       og`RAVXe
       */
      //---------------------------------------------------------------------------------
      PokeListBase( 
          gfl::heap::HeapBase* app_heap, u32 app_heap_size,
          gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
          BattleViewSystem* btlv_system );

      //---------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //---------------------------------------------------------------------------------
      virtual ~PokeListBase();

      //---------------------------------------------------------------------------------
      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      //---------------------------------------------------------------------------------
      virtual void ChangeSetting( const Setting& new_setting ) = 0; 




      //---------------------------------------------------------------------------------
      /**
       * @brief J[\w肵|Pɍ킹
       * @param party_id    ǂ̃p[eB̃|PɃJ[\킹邩H
       * @param poke_order  Ԗڂ̃|PɃJ[\킹邩H
       */
      //---------------------------------------------------------------------------------
      virtual void SetCursorPos( PartyId party_id, u8 poke_order ) = 0;



      //---------------------------------------------------------------------------------
      // ւAj[V̐
      //---------------------------------------------------------------------------------
      /**
       * @brief ւAj[VJn
       * @param party_id  ւΏۂ̃p[eB
       * @param poke1     Ԗڂ̃|Pւ邩H( p[eBCfbNXł͂Ȃ )
       * @param poke2     Ԗڂ̃|Pւ邩H( p[eBCfbNXł͂Ȃ )
       */
      virtual void StartExAnimation( PartyId party_id, u8 poke1, u8 poke2 ) = 0;
      /**
       * @brief ւAj[VIǂ𒲂ׂ
       */
      virtual bool IsExAnimationFinished( void ) const = 0;




      // I
      enum Result {
        RESULT_RETURN,               //uǂvI
        RESULT_SELECT_PLAYER_POKE,   // vC[̃|PI
        RESULT_SELECT_PARTNER_POKE,  // p[gi[̃|PI( }`ogp )
        RESULT_NULL,
      };

      //---------------------------------------------------------------------------------
      /**
       * @brief ʂ擾
       */
      //---------------------------------------------------------------------------------
      Result GetResult( void ) const;

      //---------------------------------------------------------------------------------
      /**
       * @brief Ԗڂ̃|PÎ擾
       */
      //---------------------------------------------------------------------------------
      u8 GetSelectedPokeOrder( void ) const;




      protected: 
      void SetSetting( const Setting& new_setting ) { m_settings = new_setting; }
      Mode GetMode( void ) const { return m_settings.mode; }
      MessageKind GetMessageKind( void ) const { return m_settings.message_kind; }
      bool IsReturnEnable( void ) const { return m_settings.return_enable; }
      u8 GetInitCursorPos( void ) const { return m_settings.init_cursor_pos; }
      u8 GetSortedPokeIndex( PartyId party_id, u8 poke_order ) const;
      void ExchangeSortedPokeIndex( PartyId party_id, u8 order0, u8 order1 );
      const BTL_PARTY* GetParty( PartyId party_id ) const;

      void SetResult( Result result ) { m_result = result; }
      void ResetResult( void ) { m_result = RESULT_NULL; }
      void SetSelectedPokeOrder( u8 poke_order ) { m_selected_poke_order = poke_order; }


      private:
      Setting m_settings;
      Result m_result;
      u8 m_selected_poke_order;
    };


  }  // namespace app
}  // namespace btl


#endif  // __POKELISTBASE_H__
