//=======================================================================================
/**
 * @file PokeListBase.cpp
 * @brief 퓬( |PXg̃C^[tF[X` )
 * @author obata_toshihiro
 * @date 2011.08.25
 */
//=======================================================================================
#include <gflib.h>
#include <battle/btl_common.h>
#include <battle/btlv/btlv_core.h>
#include "AppBase.h"
#include "PokeListBase.h"


namespace btl {
  namespace app {


    //---------------------------------------------------------------------------------
    // RXgN^
    //---------------------------------------------------------------------------------
    PokeListBase::PokeListBase( 
        gfl::heap::HeapBase* app_heap, u32 app_heap_size,
        gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
        BattleViewSystem* btlv_system ) : 
      AppBase( 
          app_heap, HEAPID_BATTLE_POKELIST, app_heap_size, 
          device_heap, HEAPID_BATTLE_POKELIST_DEVICE, device_heap_size, 
          btlv_system ),
      m_settings(),
      m_result( RESULT_NULL ),
      m_selected_poke_order( 0 )
    {
    }


    //---------------------------------------------------------------------------------
    // fXgN^
    //---------------------------------------------------------------------------------
    PokeListBase::~PokeListBase()
    {
    }



    //---------------------------------------------------------------------------------
    // ʂ擾
    //---------------------------------------------------------------------------------
    PokeListBase::Result PokeListBase::GetResult( void ) const
    {
      return m_result;
    }

    //---------------------------------------------------------------------------------
    // I|P̃CfbNX擾
    //---------------------------------------------------------------------------------
    u8 PokeListBase::GetSelectedPokeOrder( void ) const
    {
      return m_selected_poke_order;
    }




    // w肵тɂ|P, p[eBCfbNX擾
    u8 PokeListBase::GetSortedPokeIndex( PartyId party_id, u8 poke_order ) const 
    { 
      return m_settings.party_setting[ party_id ].sorted_poke_index[ poke_order ]; 
    }

    // яւ
    void PokeListBase::ExchangeSortedPokeIndex( PartyId party_id, u8 order0, u8 order1 )
    {
      PartySetting* party_setting = &m_settings.party_setting[ party_id ]; 
      u8 temp = party_setting->sorted_poke_index[ order0 ];
      party_setting->sorted_poke_index[ order0 ] = party_setting->sorted_poke_index[ order1 ];
      party_setting->sorted_poke_index[ order1 ] = temp;
    }


    // w肵|Pp[eB擾
    const BTL_PARTY* PokeListBase::GetParty( PartyId party_id ) const
    {
      switch( party_id ) {
      default:
        GFL_ASSERT(0);
      case PARTY_PLAYER:
        return this->GetPlayerParty();
      case PARTY_PARTNER:
        return this->GetPlayerParty();  // @todo p[gi[̃p[eBԂ
      }
    }


  }  // namespace app
}  // namespace btl
