//=======================================================================================
/**
 * @file PokeList.h
 * @brief 퓬( |PXg̓ )
 * @author obata_toshihiro
 * @date 2011.08.24
 */
//=======================================================================================
#ifndef __POKELIST_H__
#define __POKELIST_H__
#include <gflib.h>
#include <battle/btl_common.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include "AppDrawUtil.h"
#include "PokeListBase.h"


namespace btl {

  class BattleViewSystem;


  namespace app {

    class PokeList : public PokeListBase, public AppDrawUtil
    {
      GFL_FORBID_COPY_AND_ASSIGN( PokeList );  // Rs[֎~

      public:

      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param heap          gpAvP[Vq[v
       * @param device_heap   gpfoCXq[v
       * @param btlv_system   og`RAVXe
       */
      //---------------------------------------------------------------------------------
      PokeList( 
          gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap, 
          BattleViewSystem* btlv_system );

      //---------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //---------------------------------------------------------------------------------
      virtual ~PokeList();

      //---------------------------------------------------------------------------------
      /**
       * @brief ݒύX
       * @param new_setting  Vݒ
       */
      //---------------------------------------------------------------------------------
      virtual void ChangeSetting( const Setting& new_setting );



      //---------------------------------------------------------------------------------
      /**
       * @brief J[\w肵|Pɍ킹
       * @param party_id    ǂ̃p[eB̃|PɃJ[\킹邩H
       * @param poke_order  Ԗڂ̃|PɃJ[\킹邩H
       */
      //---------------------------------------------------------------------------------
      virtual void SetCursorPos( PartyId party_id, u8 poke_order );



      //---------------------------------------------------------------------------------
      // 쐧
      //--------------------------------------------------------------------------------- 
      /**
       * @brief XV
       */
      virtual void Update( void );

      /**
       * @brief ŏĊJ( ݒ͈p )
       */
      virtual void Restart( void );

      /**
       * @brief I[g`tOZbg
       */
      virtual void SetAutoDrawFlag( bool flag );




      //---------------------------------------------------------------------------------
      // ւAj[V̐
      //---------------------------------------------------------------------------------
      /**
       * @brief ւAj[VJn
       * @param party_id     ւΏۂ̃p[eB
       * @param poke_order1  Ԗڂ̃|Pւ邩H( p[eBCfbNXł͂Ȃ )
       * @param poke_order2  Ԗڂ̃|Pւ邩H( p[eBCfbNXł͂Ȃ )
       */
      virtual void StartExAnimation( PartyId party_id, u8 poke_order1, u8 poke_order2 );
      /**
       * @brief ւAj[VIǂ𒲂ׂ
       */
      virtual bool IsExAnimationFinished( void ) const;





      private: 

      // V[PX
      enum Sequence {
        SEQ_INPUT_WAIT,         // ͑҂
        SEQ_ANIME_WAIT,         // Aj[V҂
        SEQ_EXOUT_ANIME_START,  // ւAj[V( OUT )Jn
        SEQ_EXOUT_ANIME_WAIT,   // ւAj[V( OUT )҂
        SEQ_EXIN_ANIME_START,   // ւAj[V( IN )Jn
        SEQ_EXIN_ANIME_WAIT,    // ւAj[V( IN )҂
        SEQ_FINISH,             // I
      }; 

      // {^ԍ
      enum ButtonIndex {
        BUTTON_POKE_0,  // 0Ԗڂ̃|P
        BUTTON_POKE_1,  // 1Ԗڂ̃|P
        BUTTON_POKE_2,  // 2Ԗڂ̃|P
        BUTTON_POKE_3,  // 3Ԗڂ̃|P 
        BUTTON_POKE_4,  // 4Ԗڂ̃|P 
        BUTTON_POKE_5,  // 5Ԗڂ̃|P 
        BUTTON_RETURN,  //uǂv{^
        BUTTON_NUM,
        POKE_BUTTON_NUM = 6,
      };

      // Aj[Vf[^ԍ
      enum AnimationDataIndex {
        ANIMATION_DATA_DUMMY_HP_GAUGE,
        ANIMATION_DATA_DUMMY_PLATE_NORMAL,
        ANIMATION_DATA_DUMMY_PLATE_PLAYER,
        ANIMATION_DATA_DUMMY_PLATE_PARTNER,
        ANIMATION_DATA_DUMMY_PLATE_HOLD,
        ANIMATION_DATA_DUMMY_PLATE_RELEASE,
        ANIMATION_DATA_DUMMY_PLATE_SELECT,
        ANIMATION_DATA_RETURN_HOLD,
        ANIMATION_DATA_RETURN_RELEASE,
        ANIMATION_DATA_RETURN_SELECT,
        ANIMATION_DATA_RETURN_PASSIVE,
        ANIMATION_DATA_RETURN_ACTIVE,
        ANIMATION_DATA_POKE0_ALIVE,
        ANIMATION_DATA_POKE0_DEAD,
        ANIMATION_DATA_POKE0_EMPTY,
        ANIMATION_DATA_POKE0_IN,
        ANIMATION_DATA_POKE0_OUT,
        ANIMATION_DATA_POKE1_ALIVE,
        ANIMATION_DATA_POKE1_DEAD,
        ANIMATION_DATA_POKE1_EMPTY,
        ANIMATION_DATA_POKE1_IN,
        ANIMATION_DATA_POKE1_OUT,
        ANIMATION_DATA_POKE2_ALIVE,
        ANIMATION_DATA_POKE2_DEAD,
        ANIMATION_DATA_POKE2_EMPTY,
        ANIMATION_DATA_POKE2_IN,
        ANIMATION_DATA_POKE2_OUT,
        ANIMATION_DATA_POKE3_ALIVE,
        ANIMATION_DATA_POKE3_DEAD,
        ANIMATION_DATA_POKE3_EMPTY,
        ANIMATION_DATA_POKE3_IN,
        ANIMATION_DATA_POKE3_OUT,
        ANIMATION_DATA_POKE4_ALIVE,
        ANIMATION_DATA_POKE4_DEAD,
        ANIMATION_DATA_POKE4_EMPTY,
        ANIMATION_DATA_POKE4_IN,
        ANIMATION_DATA_POKE4_OUT,
        ANIMATION_DATA_POKE5_ALIVE,
        ANIMATION_DATA_POKE5_DEAD,
        ANIMATION_DATA_POKE5_EMPTY,
        ANIMATION_DATA_POKE5_IN,
        ANIMATION_DATA_POKE5_OUT,
        ANIMATION_DATA_CURSOR_FLUCTUATE,
        ANIMATION_DATA_CURSOR_ON_POKE0,
        ANIMATION_DATA_CURSOR_ON_POKE1,
        ANIMATION_DATA_CURSOR_ON_POKE2,
        ANIMATION_DATA_CURSOR_ON_POKE3,
        ANIMATION_DATA_CURSOR_ON_POKE4,
        ANIMATION_DATA_CURSOR_ON_POKE5,
        ANIMATION_DATA_CURSOR_ON_RETURN,
        ANIMATION_DATA_NUM,
      };

      // Aj[Vԍ
      enum AnimationIndex {
        ANIMATION_DUMMY_HP_GAUGE,
        ANIMATION_DUMMY_PLATE_NORMAL,
        ANIMATION_DUMMY_PLATE_PLAYER,
        ANIMATION_DUMMY_PLATE_PARTNER,
        ANIMATION_DUMMY_PLATE_HOLD,
        ANIMATION_DUMMY_PLATE_RELEASE,
        ANIMATION_DUMMY_PLATE_SELECT,
        ANIMATION_RETURN_HOLD,
        ANIMATION_RETURN_RELEASE,
        ANIMATION_RETURN_SELECT,
        ANIMATION_RETURN_PASSIVE,
        ANIMATION_RETURN_ACTIVE,
        ANIMATION_POKE0_ALIVE,
        ANIMATION_POKE0_DEAD,
        ANIMATION_POKE0_EMPTY,
        ANIMATION_POKE0_IN,
        ANIMATION_POKE0_OUT,
        ANIMATION_POKE1_ALIVE,
        ANIMATION_POKE1_DEAD,
        ANIMATION_POKE1_EMPTY,
        ANIMATION_POKE1_IN,
        ANIMATION_POKE1_OUT,
        ANIMATION_POKE2_ALIVE,
        ANIMATION_POKE2_DEAD,
        ANIMATION_POKE2_EMPTY,
        ANIMATION_POKE2_IN,
        ANIMATION_POKE2_OUT,
        ANIMATION_POKE3_ALIVE,
        ANIMATION_POKE3_DEAD,
        ANIMATION_POKE3_EMPTY,
        ANIMATION_POKE3_IN,
        ANIMATION_POKE3_OUT,
        ANIMATION_POKE4_ALIVE,
        ANIMATION_POKE4_DEAD,
        ANIMATION_POKE4_EMPTY,
        ANIMATION_POKE4_IN,
        ANIMATION_POKE4_OUT,
        ANIMATION_POKE5_ALIVE,
        ANIMATION_POKE5_DEAD,
        ANIMATION_POKE5_EMPTY,
        ANIMATION_POKE5_IN,
        ANIMATION_POKE5_OUT,
        ANIMATION_CURSOR_FLUCTUATE,
        ANIMATION_CURSOR_ON_POKE0,
        ANIMATION_CURSOR_ON_POKE1,
        ANIMATION_CURSOR_ON_POKE2,
        ANIMATION_CURSOR_ON_POKE3,
        ANIMATION_CURSOR_ON_POKE4,
        ANIMATION_CURSOR_ON_POKE5,
        ANIMATION_CURSOR_ON_RETURN,
        // ȉ, LAj[V
        ANIMATION_POKE0_HP_GAUGE,
        ANIMATION_POKE0_PLATE_NORMAL = ANIMATION_POKE0_HP_GAUGE + POKE_BUTTON_NUM,
        ANIMATION_POKE0_PLATE_PLAYER = ANIMATION_POKE0_PLATE_NORMAL + POKE_BUTTON_NUM,
        ANIMATION_POKE0_PLATE_PARTNER = ANIMATION_POKE0_PLATE_PLAYER + POKE_BUTTON_NUM,
        ANIMATION_POKE0_PLATE_HOLD = ANIMATION_POKE0_PLATE_PARTNER + POKE_BUTTON_NUM,
        ANIMATION_POKE0_PLATE_RELEASE = ANIMATION_POKE0_PLATE_HOLD + POKE_BUTTON_NUM,
        ANIMATION_POKE0_PLATE_SELECT = ANIMATION_POKE0_PLATE_RELEASE + POKE_BUTTON_NUM,
        ANIMATION_NUM = ANIMATION_POKE0_PLATE_SELECT + POKE_BUTTON_NUM,
        ANIMATION_NULL,
      };

      // LAj[Vԍ
      enum ShareAnimationIndex {
        SHARE_ANIMATION_POKE_HP_GAUGE,
        SHARE_ANIMATION_POKE_PLATE_NORMAL,
        SHARE_ANIMATION_POKE_PLATE_PLAYER,
        SHARE_ANIMATION_POKE_PLATE_PARTNER,
        SHARE_ANIMATION_POKE_PLATE_HOLD,
        SHARE_ANIMATION_POKE_PLATE_RELEASE,
        SHARE_ANIMATION_POKE_PLATE_SELECT,
        SHARE_ANIMATION_NUM,
      };


      // LAj[VƂ̐ݒ
      struct ShareAnimationDesc {
        AnimationIndex start_animation_index;           // o^CfbNX
        AnimationDataIndex animation_data_index;        // L̃Aj[Vԍ
        u32 max_share_num;                              // ő勤L
        gfl::grp::g2d::LytPaneIndex share_group_index;  // VFAΏۂ̃O[v
        gfl::grp::g2d::LytPaneIndex share_pane_index;   // VFAΏۂ̃yC
      };

      // {^Ƃ̐ݒ
      struct ButtonDesc {
        PokeListBase::Result result;              // Iꂽꍇ̌
        gfl::grp::g2d::LytPaneIndex pane_index;   // {^ƂĈyC
        AnimationIndex hold_animation;            // ꂽۂ̃Aj[V
        AnimationIndex release_animation;         // ꂽۂ̃Aj[V
        AnimationIndex select_animation;          // I΂ꂽۂ̃Aj[V
        AnimationIndex active_animation;          // {^Lȍۂ̃Aj[V
        AnimationIndex passive_animation;         // {^ȍۂ̃Aj[V
        AnimationIndex cursor_animation;          // J[\ZbgAj[V
      };

      // |P{^Ɍт|P肷
      struct PokeButtonLink {
        PokeListBase::PartyId party_id;  // ǂ̃p[eBH
        u8 poke_order;                   // Ԗڂ̃|PH
      };

      // |P{^Ƃ̐ݒ
      struct PokeButtonDesc {
        PokeButtonLink link;                        // ǂ̃|PɊ֘At邩H
        gfl::grp::g2d::LytPaneIndex name_pane;      // O\yC
        gfl::grp::g2d::LytPaneIndex sex_pane;       // ʂ\yC
        gfl::grp::g2d::LytPaneIndex lv_value_pane;  // x̒l\yC
        gfl::grp::g2d::LytPaneIndex hp_max_pane;    // őHP̒l\yC
        gfl::grp::g2d::LytPaneIndex hp_value_pane;  // HP̒l\yC
        gfl::grp::g2d::LytPaneIndex item_icon_pane; // ACeACR̃yC
        AnimationIndex in_animation;                // oĂAj
        AnimationIndex out_animation;               // ĂAj
        AnimationIndex hp_gauge_animation;          // HPQ[WAj
        AnimationIndex plate_normal_animation;      // ʏ̃v[gɂAj
        AnimationIndex plate_player_animation;      // }`ΐ( vC[ )p̃v[gɂAj
        AnimationIndex plate_partner_animation;     // }`ΐ( p[gi[ )p̃v[gɂAj
        AnimationIndex plate_alive_animation;       // 퓬\ȏԂ̃v[gɂAj
        AnimationIndex plate_dead_animation;        // mp̃v[gɂAj
        AnimationIndex plate_empty_animation;       // |PȂꍇ̃v[gɂAj
      };




      static const u32 APP_HEAPSIZE;
      static const u32 DEVICE_HEAPSIZE; 
      static const u32 LV_PLACE_COUNT;
      static const u32 HP_PLACE_COUNT;

      static const gfl::grp::g2d::LytWkSetUp LAYOUT_WORK_SETUP_DATA;
      static const gfl::grp::g2d::LytArcIndex ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUM ];
      static const ShareAnimationDesc SHARE_ANIMATION_DESC[ SHARE_ANIMATION_NUM ];
      static const ::app::tool::CursorManager::MOVE_DATA CURSOR_MOVE_DATA[ BUTTON_NUM ];
      static const ButtonDesc BUTTON_DESC[ BUTTON_NUM ];
      static const PokeButtonDesc POKE_BUTTON_DESC[ POKE_BUTTON_NUM ]; 


      gfl::grp::g2d::LytWk* m_layout_work;
      gfl::grp::g2d::LytResID m_layout_resource_id;
      ::app::tool::ButtonManager* m_button_manager;
      ::app::tool::CursorManager* m_cursor_manager;

      Sequence m_seq;
      Sequence m_next_seq;
      AnimationIndex m_wait_animation_index;
      ButtonIndex m_exchange_button[2];
      PokeButtonDesc m_poke_button_desc[ POKE_BUTTON_NUM ];


      virtual const ButtonDesc& GetButtonDesc( ButtonIndex button_index ) const;
      virtual const PokeButtonDesc& GetPokeButtonDesc( ButtonIndex button_index ) const;
      virtual void InitialziePokeButtonDesc( void );
      ButtonIndex GetButtonIndex( PartyId party_id, u8 poke_order ) const;


      void CreateLayoutWork( void );
      void CreateShareAnimation( void );
      void CreateCursorManager( void );
      void CreateButtonManager( void );
      void SetupButtonManager( void ); 
      void SetupFont( void );
      void InitializeGraphicsSystem( void );
      void InitializeCursorPos( void );

      void DeleteLayoutWork( void );
      void DeleteCursorManager( void );
      void DeleteButtonManager( void );
      void FinalizeGraphicsSystem( void );

      void SetupMessage( void );
      void SetupReturnButtonActivity( void );
      void SetupPokeButtonActivity( ButtonIndex button_index );

      void SetupPokeButton( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      bool SetupPokeButton_Kind( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      bool SetupPokeButton_State( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetupPokeButton_Params( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetPokeButtonDisplay_Normal( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetPokeButtonDisplay_Player( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetPokeButtonDisplay_Partner( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetPokeButtonDisplay_Alive( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetPokeButtonDisplay_Dead( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetPokeButtonDisplay_Empty( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetPokeButtonDisplay_Name( ButtonIndex button_index, const PokeButtonDesc& button_desc, const BTL_POKEPARAM* btl_param );
      void SetPokeButtonDisplay_Sex( ButtonIndex button_index, const PokeButtonDesc& button_desc, const BTL_POKEPARAM* btl_param );
      void SetPokeButtonDisplay_Level( ButtonIndex button_index, const PokeButtonDesc& button_desc, u32 level );
      void SetPokeButtonDisplay_Hp( ButtonIndex button_index, const PokeButtonDesc& button_desc, u32 max_hp, u32 now_hp );
      void SetPokeButtonDisplay_HaveItem( ButtonIndex button_index, const PokeButtonDesc& button_desc );
      void SetPokeButtonDisplay_NotHaveItem( ButtonIndex button_index, const PokeButtonDesc& button_desc );

      void UpdateSequence( void );
      bool IsButtonHolding( void ) const;
      bool IsButtonSelected( void ) const;
      ButtonIndex GetSelectedCursorPosByButton( void ) const;
      bool UpdateCursorMove( void );
      ButtonIndex GetCurrentCursorPos( void ) const;
      ButtonIndex GetPrevCursorPos( void ) const;
      bool IsSelectEnable( ButtonIndex cursor_pos ) const;
      void SetResultByCursorPos( ButtonIndex cursor_pos );

      void StartSelectAnimation( ButtonIndex cursor_pos );
      bool IsSelectAnimationFinished( void ) const;
      void StartCursorMoveAnimation( ButtonIndex old_cursor_pos, ButtonIndex new_cursor_pos );
      void StartExchangeOutAnimation( void );
      void StopExchangeOutAnimation( void );
      bool IsExchangeOutAnimationFinished( void ) const;
      void StartExchangeInAnimation( void );
      void StopExchangeInAnimation( void );
      bool IsExchangeInAnimationFinished( void ) const;
      void ExchangePokeButtons( void );
      void ExchangePokeButtonLinks( ButtonIndex button1, ButtonIndex button2 );
    };


  }  // namespace app
}  // namespace btl


#endif  // __POKELIST_H__
