//============================================================================================
/**
 * @file		sample_3d.cpp
 * @brief		3D֘A
 * @author	Hiroyuki Nakamura
 * @date		11.08.26
 *
 * namespace	app::sample::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//============================================================================================
#include "sample_3d.h"


namespace app {
namespace sample {

//============================================================================================
//	萔`
//============================================================================================


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		gra				OtBbNVXe
 * @param		modelMax	ǉ\ȃfő吔
 * @param		heap			q[v
 */
//--------------------------------------------------------------------------------------------
G3DSystem::G3DSystem( gfl::grp::GraphicsSystem * gra, u32 modelMax, Heap * heap ) :
	pGraSystem( gra )
{
	CreateSystem( heap );

	CreateCamera( heap );
	CreateLight( heap );
	CreateScene( heap );

	CreateModelWork( heap, modelMax );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
G3DSystem::~G3DSystem(void)
{
	DeleteModelWork();

	DeleteScene();
	DeleteLight();
	DeleteCamera();

	DeleteSystem();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		`
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G3DSystem::Draw(void)
{
	pG3dScene->Calculate();
	pG3dScene->SubmitView( pG3dCameraUpper );
	pG3dCameraLower->UpdateCameraMatrix();

	pG3dScene->StereoDraw( pGraSystem, pG3dCameraUpper );
	pG3dScene->Draw( pGraSystem, gfl::grp::DISPLAY_LOWER, pG3dCameraLower );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		G3DVXe쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G3DSystem::CreateSystem( Heap * heap )
{
	pG3dSystem = GFL_NEW( heap->Get() ) gfl::grp::g3d::System( heap->GetAllocator(), heap->GetDeviceAllocator() );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		G3DVXe폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G3DSystem::DeleteSystem(void)
{
	GFL_DELETE pG3dSystem;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		J쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G3DSystem::CreateCamera( Heap * heap )
{
	pG3dCameraUpper = GFL_NEW( heap->Get() ) gfl::grp::g3d::StereoCamera();
	pG3dCameraLower = GFL_NEW( heap->Get() ) gfl::grp::g3d::StereoCamera();

#if 0
// \[XJ쐬 

	// \[X쐬
	pG3dCameraResUpper = GFL_NEW( pAppHeap ) gfl::grp::g3d::Resource();
	pG3dCameraAnmUpper = GFL_NEW( pAppHeap ) gfl::grp::g3d::ResAnim();
	pG3dCameraResLower = GFL_NEW( pAppHeap ) gfl::grp::g3d::Resource();
	pG3dCameraAnmLower = GFL_NEW( pAppHeap ) gfl::grp::g3d::ResAnim();

	gfl::grp::g3d::Resource::AnimationResourcePack * res_pack = GFL_NEW( heap->Get() ) gfl::grp::g3d::Resource::AnimationResourcePack[2];
	int	cnt = 0;

	gfl::fs::ArcFile * af = GFL_NEW( heap->Get() ) gfl::fs::ArcFile( ARCID_SAMPLE );
	pG3dCameraResUpper->Load( pDeviceHeapAllocator, af, GARC_sample_gra_dummy_camera_BCCAM, NULL );
	if( pG3dCameraResUpper->GetCameraAnimsCount() != 0 ){
		pG3dCameraAnmUpper->Create( heap->GetDeviceAllocator(), pG3dCameraResUpper, 0, gfl::grp::g3d::ResAnim::TYPE_CAMERA );
		res_pack[cnt].resource = pG3dCameraRes[i];
		res_pack[cnt].animation_resource_type = gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_CAMERA;
		res_pack[cnt].index_in_resource = 1;
		cnt++;
	}
	pG3dCameraResLower->Load( pDeviceHeapAllocator, af, GARC_sample_dummy_camera_BCCAM, NULL );
	if( pG3dCameraResLower->GetCameraAnimsCount() != 0 ){
		pG3dCameraAnmLower->Create( heap->GetDeviceAllocator(), pG3dCameraResLower, 0, gfl::grp::g3d::ResAnim::TYPE_CAMERA );
			res_pack[cnt].resource = pG3dCameraResLower[i];
			res_pack[cnt].animation_resource_type = gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_CAMERA;
			res_pack[cnt].index_in_resource = 0;
			cnt++;
		}
	}
	GFL_DELETE af;

	maxCameraAnmCount = gfl::grp::g3d::Resource::GetMaxMemberAnimSetCount( cnt, res_pack );
	GFL_DELETE	[]res_pack;

	pG3dCameraUpper->Create( heap->GetAllocator(), heap->GetDeviceAllocator(), pG3dCameraResUpper, 0 );
	pG3dCameraLower->Create( heap->GetAllocator(), heap->GetDeviceAllocator(), pG3dCameraResLower, 0 );

#else
// vOŃJ쐬
	pG3dCameraUpper->Create( heap->GetDeviceAllocator() );
	pG3dCameraUpper->GetBaseCamera()->SetAspect( 400.0f/240.0f );

	pG3dCameraLower->Create( heap->GetDeviceAllocator() );
	pG3dCameraLower->SetPivotDirection( gfl::math::PIVOT_UPSIDE_TO_TOP );
	pG3dCameraLower->SetAspect( 320.0f / 240.0f );
#endif
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		J폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G3DSystem::DeleteCamera(void)
{
#if 0
// \[XJ쐬 
	GFL_DELETE pG3dCameraAnmLower;
	GFL_DELETE pG3dCameraResLower;
	GFL_DELETE pG3dCameraAnmUpper;
	GFL_DELETE pG3dCameraResUpper;
#else
// vOŃJ쐬
#endif
	GFL_DELETE pG3dCameraLower;
	GFL_DELETE pG3dCameraUpper;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Cg쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G3DSystem::CreateLight( Heap * heap )
{
/*
	pG3dLightRes = GFL_NEW( heap->Get() ) gfl::grp::g3d::Resource();
	pG3dLight = GFL_NEW( heap->Get() ) gfl::grp::g3d::Light();

	gfl::fs::ArcFile * af = GFL_NEW( heap->Get() ) gfl::fs::ArcFile( ARCID_SAMPLE_GRA );
	pG3dLightRes->Load( heap->GetDeviceAllocator(), af, GARC_sample_gra_dummy_light_BCLGT, NULL );
	GFL_DELETE	af;

	pG3dLight->Create( heap->GetAllocator(), heap->GetDeviceAllocator(), pG3dLightRes, 0 );
*/
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Cg폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G3DSystem::DeleteLight(void)
{
/*
	GFL_DELETE pG3dLight;
	GFL_DELETE pG3dLightRes;
*/
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		V[쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G3DSystem::CreateScene( Heap * heap )
{
	gfl::grp::g3d::Scene::Description description;
	pG3dScene = GFL_NEW( heap->Get() ) gfl::grp::g3d::Scene( heap->GetDeviceAllocator(), &description );

/*
	pG3dEnvironmentRes = GFL_NEW( heap->Get() ) gfl::grp::g3d::Resource();

	gfl::fs::ArcFile * af = GFL_NEW( heap->Get() ) gfl::fs::ArcFile( ARCID_SAMPLE_GRA );
	pG3dEnvironmentRes->Load( heap->GetDeviceAllocator(), af, GARC_sample_gra_dummy_scene_BCENV, NULL );
	GFL_DELETE	af;

	pG3dScene->BuildSceneUsingResource( heap->GetAllocator(), heap->GetDeviceAllocator(), pG3dEnvironmentRes );
*/

	pG3dScene->AddSceneNode( pG3dCameraUpper );
	pG3dScene->AddSceneNode( pG3dCameraLower );
//	pG3dScene->AddSceneNode( pG3dLight );

	SetupScene();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		V[폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G3DSystem::DeleteScene(void)
{
	pG3dScene->RemoveAllSceneNodes();
	pG3dScene->DestroyOwnObject();
//	GFL_DELETE pG3dEnvironmentRes;
	GFL_DELETE pG3dScene;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		V[ZbgAbv
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G3DSystem::SetupScene(void)
{
	pG3dScene->Initialize();
	pG3dScene->Calculate();
	pG3dScene->SetSceneEnvironmentUsingOwnObject();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		V[CjVCY
 *
 * @param		none
 *
 * @return	none
 *
 * @li	fǉȂǂɌĂԂ
 */
//--------------------------------------------------------------------------------------------
void G3DSystem::InitializeScene(void)
{
	pG3dScene->Initialize();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		f[N쐬
 *
 * @param		heap		q[v
 * @param		max			ő쐬
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G3DSystem::CreateModelWork( Heap * heap, u32 max )
{
	modelWk = GFL_NEW( heap->Get() ) MODEL_WORK[max];
	gfl::std::MemClear( modelWk, sizeof(MODEL_WORK)*max );

	modelMax = max;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		f[N폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G3DSystem::DeleteModelWork(void)
{
	GFL_DELETE []modelWk;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fǉ
 *
 * @param		af			ArcFile
 * @param		datIdx	A[Nf[^CfbNX
 * @param		heap		q[v
 * @param		id			fIDiftHg = ADD_MODEL_ID_FREE j
 * @param		anm			Ajf[^iftHg = NULL j
 * @param		anmMax	Ajf[^iftHg = 0 j
 *
 * @return	fID
 *
 * @li	id = ADD_MODEL_ID_FREE ̏ꍇA󂢂Ăꏊɒǉ
 * @li	KDelModel()ŏƁI
 */
//--------------------------------------------------------------------------------------------
u32 G3DSystem::AddModel( gfl::fs::ArcFile * af, u32 datIdx, Heap * heap, u32 id, const ANIME_DATA * anm, u32 anmMax )
{
	if( id == ADD_MODEL_ID_FREE ){
		for( u32 i=0; i<modelMax; i++ ){
			if( modelWk[i].pG3dModel == NULL ){
				id = i;
				break;
			}
		}
	}

	GFL_ASSERT( id < modelMax );

	MODEL_WORK * wk = &modelWk[id];

	wk->pG3dModelRes = GFL_NEW( heap->Get() ) gfl::grp::g3d::Resource();
	wk->pG3dModel = GFL_NEW( heap->Get() ) gfl::grp::g3d::Model;

	wk->pG3dModelRes->Load( heap->GetDeviceAllocator(), af, datIdx, NULL );
	wk->pG3dModelRes->Setup( heap->GetDeviceAllocator(), NULL, gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT );

	wk->pG3dModel->Create( heap->GetAllocator(), heap->GetDeviceAllocator(), modelWk[id].pG3dModelRes, 0 );

	if( anm != NULL ){
		wk->mtsAnm = GFL_NEW( heap->Get() ) MODEL_ANM_WORK[anmMax];
		wk->sklAnm = GFL_NEW( heap->Get() ) MODEL_ANM_WORK[anmMax];
		wk->anmMax = anmMax;

		for( u32 i=0; i<anmMax; i++ ){
			wk->mtsAnm[i].pG3dAnm = GFL_NEW( heap->Get() ) gfl::grp::g3d::ResAnim();
			wk->mtsAnm[i].pG3dAnmRes = GFL_NEW( heap->Get() ) gfl::grp::g3d::Resource();

			wk->sklAnm[i].pG3dAnm = GFL_NEW( heap->Get() ) gfl::grp::g3d::ResAnim();
			wk->sklAnm[i].pG3dAnmRes = GFL_NEW( heap->Get() ) gfl::grp::g3d::Resource();
		}

		gfl::grp::g3d::Resource::AnimationResourcePack * res_pack = GFL_NEW( heap->Get() ) gfl::grp::g3d::Resource::AnimationResourcePack[anmMax*2];
		u32	cnt = 0;

		for( u32 i=0; i<anmMax; i++ ){
			if( anm[i].mts != ANIME_DATA_NONE ){
				wk->mtsAnm[i].pG3dAnmRes->Load( heap->GetDeviceAllocator(), af, anm[i].mts, NULL );
				wk->mtsAnm[i].pG3dAnm->Create( heap->GetDeviceAllocator(), wk->mtsAnm[i].pG3dAnmRes, 0, gfl::grp::g3d::ResAnim::TYPE_MATERIAL );
				res_pack[cnt].resource = wk->mtsAnm[i].pG3dAnmRes;
				res_pack[cnt].animation_resource_type = gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_MATERIAL;
				res_pack[cnt].index_in_resource = 0;
				cnt++;
			}
			if( anm[i].skl != ANIME_DATA_NONE ){
				wk->sklAnm[i].pG3dAnmRes->Load( heap->GetDeviceAllocator(), af, anm[i].skl, NULL );
				wk->sklAnm[i].pG3dAnm->Create( heap->GetDeviceAllocator(), wk->sklAnm[i].pG3dAnmRes, 0, gfl::grp::g3d::ResAnim::TYPE_SKELETAL );
				res_pack[cnt].resource = wk->sklAnm[i].pG3dAnmRes;
				res_pack[cnt].animation_resource_type = gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_SKELETAL;
				res_pack[cnt].index_in_resource = 0;
				cnt++;
			}
		}

		wk->maxAnmCount = gfl::grp::g3d::Resource::GetMaxMemberAnimSetCount( cnt, res_pack );

		GFL_DELETE	[]res_pack;
	}

	pG3dScene->AddSceneNode( wk->pG3dModel );

	return id;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		f폜
 *
 * @param		id		fID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G3DSystem::DelModel( u32 id )
{
	if( modelWk[id].anmMax != 0 ){
		for( u32 i=0; i<modelWk[id].anmMax; i++ ){
			if( modelWk[id].mtsAnm[i].pG3dAnm != NULL ){
				GFL_DELETE modelWk[id].mtsAnm[i].pG3dAnm;
				GFL_DELETE modelWk[id].mtsAnm[i].pG3dAnmRes;
			}
			if( modelWk[id].sklAnm[i].pG3dAnm != NULL ){
				GFL_DELETE modelWk[id].sklAnm[i].pG3dAnm;
				GFL_DELETE modelWk[id].sklAnm[i].pG3dAnmRes;
			}
		}
		GFL_DELETE []modelWk[id].mtsAnm;
		GFL_DELETE []modelWk[id].sklAnm;
	}

	GFL_DELETE modelWk[id].pG3dModel;
	GFL_DELETE modelWk[id].pG3dModelRes;

	gfl::std::MemClear( &modelWk[id], sizeof(MODEL_WORK) );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fAjύX
 *
 * @param		id			fID
 * @param		anmNo		Ajԍ
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void G3DSystem::ChangeModelAnime( u32 id, u32 anmNo, Heap * heap )
{
	MODEL_WORK * wk = &modelWk[id];

	if( wk->mtsAnm[anmNo].pG3dAnm != NULL ){
		wk->pG3dModel->ChangeAnimation( heap->GetDeviceAllocator(), wk->mtsAnm[anmNo].pG3dAnm, 0, 0, wk->maxAnmCount );
	}
	if( wk->sklAnm[anmNo].pG3dAnm != NULL ){
		wk->pG3dModel->ChangeAnimation( heap->GetDeviceAllocator(), wk->sklAnm[anmNo].pG3dAnm, 0, 1, wk->maxAnmCount );
	}
}



}	// sample
}	// app
