#pragma	once

#include <gflib.h>

#include "fieldmenu_def.h"


namespace field {
namespace subscreen {

class FM_Base {
public:
	typedef struct {
		gfl::fs::ArcFile::ARCID	arcID;
		gfl::grp::g2d::LytArcIndex	lytDataID;
		const gfl::grp::g2d::LytArcIndex * anmDataIDTbl;
		u32	anmTblNum;
		u32	anmMax;
		u32	putMode;
	}LAYOUT_DATA;

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 */
	//--------------------------------------------------------------------------------------------
	FM_Base( FLDMAP_WORK * wk );
	
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~FM_Base(void);

	void CreateLayout( LAYOUT_DATA * dat );
	void RemoveLayout(void);

	void InitMoveLayout( u32 mode );
	bool MoveLayout(void);

private:
	FLDMAP_WORK * mapWk;

	gfl::grp::g2d::LytResID	layoutResID;			// \[XID
	gfl::grp::g2d::LytWk * pLayoutWork;

	f32	scrollInitX;
	u32	scrollMode;
};


}		// subscreen
}		// field
