#include "fieldmenu_base.h"


namespace field {
namespace subscreen {

#define	FM_BASE_MOVE_X		( 16.0f )


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 */
//--------------------------------------------------------------------------------------------
FM_Base::FM_Base( FLDMAP_WORK * wk ) :
	mapWk( wk )
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
FM_Base::~FM_Base(void)
{
}

void FM_Base::CreateLayout( FM_Base::LAYOUT_DATA * dat )
{
	gfl::grp::g2d::LytWkSetUp setup = {
		gfl::math::VEC3(0,-290,0),	// pos 
		gfl::math::VEC2(1,1),				// scale
		gfl::math::VEC3(0,0,0),			// rotate
		FM_LYT_PRI_PSS,							// priority
		0														// groupID
	};

	if( dat->putMode == FM_PAGE_CHG_LEFT ){
		setup.pos.x = FM_PAGE_LEFT_PX;
	}else if( dat->putMode == FM_PAGE_CHG_RIGHT ){
		setup.pos.x = FM_PAGE_RIGHT_PX;
	}

	// \[Xǂݍ
	gfl::fs::ArcFile * af	= GFL_NEW( mapWk->heap ) gfl::fs::ArcFile( dat->arcID );
	layoutResID = mapWk->lytSys->LoadLytRes( mapWk->devAllocator, af, 0 );
	GFL_DELETE af;
	// FCRAMɃeNX`]
	mapWk->lytSys->TransferAllTexture( layoutResID, gfl::grp::MEMORY_AREA_FCRAM );

	pLayoutWork = mapWk->lytSys->CreateLytWk( layoutResID, dat->lytDataID, dat->anmDataIDTbl, dat->anmTblNum, dat->anmMax, &setup, false );
}

void FM_Base::RemoveLayout(void)
{
	mapWk->lytSys->RemoveLytWk( pLayoutWork );
	mapWk->lytSys->ReleaseLytRes( layoutResID );
}

void FM_Base::InitMoveLayout( u32 mode )
{
	gfl::math::VEC3	vec;

	pLayoutWork->GetTranslate( &vec );

	scrollInitX = vec.x;
	scrollMode  = mode;
}

bool FM_Base::MoveLayout(void)
{
	gfl::math::VEC3	vec;

	pLayoutWork->GetTranslate( &vec );

	if( scrollMode == FM_PAGE_CHG_LEFT ){
		vec.x += FM_BASE_MOVE_X;
		if( vec.x > (scrollInitX+320.0f) ){
			vec.x = scrollInitX + 320.0f;
		}
	}else if( scrollMode == FM_PAGE_CHG_RIGHT ){
		vec.x -= FM_BASE_MOVE_X;
		if( vec.x < (scrollInitX-320.0f) ){
			vec.x = scrollInitX - 320.0f;
		}
	}

	pLayoutWork->SetTranslate( vec );

	if( gfl::math::FAbs(vec.x-scrollInitX) == 320.0f ){
		return false;
	}
	return true;
}


}		// subscreen
}		// field
