#pragma	once

#include <gflib.h>
#include "../FieldSubWindow.h"

#include "fieldmenu_def.h"
#include "fieldmenu_base.h"
#include "fieldmenu_pss.h"
#include "fieldmenu_kawaigari.h"
#include "fieldmenu_training.h"


namespace field {
namespace subscreen {

class FieldMenu : public SubWindowProc {
public:
	enum {
		PAGE_PSS = 0,			// PSS
		PAGE_KAWAIGARI,		// 킢
		PAGE_TRAINING,		// g[jO
		PAGE_MAX,
	};

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 */
	//--------------------------------------------------------------------------------------------
	FieldMenu( Fieldmap * p_fieldmap );
	
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~FieldMenu(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Proc
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	gfl::proc::Result
	 */
	//--------------------------------------------------------------------------------------------
	virtual gfl::proc::Result InitFunc( gfl::proc::Manager * proc_manager );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ProcI
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	gfl::proc::Result
	 */
	//--------------------------------------------------------------------------------------------
	virtual gfl::proc::Result EndFunc( gfl::proc::Manager * proc_manager );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ProcAbvf[g
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	gfl::proc::Result
	 */
	//--------------------------------------------------------------------------------------------
	virtual gfl::proc::Result UpdateFunc( gfl::proc::Manager * proc_manager );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Proc`揈
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	virtual void DrawFunc( gfl::proc::Manager * proc_manager );

private:
	bool Update(void);
	void Draw(void);

	void SetMapWork(void);

	void CreateLayout(void);
	void RemoveLayout(void);

	void CreatePage( u8 id, u32 mode );
	void DeletePage( u8 id );
	u8 GetNextPage( s8 mv );

public:
	int MainSeq_PSS(void);
	int MainSeq_Kawaigari(void);
	int MainSeq_Training(void);
	int MainSeq_FieldMenu(void);
	int MainSeq_PageChange(void);

private:
	FLDMAP_WORK	mapWk;

	FM_Pss * pPss;
	FM_Kawaigari * pKawaigari;
	FM_Training * pTraining;

	FM_Base * baseOld;
	FM_Base * baseNew;

	gfl::grp::g2d::LytResID	layoutResID;			// \[XID
	gfl::grp::g2d::LytWk * pLayoutWork;

	u8	page;
	u8	pageNext;
	u8	pageEnable;
	u8	pageMax;

	int mainSeq;
	int subSeq;

};


}		// subscreen
}		// field
