#include "fieldmenu.h"
#include "fieldmenu_res.h"
#include "fieldmenu_res_pane.h"


namespace field {
namespace subscreen {

enum {
	MAINSEQ_PSS = 0,
	MAINSEQ_KAWAIGARI,
	MAINSEQ_TRAINING,
	MAINSEQ_FIELDMENU,

	MAINSEQ_PAGECHANGE,
};


typedef int (FieldMenu::*pSeqFunc)(void);

// CV[PX֐e[u
static const pSeqFunc MainSeq[] = {
	&FieldMenu::MainSeq_PSS,
	&FieldMenu::MainSeq_Kawaigari,
	&FieldMenu::MainSeq_Training,
	&FieldMenu::MainSeq_FieldMenu,

	&FieldMenu::MainSeq_PageChange,
};



//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 */
//--------------------------------------------------------------------------------------------
FieldMenu::FieldMenu( Fieldmap * p_fieldmap ) :
	SubWindowProc( p_fieldmap )
{
	page = PAGE_PSS;
	pageEnable = 0xff;

	mainSeq = MAINSEQ_PSS;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
FieldMenu::~FieldMenu(void)
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result FieldMenu::InitFunc( gfl::proc::Manager * )
{
	SetMapWork();
	CreateLayout();
	CreatePage( page, FM_PAGE_CHG_NONE );
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcI
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result FieldMenu::EndFunc( gfl::proc::Manager * )
{
	int	i;

	for( i=0; i<PAGE_MAX; i++ ){
		DeletePage( i );
	}
	RemoveLayout();

	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcAbvf[g
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result FieldMenu::UpdateFunc( gfl::proc::Manager * )
{
	// I
	if( IsReqEnd() ){
		return gfl::proc::RES_FINISH;
	}

	if( Update() == false ){
		return gfl::proc::RES_FINISH;
	}

	return gfl::proc::RES_CONTINUE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc`揈
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void FieldMenu::DrawFunc( gfl::proc::Manager * )
{
	Draw();
}

bool FieldMenu::Update(void)
{
	mainSeq = (this->*MainSeq[mainSeq])();
	return true;
}

void FieldMenu::Draw(void)
{
}


void FieldMenu::SetMapWork(void)
{
	field::Fieldmap * map = this->GetFieldmap();
	field::Graphics * gra = map->GetGraphics();

	mapWk.lytSys       = gra->GetLytSys();
	mapWk.heap         = this->GetSubWindowHeap();
	mapWk.devHeap      = this->GetSubWindowDevice();
	mapWk.allocator    = this->GetSubWindowHeapAllocator();
	mapWk.devAllocator = this->GetSubWindowDeviceAllocator();
}

void FieldMenu::CreateLayout(void)
{
	const gfl::grp::g2d::LytWkSetUp setup = {
		gfl::math::VEC3(0,-290,0),	// pos 
		gfl::math::VEC2(1,1),				// scale
		gfl::math::VEC3(0,0,0),			// rotate
		FM_LYT_PRI_MENU,						// priority
		0														// groupID
	};

	// \[Xǂݍ
	gfl::fs::ArcFile * af	= GFL_NEW( mapWk.heap ) gfl::fs::ArcFile( ARCID_FIELD_MENU_GRA );
	layoutResID = mapWk.lytSys->LoadLytRes( mapWk.devAllocator, af, 0 );
	GFL_DELETE af;
	// FCRAMɃeNX`]
	mapWk.lytSys->TransferAllTexture( layoutResID, gfl::grp::MEMORY_AREA_FCRAM );

	pLayoutWork = mapWk.lytSys->CreateLytWk( layoutResID, LYTRES_FIELDMENU_RES_MENU_BAR_BCLYT, NULL, 0, 0, &setup, false );
}

void FieldMenu::RemoveLayout(void)
{
	mapWk.lytSys->RemoveLytWk( pLayoutWork );
}

void FieldMenu::CreatePage( u8 id, u32 mode )
{
	switch( id ){
	case PAGE_PSS:				// PSS
		GFL_ASSERT( pPss == NULL );
		pPss = GFL_NEW( mapWk.heap ) FM_Pss( &mapWk, mode );
		baseOld = baseNew;
		baseNew = pPss;
		break;

	case PAGE_KAWAIGARI:	// 킢
		GFL_ASSERT( pKawaigari == NULL );
		pKawaigari = GFL_NEW( mapWk.heap ) FM_Kawaigari( &mapWk, mode );
		baseOld = baseNew;
		baseNew = pKawaigari;
		break;

	case PAGE_TRAINING:		// g[jO
		GFL_ASSERT( pTraining == NULL );
		pTraining = GFL_NEW( mapWk.heap ) FM_Training( &mapWk, mode );
		baseOld = baseNew;
		baseNew = pTraining;
		break;

	default:
		GFL_ASSERT( 0 );
	}

	if( mode == FM_PAGE_CHG_NONE ){
		baseOld = baseNew;
	}
}

void FieldMenu::DeletePage( u8 id )
{
	switch( id ){
	case PAGE_PSS:				// PSS
		if( pPss != NULL ){
			GFL_DELETE pPss;
			pPss = NULL;
		}
		break;

	case PAGE_KAWAIGARI:	// 킢
		if( pKawaigari != NULL ){
			GFL_DELETE pKawaigari;
			pKawaigari = NULL;
		}
		break;

	case PAGE_TRAINING:		// g[jO
		if( pTraining != NULL ){
			GFL_DELETE pTraining;
			pTraining = NULL;
		}
		break;

	default:
		GFL_ASSERT( 0 );
	}
}


u8 FieldMenu::GetNextPage( s8 mv )
{
	s8	next = page;

	while(1){
		next += mv;
		if( next < 0 ){
			next = PAGE_MAX - 1;
		}else if( next == PAGE_MAX ){
			next = 0;
		}
		if( next == page ){
			break;
		}

		if( ( pageEnable & (1<<next) ) != 0 ){
			break;
		}
	}

	return next;
}





int FieldMenu::MainSeq_PSS(void)
{
	gamesystem::GameManager * pgm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	gfl::ui::DeviceManager * devMan = pgm->GetUiDeviceManager();
	gfl::ui::Button * pButton = devMan->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );

	if( pButton->IsTrigger( gfl::ui::BUTTON_Y ) ){
	}
	if( pButton->IsTrigger( gfl::ui::BUTTON_L ) ){
//		GFL_PRINT( "trg L\n" );
		pageNext = GetNextPage( -1 );
		if( pageNext != page ){
			CreatePage( pageNext, FM_PAGE_CHG_LEFT );
			baseOld->InitMoveLayout( FM_PAGE_CHG_LEFT );
			baseNew->InitMoveLayout( FM_PAGE_CHG_LEFT );
			subSeq = 0;
			return MAINSEQ_PAGECHANGE;
		}
		return MAINSEQ_PSS;
	}
	if( pButton->IsTrigger( gfl::ui::BUTTON_R ) ){
//		GFL_PRINT( "trg R\n" );
		pageNext = GetNextPage( 1 );
		if( pageNext != page ){
			CreatePage( pageNext, FM_PAGE_CHG_RIGHT );
			baseOld->InitMoveLayout( FM_PAGE_CHG_RIGHT );
			baseNew->InitMoveLayout( FM_PAGE_CHG_RIGHT );
			subSeq = 0;
			return MAINSEQ_PAGECHANGE;
		}
		return MAINSEQ_PSS;
	}

	return MAINSEQ_PSS;
}

int FieldMenu::MainSeq_Kawaigari(void)
{
	return MAINSEQ_KAWAIGARI;
}

int FieldMenu::MainSeq_Training(void)
{
	return MAINSEQ_TRAINING;
}

int FieldMenu::MainSeq_FieldMenu(void)
{
	return MAINSEQ_FIELDMENU;
}

int FieldMenu::MainSeq_PageChange(void)
{
	bool ret_old = baseOld->MoveLayout();
	bool ret_new = baseNew->MoveLayout();

	if( ret_old == false && ret_new == false ){
		DeletePage( page );
		page = pageNext;
		return MAINSEQ_PSS;
	}

	return MAINSEQ_PAGECHANGE;
}



}		// subscreen
}		// field
