//=============================================================================
/**
 *
 *	@file		FieldScriptSystem.cpp
 *	@brief  tB[hXNvgVXe
 *	@author hosaka genya
 *	@data		2011.08.12
 *
 */
//=============================================================================

#include "field/script/FieldScriptSystem.h"

GFL_NAMESPACE_BEGIN( field )
GFL_NAMESPACE_BEGIN( script )

System* System::pThis = NULL;
  
// L[擾ix^j
cell AMX_NATIVE_CALL System::GetKeyCont( AMX *, const cell * )
{
  GFL_ASSERT( pThis );
  gfl::ui::Button *uiButton = pThis->m_pDeviceManager->GetButton(0);
  return uiButton->GetHold();
}

// L[擾igK[j
cell AMX_NATIVE_CALL System::GetKeyTrg( AMX *, const cell * )
{
  GFL_ASSERT( pThis );
  gfl::ui::Button *uiButton = pThis->m_pDeviceManager->GetButton(0);
  return uiButton->GetTrigger();
}

//-----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 *	
 *	@param  gfl::heap::HeapBase* p_heap   q[v
 */
//-----------------------------------------------------------------------------
System::System( gfl::heap::HeapBase* p_heap, gamesystem::GameManager* p_gman )
{
  m_pPawn = GFL_NEW( p_heap ) gfl::pawn::Pawn( p_heap );
  m_pDeviceManager = p_gman->GetUiDeviceManager();
  
  m_bRunning = false;
  
  GFL_ASSERT(pThis==NULL);
  pThis=this;  //i[
}

//-----------------------------------------------------------------------------
/**
 *	@brief  fXgN^
 */
//-----------------------------------------------------------------------------
System::~System( void )
{
  pThis = NULL;
  GFL_DELETE( m_pPawn );
}

//-----------------------------------------------------------------------------
/**
 *	@brief  XNvg[hA߃Zbg̓o^
 *
 *	@param	gfl::fs::ArcFile::ARCDATID id  ǂݍރXNvgID
 */
//-----------------------------------------------------------------------------
void System::LoadFile( gfl::fs::ArcFile::ARCDATID id )
{ 
  GFL_ASSERT( m_pPawn->GetAmx() );
  
  m_pPawn->LoadFile( "field/script/t01.amx" );
  
  HOSAKA_PRINT( "script load id = %d \n", id );
}
  
#include "AmxPath.cdat"

//-----------------------------------------------------------------------------
/**
 *	@brief  XNvg[hA߃Zbg̓o^
 *
 *	@param	ZoneID zone_id  ][ID
 */
//-----------------------------------------------------------------------------
void System::LoadFile( ZoneID zone_id )
{ 
  HOSAKA_PRINT( "zone_id = %d \n", zone_id );
  
#if PM_DEBUG
  
  const char* path;
  path = amxNamePath[ zone_id ];
  
  HOSAKA_PRINT( "script load = %s \n", path );
  
  m_pPawn->LoadFile( path );
 
#else
  LoadFile( static_cast<gfl::fs::ArcFile::ARCDATID>(zone_id) );
#endif
  
  //@todo ߃Zbg̓ǂݍ
  //@todo ǂā@ǂ̖߃Zbgǂݍނ̂߂邩H
  
  static const GFL_PAWN_FUNC_TABLE s_FuncTable[] = 
  {
    GFL_PAWN_FUNC( GetKeyCont ) 
    GFL_PAWN_FUNC( GetKeyTrg ) 
    GFL_PAWN_FUNC_END,
  };

  RegisterPawnFunction( s_FuncTable );
}

//-----------------------------------------------------------------------------
/**
 *	@brief  XNvgJn
 *
 *	@param	u32 mode Jn[h
 */
//-----------------------------------------------------------------------------
void System::RunRequest( u32 mode )
{
  HOSAKA_PRINT( "script run req\n" );
  
  GFL_ASSERT( m_bRunning == false );
  
  //@todo ֐ɃANZX
  m_pPawn->SetGlobalParameterInteger( "g_mode", mode );
  
  m_bRunning = true;
  
}

//-----------------------------------------------------------------------------
/**
 *	@brief  XNvgXV
 */
//-----------------------------------------------------------------------------
void System::Update( void )
{
  if( m_bRunning )
  {
    // s֐
    m_pPawn->Update();
    
    if( m_pPawn->IsFinished() )
    {
      m_bRunning = false;
      HOSAKA_PRINT( "Script End\n" );
    }
  }
}
  
GFL_NAMESPACE_END( script )
GFL_NAMESPACE_END( field )
