//=============================================================================
/**
 *
 *	@file		EventScriptCall.cpp
 *	@brief  XNvgĂяo
 *	@author hosaka genya
 *	@data		2011.08.24
 *
 */
//=============================================================================
#include "EventScriptCall.h"

GFL_NAMESPACE_BEGIN( field );

void EventScriptCall::SetUp( u32 mode )
{
  m_Mode = mode;
}

bool EventScriptCall::BootChk( gamesystem::GameManager* p_gman )
{
  GFL_UNUSED(p_gman);
  return true;
}


void EventScriptCall::InitFunc(gamesystem::GameManager* p_gman)
{
  GFL_UNUSED(p_gman);
}

gamesystem::GMEVENT_RESULT EventScriptCall::MainFunc(gamesystem::GameManager* p_gman)
{
  script::System* script = p_gman->GetFieldScriptSystem();
  
  switch( m_Seq )
  {
    case 0:
      script->RunRequest( m_Mode );
      m_Seq = 1;
      /* FALLTHROW */

    case 1:
      // XNvgXV
      script->Update();
      if( script->IsRunning() == false )
      {
        return gamesystem::GMEVENT_RES_FINISH;
      }
      break;

    default : GFL_ASSERT(0);
  }

  return gamesystem::GMEVENT_RES_CONTINUE;
}
  
void EventScriptCall::EndFunc(gamesystem::GameManager* p_gman)
{
  GFL_UNUSED(p_gman);
}


GFL_NAMESPACE_END( field );
