//=============================================================================
/**
 *
 *	@file		FieldScriptSystem.h
 *	@brief  tB[hXNvgVXe
 *	@author hosaka genya
 *	@data		2011.08.12
 *
 */
//=============================================================================
#ifndef __FIELDSCRIPTSYSTEM_H__
#define __FIELDSCRIPTSYSTEM_H__

#include "gfl_Pawn.h"

GFL_NAMESPACE_BEGIN( field )
GFL_NAMESPACE_BEGIN( script )

class System
{ 
  GFL_FORBID_COPY_AND_ASSIGN( System );
public:
  // RXgN^EfXgN^
  System( gfl::heap::HeapBase* p_heap, gamesystem::GameManager* p_gman );
  ~System( void );
  
  void LoadFile( gfl::fs::ArcFile::ARCDATID id );
  void LoadFile( ZoneID zone_id );
  void RunRequest( u32 mode );
  void Update( void );
  
  bool IsRunning( void ) const { return m_bRunning; }
  void RegisterPawnFunction( const GFL_PAWN_FUNC_TABLE native_func_tbl[] ){ m_pPawn->RegisterPawnFunction( native_func_tbl ); }
  
private:
  //ÓIȊ֐łȂƌĂяoȂ玩gKv
  //ł͎ƂČ肵Ă邪Ȁꍇɂ͂𑝂₵ĊǗKv
  static System* pThis;
  
  gfl::pawn::Pawn*  m_pPawn;
  gfl::ui::DeviceManager* m_pDeviceManager;
  bool              m_bRunning;
  
  // XNvgɓn֐
  static cell AMX_NATIVE_CALL GetKeyCont( AMX *, const cell * );
  static cell AMX_NATIVE_CALL GetKeyTrg( AMX *, const cell * );
};
  

GFL_NAMESPACE_END( script )
GFL_NAMESPACE_END( field )


#endif // __FIELDSCRIPTSYSTEM_H__
