//=======================================================================================
/**
 * @file   test_obata_btl_TripleBattle.h
 * @brief  ogʂ̃eXgvZX
 * @author obata_toshihiro
 * @date   2011.08.06
 */
//=======================================================================================
#include <gflib.h>
#include <gamesystem/GameProc.h>
#include <battle/battle_MainProc.h>
#include <battle/btlv/app/AppBase.h>
#include <battle/btlv/app/ActionSelect.h>
#include "test_obata_btl_TripleBattle.h"

namespace test {
  namespace obata {



    //-----------------------------------------------------------------------------------
    // RXgN^
    //-----------------------------------------------------------------------------------
    TripleBattle::TripleBattle( void ) : 
      btl::BattleMainProc(),
      m_set_next_proc( false )
    {
      gfl::heap::HeapBase* heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
      gfl::heap::HeapBase* device_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );
      gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      gamesystem::GameData* game_data = game_manager->GetGameData();
      pml::bridge::CtrAllocator allocator( heap ); 

      // p[eB쐬
      pml::PokeParty* player_party = game_data->GetPlayerParty(); 
      {
        pml::pokepara::PokemonParam* param;
        param = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_PIKATYUU, 5, 0 );
        player_party->ReplaceMember( 0, *param );
        pml::System::PokeParaFactory()->DeletePokemonParam( param );

        param = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_RAITYUU, 5, 0 );
        player_party->ReplaceMember( 1, *param );
        pml::System::PokeParaFactory()->DeletePokemonParam( param );

        param = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_PITYUU, 5, 0 );
        player_party->ReplaceMember( 2, *param );
        pml::System::PokeParaFactory()->DeletePokemonParam( param );
      }

      // Gp[eB쐬
      m_enemy_party = GFL_NEW( heap ) pml::PokeParty( heap );
      {
        pml::pokepara::PokemonParam* param;
        param = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_HUSIGIBANA, 5, 0 );
        m_enemy_party->AddMember( *param ); 
        pml::System::PokeParaFactory()->DeletePokemonParam( param );

        param = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_RIZAADON, 5, 0 );
        m_enemy_party->AddMember( *param ); 
        pml::System::PokeParaFactory()->DeletePokemonParam( param );

        param = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_KAMEKKUSU, 5, 0 );
        m_enemy_party->AddMember( *param ); 
        pml::System::PokeParaFactory()->DeletePokemonParam( param );

        param = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_PIZYOTTO, 5, 0 );
        m_enemy_party->AddMember( *param ); 
        pml::System::PokeParaFactory()->DeletePokemonParam( param );

        param = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_ONIDORIRU, 5, 0 );
        m_enemy_party->AddMember( *param ); 
        pml::System::PokeParaFactory()->DeletePokemonParam( param );
      }


      // ogvZX̃ZbgAbv
      BATTLE_SETUP_FIELD_SITUATION_Init( &m_btl_field_situation );
      BATTLE_SETUP_Wild( &m_btl_param, game_data, 
          m_enemy_party, &m_btl_field_situation, BTL_RULE_TRIPLE, heap ); 
      this->SetupParam( &m_btl_param, heap, device_heap );
    }



    //-----------------------------------------------------------------------------------
    // fXgN^
    //----------------------------------------------------------------------------------- 
    TripleBattle::~TripleBattle( void )
    {
      GFL_DELETE m_enemy_party;
    }



    //----------------------------------------------------------------------------------- 
    // I
    //----------------------------------------------------------------------------------- 
    gfl::proc::Result TripleBattle::EndFunc( gfl::proc::Manager* pProcManager )
    {
      if( !m_set_next_proc ) {
        m_set_next_proc = true;
        KUJIRA_PROC_SETNEXT<gamesystem::GameProcManager, test::obata::Proc>( 
            GFL_SINGLETON_INSTANCE( gamesystem::GameManager )->GetProcManager() );
        gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_DOUBLE, 10 );  // ʃtF[hCJn
      }
      return btl::BattleMainProc::EndFunc( pProcManager );
    }



  } // namespace obata
} // namespace test 
