//=======================================================================================
/**
 * @file   test_obata_btl_SingleBattle.h
 * @brief  ogʂ̃eXgvZX
 * @author obata_toshihiro
 * @date   2011.08.06
 */
//=======================================================================================
#include <gflib.h>
#include <gamesystem/GameProc.h>
#include <battle/battle_MainProc.h>
#include <battle/btlv/app/AppBase.h>
#include <battle/btlv/app/ActionSelect.h>
#include "test_obata_btl_SingleBattle.h"

namespace test {
  namespace obata {



    //-----------------------------------------------------------------------------------
    // RXgN^
    //-----------------------------------------------------------------------------------
    SingleBattle::SingleBattle( void ) : 
      btl::BattleMainProc(),
      m_set_next_proc( false )
    {
      gfl::heap::HeapBase* heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
      gfl::heap::HeapBase* device_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );
      gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      gamesystem::GameData* game_data = game_manager->GetGameData();
      pml::bridge::CtrAllocator allocator( heap ); 

      // p[eB쐬
      pml::PokeParty* player_party = game_data->GetPlayerParty(); 
      {
        pml::pokepara::PokemonParam* param = 
          pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_PIKATYUU, 5, 0 );
        player_party->ReplaceMember( 0, *param );
      }

      // Gp[eB쐬
      m_enemy_party = GFL_NEW( heap ) pml::PokeParty( heap );
      {
        pml::pokepara::PokemonParam* param = 
          pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_PIKATYUU, 5, 0 );
        m_enemy_party->AddMember( *param ); 
      }


      // ogvZX̃ZbgAbv
      BATTLE_SETUP_FIELD_SITUATION_Init( &m_btl_field_situation );
      BATTLE_SETUP_Wild( &m_btl_param, game_data, 
          m_enemy_party, &m_btl_field_situation, BTL_RULE_SINGLE, heap ); 
      this->SetupParam( &m_btl_param, heap, device_heap );
    }



    //-----------------------------------------------------------------------------------
    // fXgN^
    //----------------------------------------------------------------------------------- 
    SingleBattle::~SingleBattle( void )
    {
      GFL_DELETE m_enemy_party;
    }



    //----------------------------------------------------------------------------------- 
    // I
    //----------------------------------------------------------------------------------- 
    gfl::proc::Result SingleBattle::EndFunc( gfl::proc::Manager* pProcManager )
    {
      if( !m_set_next_proc ) {
        m_set_next_proc = true;
        KUJIRA_PROC_SETNEXT<gamesystem::GameProcManager, test::obata::Proc>( 
            GFL_SINGLETON_INSTANCE( gamesystem::GameManager )->GetProcManager() );
        gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_DOUBLE, 10 );  // ʃtF[hCJn
      }
      return btl::BattleMainProc::EndFunc( pProcManager );
    }



  } // namespace obata
} // namespace test 
