//================================================================================
/**
 * @file   test_ohno_tinymt.cpp
 * @brief  ̃eXg
 * @author k.ohno
 * @date   2011.08.19
 */ 
//================================================================================
#include <nn.h>
#include <gflib.h>
#include <gamesystem/GameManager.h>
#include <gamesystem/GameProcManager.h>
#include "test_ohno_tinymt.h"


namespace gflnet{
extern nn::nex::qInt GenericInit(nn::nex::qInt argc, nn::nex::qChar** argv,
                                 gfl::heap::HeapBase *systemHeap,gfl::ui::Button*);
extern nn::nex::qInt GenericMain(nn::nex::qInt argc, nn::nex::qChar** argv,
                                 gfl::heap::HeapBase *systemHeap,gfl::ui::Button*);
extern nn::nex::qInt GenericEnd(nn::nex::qInt argc, nn::nex::qChar** argv,
                                 gfl::heap::HeapBase *systemHeap,gfl::ui::Button*);
};

GFL_NAMESPACE_BEGIN(test)
GFL_NAMESPACE_BEGIN(ohno)




    //-----------------------------------------------------------------------------
    // RXgN^
    //-----------------------------------------------------------------------------
TestOhnoTinymt::TestOhnoTinymt( 
  gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
  gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allcator,
  gfl::grp::GraphicsSystem* graphics_system, gfl::ui::DeviceManager* ui_device_manager ) :
Base( heap, device_heap, heap_allocator, device_allcator, graphics_system, ui_device_manager )
{ 
  gfl::heap::HeapBase *pSsystemHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );


  gfl::math::Random *rnd1 = GFL_NEW(pSsystemHeap) gfl::math::Random();
  rnd1->Initialize();

  for(int i=0;i<1000;i++){  //z
    int ans = rnd1->Next(100);
    if(ans < 10){
      NN_LOG("%4d  %2d \n",i,ans);
    }
 //   buff[i] = ans;
  }

  GFL_DELETE rnd1;

}


//-----------------------------------------------------------------------------
// fXgN^
//-----------------------------------------------------------------------------
TestOhnoTinymt::~TestOhnoTinymt()
{
}


//-----------------------------------------------------------------------------
// C
//-----------------------------------------------------------------------------
void TestOhnoTinymt::UpdateTest( void )
{

  
  // START {^ŏI
  if( m_button->IsTrigger( gfl::ui::BUTTON_START ) ) {
    this->End();
  }
} 



//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void TestOhnoTinymt::DrawTest( void )
{

}


GFL_NAMESPACE_END(ohno)
GFL_NAMESPACE_END(test)
