//======================================================================
/**
 * @file	btlv_core_eff.h
 * @brief	EffectViewerpbtlvCore
 * @author	ariizumi
 * @data	11/8/10
 */
//======================================================================

#ifndef __BTLV_CORE_EFF_H__
#define __BTLV_CORE_EFF_H__

#include "battle/btlv/btlv_core.h"

namespace btl
{
  class BTL_POKEPARAM;
  class BTL_PARTY;
}

namespace test
{
namespace ariizumi
{

class BattleEffectViewSystem : public btl::BattleViewSystem
{
public:
  BattleEffectViewSystem(void);
  virtual ~BattleEffectViewSystem();

  virtual void Initialize(gfl::heap::HeapBase* heapMem , gfl::heap::HeapBase* deviceMem );

private:
  virtual BtlRule GetBattleRule(void)const{return BTL_RULE_SINGLE;}
  virtual u8 GetClientID(void)const{return 0;}

  virtual btl::BtlvPos BtlPosToViewPos( btl::BtlPokePos pos )const{return (btl::BtlvPos)pos;}
  virtual btl::BtlPokePos ViewPosToBtlPos( btl::BtlvPos pos )const{return (btl::BtlPokePos)pos;}

  virtual btl::BTL_POKEPARAM* GetBattlePokeParam( btl::BtlvPos pos )const{return mBtlParam[pos%2][pos/2];}
  virtual btl::BTL_PARTY* GetBattleParty_Self(void)const{return mParty[0];}
  virtual btl::BTL_PARTY* GetBattleParty_Enemy(int idx = 0)const{return mParty[1];}

  virtual bool isArBattle(void)const{return false;}

  //_~[f[^
  pml::pokepara::PokemonParam *mParam[2][6];

  btl::BTL_PARTY *mParty[2];
  btl::BTL_POKEPARAM *mBtlParam[2][6];

};


}//namespace test
}//namespace ariizumi


#endif //__BTLV_CORE_EFF_H__
