//======================================================================
/**
 * @file	btlv_core_eff.cpp
 * @brief	EffectViewerpbtlvCore
 * @author	ariizumi
 * @data	11/8/10
 */
//======================================================================

#include <gflib.h>

#include "battle/btlv/btlv_core.h"
#include "battle/btl_pokeparam.h"
#include "battle/btl_party.h"
#include "btlv_core_eff.h"

namespace test
{
namespace ariizumi
{

BattleEffectViewSystem::BattleEffectViewSystem(void)
:BattleViewSystem()
{
  mIsEffView = false;
}

BattleEffectViewSystem::~BattleEffectViewSystem()
{
  mParty[0]->Initialize();
  mParty[1]->Initialize();

  for( int i=0;i<6;i++ )
  {
    GFL_DELETE mBtlParam[0][i];
    GFL_DELETE mBtlParam[1][i];

    pml::System::PokeParaFactory()->DeletePokemonParam( mParam[0][i] );
    pml::System::PokeParaFactory()->DeletePokemonParam( mParam[1][i] );
  }
  
  GFL_DELETE mParty[0];
  GFL_DELETE mParty[1];
}

void BattleEffectViewSystem::Initialize(gfl::heap::HeapBase* heapMem , gfl::heap::HeapBase* deviceMem )
{
  //_~[f[^쐬

  pml::bridge::CtrAllocator allocator( heapMem );
  for( int i=0;i<2;i++ )
  {
    mParty[i] = GFL_NEW(heapMem)btl::BTL_PARTY();
  }

  for( int i=0;i<6;i++ )
  {
    mParam[0][i] = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, (MonsNo)(MONSNO_PIKATYUU+i), 20+i, 0 );
    mParam[1][i] = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, (MonsNo)(MONSNO_PIKATYUU+i), 20+i, 0 );
    
    mBtlParam[0][i] = GFL_NEW(heapMem)btl::BTL_POKEPARAM(mParam[0][i],i);
    mBtlParam[1][i] = GFL_NEW(heapMem)btl::BTL_POKEPARAM(mParam[1][i],i);

    mParty[0]->AddMember( mBtlParam[0][i] );
    mParty[1]->AddMember( mBtlParam[1][i] );
  }
  

  BattleViewSystem::Initialize(heapMem,deviceMem);
  
  //heapMem->Dump();
}
  
}//namespace test
}//namespace ariizumi
