//======================================================================
/**
 * @file	btl_effect_viewer.cpp
 * @brief	EffectViewer
 * @author	ariizumi
 * @data	11/8/9
 */
//======================================================================

#include <gflib.h>

#include "btl_eff_viewer.h"



namespace test
{
namespace ariizumi
{

//------------------------------------------------------------------
/**
 * @brief	  PROC̏s֐
 * @return	Result 삪I RES_FINISHԂĂ炤MainFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result BattleEffectViewerProc::InitFunc(gfl::proc::Manager* pManager)
{
  GFL_UNUSED( pManager );
  
  gfl::heap::HeapBase* heap_memory   = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
  gfl::heap::HeapBase* device_memory = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );

#if GFL_HIO_ENABLE
  gfl::fs::FileSystem::InitializeHio( gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE ) );
#endif
  
  mHeapMem = gfl::heap::Manager::CreateHeap( heap_memory, HEAPID_TEST_ARIIZUMI    , 0x500000  , gfl::heap::HEAP_TYPE_EXP );
  mDevMem = gfl::heap::Manager::CreateHeap( device_memory,HEAPID_TEST_ARIIZUMI_DEV, 0x1500000 , gfl::heap::HEAP_TYPE_EXP );


  mViewCore = GFL_NEW( mHeapMem ) BattleEffectViewSystem();
  mViewCore->Initialize( mHeapMem , mDevMem );

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̏Is֐
 * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
 */
//------------------------------------------------------------------
gfl::proc::Result BattleEffectViewerProc::EndFunc(gfl::proc::Manager* pManager)
{
  GFL_UNUSED( pManager );
  
  mViewCore->Finalize();
  GFL_DELETE mViewCore;

  gfl::heap::Manager::DeleteHeap( mHeapMem );
  gfl::heap::Manager::DeleteHeap( mDevMem );

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃Cs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result BattleEffectViewerProc::UpdateFunc(gfl::proc::Manager* pManager)
{

  mViewCore->Update();
 return gfl::proc::RES_CONTINUE;
}

void BattleEffectViewerProc::DrawFunc(gfl::proc::Manager* pManager)
{
  mViewCore->Draw();


}
  
  
}//namespace test
}//namespace ariizumi
