//======================================================================
/**
 * @file  btlv_seq_sys.cpp
 * @brief og`V[PXVXe
 * @author  ariizumi
 * @data  11/08/11
 */
//======================================================================

#include <gflib.h> 
#include "btlv_local_def.h"
#include "btlv_seq_sys.h"

#include "btlv_seq_com.h"

namespace btl
{

#define BTL_SEQ_DEF(name) BTLV_SEQCOM_ ## name ,

tool::seqeditor::SEQEDITOR_COMMAND_FUNC comFunc[]=
{
#include "btlv_seq_com.cdat"
};


BtlvSeqSys::BtlvSeqSys(BattleViewSystem *core)
:mBtlvCore(core)
{
  gfl::heap::HeapBase *heapMem = mBtlvCore->GetHeapMem();
  
  tool::seqeditor::InitParam initParam =
  {
    heapMem,
    comFunc,
    GFL_NELEMS(comFunc)
  };
  
  mSeqSys = GFL_NEW(heapMem)tool::seqeditor::SeqSystem(initParam);
}

BtlvSeqSys::~BtlvSeqSys()
{
  GFL_DELETE mSeqSys;
}

void BtlvSeqSys::Update(void)
{
  
  mSeqSys->UpdateFrame();
}


}

