﻿##============================================================================
=pod
     file   camera_setting_excel_converter.pl
     brief  フィールドカメラ設定を書いたExcelファイルをバイナリファイルに変換する
     author Koji Kawada
     data   2011.08.11
=cut 
##============================================================================


##============================================================================
=pod

[usage]
perl camera_setting_excel_converter.pl excel_file.xls binary_file.bin

[引数]
excel_file.xls
入力するExcelファイル

binary_file.bin
生成されるバイナリファイル

=cut 
##============================================================================


# このソース自体をUTF8で記述し、UTF8で処理を行う
use utf8;
binmode STDIN,  ":encoding(shiftjis)";
binmode STDOUT, ":encoding(shiftjis)";
binmode STDERR, ":encoding(shiftjis)";

# インクルード
use Encode;


##============================================================================
=pod
    グローバル変数
=cut
##============================================================================
#### デバッグフラグ
$g_warning_enable  = 1;  # 0のとき警告コード無効、1のとき警告コード有効
$g_debug_enable    = 1;  # 0のときデバッグコード無効、1のときデバッグコード有効

#### 入力および出力
# 引数
$g_excel_file   = $ARGV[0];  # excel_file.xls
$g_binary_file  = $ARGV[1];  # binary_file.bin

# 入力ファイル
# なし

# 出力ファイル
# なし

# 使用するファイル
$g_excel_sheet_converter = $ENV{"GFL_TOOL_DIR"}."/exceltool/ExcelSeetConv.exe";   # Excelファイルからシートをcsvで抜き出すツール

# 一時的に生成してすぐに削除するcsvファイル
$g_csv_file      = "camera_setting.csv";       # g_excel_fileから抜き出したシートのcsvファイル  # ShiftJIS版
$g_csv_file_utf8 = "camera_setting_utf8.csv";  # g_csv_fileのUTF8版
# exeでファイルを生成しなければならない縛りがなければFile::Tempを使用するのだが。

#### 定数
# g_excel_fileにあるシートの名前
$g_excel_sheet = "data";

## g_excel_sheetのセル番号
## 1(A)スタートとした場合、(3,F)はrow3=3行目、column6=6(F)列目となる
#$g_sheet_start_row =   2;  # 1スタート
#$g_sheet_end_row   =  40;  # g_sheet_start_row<= <g_sheet_end_row
#$g_sheet_start_col =   2;  # 1スタート
#$g_sheet_end_col   =  16;  # g_sheet_start_col<= <g_sheet_end_col

# g_excel_sheetのセル番号がまだ未定のときの値
$g_sheet_start_end_not_set = -1;
# g_excel_sheetのセルに入っている予約語
$g_sheet_start_reserved_word = "#data_start";
$g_sheet_end_reserved_word   = "#data_end";

#### 変数
# g_excel_sheetのセル番号
# 1(A)スタートとした場合、(3,F)はrow3=3行目、column6=6(F)列目となる
$g_sheet_start_row = $g_sheet_start_end_not_set;  # g_sheet_start_row<= <g_sheet_end_row
$g_sheet_end_row   = $g_sheet_start_end_not_set;  # "#data_start" < row < "#data_end" を読んで設定する
$g_sheet_start_col = $g_sheet_start_end_not_set;  # g_sheet_start_col<= <g_sheet_end_col
$g_sheet_end_col   = $g_sheet_start_end_not_set;  # $g_sheet_start_row = #data_start +1; $g_sheet_end_row = #data_end; となる。

# 2次元配列のテーブル
@g_table = ();  # g_table[row][col]

# テーブルの列の内容  # @todo 本来ならこの情報をゲームプログラムとこのコンバートプログラムで共用しなければならない。
$g_table_col_index       =  0;
$g_table_col_length      =  1;
$g_table_col_pitch       =  2;
$g_table_col_yow         =  3;
$g_table_col_roll        =  4;
$g_table_col_view_type   =  5;
$g_table_col_depth       =  6;
$g_table_col_fovy        =  7;
$g_table_col_near        =  8;
$g_table_col_far         =  9;
$g_table_col_player_link = 10;
$g_table_col_offset_x    = 11;
$g_table_col_offset_y    = 12;
$g_table_col_offset_z    = 13;


##=============================================================================
=pod
    メイン処理
=cut
##=============================================================================
&MakeTemporaryFileName();
&ConvertExcelToCsv( $g_excel_file, $g_excel_sheet, $g_csv_file );
&EncodeFileFromShiftjisToUtf8( $g_csv_file, $g_csv_file_utf8 );
&ReadCsvFile();
&WriteBinaryFile();
&RemoveCsv();

# 終了
exit;


##=============================================================================
=pod
    サブルーチン
=cut
##=============================================================================

##-------------------------------------
### 一時ファイルの名前を決める
### グローバル変数を使っているので、他では使えないサブルーチンです。
##-------------------------------------
sub MakeTemporaryFileName
{
  my $current_time = time();
 
  {
    my $csv_file_base = $g_csv_file.$current_time;
    my $no = 0;
    my $csv_file_unique = $csv_file_base.$no;
    while( -f $csv_file_unique )
    {
      $no++;
      $csv_file_unique = $csv_file_base.$no;
      if( $no > 9999 )  # ここまでずっと同じ名前ならあきらめる
      {
        if( $g_warning_enable == 1 )
        {
          # 標準エラー出力
          print STDERR "There is the same file name \""."$csv_file_unique"."\""."\r\n";  # 0D 0A
        }

        last;
      }
    }
    $g_csv_file = $csv_file_unique;
  }

  {
    my $csv_file_base = $g_csv_file_utf8.$current_time;
    my $no = 0;
    my $csv_file_unique = $csv_file_base.$no;
    while( -f $csv_file_unique )
    {
      $no++;
      $csv_file_unique = $csv_file_base.$no;
      if( $no > 9999 )  # ここまでずっと同じ名前ならあきらめる
      {
        if( $g_warning_enable == 1 )
        {
          # 標準エラー出力
          print STDERR "WARNING: There is the same file name \""."$csv_file_unique"."\""."\r\n";  # 0D 0A
        }

        last;
      }
    }
    $g_csv_file_utf8 = $csv_file_unique;
  }

  if( $g_debug_enable == 1 )
  {
    # 標準エラー出力
    print STDERR "$g_csv_file"."\r\n";  # 0D 0A
    print STDERR "$g_csv_file_utf8"."\r\n";  # 0D 0A
  }
}

##-------------------------------------
### Excelファイルからシートをcsvで抜き出す
### グローバル変数を使っているので、他では使えないサブルーチンです。
##-------------------------------------
sub ConvertExcelToCsv
{
  my( $xls_file, $sheet_name, $csv_file ) = @_;
  system( $g_excel_sheet_converter.' -o '.$csv_file.' -n '.$sheet_name.' -s csv '.$xls_file );
}

##-------------------------------------
### ShiftJISファイルからUTF8ファイルを作成する
### グローバル変数を一切使っていないので、他でも使うことができるサブルーチンです。
##=====================================
sub EncodeFileFromShiftjisToUtf8
{
  my $in_file   = $_[0];  # shiftjis
  my $out_file  = $_[1];  # utf8

  open( IN, "<", $in_file );
  open( OUT, ">", $out_file );

  while( <IN> )
  {
    #$line = Encode::decode( 'shiftjis', $_ );
    $line = Encode::decode( 'cp932', $_ );  # WindowsのShiftJISはcp932。これにしておかないとハイフンとかチルダがうまくいかないらしい。
    print OUT Encode::encode( 'utf8', $line );
  }

  close( OUT );
  close( IN );
}

##-------------------------------------
### csvからデータを読み込む
### グローバル変数を使っているので、他では使えないサブルーチンです。
##-------------------------------------
sub ReadCsvFile
{
  my $sheet_row_no    = 1;  # csvの行番号(1スタート)
  my $sheet_col_no    = 1;  # csvの列番号(1スタート)

  my $table_row_index = 0;  # テーブルの行番号(0スタート)
  my $table_col_index = 0;  # テーブルの列番号(0スタート)


  open( DATA, "<:encoding(utf8)", $g_csv_file_utf8 );

  # 値に改行コードを含む CSV形式を扱う

  while (my $line = <DATA>)
  {
    $line .= <DATA> while ($line =~ tr/"// % 2 and !eof(DATA));

    $line =~ s/(?:\x0D\x0A|[\x0D\x0A])?$/,/;
    @values = map {/^"(.*)"$/s ? scalar($_ = $1, s/""/"/g, $_) : $_}
                  ($line =~ /("[^"]*(?:""[^"]*)*"|[^,]*),/g);

    # @values を処理する
    

    $sheet_col_no = 1;
    $table_col_index = 0;
    my $table_row_increment = 0;

    foreach my $word ( @values )
    {
      if( $g_sheet_start_row == $g_sheet_start_end_not_set )  # まだデータの開始位置を見付けていないとき
      {
        if( $word eq $g_sheet_start_reserved_word )
        {
          $g_sheet_start_row = $sheet_row_no +1;
          $g_sheet_start_col = $sheet_col_no +1;
        }
      }
      elsif( $g_sheet_end_col == $g_sheet_start_end_not_set )  # まだデータの列の終了位置を見付けていないとき
      {
        if( $word eq $g_sheet_end_reserved_word )
        {
          $g_sheet_end_col = $sheet_col_no;
        }
      }
      else  # 既にデータの開始位置を見付けており、かつ、既にデータの列の終了位置を見付けているとき
      {
        if( $g_sheet_end_row == $g_sheet_start_end_not_set )  # まだデータの行の終了位置を見付けていないとき
        {
          if( $word eq $g_sheet_end_reserved_word )  # データの行の終了位置を見付けた
          {
            $g_sheet_end_row = $sheet_row_no;
          }
          else
          {
            if( ($g_sheet_start_col <= $sheet_col_no) && ($sheet_col_no < $g_sheet_end_col) && ($g_sheet_start_row <= $sheet_row_no) )  # データとして扱える範囲内
            {
              $g_table[$table_row_index][$table_col_index] = $word;
              $table_col_index++;

              $table_row_increment = 1;
            }
          }
        }
      }

      $sheet_col_no++;
    }

    if( $table_row_increment )
    {
      $table_row_index++;
    }
    $sheet_row_no++;


  }

  close( DATA );
}

##-------------------------------------
### バイナリファイルを書き出す
### グローバル変数を使っているので、他では使えないサブルーチンです。
##-------------------------------------
sub WriteBinaryFile
{
  open( FH_BIN,  ">", $g_binary_file );

  for( my $row=0; $row<$g_sheet_end_row-$g_sheet_start_row; $row++ )
  {
    my $buf;
    $buf = pack "l", $g_table[$row][$g_table_col_index];
    print FH_BIN "$buf";
    $buf = pack "f", $g_table[$row][$g_table_col_length];
    print FH_BIN "$buf";
    $buf = pack "f", $g_table[$row][$g_table_col_pitch];
    print FH_BIN "$buf";
    $buf = pack "f", $g_table[$row][$g_table_col_yow];
    print FH_BIN "$buf";
    $buf = pack "f", $g_table[$row][$g_table_col_roll];
    print FH_BIN "$buf";

    my $view_type = 0;
    if( $g_table[$row][$g_table_col_view_type] eq "PER" )
    {
      $view_type = 1;
    }
    $buf = pack "l", $view_type;
    print FH_BIN "$buf";

    my $depth = 0;
    if( $g_table[$row][$g_table_col_depth] eq "ZBUF" )
    {
      $depth = 1;
    }
    $buf = pack "l", $depth;
    print FH_BIN "$buf";
    
    $buf = pack "f", $g_table[$row][$g_table_col_fovy];
    print FH_BIN "$buf";
    $buf = pack "f", $g_table[$row][$g_table_col_near];
    print FH_BIN "$buf";
    $buf = pack "f", $g_table[$row][$g_table_col_far];
    print FH_BIN "$buf";
   
    my $player_link = 0;
    if( $g_table[$row][$g_table_col_player_link] eq "○" )
    {
      $player_link = 1;
    }
    $buf = pack "l", $player_link;
    print FH_BIN "$buf";

    $buf = pack "f", $g_table[$row][$g_table_col_offset_x];
    print FH_BIN "$buf";
    $buf = pack "f", $g_table[$row][$g_table_col_offset_y];
    print FH_BIN "$buf";
    $buf = pack "f", $g_table[$row][$g_table_col_offset_z];
    print FH_BIN "$buf";

    if( $g_debug_enable == 1 )
    {
      for( my $col=0; $col<$g_sheet_end_col-$g_sheet_start_col; $col++ )
      {
        #my $buf = pack "e", $g_table[$row][$col];  # リトルエンディアンの単精度浮動小数点数(機種依存)
        #my $buf = pack "V", $g_table[$row][$col];  # "VAX"バイトオーダー(リトルエンディアン)のunsigned long
        #my $buf = pack "f", $g_table[$row][$col];  # 機種依存の単精度浮動小数点数。あるマシンでパックした浮動小数点数は、別のマシンでは読めない可能性があります。
        #my $buf = pack "l", $g_table[$row][$col];  # 符号付き32ビット整数(long)。
        
        {
          # 標準エラー出力
          print STDERR "$g_table[$row][$col]".", ";
        }
      }

      # 標準エラー出力
      print STDERR "\r\n";  # 0D 0A
    }
  }

  close( FH_BIN );
}

##-------------------------------------
### 一時的に生成してすぐに削除するcsvファイルを削除する
### グローバル変数を使っているので、他では使えないサブルーチンです。
##-------------------------------------
sub RemoveCsv
{
  unlink( $g_csv_file_utf8 );
  unlink( $g_csv_file );
}


##============================================================================
=pod
# ファイルのコピーの例

use File::Copy;
$g_src = $ARGV[0];
$g_dst = $ARGV[1];
copy( $g_src $g_dst );

=cut 
##============================================================================
