//================================================================================
/**
 * @file   test_ohno_gfbeacon.cpp
 * @brief  Q[t[NƎ̃r[RႢeXg
 * @author k.ohno
 * @date   2011.08.11
 */ 
//================================================================================
#include <nn.h>
#include <gflib.h>
#include <gflnet.h>
#include <gamesystem/GameManager.h>
#include <gamesystem/GameProcManager.h>
#include "test_ohno_gfbeacon.h"



GFL_NAMESPACE_BEGIN(test)
GFL_NAMESPACE_BEGIN(ohno)




    //-----------------------------------------------------------------------------
    // RXgN^
    //-----------------------------------------------------------------------------
TestOhnoGfBeacon::TestOhnoGfBeacon( 
  gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
  gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allcator,
  gfl::grp::GraphicsSystem* graphics_system, gfl::ui::DeviceManager* ui_device_manager ) :
Base( heap, device_heap, heap_allocator, device_allcator, graphics_system, ui_device_manager )
{


  mpSsystemHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
  gfl::heap::HeapBase *devHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );

  mGFEachOther = GFL_NEW(mpSsystemHeap) netapp::beacon::GFEachOther(mpSsystemHeap,devHeap);

}


//-----------------------------------------------------------------------------
// fXgN^
//-----------------------------------------------------------------------------
TestOhnoGfBeacon::~TestOhnoGfBeacon()
{
  GFL_DELETE mGFEachOther;
}


//-----------------------------------------------------------------------------
// C
//-----------------------------------------------------------------------------
void TestOhnoGfBeacon::UpdateTest( void )
{
//  mpManager->Main();

  mGFEachOther->Main();
  
  // START {^ŏI
  if( m_button->IsTrigger( gfl::ui::BUTTON_START ) ) {
    this->End();
  }
} 



//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void TestOhnoGfBeacon::DrawTest( void )
{

}


GFL_NAMESPACE_END(ohno)
GFL_NAMESPACE_END(test)
