#ifndef __GFEACHOTHER_H__
#define __GFEACHOTHER_H__
//======================================================================
/**
 * @file	  GFEachOther.h
 * @brief	  GF^Cv̂ႢʐM
 * @author	k.ohno
 * @data	  2011/08/08
 */
//======================================================================

#include <gflib.h>
#include <gflnet.h>

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(beacon)


class GFEachOther
{
  GFL_FORBID_COPY_AND_ASSIGN( GFEachOther );
private:

  
  static const int BEACON_MAX = 100;  //Sl

  u8 mRecvBeacon[BEACON_MAX][gfl::net::NetManager::BEACON_MAXBYTE];
  u8 mSendBeacon[gfl::net::NetManager::BEACON_MAXBYTE];

  gfl::heap::HeapBase*  mpHeapMem;
  gfl::heap::HeapBase*  mpDeviceMem;

  gfl::net::NetManager* mNetMng;
  
public:
  GFEachOther(gfl::heap::HeapBase* pBase, gfl::heap::HeapBase *pDev);
  virtual ~GFEachOther();

  //--------------------------------------------------------------
  /**
   * @brief   
   * @param   heap       workƂ邽߂̃NX
   * @param   parent     ẽCxgNX
   */
  //--------------------------------------------------------------
  bool Initialize(const u8* sendData);

  //--------------------------------------------------------------
  /**
   * @brief   C[v
   */
  //--------------------------------------------------------------
  void Main(void);

  //--------------------------------------------------------------
  /**
   * @brief    r[R͑Ƃ߂܂AʐM͂ɏIȂ̂ŁAI̊Jns܂
   * @retval   true   ʐMIJn
   * @retval   false  G[N
   */
  //--------------------------------------------------------------
  bool Finalize(void);

  //--------------------------------------------------------------
  /**
   * @brief    IǂmFł܂ IĂJł܂
   * @retval   true  ʐMI
   * @retval   false ʐMI
   */
  //--------------------------------------------------------------
  bool IsFinalize(void);


  //--------------------------------------------------------------
  /**
   * @brief   r[R擾\ł
   * @param   index      r[R̕ۑ
   * @return  r[Rf[^
   */
  //--------------------------------------------------------------
  u8* GetBeacon(int index);
  
  //--------------------------------------------------------------
  /**
   * @brief   r[Rf[^ύX܂
   * @param   heap       workƂ邽߂̃NX
   * @param   parent     ẽCxgNX
   */
  //--------------------------------------------------------------
  bool ChangeData(const u8* sendData);
};



GFL_NAMESPACE_END(beacon)
GFL_NAMESPACE_END(netapp)

#endif //__GFEACHOTHER_H__
