//======================================================================
/**
 * @file	  GFEachOther.cpp
 * @brief	  fobOC
 * @author	k.ohno
 * @data	  2011/08/10
 */
//======================================================================

#include <gflib.h>
#include <gflnet.h>
#include "GFEachOther.h"


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(beacon)



GFEachOther::GFEachOther(gfl::heap::HeapBase* pBase, gfl::heap::HeapBase *pDev)
{

  mpHeapMem = pBase;
  mpDeviceMem = pDev;
}

GFEachOther::~GFEachOther()
{
}

//--------------------------------------------------------------
/**
 * @brief   
 * @param   sendData   f[^
 */
//--------------------------------------------------------------
bool GFEachOther::Initialize(const void* sendData)
{
  ChangeData(sendData);

  gflnet::InitParameter netInitParam = {
    mpHeapMem,
    mpDeviceMem,
    gflnet::TYPE_WIRELESS_INIT,
    true,
    0, //@todo K
    XY_NET_DEBUGARI_CONNECT_MAX,
  };

  gflnet::InitParameterFixed netInitParamFix = {
    XY_PRODUCT_CODE,  //
    0,  //܂̓}WbN @todo
    0, //܂̓}WbN @todo
    XY_NET_VERSION, //
  };

  mNetMng = GFL_NEW(mpHeapMem)gfl::net::NetManager(mpHeapMem);
  mNetMng->CreateNetwork(&netInitParam,&netInitParamFix);

    //r[Rݒ
  mNetMng->SetBeacon(mSendBeacon,sizeof(mSendBeacon));


}

//--------------------------------------------------------------
/**
 * @brief   C[v
 */
//--------------------------------------------------------------
void GFEachOther::Main(void)
{
  if(mNetMng){
    mNetMng->Main();
  }
}

//--------------------------------------------------------------
/**
 * @brief    r[R͑Ƃ߂܂AʐM͂ɏIȂ̂ŁAI̊Jns܂
 * @retval   true   ʐMIJn
 * @retval   false  G[N
 */
//--------------------------------------------------------------
bool GFEachOther::Finalize(void)
{
  GFL_DELETE mNetMng;
  mNetMng = NULL;
  return true;
}

//--------------------------------------------------------------
/**
 * @brief    IǂmFł܂ IĂJł܂
 * @retval   true  ʐMI
 * @retval   false ʐMI
 */
//--------------------------------------------------------------
bool GFEachOther::IsFinalize(void)
{
  return true;
}


//--------------------------------------------------------------
/**
 * @brief   r[R擾\ł
 * @param   index      r[R̕ۑ
 * @return  r[Rf[^
 */
//--------------------------------------------------------------
u8* GFEachOther::GetBeacon(int index)
{
  GFL_ASSERT(index < BEACON_MAX);
  if(index < BEACON_MAX){
    return mpRecvBeacon[index];
  }
  return NULL;
}
  
//--------------------------------------------------------------
/**
 * @brief   r[Rf[^ύX܂
 * @param   heap       workƂ邽߂̃NX
 * @param   parent     ẽCxgNX
 */
//--------------------------------------------------------------
bool GFEachOther::ChangeData(const u8* sendData)
{
  memcpy(mSendBeacon,sendData);
  return true;
}



GFL_NAMESPACE_END(beacon)
GFL_NAMESPACE_END(netapp)
