####################################################3
#
#   camera_area.rb 
#
#
# ruby camera_area.rb textfile
#
#
####################################################3

class DataFormatError < Exception; end


def debug_puts str
  puts str
end




####################################################3
# f[^萔
####################################################3
IDX_ID      = 0
IDX_SGX     = 1
IDX_SGZ     = 2
IDX_EGX     = 3
IDX_EGZ     = 4
IDX_YOFS    = 5
IDX_ROTX    = 6
IDX_ROTY    = 7
IDX_FOV     = 8
IDX_DIST    = 9
IDX_MAX     = 10


class CameraAreaData

  attr :id
  attr :s_grid_x
  attr :s_grid_z
  attr :e_grid_x
  attr :e_grid_z
  attr :y_ofs
  attr :rotate_x
  attr :rotate_y
  attr :fov
  attr :dist


  def initialize line
    column = line.split()
    
    @id = column[IDX_ID].to_i
    
    @s_grid_x = column[IDX_SGX].to_i
    @s_grid_z = column[IDX_SGZ].to_i
    @e_grid_x = column[IDX_EGX].to_i
    @e_grid_z = column[IDX_EGZ].to_i

    @y_ofs    = column[IDX_YOFS].to_f
    @rotate_x = column[IDX_ROTX].to_f
    @rotate_y = column[IDX_ROTY].to_f

    @fov  = column[IDX_FOV].to_f
    @dist = column[IDX_DIST].to_f
    
  end

  def dumpBinary
    output = ""

    output += [@s_grid_z].pack("S")
    output += [@e_grid_z].pack("S")
    output += [@s_grid_x].pack("S")
    output += [@e_grid_x].pack("S")
    
    output += [@y_ofs].pack("f")
    output += [@rotate_x].pack("f")
    output += [@rotate_y].pack("f")
    output += [@fov].pack("f")
    output += [@dist].pack("f")
    
    return output
  end
  
end

begin

  if ARGV.size < 2
    raise DataFormatError, "camera_area.rb param error\n"
  end

  cameraAreaArray = Array.new
  
  #ǂݍ
  File.open( ARGV[0], "r" ){|file|

    while line = file.gets

      column = line.split

      if column[0] =~ /[0-9]+/

        obj = CameraAreaData.new( line )

        cameraAreaArray << obj
        
      elsif column[0] == "END"
        break
      end
    end
  }


  output = ""
  
  for i in 1..cameraAreaArray.size

    index = i-1

    output += cameraAreaArray[index].dumpBinary()
    
  end

  #
  File.open( ARGV[1], "wb" ){|file|
    file.write [ cameraAreaArray.size ].pack("I")
    file.write output
  }
  
end
