//=======================================================================================
/**
 * @file TargetSelect1vs5_data.cpp
 * @brief ΏۑI( 1vs5 )̃f[^`
 * @author obata_toshihiro
 * @date 2011.08.10
 */
//=======================================================================================
#include <battle/btl_common.h>
#include "TargetSelectBase.h"
#include "TargetSelect1vs5.h"

#include "target_select_1vs5.h"
#include "target_select_1vs5_pane.h"


namespace btl {
  namespace app {


    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_OTHER_ONE( ȊO1|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect1vs5::WazaRangeDesc TargetSelect1vs5::WAZA_RANGE_DESC_ENEMY_ONE = 
    {
      /* J[\ʒu */ CURSOR_POS_UL,
      /* e{^Ɋ蓖ĂJ[\ʒu */
      {
        /* BUTTON_TARGET_UL */ CURSOR_POS_UL,
        /* BUTTON_TARGET_UC */ CURSOR_POS_UC,
        /* BUTTON_TARGET_UR */ CURSOR_POS_UR,
        /* BUTTON_TARGET_DL */ CURSOR_POS_DL,
        /* BUTTON_TARGET_DC */ CURSOR_POS_NULL,
        /* BUTTON_TARGET_DR */ CURSOR_POS_DR,
        /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
        /* BUTTON_RETURN */ CURSOR_POS_RETURN,
      },
      /* J[\ʒuƂ̐ݒ */
      {
        /* CURSOR_POS_UL */
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_BAND_FAR_1,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UL_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_UL,
        },
        /* CURSOR_POS_UC */
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_BAND_FAR_2,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UC_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_UC,
        },
        /* CURSOR_POS_UR */ 
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_BAND_FAR_3,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UR_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UR_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UR_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_UR,
        },
        /* CURSOR_POS_DL */ 
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_BAND_FAR_4,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DL_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_DL,
        },
        /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DR */ 
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_BAND_FAR_5,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DR_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DR_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DR_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_DR,
        },
        /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_RETURN */
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_RET,
        }, 
      },
      /* J[\ړf[^ */
      {
        /*   ID                    UP                 DOWN               LEFT               RIGHT  */
        { CURSOR_POS_UL,         { CURSOR_POS_UL,     CURSOR_POS_DL,     CURSOR_POS_UL,     CURSOR_POS_UC } },
        { CURSOR_POS_UC,         { CURSOR_POS_UC,     CURSOR_POS_RETURN, CURSOR_POS_UL,     CURSOR_POS_UR } },
        { CURSOR_POS_UR,         { CURSOR_POS_UR,     CURSOR_POS_DR,     CURSOR_POS_UC,     CURSOR_POS_UR } },
        { CURSOR_POS_DL,         { CURSOR_POS_UL,     CURSOR_POS_RETURN, CURSOR_POS_DL,     CURSOR_POS_DR } },
        { CURSOR_POS_DC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_DR,         { CURSOR_POS_UR,     CURSOR_POS_RETURN, CURSOR_POS_DL,     CURSOR_POS_DR } },
        { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_RETURN,     { CURSOR_POS_DR,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
      },
    };








    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_OTHER_ALL( ȊȎS|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect1vs5::WazaRangeDesc TargetSelect1vs5::WAZA_RANGE_DESC_ENEMY_ALL = 
    {
      /* J[\ʒu */ CURSOR_POS_ENEMY_ALL,
      /* e{^Ɋ蓖ĂJ[\ʒu */
      {
        /* BUTTON_TARGET_UL */ CURSOR_POS_ENEMY_ALL,
        /* BUTTON_TARGET_UC */ CURSOR_POS_ENEMY_ALL,
        /* BUTTON_TARGET_UR */ CURSOR_POS_ENEMY_ALL,
        /* BUTTON_TARGET_DL */ CURSOR_POS_ENEMY_ALL,
        /* BUTTON_TARGET_DC */ CURSOR_POS_NULL,
        /* BUTTON_TARGET_DR */ CURSOR_POS_ENEMY_ALL,
        /* BUTTON_PADDING_UL */ CURSOR_POS_ENEMY_ALL,
        /* BUTTON_PADDING_UR */ CURSOR_POS_ENEMY_ALL,
        /* BUTTON_PADDING_L */ CURSOR_POS_ENEMY_ALL,
        /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_R */ CURSOR_POS_ENEMY_ALL,
        /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
        /* BUTTON_RETURN */ CURSOR_POS_RETURN,
      },
      /* J[\ʒuƂ̐ݒ */
      {
        /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_ENEMY_ALL */
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ALL_ENEMY_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ALL_ENEMY_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_ALL_ENEMY_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ALL,
        },
        /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
        // CURSOR_POS_RETURN
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ALL_RET,
        }, 
      },
      /* J[\ړf[^ */
      {
        /*   id                    up                    down               left                  right  */
        { CURSOR_POS_UL,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        { CURSOR_POS_UC,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        { CURSOR_POS_UR,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        { CURSOR_POS_DL,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        { CURSOR_POS_DC,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        { CURSOR_POS_DR,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_ENEMY_ALL, CURSOR_POS_ENEMY_ALL } },
        { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        { CURSOR_POS_RETURN,     { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
      },
    };









    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_ALL( ɂS|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect1vs5::WazaRangeDesc TargetSelect1vs5::WAZA_RANGE_DESC_ALL = 
    {
      /* J[\ʒu */ CURSOR_POS_ALL,
      /* e{^Ɋ蓖ĂJ[\ʒu */
      {
        /* BUTTON_TARGET_UL */ CURSOR_POS_ALL,
        /* BUTTON_TARGET_UC */ CURSOR_POS_ALL,
        /* BUTTON_TARGET_UR */ CURSOR_POS_ALL,
        /* BUTTON_TARGET_DL */ CURSOR_POS_ALL,
        /* BUTTON_TARGET_DC */ CURSOR_POS_ALL,
        /* BUTTON_TARGET_DR */ CURSOR_POS_ALL,
        /* BUTTON_PADDING_UL */ CURSOR_POS_ALL,
        /* BUTTON_PADDING_UR */ CURSOR_POS_ALL,
        /* BUTTON_PADDING_L */ CURSOR_POS_ALL,
        /* BUTTON_PADDING_C */ CURSOR_POS_ALL,
        /* BUTTON_PADDING_R */ CURSOR_POS_ALL,
        /* BUTTON_PADDING_DL */ CURSOR_POS_ALL,
        /* BUTTON_PADDING_DR */ CURSOR_POS_ALL,
        /* BUTTON_RETURN */ CURSOR_POS_RETURN,
      },
      /* J[\ʒuƂ̐ݒ */
      {
        /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_ALL */ 
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ALL_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ALL_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_ALL_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_ALL,
        }, 
        // CURSOR_POS_RETURN
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_ALL_RET,
        }, 
      },
      /* J[\ړf[^ */
      {
        /*   id                    up                 down               left               right  */
        { CURSOR_POS_UL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_UC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_UR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_DL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_DC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_DR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_ALL,        { CURSOR_POS_ALL,    CURSOR_POS_RETURN, CURSOR_POS_ALL,    CURSOR_POS_ALL } },
        { CURSOR_POS_RETURN,     { CURSOR_POS_ALL,    CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
      },
    };












    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_USER( ̂ )
    //-----------------------------------------------------------------------------------
    const TargetSelect1vs5::WazaRangeDesc TargetSelect1vs5::WAZA_RANGE_DESC_USER =
    {
      /* J[\ʒu */ CURSOR_POS_DC,
      /* e{^Ɋ蓖ĂJ[\ʒu */
      {
        /* BUTTON_TARGET_UL */ CURSOR_POS_NULL,
        /* BUTTON_TARGET_UC */ CURSOR_POS_NULL,
        /* BUTTON_TARGET_UR */ CURSOR_POS_NULL,
        /* BUTTON_TARGET_DL */ CURSOR_POS_NULL,
        /* BUTTON_TARGET_DC */ CURSOR_POS_DC,
        /* BUTTON_TARGET_DR */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
        /* BUTTON_RETURN */ CURSOR_POS_RETURN,
      },
      /* J[\ʒuƂ̐ݒ */
      {
        /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DC */ 
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_BAND_NEAR_1,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DC_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_USER,
        }, 
        /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
        // CURSOR_POS_RETURN
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_USER_RET,
        }, 
      },
      /* J[\ړf[^ */
      {
        /*   id                    up                 down               left               right  */
        { CURSOR_POS_UL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_UC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_UR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_DL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_DC,         { CURSOR_POS_DC,     CURSOR_POS_RETURN, CURSOR_POS_DC,     CURSOR_POS_DC } },
        { CURSOR_POS_DR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_RETURN,     { CURSOR_POS_DC,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
      },
    };




  }  // namespace app
}  // namespace btl
