//=======================================================================================
/**
 * @file TargetSelect1vs5.cpp
 * @brief ΏۑI( 1vs5 )
 * @author obata_toshihiro
 * @date 2011.08.10
 */
//=======================================================================================
#include <gflib.h>
#include <battle/btl_common.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include "AppDrawUtil.h"
#include "TargetSelectBase.h"
#include "TargetSelect1vs5.h"

#include <arc/arc_def.h>
#include <arc/btl_app.gaix>
#include <message/msg_btl_app.h>
#include "target_select_1vs5.h"
#include "target_select_1vs5_pane.h"


namespace btl {
  namespace app {


    // q[vTCY
    const u32 TargetSelect1vs5::APP_HEAPSIZE = 0x1800;
    const u32 TargetSelect1vs5::DEVICE_HEAPSIZE = 0x200000;



    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp TargetSelect1vs5::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, LAYOUT_DOWN_OFS, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),                   // scale
      gfl::math::VEC3( 0, 0, 0 ),                // rotate
      1,                                         // priority
    };



    // Aj[Vf[^̃e[u
    const gfl::grp::g2d::LytArcIndex TargetSelect1vs5::ANIMATION_DATA_TABLE[ TargetSelect1vs5::ANIMATION_DATA_NUM ] = 
    {
      /* ANIMATION_DATA_DUMMY_BALL_NORMAL */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_DUMMY_BALL_NORMAL_BCLAN,
      /* ANIMATION_DATA_DUMMY_BALL_SICK */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_DUMMY_BALL_SICK_BCLAN,
      /* ANIMATION_DATA_DUMMY_BALL_DEAD */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_DUMMY_BALL_DEAD_BCLAN,
      /* ANIMATION_DATA_DUMMY_BALL_NULL */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_DUMMY_BALL_NULL_BCLAN,
      /* ANIMATION_DATA_ENEMY_UL_ALIVE */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_ENEMY_UL_ALIVE_BCLAN,
      /* ANIMATION_DATA_ENEMY_UL_DEAD */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_ENEMY_UL_DEAD_BCLAN,
      /* ANIMATION_DATA_ENEMY_UC_ALIVE */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_ENEMY_UC_ALIVE_BCLAN,
      /* ANIMATION_DATA_ENEMY_UC_DEAD */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_ENEMY_UC_DEAD_BCLAN,
      /* ANIMATION_DATA_ENEMY_UR_ALIVE */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_ENEMY_UR_ALIVE_BCLAN,
      /* ANIMATION_DATA_ENEMY_UR_DEAD */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_ENEMY_UR_DEAD_BCLAN,
      /* ANIMATION_DATA_ENEMY_DL_ALIVE */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_ENEMY_DL_ALIVE_BCLAN,
      /* ANIMATION_DATA_ENEMY_DL_DEAD */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_ENEMY_DL_DEAD_BCLAN,
      /* ANIMATION_DATA_ENEMY_DR_ALIVE */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_ENEMY_DR_ALIVE_BCLAN,
      /* ANIMATION_DATA_ENEMY_DR_DEAD */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_ENEMY_DR_DEAD_BCLAN,
      /* ANIMATION_DATA_PLAYER_ALIVE */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_PLAYER_ALIVE_BCLAN,
      /* ANIMATION_DATA_PLAYER_DEAD */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_PLAYER_DEAD_BCLAN,
      /* ANIMATION_DATA_CURSOR_FLUCTUATE */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_CURSOR_FLUCTUATE_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_SELECT_UL */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_CURSOR_OTHER_SELECT_UL_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_SELECT_UC */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_CURSOR_OTHER_SELECT_UC_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_SELECT_UR */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_CURSOR_OTHER_SELECT_UR_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_SELECT_DL */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_CURSOR_OTHER_SELECT_DL_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_SELECT_DR */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_CURSOR_OTHER_SELECT_DR_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_SELECT_RET */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_CURSOR_OTHER_SELECT_RET_BCLAN,
      /* ANIMATION_DATA_CURSOR_ENEMY_ALL */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_CURSOR_ENEMY_ALL_BCLAN,
      /* ANIMATION_DATA_CURSOR_ENEMY_ALL_RET */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_CURSOR_ENEMY_ALL_RET_BCLAN,
      /* ANIMATION_DATA_CURSOR_ALL */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_CURSOR_ALL_BCLAN,
      /* ANIMATION_DATA_CURSOR_ALL_RET */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_CURSOR_ALL_RET_BCLAN,
      /* ANIMATION_DATA_CURSOR_USER */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_CURSOR_USER_BCLAN,
      /* ANIMATION_DATA_CURSOR_USER_RET */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_CURSOR_USER_RET_BCLAN,
      /* ANIMATION_DATA_BUTTON_UL_HOLD */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_UL_HOLD_BCLAN,
      /* ANIMATION_DATA_BUTTON_UL_RELEASE */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_UL_RELEASE_BCLAN,
      /* ANIMATION_DATA_BUTTON_UL_SELECT */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_UL_SELECT_BCLAN,
      /* ANIMATION_DATA_BUTTON_UC_HOLD */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_UC_HOLD_BCLAN,
      /* ANIMATION_DATA_BUTTON_UC_RELEASE */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_UC_RELEASE_BCLAN,
      /* ANIMATION_DATA_BUTTON_UC_SELECT */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_UC_SELECT_BCLAN,
      /* ANIMATION_DATA_BUTTON_UR_HOLD */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_UR_HOLD_BCLAN,
      /* ANIMATION_DATA_BUTTON_UR_RELEASE */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_UR_RELEASE_BCLAN,
      /* ANIMATION_DATA_BUTTON_UR_SELECT */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_UR_SELECT_BCLAN,
      /* ANIMATION_DATA_BUTTON_DL_HOLD */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_DL_HOLD_BCLAN,
      /* ANIMATION_DATA_BUTTON_DL_RELEASE */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_DL_RELEASE_BCLAN,
      /* ANIMATION_DATA_BUTTON_DL_SELECT */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_DL_SELECT_BCLAN,
      /* ANIMATION_DATA_BUTTON_DC_HOLD */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_DC_HOLD_BCLAN,
      /* ANIMATION_DATA_BUTTON_DC_RELEASE */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_DC_RELEASE_BCLAN,
      /* ANIMATION_DATA_BUTTON_DC_SELECT */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_DC_SELECT_BCLAN,
      /* ANIMATION_DATA_BUTTON_DR_HOLD */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_DR_HOLD_BCLAN,
      /* ANIMATION_DATA_BUTTON_DR_RELEASE */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_DR_RELEASE_BCLAN,
      /* ANIMATION_DATA_BUTTON_DR_SELECT */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_DR_SELECT_BCLAN,
      /* ANIMATION_DATA_BUTTON_RET_HOLD */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_RET_HOLD_BCLAN,
      /* ANIMATION_DATA_BUTTON_RET_RELEASE */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_RET_RELEASE_BCLAN,
      /* ANIMATION_DATA_BUTTON_RET_SELECT */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_RET_SELECT_BCLAN,
      /* ANIMATION_DATA_BUTTON_ALL_ENEMY_HOLD */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_ALL_ENEMY_HOLD_BCLAN,
      /* ANIMATION_DATA_BUTTON_ALL_ENEMY_RELEASE */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_ALL_ENEMY_RELEASE_BCLAN,
      /* ANIMATION_DATA_BUTTON_ALL_ENEMY_SELECT */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_ALL_ENEMY_SELECT_BCLAN,
      /* ANIMATION_DATA_BUTTON_ALL_HOLD */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_ALL_HOLD_BCLAN,
      /* ANIMATION_DATA_BUTTON_ALL_RELEASE */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_ALL_RELEASE_BCLAN,
      /* ANIMATION_DATA_BUTTON_ALL_SELECT */ LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BUTTON_ALL_SELECT_BCLAN,
    };



    // LAj[VƂ̐ݒ
    const TargetSelect1vs5::ShareAnimationDesc TargetSelect1vs5::SHARE_ANIMATION_DESC[ TargetSelect1vs5::SHARE_ANIMATION_NUM ] = 
    {
      /* SHARE_ANIMATION_MYBALL_NORMAL */
      {
        ANIMATION_MYBALL00_NORMAL, 
        ANIMATION_DATA_DUMMY_BALL_NORMAL,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_TARGET_SELECT_1VS5_GROUP_MY_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_MYBALL_SICK */
      {
        ANIMATION_MYBALL00_SICK, 
        ANIMATION_DATA_DUMMY_BALL_SICK,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_TARGET_SELECT_1VS5_GROUP_MY_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_MYBALL_DEAD */
      {
        ANIMATION_MYBALL00_DEAD, 
        ANIMATION_DATA_DUMMY_BALL_DEAD,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_TARGET_SELECT_1VS5_GROUP_MY_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_MYBALL_NULL */
      {
        ANIMATION_MYBALL00_NULL, 
        ANIMATION_DATA_DUMMY_BALL_NULL,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_TARGET_SELECT_1VS5_GROUP_MY_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_ENBALL_NORMAL */
      {
        ANIMATION_ENBALL00_NORMAL, 
        ANIMATION_DATA_DUMMY_BALL_NORMAL,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_TARGET_SELECT_1VS5_GROUP_EN_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_ENBALL_SICK */
      {
        ANIMATION_ENBALL00_SICK, 
        ANIMATION_DATA_DUMMY_BALL_SICK,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_TARGET_SELECT_1VS5_GROUP_EN_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_ENBALL_DEAD */
      {
        ANIMATION_ENBALL00_DEAD, 
        ANIMATION_DATA_DUMMY_BALL_DEAD,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_TARGET_SELECT_1VS5_GROUP_EN_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_ENBALL_NULL */
      {
        ANIMATION_ENBALL00_NULL, 
        ANIMATION_DATA_DUMMY_BALL_NULL,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_TARGET_SELECT_1VS5_GROUP_EN_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
    };






    // ̃{[Ƃ̐ݒ
    const TargetSelect1vs5::BallDesc TargetSelect1vs5::MY_BALL_DESC[ pml::PokeParty::MAX_MEMBERS ] = 
    {
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 0 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 0 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 0 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 0 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 1 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 1 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 1 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 1 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 2 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 2 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 2 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 2 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 3 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 3 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 3 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 3 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 4 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 4 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 4 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 4 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 5 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 5 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 5 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 5 ),
      },
    };




    // 葤̃{[Ƃ̐ݒ
    const TargetSelect1vs5::BallDesc TargetSelect1vs5::ENEMY_BALL_DESC[ pml::PokeParty::MAX_MEMBERS ] = 
    {
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 0 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 0 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 0 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 0 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 1 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 1 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 1 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 1 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 2 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 2 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 2 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 2 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 3 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 3 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 3 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 3 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 4 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 4 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 4 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 4 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 5 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 5 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 5 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 5 ),
      },
    };




    // Ώۃ{^Ƃ̐ݒ
    const TargetSelect1vs5::TargetButtonDesc TargetSelect1vs5::TARGET_BUTTON_DESC[ TargetSelect1vs5::TARGET_BUTTON_NUM ] = 
    {
      // TARGET_BUTTON_UL,
      {
        BTL_VPOS_BAND_FAR_1,
        ANIMATION_ENEMY_UL_ALIVE,
        ANIMATION_ENEMY_UL_DEAD,
        PANENAME_TARGET_SELECT_1VS5_PANE_EN_UL_NAME,
        PANENAME_TARGET_SELECT_1VS5_PANE_EN_UL_POKEICON,
        PANENAME_TARGET_SELECT_1VS5_PANE_EN_UL_SEX,
      },
      // TARGET_BUTTON_UC,
      {
        BTL_VPOS_BAND_FAR_2,
        ANIMATION_ENEMY_UC_ALIVE,
        ANIMATION_ENEMY_UC_DEAD,
        PANENAME_TARGET_SELECT_1VS5_PANE_EN_UC_NAME,
        PANENAME_TARGET_SELECT_1VS5_PANE_EN_UC_POKEICON,
        PANENAME_TARGET_SELECT_1VS5_PANE_EN_UC_SEX,
      },
      // TARGET_BUTTON_UR,
      {
        BTL_VPOS_BAND_FAR_3,
        ANIMATION_ENEMY_UR_ALIVE,
        ANIMATION_ENEMY_UR_DEAD,
        PANENAME_TARGET_SELECT_1VS5_PANE_EN_UR_NAME,
        PANENAME_TARGET_SELECT_1VS5_PANE_EN_UR_POKEICON,
        PANENAME_TARGET_SELECT_1VS5_PANE_EN_UR_SEX,
      },
      // TARGET_BUTTON_DL,
      {
        BTL_VPOS_BAND_FAR_4,
        ANIMATION_ENEMY_DL_ALIVE,
        ANIMATION_ENEMY_DL_DEAD,
        PANENAME_TARGET_SELECT_1VS5_PANE_EN_DL_NAME,
        PANENAME_TARGET_SELECT_1VS5_PANE_EN_DL_POKEICON,
        PANENAME_TARGET_SELECT_1VS5_PANE_EN_DL_SEX,
      },
      // TARGET_BUTTON_DC,
      {
        BTL_VPOS_BAND_NEAR_1,
        ANIMATION_PLAYER_ALIVE,
        ANIMATION_PLAYER_DEAD,
        PANENAME_TARGET_SELECT_1VS5_PANE_PL_NAME,
        PANENAME_TARGET_SELECT_1VS5_PANE_PL_POKEICON,
        PANENAME_TARGET_SELECT_1VS5_PANE_PL_SEX,
      },
      // TARGET_BUTTON_DR,
      {
        BTL_VPOS_BAND_FAR_5,
        ANIMATION_ENEMY_DR_ALIVE,
        ANIMATION_ENEMY_DR_DEAD,
        PANENAME_TARGET_SELECT_1VS5_PANE_EN_DR_NAME,
        PANENAME_TARGET_SELECT_1VS5_PANE_EN_DR_POKEICON,
        PANENAME_TARGET_SELECT_1VS5_PANE_EN_DR_SEX,
      },
    };






    // {^ƂĈyC
    const gfl::grp::g2d::LytPaneIndex TargetSelect1vs5::BUTTON_PANE[ TargetSelect1vs5::BUTTON_NUM ] = 
    {
      /* BUTTON_TARGET_UL */ PANENAME_TARGET_SELECT_1VS5_PANE_ENEMY_UL,
      /* BUTTON_TARGET_UC */ PANENAME_TARGET_SELECT_1VS5_PANE_ENEMY_UC,
      /* BUTTON_TARGET_UR */ PANENAME_TARGET_SELECT_1VS5_PANE_ENEMY_UR,
      /* BUTTON_TARGET_DL */ PANENAME_TARGET_SELECT_1VS5_PANE_ENEMY_DL,
      /* BUTTON_TARGET_DC */ PANENAME_TARGET_SELECT_1VS5_PANE_PLAYER,
      /* BUTTON_TARGET_DR */ PANENAME_TARGET_SELECT_1VS5_PANE_ENEMY_DR,
      /* BUTTON_PADDING_UL */ PANENAME_TARGET_SELECT_1VS5_PANE_PADDING_UL,
      /* BUTTON_PADDING_UR */ PANENAME_TARGET_SELECT_1VS5_PANE_PADDING_UR,
      /* BUTTON_PADDING_L */ PANENAME_TARGET_SELECT_1VS5_PANE_PADDING_L,
      /* BUTTON_PADDING_C */ PANENAME_TARGET_SELECT_1VS5_PANE_PADDING_C,
      /* BUTTON_PADDING_R */ PANENAME_TARGET_SELECT_1VS5_PANE_PADDING_R,
      /* BUTTON_PADDING_DL */ PANENAME_TARGET_SELECT_1VS5_PANE_PADDING_DL,
      /* BUTTON_PADDING_DR */ PANENAME_TARGET_SELECT_1VS5_PANE_PADDING_DR,
      /* BUTTON_RETURN */ PANENAME_TARGET_SELECT_1VS5_PANE_RETURN_BUTTON,
    };






    // Ns\ȃJ[\ʒu̐ݒ
    const TargetSelect1vs5::CursorPosDesc TargetSelect1vs5::INVALID_CURSOR_POS_DESC = 
    {
      /* J[\ړ\ǂ */ false,
      /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
      /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
      /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_NULL,
      /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_NULL,
      /* Iۂ̃Aj[V */ ANIMATION_NULL,
      /* J[\ZbgAj[V */ ANIMATION_NULL,
    };










    // Žʔ͈͂Ƃ̐ݒ
    const TargetSelect1vs5::WazaRangeDesc 
      TargetSelect1vs5::WAZA_RANGE_DESC[ TargetSelectBase::WAZA_RANGE_NUM ] = 
      {
        /* WAZA_RANGE_OTHER_ONE */ WAZA_RANGE_DESC_ENEMY_ONE,
        /* WAZA_RANGE_OTHER_ONE_LONG */ WAZA_RANGE_DESC_ENEMY_ONE,
        /* WAZA_RANGE_OTHER_ALL */ WAZA_RANGE_DESC_ENEMY_ALL,
        /* WAZA_RANGE_ENEMY_ONE */ WAZA_RANGE_DESC_ENEMY_ONE,
        /* WAZA_RANGE_ENEMY_ALL */ WAZA_RANGE_DESC_ENEMY_ALL,
        /* WAZA_RANGE_FRIEND_ONE */ WAZA_RANGE_DESC_USER,
        /* WAZA_RANGE_FRIEND_OTHER_ONE */ WAZA_RANGE_DESC_USER,
        /* WAZA_RANGE_FRIEND_ALL */ WAZA_RANGE_DESC_USER,
        /* WAZA_RANGE_ALL */ WAZA_RANGE_DESC_ENEMY_ALL,
        /* WAZA_RANGE_USER */ WAZA_RANGE_DESC_USER,
        /* WAZA_RANGE_ENEMY_ONE_RANDOM */ WAZA_RANGE_DESC_USER,
        /* WAZA_RANGE_FIELD_ALL */ WAZA_RANGE_DESC_ALL,
        /* WAZA_RANGE_FIELD_ENEMY */ WAZA_RANGE_DESC_ENEMY_ALL,
        /* WAZA_RANGE_FIELD_FRIEND */ WAZA_RANGE_DESC_USER,
        /* WAZA_RANGE_UNKNOWN */ WAZA_RANGE_DESC_USER,
      };








    // ÓIf[^ւ̃ANZbT\bh

    TargetSelect1vs5::CursorPos TargetSelect1vs5::GetInitialCursorPos( void ) const
    {
      const WazaRangeDesc& waza_range_desc = this->GetWazaRangeDesc();
      return waza_range_desc.cursor_init_pos;
    }


    TargetSelect1vs5::CursorPos 
      TargetSelect1vs5::GetCursorPos( TargetSelect1vs5::ButtonIndex button_index ) const
    {
      const WazaRangeDesc& waza_range_desc = this->GetWazaRangeDesc();
      return waza_range_desc.cursor_pos_of_button[ button_index ];
    }


    const TargetSelect1vs5::CursorPosDesc& 
      TargetSelect1vs5::GetCursorPosDesc( TargetSelect1vs5::ButtonIndex button_index ) const
    {
      CursorPos cursor_pos = this->GetCursorPos( button_index );
      return this->GetCursorPosDesc( cursor_pos );
    }


    const TargetSelect1vs5::CursorPosDesc& 
      TargetSelect1vs5::GetCursorPosDesc( TargetSelect1vs5::CursorPos cursor_pos ) const
    {
      const WazaRangeDesc& waza_range_desc = this->GetWazaRangeDesc();
      return waza_range_desc.cursor_pos_desc[ cursor_pos ];
    } 


    const ::app::tool::CursorManager::MOVE_DATA* TargetSelect1vs5::GetCursorMoveData( void ) const
    {
      const WazaRangeDesc& waza_range_desc = this->GetWazaRangeDesc();
      return waza_range_desc.cursor_move_data;
    }


    const TargetSelect1vs5::WazaRangeDesc& TargetSelect1vs5::GetWazaRangeDesc( void ) const
    {
      TargetSelectBase::WazaRange waza_range = this->GetWazaRange();
      return WAZA_RANGE_DESC[ waza_range ]; 
    }










    //---------------------------------------------------------------------------------
    // RXgN^
    //---------------------------------------------------------------------------------
    TargetSelect1vs5::TargetSelect1vs5( 
        gfl::heap::HeapBase* app_heap, gfl::heap::HeapBase* device_heap, 
        BattleViewSystem* btlv_system, const TargetSelectBase::Setting& base_settings ) : 
      TargetSelectBase( 
          app_heap, APP_HEAPSIZE, device_heap, DEVICE_HEAPSIZE, btlv_system, base_settings ),
      AppDrawUtil(),
      m_init_flag( false ),
      m_seq( SEQ_WAIT_INPUT ),
      m_next_seq( SEQ_WAIT_INPUT ),
      m_button_manager( NULL ),
      m_cursor_manager( NULL ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 ),
      m_wait_animation_index( ANIMATION_NULL )
    {
    }





    //---------------------------------------------------------------------------------
    // fXgN^
    //---------------------------------------------------------------------------------
    TargetSelect1vs5::~TargetSelect1vs5()
    {
      if( m_init_flag ) {
        this->DeleteCursorManager();
        this->DeleteButtonManager();
        this->DeleteLayoutWork();
        this->FinalizeGraphicsSystem();
      }
    }


    // J[\ǗIuWFNgj
    void TargetSelect1vs5::DeleteCursorManager( void )
    {
      GFL_DELETE m_cursor_manager;
    }


    // {^}l[Wj
    void TargetSelect1vs5::DeleteButtonManager( void )
    {
      if( m_button_manager ) {
        GFL_DELETE m_button_manager;
      }
    }


    // CAEg[Nj
    void TargetSelect1vs5::DeleteLayoutWork( void ) 
    {
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();
      layout_system->RemoveLytWk( m_layout_work );
      layout_system->ReleaseLytRes( m_layout_resource_id );
    }


    // OtBbNXVXȅI
    void TargetSelect1vs5::FinalizeGraphicsSystem( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->FinalizeApplicationMemory();
    }







    //---------------------------------------------------------------------------------
    // 
    //---------------------------------------------------------------------------------
    AppBase::InitResult TargetSelect1vs5::Initialize( void )
    {
      if( !m_init_flag ) {
        m_init_flag = true;
        this->InitializeGraphicsSystem();
        this->SetupFont();
        this->CreateLayoutWork();
        this->CreateShareAnimation();
        this->CreateCursorManager();
        this->CreateButtonManager();
        this->SetupButtonManager();
        this->SetupPlayerBalls();
        this->SetupEnemyBalls();
        this->SetupTargetButtonInfo( TARGET_BUTTON_UL );
        this->SetupTargetButtonInfo( TARGET_BUTTON_UC );
        this->SetupTargetButtonInfo( TARGET_BUTTON_UR );
        this->SetupTargetButtonInfo( TARGET_BUTTON_DL );
        this->SetupTargetButtonInfo( TARGET_BUTTON_DC );
        this->SetupTargetButtonInfo( TARGET_BUTTON_DR );
        this->InitializeCursorPos();
      }
      return AppBase::INIT_RESULT_FINISH;
    }



    // OtBbNXVXe
    void TargetSelect1vs5::InitializeGraphicsSystem( void )
    {
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->InitializeApplicationMemory( nw_device_allocator );
    }


    // tHg̏
    void TargetSelect1vs5::SetupFont( void )
    {
      gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), "cbf_std.bcfnt" );
    }


    // CAEg[N𐶐
    void TargetSelect1vs5::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( ARCID_BATTLE_APP, heap );
      m_layout_resource_id = layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_btl_app_target_select_1vs5_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id,
          LYTRES_TARGET_SELECT_1VS5_TARGET_SELECT_1VS5_BCLYT,
          ANIMATION_DATA_TABLE, ANIMATION_DATA_NUM, ANIMATION_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ

      m_layout_work->SetAutoDrawFlag( false );  // XV, `, jŊǗ
    }


    // LAj[V𐶐
    void TargetSelect1vs5::CreateShareAnimation( void )
    {
      for( u32 i=0; i<SHARE_ANIMATION_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIMATION_DESC[i].start_animation_index,
            ANIMATION_DATA_TABLE[ SHARE_ANIMATION_DESC[i].animation_data_index ],
            SHARE_ANIMATION_DESC[i].max_share_num,
            SHARE_ANIMATION_DESC[i].share_group_index,
            SHARE_ANIMATION_DESC[i].share_pane_index );
      }
    }


    // J[\ǗIuWFNg𐶐
    void TargetSelect1vs5::CreateCursorManager( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_cursor_manager = GFL_NEW( heap ) 
        ::app::tool::CursorManager(
            this->GetCursorMoveData(),
            CURSOR_POS_NUM, 
            heap, 
            this->GetInitialCursorPos() );
    }


    // {^}l[W𐶐
    void TargetSelect1vs5::CreateButtonManager( void )
    {
      const gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_button_manager = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, BUTTON_NUM, ANIMATION_NULL );
    }


    // {^}l[WZbgAbv
    void TargetSelect1vs5::SetupButtonManager( void )
    {
      for( u32 i=0; i<BUTTON_NUM; i++ ) {
        ButtonIndex button_index = static_cast<ButtonIndex>(i);
        const CursorPosDesc& cursor_pos_desc = this->GetCursorPosDesc( button_index );
        m_button_manager->AddButton( 
            this->GetHeap(), 
            this->GetCursorPos( button_index ),  // ΉJ[\ʒuIDƂēo^
            m_layout_work,
            BUTTON_PANE[i],
            cursor_pos_desc.hold_animation_index,
            cursor_pos_desc.release_animation_index,
            cursor_pos_desc.select_animation_index,
            ANIMATION_NULL,  // activeAjȂ
            ANIMATION_NULL,  // passiveAjȂ
            NULL );  // R[obNȂ
      }
    }







    //---------------------------------------------------------------------------------
    // V[PXZbg
    //---------------------------------------------------------------------------------
    void TargetSelect1vs5::ResetSequence( void )
    {
      m_seq = SEQ_WAIT_INPUT;
      m_next_seq = SEQ_WAIT_INPUT;
      this->SetupPlayerBalls();
      this->SetupEnemyBalls();
      this->SetupTargetButtonInfo( TARGET_BUTTON_UL );
      this->SetupTargetButtonInfo( TARGET_BUTTON_UC );
      this->SetupTargetButtonInfo( TARGET_BUTTON_UR );
      this->SetupTargetButtonInfo( TARGET_BUTTON_DL );
      this->SetupTargetButtonInfo( TARGET_BUTTON_DC );
      this->SetupTargetButtonInfo( TARGET_BUTTON_DR );
      this->InitializeCursorPos();
    }




    // J[\ʒu
    void TargetSelect1vs5::InitializeCursorPos( void )
    {
      CursorPos cursor_pos = this->GetInitialCursorPos();
      const CursorPosDesc& cursor_pos_desc = this->GetCursorPosDesc( cursor_pos );
      m_cursor_manager->SetPos( cursor_pos );
      this->StartAnimation( m_layout_work, cursor_pos_desc.cursor_animation_index );
      this->StartAnimation( m_layout_work, ANIMATION_CURSOR_FLUCTUATE );
    }





    // ̃{[̃ZbgAbv
    void TargetSelect1vs5::SetupPlayerBalls( void )
    {
      for( u32 i=0; i<pml::PokeParty::MAX_MEMBERS; i++ ) {
        this->SetupPlayerBall(i);
      }
    }

    // w肵{[̕\XV
    void TargetSelect1vs5::SetupPlayerBall( u8 ball_index )
    {
      const btl::BTL_PARTY* btl_party = this->GetPlayerParty();
      u32 member_count = btl_party->GetMemberCount();

      if( member_count <= ball_index ) {
        this->SetPlayerBallDisplay_Null( ball_index );
      }
      else {
        const btl::BTL_POKEPARAM* btl_param = btl_party->GetMemberDataConst( ball_index );
        if( btl_param->IsDead() ) {
          this->SetPlayerBallDisplay_Dead( ball_index );
        }
        else if( btl_param->GetPokeSick() != pml::pokepara::SICK_NULL ) {
          this->SetPlayerBallDisplay_Sick( ball_index );
        }
        else {
          this->SetPlayerBallDisplay_Normal( ball_index );
        }
      }
    }

    // ̃{[ʏ̕\ɂ
    void TargetSelect1vs5::SetPlayerBallDisplay_Normal( u8 ball_index )
    {
      this->StartAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[Ԉُ̕\ɂ
    void TargetSelect1vs5::SetPlayerBallDisplay_Sick( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StartAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[m̕\ɂ
    void TargetSelect1vs5::SetPlayerBallDisplay_Dead( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StartAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[̕\ɂ
    void TargetSelect1vs5::SetPlayerBallDisplay_Null( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StartAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].null_animation_index );
    }








    // ̑S{[̕\XV
    void TargetSelect1vs5::SetupEnemyBalls( void )
    {
      if( this->IsEnemyBallsDisplay() ) {
        for( u32 i=0; i<pml::PokeParty::MAX_MEMBERS; i++ ) {
          this->SetupEnemyBall(i);
        }
      }
    }

    // w肵{[̕\XV
    void TargetSelect1vs5::SetupEnemyBall( u8 ball_index )
    {
      const btl::BTL_PARTY* btl_party = this->GetEnemyParty();
      u32 member_count = btl_party->GetMemberCount();

      if( member_count <= ball_index ) {
        this->SetEnemyBallDisplay_Null( ball_index );
      }
      else {
        const btl::BTL_POKEPARAM* btl_param = btl_party->GetMemberDataConst( ball_index );
        if( btl_param->IsDead() ) {
          this->SetEnemyBallDisplay_Dead( ball_index );
        }
        else if( btl_param->GetPokeSick() != pml::pokepara::SICK_NULL ) {
          this->SetEnemyBallDisplay_Sick( ball_index );
        }
        else {
          this->SetEnemyBallDisplay_Normal( ball_index );
        }
      }
    }


    // ̃{[ʏ̕\ɂ
    void TargetSelect1vs5::SetEnemyBallDisplay_Normal( u8 ball_index )
    {
      this->StartAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[Ԉُ̕\ɂ
    void TargetSelect1vs5::SetEnemyBallDisplay_Sick( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StartAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[m̕\ɂ
    void TargetSelect1vs5::SetEnemyBallDisplay_Dead( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StartAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[̕\ɂ
    void TargetSelect1vs5::SetEnemyBallDisplay_Null( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StartAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].null_animation_index );
    }









    // Ώۃ{^̏ZbgAbv
    void TargetSelect1vs5::SetupTargetButtonInfo( TargetButtonIndex button_index )
    {
      BtlvPos view_pos = TARGET_BUTTON_DESC[ button_index ].btlv_pos;
      const BTL_POKEPARAM* btl_param = this->GetBtlParam( view_pos );
      if( btl_param->IsDead() ) {
        this->SetTargetButtonDisplay_Dead( button_index );
      }
      else {
        const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam( view_pos );
        this->SetTargetButtonDisplay_Alive( button_index );
        this->SetTargetButtonDisplay_MonsName( button_index, pokeparam );
        this->SetTargetButtonDisplay_PokeIcon( button_index, pokeparam );
        this->SetTargetButtonDisplay_Sex( button_index, pokeparam );
      }
    }


    // Ώۃ|P퓬\ȏԂ̕\ɂ
    void TargetSelect1vs5::SetTargetButtonDisplay_Alive( TargetButtonIndex button_index )
    {
      this->StopAnimation( m_layout_work, TARGET_BUTTON_DESC[ button_index ].dead_animation_index );
      this->StartAnimation( m_layout_work, TARGET_BUTTON_DESC[ button_index ].alive_animation_index );
    }


    // Ώۃ|PmԂ̕\ɂ
    void TargetSelect1vs5::SetTargetButtonDisplay_Dead( TargetButtonIndex button_index )
    {
      this->StopAnimation( m_layout_work, TARGET_BUTTON_DESC[ button_index ].alive_animation_index );
      this->StartAnimation( m_layout_work, TARGET_BUTTON_DESC[ button_index ].dead_animation_index );
    }


    // Ώۃ{^ɃX^[Zbg
    void TargetSelect1vs5::SetTargetButtonDisplay_MonsName( 
        TargetButtonIndex button_index, const pml::pokepara::PokemonParam* param )
    {
      MonsNo monsno = param->GetMonsNo();
      this->SetTextboxPaneMonsName( m_layout_work, 
          TARGET_BUTTON_DESC[ button_index ].monsname_pane_index, monsno );
    }


    // Ώۃ{^Ƀ|PACRZbg
    void TargetSelect1vs5::SetTargetButtonDisplay_PokeIcon( 
      TargetButtonIndex button_index, const pml::pokepara::PokemonParam* param )
      {
        // @todo
      }


    // Ώۃ{^Ƀ|P̐ʂZbg
    void TargetSelect1vs5::SetTargetButtonDisplay_Sex( 
      TargetButtonIndex button_index, const pml::pokepara::PokemonParam* param )
    {
      pml::Sex sex = param->GetSex();
      this->SetTextboxPaneSex( m_layout_work, 
          TARGET_BUTTON_DESC[ button_index ].sex_pane_index, sex );
    }











    //---------------------------------------------------------------------------------
    // XV
    //---------------------------------------------------------------------------------
    void TargetSelect1vs5::Update( void )
    {
      m_button_manager->Update();
      this->UpdateSequence(); 
      m_layout_work->Update();
    }



    // V[PXXV
    void TargetSelect1vs5::UpdateSequence( void )
    {
      const gfl::ui::Button* ui_button = 
        this->GetUiDeviceManager()->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );

      switch( m_seq )
      {
      case SEQ_WAIT_INPUT:
        if( this->IsButtonSelected() ) {
          CursorPos cursor_pos = this->GetSelectedCursorPosByButton();
          if( this->IsSelectEnable( cursor_pos ) ) {
            this->SetResultByCursorPos( cursor_pos );
            this->StartSelectAnimation( cursor_pos );
            m_seq = SEQ_WAIT_ANIMATION;
            m_next_seq = SEQ_FINISH;
          }
        }
        else if( this->IsButtonHolding() ) {
          // do nothing
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
          CursorPos cursor_pos = this->GetCurrentCursorPos();
          if( this->IsSelectEnable( cursor_pos ) ) {
            this->SetResultByCursorPos( cursor_pos );
            this->StartSelectAnimation( cursor_pos );
            m_seq = SEQ_WAIT_ANIMATION;
            m_next_seq = SEQ_FINISH;
          }
        }
        else if( this->UpdateCursorMove() ) {  // J[\ړ
          CursorPos old_cursor_pos = this->GetPrevCursorPos();
          CursorPos new_cursor_pos = this->GetCurrentCursorPos();
          this->StartCursorMoveAnimation( old_cursor_pos, new_cursor_pos );
        }
        break;


      case SEQ_WAIT_ANIMATION:
        if( this->IsSelectAnimationFinished() ) {
          m_seq = m_next_seq;
        }
        break;


      default:
        GFL_ASSERT(0);
        // fall through

      case SEQ_FINISH:
        GFL_ASSERT( this->GetResult() != RESULT_NULL );
        this->Finish();
        break; 
      }
    }




    // {^Ă邩ǂ𒲂ׂ
    bool TargetSelect1vs5::IsButtonHolding( void ) const
    {
      return m_button_manager->IsButtonHolding();
    }

    // {^Iꂽǂ𒲂ׂ
    bool TargetSelect1vs5::IsButtonSelected( void ) const
    {
      return m_button_manager->IsButtonSelected();
    }

    // Iꂽ{^Ɋ֘AtĂJ[\ʒu擾
    TargetSelect1vs5::CursorPos TargetSelect1vs5::GetSelectedCursorPosByButton( void ) const
    {
      return static_cast<CursorPos>( m_button_manager->GetSelectedButtonId() );
    }



    // J[\̓XV
    bool TargetSelect1vs5::UpdateCursorMove( void )
    {
      ::app::tool::CursorManager::MOVE_RET move_result = m_cursor_manager->MainTrigger();
      return( move_result == ::app::tool::CursorManager::RET_MOVE ); // ړǂ
    } 


    // ݂̃J[\ʒu擾
    TargetSelect1vs5::CursorPos TargetSelect1vs5::GetCurrentCursorPos( void ) const
    {
      return static_cast<CursorPos>( m_cursor_manager->GetID() );
    } 


    // ÕJ[\ʒu擾
    TargetSelect1vs5::CursorPos TargetSelect1vs5::GetPrevCursorPos( void ) const
    {
      return static_cast<CursorPos>( m_cursor_manager->GetOldID() );
    }


    // J[\ړۂ̏
    void TargetSelect1vs5::StartCursorMoveAnimation( 
        TargetSelect1vs5::CursorPos old_cursor_pos, TargetSelect1vs5::CursorPos new_cursor_pos )
    {
      const CursorPosDesc& old_cursor_pos_desc = this->GetCursorPosDesc( old_cursor_pos );
      const CursorPosDesc& new_cursor_pos_desc = this->GetCursorPosDesc( new_cursor_pos );
      this->StopAnimation( m_layout_work, old_cursor_pos_desc.cursor_animation_index );
      this->StartAnimation( m_layout_work, new_cursor_pos_desc.cursor_animation_index );
    }





    // I\ǂ𒲂ׂ
    bool TargetSelect1vs5::IsSelectEnable( CursorPos cursor_pos ) const
    {
      if( cursor_pos < CURSOR_POS_NUM ) {
        const CursorPosDesc& cursor_pos_desc = this->GetCursorPosDesc( cursor_pos );
        return cursor_pos_desc.move_enable;
      }
      return false;
    }



    // J[\ʒu, 쌋ʂZbg
    void TargetSelect1vs5::SetResultByCursorPos( CursorPos cursor_pos )
    {
      const CursorPosDesc& cursor_pos_desc = this->GetCursorPosDesc( cursor_pos );
      this->SetResult( cursor_pos_desc.result );
      this->SetSelectedPos( cursor_pos_desc.btlv_pos );
    } 


    // ȊIAj[VJn
    void TargetSelect1vs5::StartSelectAnimation( CursorPos cursor_pos )
    {
      const CursorPosDesc& cursor_pos_desc = this->GetCursorPosDesc( cursor_pos );
      m_wait_animation_index = cursor_pos_desc.select_animation_index;
      this->StartAnimation( m_layout_work, m_wait_animation_index );
    }


    // ȊIAj[VIǂ𒲂ׂ
    bool TargetSelect1vs5::IsSelectAnimationFinished( void ) const
    {
      if( m_wait_animation_index < ANIMATION_NUM ) {
        return m_layout_work->IsAnimeEnd( m_wait_animation_index );
      }
      return true;  // Aj[Vo^ȂIƂɂ
    }








    //---------------------------------------------------------------------------------
    // `揈
    //---------------------------------------------------------------------------------
    void TargetSelect1vs5::Draw( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      gfl::grp::RenderTarget* lower_frame_buffer = graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
      m_layout_work->Draw( graphics_system, gfl::grp::DISPLAY_LOWER, lower_frame_buffer );
    }







  }  // namespace app
}  // namespace btl
