//=======================================================================================
/**
 * @file TargetSelect3vs3_data.cpp
 * @brief ΏۑI( 3vs3 )̃f[^`
 * @author obata_toshihiro
 * @date 2011.08.09
 */
//=======================================================================================
#include <battle/btl_common.h>
#include "TargetSelectBase.h"
#include "TargetSelect3vs3.h"

#include "target_select_3vs3.h"
#include "target_select_3vs3_pane.h"


namespace btl {
  namespace app {


    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_OTHER_ONE( ȊO1|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect3vs3::WazaRangeDesc TargetSelect3vs3::WAZA_RANGE_DESC_OTHER_ONE[ TargetSelectBase::USER_POS_NUM_3VS3 ] = 
    {
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_UL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_UL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_UC,
          /* BUTTON_TARGET_UR */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_DC,
          /* BUTTON_TARGET_DR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_L_UL,
          },
          /* CURSOR_POS_UC */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_L_UC,
          },
          /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DC */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_L_DC,
          },
          /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RETURN */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_L_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_UL,         { CURSOR_POS_UL,     CURSOR_POS_RETURN, CURSOR_POS_UL,     CURSOR_POS_UC } },
          { CURSOR_POS_UC,         { CURSOR_POS_UC,     CURSOR_POS_DC,     CURSOR_POS_UL,     CURSOR_POS_UC } },
          { CURSOR_POS_UR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DC,         { CURSOR_POS_UC,     CURSOR_POS_RETURN, CURSOR_POS_DC,     CURSOR_POS_DC } },
          { CURSOR_POS_DR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_DC,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      }, 
      //----------------------
      // ʒuȄꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_UC,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_UC,
          /* BUTTON_TARGET_UR */ CURSOR_POS_UR,
          /* BUTTON_TARGET_DL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_DC,
          /* BUTTON_TARGET_DR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UC */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_R_UC,
          },
          /* CURSOR_POS_UR */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_3,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UR_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UR_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UR_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_R_UR,
          },
          /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DC */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_R_DC,
          },
          /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RETURN */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_R_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_UL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_UC,         { CURSOR_POS_UC,     CURSOR_POS_DC,     CURSOR_POS_UC,     CURSOR_POS_UR } },
          { CURSOR_POS_UR,         { CURSOR_POS_UR,     CURSOR_POS_RETURN, CURSOR_POS_UC,     CURSOR_POS_UR } },
          { CURSOR_POS_DL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DC,         { CURSOR_POS_UC,     CURSOR_POS_RETURN, CURSOR_POS_DC,     CURSOR_POS_DC } },
          { CURSOR_POS_DR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_DC,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      }, 
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_UL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_UL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_UC,
          /* BUTTON_TARGET_UR */ CURSOR_POS_UR,
          /* BUTTON_TARGET_DL */ CURSOR_POS_DL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DR */ CURSOR_POS_DR,
          /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_C_UL,
          },
          /* CURSOR_POS_UC */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_C_UC,
          },
          /* CURSOR_POS_UR */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_3,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UR_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UR_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UR_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_C_UR,
          },
          /* CURSOR_POS_DL */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_C_DL,
          },
          /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DR */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_3,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DR_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DR_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DR_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_C_DR,
          },
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RETURN */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_C_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_UL,         { CURSOR_POS_UL,     CURSOR_POS_DL,     CURSOR_POS_UL,     CURSOR_POS_UC } },
          { CURSOR_POS_UC,         { CURSOR_POS_UC,     CURSOR_POS_RETURN, CURSOR_POS_UL,     CURSOR_POS_UR } },
          { CURSOR_POS_UR,         { CURSOR_POS_UR,     CURSOR_POS_DR,     CURSOR_POS_UC,     CURSOR_POS_UR } },
          { CURSOR_POS_DL,         { CURSOR_POS_UL,     CURSOR_POS_RETURN, CURSOR_POS_DL,     CURSOR_POS_DR } },
          { CURSOR_POS_DC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DR,         { CURSOR_POS_UR,     CURSOR_POS_RETURN, CURSOR_POS_DL,     CURSOR_POS_DR } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_DR,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      }, 
    };









    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_OTHER_ONE( ȊO1|P, Z )
    //-----------------------------------------------------------------------------------
    const TargetSelect3vs3::WazaRangeDesc TargetSelect3vs3::WAZA_RANGE_DESC_OTHER_ONE_LONG[ TargetSelectBase::USER_POS_NUM_3VS3 ] = 
    {
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_UL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_UL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_UC,
          /* BUTTON_TARGET_UR */ CURSOR_POS_UR,
          /* BUTTON_TARGET_DL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_DC,
          /* BUTTON_TARGET_DR */ CURSOR_POS_DR,
          /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_L_UL,
          },
          /* CURSOR_POS_UC */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_L_UC,
          },
          /* CURSOR_POS_UR */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_3,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UR_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UR_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UR_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_L_UR,
          },
          /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DC */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_L_DC,
          },
          /* CURSOR_POS_DR */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_3,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DR_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DR_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DR_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_L_DR,
          },
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RETURN */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_L_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_UL,         { CURSOR_POS_UL,     CURSOR_POS_RETURN, CURSOR_POS_UL,     CURSOR_POS_UC } },
          { CURSOR_POS_UC,         { CURSOR_POS_UC,     CURSOR_POS_DC,     CURSOR_POS_UL,     CURSOR_POS_UR } },
          { CURSOR_POS_UR,         { CURSOR_POS_UR,     CURSOR_POS_DR,     CURSOR_POS_UC,     CURSOR_POS_UR } },
          { CURSOR_POS_DL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DC,         { CURSOR_POS_UC,     CURSOR_POS_RETURN, CURSOR_POS_DC,     CURSOR_POS_DR } },
          { CURSOR_POS_DR,         { CURSOR_POS_UR,     CURSOR_POS_RETURN, CURSOR_POS_DC,     CURSOR_POS_DR } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_DC,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      }, 
      //----------------------
      // ʒuȄꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_UL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_UL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_UC,
          /* BUTTON_TARGET_UR */ CURSOR_POS_UR,
          /* BUTTON_TARGET_DL */ CURSOR_POS_DL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_DC,
          /* BUTTON_TARGET_DR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_R_UL,
          },
          /* CURSOR_POS_UC */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_R_UC,
          },
          /* CURSOR_POS_UR */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_3,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UR_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UR_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UR_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_R_UR,
          },
          /* CURSOR_POS_DL */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_R_DL,
          },
          /* CURSOR_POS_DC */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_R_DC,
          },
          /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RETURN */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_R_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_UL,         { CURSOR_POS_UL,     CURSOR_POS_DL,     CURSOR_POS_UL,     CURSOR_POS_UC } },
          { CURSOR_POS_UC,         { CURSOR_POS_UC,     CURSOR_POS_DC,     CURSOR_POS_UL,     CURSOR_POS_UR } },
          { CURSOR_POS_UR,         { CURSOR_POS_UR,     CURSOR_POS_RETURN, CURSOR_POS_UC,     CURSOR_POS_UR } },
          { CURSOR_POS_DL,         { CURSOR_POS_UL,     CURSOR_POS_RETURN, CURSOR_POS_DL,     CURSOR_POS_DC } },
          { CURSOR_POS_DC,         { CURSOR_POS_UC,     CURSOR_POS_RETURN, CURSOR_POS_DL,     CURSOR_POS_DC } },
          { CURSOR_POS_DR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_DC,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      }, 
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_UL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_UL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_UC,
          /* BUTTON_TARGET_UR */ CURSOR_POS_UR,
          /* BUTTON_TARGET_DL */ CURSOR_POS_DL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DR */ CURSOR_POS_DR,
          /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_C_UL,
          },
          /* CURSOR_POS_UC */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_C_UC,
          },
          /* CURSOR_POS_UR */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_3,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UR_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UR_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UR_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_C_UR,
          },
          /* CURSOR_POS_DL */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_C_DL,
          },
          /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DR */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_3,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DR_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DR_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DR_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_C_DR,
          },
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RETURN */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_C_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_UL,         { CURSOR_POS_UL,     CURSOR_POS_DL,     CURSOR_POS_UL,     CURSOR_POS_UC } },
          { CURSOR_POS_UC,         { CURSOR_POS_UC,     CURSOR_POS_RETURN, CURSOR_POS_UL,     CURSOR_POS_UR } },
          { CURSOR_POS_UR,         { CURSOR_POS_UR,     CURSOR_POS_DR,     CURSOR_POS_UC,     CURSOR_POS_UR } },
          { CURSOR_POS_DL,         { CURSOR_POS_UL,     CURSOR_POS_RETURN, CURSOR_POS_DL,     CURSOR_POS_DR } },
          { CURSOR_POS_DC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DR,         { CURSOR_POS_UR,     CURSOR_POS_RETURN, CURSOR_POS_DL,     CURSOR_POS_DR } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_DR,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      }, 
    };








    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_OTHER_ALL( ȊȎS|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect3vs3::WazaRangeDesc TargetSelect3vs3::WAZA_RANGE_DESC_OTHER_ALL[ TargetSelectBase::USER_POS_NUM_3VS3 ] = 
    {
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_OTHER_ALL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_TARGET_UR */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_TARGET_DR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UL */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_UC_DC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_UC_DC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UL_UC_DC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_ALL_IN_L,
          },
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_ALL_IN_L_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                    down               left                  right  */
          { CURSOR_POS_UL,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_UC,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_UR,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DL,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DC,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DR,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_OTHER_ALL, CURSOR_POS_RETURN, CURSOR_POS_OTHER_ALL, CURSOR_POS_OTHER_ALL } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_OTHER_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        },
      },
      //----------------------
      // ʒuȄꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_OTHER_ALL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_TARGET_UR */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_TARGET_DL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_TARGET_DR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_UR_DC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_UR_DC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UC_UR_DC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_ALL_IN_R,
          },
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_ALL_IN_R_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                    down               left                  right  */
          { CURSOR_POS_UL,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_UC,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_UR,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DL,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DC,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DR,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_OTHER_ALL, CURSOR_POS_RETURN, CURSOR_POS_OTHER_ALL, CURSOR_POS_OTHER_ALL } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_OTHER_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        },
      },
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_OTHER_ALL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_TARGET_UR */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_TARGET_DL */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DR */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_PADDING_UL */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_PADDING_L */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ALL_EXCEPT_DC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ALL_EXCEPT_DC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_ALL_EXCEPT_DC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_ALL_IN_C,
          },
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_ALL_IN_C_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                    down               left                  right  */
          { CURSOR_POS_UL,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_UC,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_UR,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DL,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DC,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DR,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_OTHER_ALL, CURSOR_POS_RETURN, CURSOR_POS_OTHER_ALL, CURSOR_POS_OTHER_ALL } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_OTHER_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        },
      },
    };








    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_ENEMY_ONE( 葤1|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect3vs3::WazaRangeDesc TargetSelect3vs3::WAZA_RANGE_DESC_ENEMY_ONE[ TargetSelectBase::USER_POS_NUM_3VS3 ] = 
    {
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_UL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_UL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_UC,
          /* BUTTON_TARGET_UR */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ONE_IN_L_L,
          }, 
          /* CURSOR_POS_UC */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ONE_IN_L_C,
          }, 
          /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ONE_IN_L_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_UL,         { CURSOR_POS_UL,     CURSOR_POS_RETURN, CURSOR_POS_UL,     CURSOR_POS_UC } },
          { CURSOR_POS_UC,         { CURSOR_POS_UC,     CURSOR_POS_RETURN, CURSOR_POS_UL,     CURSOR_POS_UC } },
          { CURSOR_POS_UR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_UC,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      },
      //----------------------
      // ʒuȄꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_UC,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_UC,
          /* BUTTON_TARGET_UR */ CURSOR_POS_UR,
          /* BUTTON_TARGET_DC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UC */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ONE_IN_R_C,
          }, 
          /* CURSOR_POS_UR */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_3,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UR_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UR_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UR_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ONE_IN_R_R,
          }, 
          /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ONE_IN_R_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_UL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_UC,         { CURSOR_POS_UC,     CURSOR_POS_RETURN, CURSOR_POS_UC,     CURSOR_POS_UR } },
          { CURSOR_POS_UR,         { CURSOR_POS_UR,     CURSOR_POS_RETURN, CURSOR_POS_UC,     CURSOR_POS_UR } },
          { CURSOR_POS_DL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_UR,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      },
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_UL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_UL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_UC,
          /* BUTTON_TARGET_UR */ CURSOR_POS_UR,
          /* BUTTON_TARGET_DC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ONE_IN_C_L,
          }, 
          /* CURSOR_POS_UC */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ONE_IN_C_C,
          }, 
          /* CURSOR_POS_UR */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_3,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UR_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UR_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UR_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ONE_IN_C_R,
          }, 
          /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ONE_IN_C_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_UL,         { CURSOR_POS_UL,     CURSOR_POS_RETURN, CURSOR_POS_UL,     CURSOR_POS_UC } },
          { CURSOR_POS_UC,         { CURSOR_POS_UC,     CURSOR_POS_RETURN, CURSOR_POS_UL,     CURSOR_POS_UR } },
          { CURSOR_POS_UR,         { CURSOR_POS_UR,     CURSOR_POS_RETURN, CURSOR_POS_UC,     CURSOR_POS_UR } },
          { CURSOR_POS_DL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_UR,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      },
    };












    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_ENEMY_ALL( 葤̑S|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect3vs3::WazaRangeDesc TargetSelect3vs3::WAZA_RANGE_DESC_ENEMY_ALL[ TargetSelectBase::USER_POS_NUM_3VS3 ] =
    {
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_ENEMY_ALL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_TARGET_UR */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_TARGET_DL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UL */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_UC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_UC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UL_UC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ALL_IN_L,
          }, 
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ALL_IN_L_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                    down               left                  right  */
          { CURSOR_POS_UL,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_UC,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_UR,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DL,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DC,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DR,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_ENEMY_ALL, CURSOR_POS_ENEMY_ALL } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        },
      },
      //----------------------
      // ʒuȄꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_ENEMY_ALL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_TARGET_UR */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_TARGET_DL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_UR_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UC_UR_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UC_UR_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ALL_IN_R,
          }, 
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ALL_IN_R_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                    down               left                  right  */
          { CURSOR_POS_UL,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_UC,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_UR,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DL,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DC,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DR,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_ENEMY_ALL, CURSOR_POS_ENEMY_ALL } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        },
      },
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_ENEMY_ALL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_TARGET_UR */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_TARGET_DL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UL */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_UC_UR_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_UC_UR_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UL_UC_UR_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ALL_IN_C,
          }, 
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ALL_IN_C_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                    down               left                  right  */
          { CURSOR_POS_UL,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_UC,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_UR,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DL,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DC,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_DR,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_ENEMY_ALL, CURSOR_POS_ENEMY_ALL } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        },
      },
    };








    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_FIELD_ENEMY(  )
    //-----------------------------------------------------------------------------------
    const TargetSelect3vs3::WazaRangeDesc TargetSelect3vs3::WAZA_RANGE_DESC_ENEMY_FIELD = 
    {
      /* J[\ʒu */ CURSOR_POS_ENEMY_ALL,
      /* e{^Ɋ蓖ĂJ[\ʒu */
      {
        /* BUTTON_TARGET_UL */ CURSOR_POS_ENEMY_ALL,
        /* BUTTON_TARGET_UC */ CURSOR_POS_ENEMY_ALL,
        /* BUTTON_TARGET_UR */ CURSOR_POS_ENEMY_ALL,
        /* BUTTON_TARGET_DL */ CURSOR_POS_NULL,
        /* BUTTON_TARGET_DC */ CURSOR_POS_NULL,
        /* BUTTON_TARGET_DR */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_UL */ CURSOR_POS_ENEMY_ALL,
        /* BUTTON_PADDING_UR */ CURSOR_POS_ENEMY_ALL,
        /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
        /* BUTTON_RETURN */ CURSOR_POS_RETURN,
      },
      /* J[\ʒuƂ̐ݒ */
      {
        /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_ENEMY_ALL */ 
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_UC_UR_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_UL_UC_UR_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_UL_UC_UR_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_FIELD,
        }, 
        /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
        // CURSOR_POS_RETURN
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_FIELD_RET,
        }, 
      },
      /* J[\ړf[^ */
      {
        /*   id                    up                    down               left                  right  */
        { CURSOR_POS_UL,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        { CURSOR_POS_UC,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        { CURSOR_POS_UR,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        { CURSOR_POS_DL,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        { CURSOR_POS_DC,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        { CURSOR_POS_DR,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_ENEMY_ALL, CURSOR_POS_ENEMY_ALL } },
        { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        { CURSOR_POS_RETURN,     { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
      },
    };










    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_FRIEND_ONE( ܂, 1|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect3vs3::WazaRangeDesc TargetSelect3vs3::WAZA_RANGE_DESC_FRIEND_ONE = 
    {
      /* J[\ʒu */ CURSOR_POS_DL,
      /* e{^Ɋ蓖ĂJ[\ʒu */
      {
        /* BUTTON_TARGET_UL */ CURSOR_POS_NULL,
        /* BUTTON_TARGET_UC */ CURSOR_POS_NULL,
        /* BUTTON_TARGET_UR */ CURSOR_POS_NULL,
        /* BUTTON_TARGET_DL */ CURSOR_POS_DL,
        /* BUTTON_TARGET_DC */ CURSOR_POS_DC,
        /* BUTTON_TARGET_DR */ CURSOR_POS_DR,
        /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
        /* BUTTON_RETURN */ CURSOR_POS_RETURN,
      },
      /* J[\ʒuƂ̐ݒ */
      {
        /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DL */ 
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DL_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_ONE_L,
        }, 
        /* CURSOR_POS_DC */ 
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_2,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DC_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_ONE_C,
        }, 
        /* CURSOR_POS_DR */ 
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_3,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DR_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DR_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DR_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_ONE_R,
        }, 
        /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
        // CURSOR_POS_RETURN
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_ONE_RET,
        }, 
      },
      /* J[\ړf[^ */
      {
        /*   id                    up                 down               left               right  */
        { CURSOR_POS_UL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_UC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_UR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_DL,         { CURSOR_POS_DL,     CURSOR_POS_RETURN, CURSOR_POS_DL,     CURSOR_POS_DC } },
        { CURSOR_POS_DC,         { CURSOR_POS_DC,     CURSOR_POS_RETURN, CURSOR_POS_DL,     CURSOR_POS_DR } },
        { CURSOR_POS_DR,         { CURSOR_POS_DR,     CURSOR_POS_RETURN, CURSOR_POS_DC,     CURSOR_POS_DR } },
        { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_RETURN,     { CURSOR_POS_DR,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
      },
    };












    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_FRIEND_OTHER_ONE( , 1|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect3vs3::WazaRangeDesc TargetSelect3vs3::WAZA_RANGE_DESC_FRIEND_OTHER_ONE[ TargetSelectBase::USER_POS_NUM_3VS3 ] = 
    {
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_DC,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_UR */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_DC,
          /* BUTTON_TARGET_DR */ CURSOR_POS_DR,
          /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DC */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_L_C,
          }, 
          /* CURSOR_POS_DR */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_3,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DR_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DR_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DR_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_L_R,
          }, 
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_L_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_UL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_UC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_UR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DC,         { CURSOR_POS_DC,     CURSOR_POS_RETURN, CURSOR_POS_DC,     CURSOR_POS_DR } },
          { CURSOR_POS_DR,         { CURSOR_POS_DR,     CURSOR_POS_RETURN, CURSOR_POS_DC,     CURSOR_POS_DR } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_DR,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      },
      //----------------------
      // ʒuȄꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_DL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_UR */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DL */ CURSOR_POS_DL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_DC,
          /* BUTTON_TARGET_DR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DL */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_R_L,
          }, 
          /* CURSOR_POS_DC */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_R_C,
          }, 
          /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_R_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_UL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_UC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_UR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DL,         { CURSOR_POS_DL,     CURSOR_POS_RETURN, CURSOR_POS_DL,     CURSOR_POS_DC } },
          { CURSOR_POS_DC,         { CURSOR_POS_DC,     CURSOR_POS_RETURN, CURSOR_POS_DL,     CURSOR_POS_DC } },
          { CURSOR_POS_DR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_DC,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      },
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_DL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_UR */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DL */ CURSOR_POS_DL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DR */ CURSOR_POS_DR,
          /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DL */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_C_L,
          }, 
          /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DR */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_3,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DR_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DR_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DR_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_C_R,
          }, 
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_C_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_UL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_UC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_UR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DL,         { CURSOR_POS_DL,     CURSOR_POS_RETURN, CURSOR_POS_DL,     CURSOR_POS_DR } },
          { CURSOR_POS_DC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DR,         { CURSOR_POS_DR,     CURSOR_POS_RETURN, CURSOR_POS_DL,     CURSOR_POS_DR } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_DR,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      },
    };












    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_FRIEND_ALL( ܂, ̑S|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect3vs3::WazaRangeDesc TargetSelect3vs3::WAZA_RANGE_DESC_FRIEND_ALL =
    {
      /* J[\ʒu */ CURSOR_POS_FRIEND_ALL,
      /* e{^Ɋ蓖ĂJ[\ʒu */
      {
        /* BUTTON_TARGET_UL */ CURSOR_POS_NULL,
        /* BUTTON_TARGET_UC */ CURSOR_POS_NULL,
        /* BUTTON_TARGET_UR */ CURSOR_POS_NULL,
        /* BUTTON_TARGET_DL */ CURSOR_POS_FRIEND_ALL,
        /* BUTTON_TARGET_DC */ CURSOR_POS_FRIEND_ALL,
        /* BUTTON_TARGET_DR */ CURSOR_POS_FRIEND_ALL,
        /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
        /* BUTTON_PADDING_DL */ CURSOR_POS_FRIEND_ALL,
        /* BUTTON_PADDING_DR */ CURSOR_POS_FRIEND_ALL,
        /* BUTTON_RETURN */ CURSOR_POS_RETURN,
      },
      /* J[\ʒuƂ̐ݒ */
      {
        /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_FRIEND_ALL */ 
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_DC_DR_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_DC_DR_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DL_DC_DR_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_FIELD,
        }, 
        /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
        // CURSOR_POS_RETURN
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_FIELD_RET,
        }, 
      },
      /* J[\ړf[^ */
      {
        /*   id                    up                     down               left                   right  */
        { CURSOR_POS_UL,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
        { CURSOR_POS_UC,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
        { CURSOR_POS_UR,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
        { CURSOR_POS_DL,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
        { CURSOR_POS_DC,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
        { CURSOR_POS_DR,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
        { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_FRIEND_ALL, CURSOR_POS_RETURN, CURSOR_POS_FRIEND_ALL, CURSOR_POS_FRIEND_ALL } },
        { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
        { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
        { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
        { CURSOR_POS_RETURN,     { CURSOR_POS_FRIEND_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
      },
    };












    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_ALL( ɂS|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect3vs3::WazaRangeDesc TargetSelect3vs3::WAZA_RANGE_DESC_ALL = 
    {
      /* J[\ʒu */ CURSOR_POS_ALL,
      /* e{^Ɋ蓖ĂJ[\ʒu */
      {
        /* BUTTON_TARGET_UL */ CURSOR_POS_ALL,
        /* BUTTON_TARGET_UC */ CURSOR_POS_ALL,
        /* BUTTON_TARGET_UR */ CURSOR_POS_ALL,
        /* BUTTON_TARGET_DL */ CURSOR_POS_ALL,
        /* BUTTON_TARGET_DC */ CURSOR_POS_ALL,
        /* BUTTON_TARGET_DR */ CURSOR_POS_ALL,
        /* BUTTON_PADDING_UL */ CURSOR_POS_ALL,
        /* BUTTON_PADDING_UR */ CURSOR_POS_ALL,
        /* BUTTON_PADDING_L */ CURSOR_POS_ALL,
        /* BUTTON_PADDING_C */ CURSOR_POS_ALL,
        /* BUTTON_PADDING_R */ CURSOR_POS_ALL,
        /* BUTTON_PADDING_DL */ CURSOR_POS_ALL,
        /* BUTTON_PADDING_DR */ CURSOR_POS_ALL,
        /* BUTTON_RETURN */ CURSOR_POS_RETURN,
      },
      /* J[\ʒuƂ̐ݒ */
      {
        /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
        /* CURSOR_POS_ALL */ 
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ALL_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ALL_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_ALL_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_ALL,
        }, 
        // CURSOR_POS_RETURN
        {
          /* J[\ړ\ǂ */ true,
          /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
          /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
          /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
          /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
          /* J[\ZbgAj[V */ ANIMATION_CURSOR_ALL_RET,
        }, 
      },
      /* J[\ړf[^ */
      {
        /*   id                    up                 down               left               right  */
        { CURSOR_POS_UL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_UC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_UR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_DL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_DC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_DR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        { CURSOR_POS_ALL,        { CURSOR_POS_ALL,    CURSOR_POS_RETURN, CURSOR_POS_ALL,    CURSOR_POS_ALL } },
        { CURSOR_POS_RETURN,     { CURSOR_POS_ALL,    CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
      },
    };












    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_USER( ̂ )
    //-----------------------------------------------------------------------------------
    const TargetSelect3vs3::WazaRangeDesc TargetSelect3vs3::WAZA_RANGE_DESC_USER[ TargetSelectBase::USER_POS_NUM_3VS3 ] = 
    {
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_DL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_UR */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DL */ CURSOR_POS_DL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DL */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_USER_IN_L,
          }, 
          /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_USER_IN_L_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_UL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_UC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_UR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DL,         { CURSOR_POS_DL,     CURSOR_POS_RETURN, CURSOR_POS_DL,     CURSOR_POS_DL } },
          { CURSOR_POS_DC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_DL,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      }, 
      //----------------------
      // ʒuȄꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_DR,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_UR */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DR */ CURSOR_POS_DR,
          /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC, 
          /* CURSOR_POS_DC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DR */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_3,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DR_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DR_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DR_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_USER_IN_R,
          }, 
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_USER_IN_R_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_UL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_UC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_UR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DR,         { CURSOR_POS_DR,     CURSOR_POS_RETURN, CURSOR_POS_DR,     CURSOR_POS_DR } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_DR,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      }, 
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_DC,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_UL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_UC */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_UR */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DL */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_DC */ CURSOR_POS_DC,
          /* BUTTON_TARGET_DR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_UR */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_C */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DL */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_DR */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_UL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UC */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_UR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_DC */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_DC_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_DC_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_USER_IN_C,
          }, 
          /* CURSOR_POS_DR */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RET_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RET_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_USER_IN_C_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_UL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_UC,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_UR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DL,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_DC,         { CURSOR_POS_DC,     CURSOR_POS_RETURN, CURSOR_POS_DC,     CURSOR_POS_DC } },
          { CURSOR_POS_DR,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_DR,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      }, 
    };




  }  // namespace app
}  // namespace btl
