//=======================================================================================
/**
 * @file TargetSelect3vs3.h
 * @brief ΏۑI( 3vs3 )
 * @author obata_toshihiro
 * @date 2011.08.10
 */
//=======================================================================================
#ifndef __TARGETSELECT3VS3_H__
#define __TARGETSELECT3VS3_H__
#include <gflib.h>
#include <battle/btl_common.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include "AppDrawUtil.h"
#include "TargetSelectBase.h"


namespace btl {
  namespace app {

    class TargetSelect3vs3 : public TargetSelectBase, public AppDrawUtil
    {
      GFL_FORBID_COPY_AND_ASSIGN( TargetSelect3vs3 );  // Rs[֎~

      public:

      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap       gpAvP[Vq[v
       * @param device_heap    gpfoCXq[v
       * @param btlv_system    og`RAVXe
       * @param base_settings  ݒ
       */
      //---------------------------------------------------------------------------------
      TargetSelect3vs3( 
          gfl::heap::HeapBase* app_heap, gfl::heap::HeapBase* device_heap, 
          BattleViewSystem* btlv_system, const TargetSelectBase::Setting& base_settings );

      //---------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //---------------------------------------------------------------------------------
      virtual ~TargetSelect3vs3(); 

      //---------------------------------------------------------------------------------
      /**
       * @brief AvP[V̊{
       */
      //---------------------------------------------------------------------------------
      virtual AppBase::InitResult Initialize( void );
      virtual void Update( void );
      virtual void Draw( void );
      virtual void ResetSequence( void );



      private:

      // V[PX
      enum Sequence {
        SEQ_WAIT_INPUT,      // ͑҂
        SEQ_WAIT_ANIMATION,  // Aj[VI҂
        SEQ_FINISH,          // I
      }; 

      // J[\ʒu
      enum CursorPos {
        CURSOR_POS_UL,         // 
        CURSOR_POS_UC,         // 
        CURSOR_POS_UR,         // E
        CURSOR_POS_DL,         // 
        CURSOR_POS_DC,         // 
        CURSOR_POS_DR,         // E
        CURSOR_POS_FRIEND_ALL, // ̑S|P
        CURSOR_POS_ENEMY_ALL,  // 葤̑S|P
        CURSOR_POS_OTHER_ALL,  // ȊȎS|P
        CURSOR_POS_ALL,        // ɂS|P
        CURSOR_POS_RETURN,     // ߂
        CURSOR_POS_NUM,        // 
        CURSOR_POS_NULL,       // l
      };

      // {^
      enum ButtonIndex {
        BUTTON_TARGET_UL,  // 
        BUTTON_TARGET_UC,  // 
        BUTTON_TARGET_UR,  // E
        BUTTON_TARGET_DL,  // 
        BUTTON_TARGET_DC,  // 
        BUTTON_TARGET_DR,  // E
        BUTTON_PADDING_UL, // ԃ{^(  )
        BUTTON_PADDING_UR, // ԃ{^( E )
        BUTTON_PADDING_L,  // ԃ{^(  )
        BUTTON_PADDING_C,  // ԃ{^(  )
        BUTTON_PADDING_R,  // ԃ{^( E )
        BUTTON_PADDING_DL, // ԃ{^(  )
        BUTTON_PADDING_DR, // ԃ{^( E )
        BUTTON_RETURN,     //uǂv{^
        BUTTON_NUM,        // 
      };

      // Ώۃ{^
      enum TargetButtonIndex {
        TARGET_BUTTON_UL,
        TARGET_BUTTON_UC,
        TARGET_BUTTON_UR,
        TARGET_BUTTON_DL,
        TARGET_BUTTON_DC,
        TARGET_BUTTON_DR,
        TARGET_BUTTON_NUM,
      };

      // Aj[Vf[^ԍ
      enum AnimationDataIndex {
        ANIMATION_DATA_DUMMY_BALL_NORMAL,
        ANIMATION_DATA_DUMMY_BALL_SICK,
        ANIMATION_DATA_DUMMY_BALL_DEAD,
        ANIMATION_DATA_DUMMY_BALL_NULL,
        ANIMATION_DATA_ENEMY_L_ALIVE,
        ANIMATION_DATA_ENEMY_L_DEAD,
        ANIMATION_DATA_ENEMY_C_ALIVE,
        ANIMATION_DATA_ENEMY_C_DEAD,
        ANIMATION_DATA_ENEMY_R_ALIVE,
        ANIMATION_DATA_ENEMY_R_DEAD,
        ANIMATION_DATA_PLAYER_L_ALIVE,
        ANIMATION_DATA_PLAYER_L_DEAD,
        ANIMATION_DATA_PLAYER_C_ALIVE,
        ANIMATION_DATA_PLAYER_C_DEAD,
        ANIMATION_DATA_PLAYER_R_ALIVE,
        ANIMATION_DATA_PLAYER_R_DEAD,
        ANIMATION_DATA_CURSOR_FLUCTUATE,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_L_UL,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_L_UC,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_L_DC,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_L_RET,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_C_UL,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_C_UC,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_C_UR,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_C_DL,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_C_DR,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_C_RET,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_R_UC,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_R_UR,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_R_DC,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_R_RET,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_L_UL,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_L_UC,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_L_UR,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_L_DC,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_L_DR,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_L_RET,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_C_UL,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_C_UC,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_C_UR,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_C_DL,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_C_DR,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_C_RET,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_R_UL,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_R_UC,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_R_UR,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_R_DL,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_R_DC,
        ANIMATION_DATA_CURSOR_OTHER_SELECT_LONG_IN_R_RET,
        ANIMATION_DATA_CURSOR_ENEMY_ALL_IN_L,
        ANIMATION_DATA_CURSOR_ENEMY_ALL_IN_L_RET,
        ANIMATION_DATA_CURSOR_ENEMY_ALL_IN_C,
        ANIMATION_DATA_CURSOR_ENEMY_ALL_IN_C_RET,
        ANIMATION_DATA_CURSOR_ENEMY_ALL_IN_R,
        ANIMATION_DATA_CURSOR_ENEMY_ALL_IN_R_RET,
        ANIMATION_DATA_CURSOR_ENEMY_FIELD,
        ANIMATION_DATA_CURSOR_ENEMY_FIELD_RET,
        ANIMATION_DATA_CURSOR_OTHER_ALL_IN_L,
        ANIMATION_DATA_CURSOR_OTHER_ALL_IN_L_RET,
        ANIMATION_DATA_CURSOR_OTHER_ALL_IN_C,
        ANIMATION_DATA_CURSOR_OTHER_ALL_IN_C_RET,
        ANIMATION_DATA_CURSOR_OTHER_ALL_IN_R,
        ANIMATION_DATA_CURSOR_OTHER_ALL_IN_R_RET,
        ANIMATION_DATA_CURSOR_ALL,
        ANIMATION_DATA_CURSOR_ALL_RET,
        ANIMATION_DATA_CURSOR_USER_IN_L,
        ANIMATION_DATA_CURSOR_USER_IN_L_RET,
        ANIMATION_DATA_CURSOR_USER_IN_C,
        ANIMATION_DATA_CURSOR_USER_IN_C_RET,
        ANIMATION_DATA_CURSOR_USER_IN_R,
        ANIMATION_DATA_CURSOR_USER_IN_R_RET,
        ANIMATION_DATA_CURSOR_FRIEND_FIELD,
        ANIMATION_DATA_CURSOR_FRIEND_FIELD_RET,
        ANIMATION_DATA_CURSOR_FRIEND_OTHER_ONE_IN_L_C,
        ANIMATION_DATA_CURSOR_FRIEND_OTHER_ONE_IN_L_R,
        ANIMATION_DATA_CURSOR_FRIEND_OTHER_ONE_IN_L_RET,
        ANIMATION_DATA_CURSOR_FRIEND_OTHER_ONE_IN_C_L,
        ANIMATION_DATA_CURSOR_FRIEND_OTHER_ONE_IN_C_R,
        ANIMATION_DATA_CURSOR_FRIEND_OTHER_ONE_IN_C_RET,
        ANIMATION_DATA_CURSOR_FRIEND_OTHER_ONE_IN_R_L,
        ANIMATION_DATA_CURSOR_FRIEND_OTHER_ONE_IN_R_C,
        ANIMATION_DATA_CURSOR_FRIEND_OTHER_ONE_IN_R_RET,
        ANIMATION_DATA_CURSOR_FRIEND_ONE_L,
        ANIMATION_DATA_CURSOR_FRIEND_ONE_C,
        ANIMATION_DATA_CURSOR_FRIEND_ONE_R,
        ANIMATION_DATA_CURSOR_FRIEND_ONE_RET,
        ANIMATION_DATA_CURSOR_ENEMY_ONE_IN_L_L,
        ANIMATION_DATA_CURSOR_ENEMY_ONE_IN_L_C,
        ANIMATION_DATA_CURSOR_ENEMY_ONE_IN_L_RET,
        ANIMATION_DATA_CURSOR_ENEMY_ONE_IN_C_L,
        ANIMATION_DATA_CURSOR_ENEMY_ONE_IN_C_C,
        ANIMATION_DATA_CURSOR_ENEMY_ONE_IN_C_R,
        ANIMATION_DATA_CURSOR_ENEMY_ONE_IN_C_RET,
        ANIMATION_DATA_CURSOR_ENEMY_ONE_IN_R_C,
        ANIMATION_DATA_CURSOR_ENEMY_ONE_IN_R_R,
        ANIMATION_DATA_CURSOR_ENEMY_ONE_IN_R_RET,
        ANIMATION_DATA_BUTTON_UL_HOLD,
        ANIMATION_DATA_BUTTON_UL_RELEASE,
        ANIMATION_DATA_BUTTON_UL_SELECT,
        ANIMATION_DATA_BUTTON_UC_HOLD,
        ANIMATION_DATA_BUTTON_UC_RELEASE,
        ANIMATION_DATA_BUTTON_UC_SELECT,
        ANIMATION_DATA_BUTTON_UR_HOLD,
        ANIMATION_DATA_BUTTON_UR_RELEASE,
        ANIMATION_DATA_BUTTON_UR_SELECT,
        ANIMATION_DATA_BUTTON_DL_HOLD,
        ANIMATION_DATA_BUTTON_DL_RELEASE,
        ANIMATION_DATA_BUTTON_DL_SELECT,
        ANIMATION_DATA_BUTTON_DC_HOLD,
        ANIMATION_DATA_BUTTON_DC_RELEASE,
        ANIMATION_DATA_BUTTON_DC_SELECT,
        ANIMATION_DATA_BUTTON_DR_HOLD,
        ANIMATION_DATA_BUTTON_DR_RELEASE,
        ANIMATION_DATA_BUTTON_DR_SELECT,
        ANIMATION_DATA_BUTTON_RET_HOLD,
        ANIMATION_DATA_BUTTON_RET_RELEASE,
        ANIMATION_DATA_BUTTON_RET_SELECT,
        ANIMATION_DATA_BUTTON_UL_UC_HOLD,
        ANIMATION_DATA_BUTTON_UL_UC_RELEASE,
        ANIMATION_DATA_BUTTON_UL_UC_SELECT,
        ANIMATION_DATA_BUTTON_UL_UC_UR_HOLD,
        ANIMATION_DATA_BUTTON_UL_UC_UR_RELEASE,
        ANIMATION_DATA_BUTTON_UL_UC_UR_SELECT,
        ANIMATION_DATA_BUTTON_UC_UR_HOLD,
        ANIMATION_DATA_BUTTON_UC_UR_RELEASE,
        ANIMATION_DATA_BUTTON_UC_UR_SELECT,
        ANIMATION_DATA_BUTTON_ALL_EXCEPT_DL_HOLD,
        ANIMATION_DATA_BUTTON_ALL_EXCEPT_DL_RELEASE,
        ANIMATION_DATA_BUTTON_ALL_EXCEPT_DL_SELECT,
        ANIMATION_DATA_BUTTON_ALL_EXCEPT_DC_HOLD,
        ANIMATION_DATA_BUTTON_ALL_EXCEPT_DC_RELEASE,
        ANIMATION_DATA_BUTTON_ALL_EXCEPT_DC_SELECT,
        ANIMATION_DATA_BUTTON_ALL_EXCEPT_DR_HOLD,
        ANIMATION_DATA_BUTTON_ALL_EXCEPT_DR_RELEASE,
        ANIMATION_DATA_BUTTON_ALL_EXCEPT_DR_SELECT,
        ANIMATION_DATA_BUTTON_ALL_HOLD,
        ANIMATION_DATA_BUTTON_ALL_RELEASE,
        ANIMATION_DATA_BUTTON_ALL_SELECT,
        ANIMATION_DATA_BUTTON_DL_DC_DR_HOLD,
        ANIMATION_DATA_BUTTON_DL_DC_DR_RELEASE,
        ANIMATION_DATA_BUTTON_DL_DC_DR_SELECT,
        ANIMATION_DATA_NUM,
      };

      // Aj[Vԍ
      enum AnimationIndex {
        ANIMATION_DUMMY_BALL_NORMAL,
        ANIMATION_DUMMY_BALL_SICK,
        ANIMATION_DUMMY_BALL_DEAD,
        ANIMATION_DUMMY_BALL_NULL,
        ANIMATION_ENEMY_L_ALIVE,
        ANIMATION_ENEMY_L_DEAD,
        ANIMATION_ENEMY_C_ALIVE,
        ANIMATION_ENEMY_C_DEAD,
        ANIMATION_ENEMY_R_ALIVE,
        ANIMATION_ENEMY_R_DEAD,
        ANIMATION_PLAYER_L_ALIVE,
        ANIMATION_PLAYER_L_DEAD,
        ANIMATION_PLAYER_C_ALIVE,
        ANIMATION_PLAYER_C_DEAD,
        ANIMATION_PLAYER_R_ALIVE,
        ANIMATION_PLAYER_R_DEAD,
        ANIMATION_CURSOR_FLUCTUATE,
        ANIMATION_CURSOR_OTHER_SELECT_IN_L_UL,
        ANIMATION_CURSOR_OTHER_SELECT_IN_L_UC,
        ANIMATION_CURSOR_OTHER_SELECT_IN_L_DC,
        ANIMATION_CURSOR_OTHER_SELECT_IN_L_RET,
        ANIMATION_CURSOR_OTHER_SELECT_IN_C_UL,
        ANIMATION_CURSOR_OTHER_SELECT_IN_C_UC,
        ANIMATION_CURSOR_OTHER_SELECT_IN_C_UR,
        ANIMATION_CURSOR_OTHER_SELECT_IN_C_DL,
        ANIMATION_CURSOR_OTHER_SELECT_IN_C_DR,
        ANIMATION_CURSOR_OTHER_SELECT_IN_C_RET,
        ANIMATION_CURSOR_OTHER_SELECT_IN_R_UC,
        ANIMATION_CURSOR_OTHER_SELECT_IN_R_UR,
        ANIMATION_CURSOR_OTHER_SELECT_IN_R_DC,
        ANIMATION_CURSOR_OTHER_SELECT_IN_R_RET,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_L_UL,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_L_UC,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_L_UR,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_L_DC,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_L_DR,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_L_RET,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_C_UL,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_C_UC,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_C_UR,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_C_DL,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_C_DR,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_C_RET,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_R_UL,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_R_UC,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_R_UR,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_R_DL,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_R_DC,
        ANIMATION_CURSOR_OTHER_SELECT_LONG_IN_R_RET,
        ANIMATION_CURSOR_ENEMY_ALL_IN_L,
        ANIMATION_CURSOR_ENEMY_ALL_IN_L_RET,
        ANIMATION_CURSOR_ENEMY_ALL_IN_C,
        ANIMATION_CURSOR_ENEMY_ALL_IN_C_RET,
        ANIMATION_CURSOR_ENEMY_ALL_IN_R,
        ANIMATION_CURSOR_ENEMY_ALL_IN_R_RET,
        ANIMATION_CURSOR_ENEMY_FIELD,
        ANIMATION_CURSOR_ENEMY_FIELD_RET,
        ANIMATION_CURSOR_OTHER_ALL_IN_L,
        ANIMATION_CURSOR_OTHER_ALL_IN_L_RET,
        ANIMATION_CURSOR_OTHER_ALL_IN_C,
        ANIMATION_CURSOR_OTHER_ALL_IN_C_RET,
        ANIMATION_CURSOR_OTHER_ALL_IN_R,
        ANIMATION_CURSOR_OTHER_ALL_IN_R_RET,
        ANIMATION_CURSOR_ALL,
        ANIMATION_CURSOR_ALL_RET,
        ANIMATION_CURSOR_USER_IN_L,
        ANIMATION_CURSOR_USER_IN_L_RET,
        ANIMATION_CURSOR_USER_IN_C,
        ANIMATION_CURSOR_USER_IN_C_RET,
        ANIMATION_CURSOR_USER_IN_R,
        ANIMATION_CURSOR_USER_IN_R_RET,
        ANIMATION_CURSOR_FRIEND_FIELD,
        ANIMATION_CURSOR_FRIEND_FIELD_RET,
        ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_L_C,
        ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_L_R,
        ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_L_RET,
        ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_C_L,
        ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_C_R,
        ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_C_RET,
        ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_R_L,
        ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_R_C,
        ANIMATION_CURSOR_FRIEND_OTHER_ONE_IN_R_RET,
        ANIMATION_CURSOR_FRIEND_ONE_L,
        ANIMATION_CURSOR_FRIEND_ONE_C,
        ANIMATION_CURSOR_FRIEND_ONE_R,
        ANIMATION_CURSOR_FRIEND_ONE_RET,
        ANIMATION_CURSOR_ENEMY_ONE_IN_L_L,
        ANIMATION_CURSOR_ENEMY_ONE_IN_L_C,
        ANIMATION_CURSOR_ENEMY_ONE_IN_L_RET,
        ANIMATION_CURSOR_ENEMY_ONE_IN_C_L,
        ANIMATION_CURSOR_ENEMY_ONE_IN_C_C,
        ANIMATION_CURSOR_ENEMY_ONE_IN_C_R,
        ANIMATION_CURSOR_ENEMY_ONE_IN_C_RET,
        ANIMATION_CURSOR_ENEMY_ONE_IN_R_C,
        ANIMATION_CURSOR_ENEMY_ONE_IN_R_R,
        ANIMATION_CURSOR_ENEMY_ONE_IN_R_RET,
        ANIMATION_BUTTON_UL_HOLD,
        ANIMATION_BUTTON_UL_RELEASE,
        ANIMATION_BUTTON_UL_SELECT,
        ANIMATION_BUTTON_UC_HOLD,
        ANIMATION_BUTTON_UC_RELEASE,
        ANIMATION_BUTTON_UC_SELECT,
        ANIMATION_BUTTON_UR_HOLD,
        ANIMATION_BUTTON_UR_RELEASE,
        ANIMATION_BUTTON_UR_SELECT,
        ANIMATION_BUTTON_DL_HOLD,
        ANIMATION_BUTTON_DL_RELEASE,
        ANIMATION_BUTTON_DL_SELECT,
        ANIMATION_BUTTON_DC_HOLD,
        ANIMATION_BUTTON_DC_RELEASE,
        ANIMATION_BUTTON_DC_SELECT,
        ANIMATION_BUTTON_DR_HOLD,
        ANIMATION_BUTTON_DR_RELEASE,
        ANIMATION_BUTTON_DR_SELECT,
        ANIMATION_BUTTON_RET_HOLD,
        ANIMATION_BUTTON_RET_RELEASE,
        ANIMATION_BUTTON_RET_SELECT,
        ANIMATION_BUTTON_UL_UC_HOLD,
        ANIMATION_BUTTON_UL_UC_RELEASE,
        ANIMATION_BUTTON_UL_UC_SELECT,
        ANIMATION_BUTTON_UL_UC_UR_HOLD,
        ANIMATION_BUTTON_UL_UC_UR_RELEASE,
        ANIMATION_BUTTON_UL_UC_UR_SELECT,
        ANIMATION_BUTTON_UC_UR_HOLD,
        ANIMATION_BUTTON_UC_UR_RELEASE,
        ANIMATION_BUTTON_UC_UR_SELECT,
        ANIMATION_BUTTON_UL_UC_DC_HOLD,
        ANIMATION_BUTTON_UL_UC_DC_RELEASE,
        ANIMATION_BUTTON_UL_UC_DC_SELECT,
        ANIMATION_BUTTON_ALL_EXCEPT_DC_HOLD,
        ANIMATION_BUTTON_ALL_EXCEPT_DC_RELEASE,
        ANIMATION_BUTTON_ALL_EXCEPT_DC_SELECT,
        ANIMATION_BUTTON_UC_UR_DC_HOLD,
        ANIMATION_BUTTON_UC_UR_DC_RELEASE,
        ANIMATION_BUTTON_UC_UR_DC_SELECT,
        ANIMATION_BUTTON_ALL_HOLD,
        ANIMATION_BUTTON_ALL_RELEASE,
        ANIMATION_BUTTON_ALL_SELECT,
        ANIMATION_BUTTON_DL_DC_DR_HOLD,
        ANIMATION_BUTTON_DL_DC_DR_RELEASE,
        ANIMATION_BUTTON_DL_DC_DR_SELECT,
        // ȉ, LAj[V
        ANIMATION_MYBALL00_NORMAL,
        ANIMATION_MYBALL00_SICK = ANIMATION_MYBALL00_NORMAL + pml::PokeParty::MAX_MEMBERS,
        ANIMATION_MYBALL00_DEAD = ANIMATION_MYBALL00_SICK + pml::PokeParty::MAX_MEMBERS,
        ANIMATION_MYBALL00_NULL = ANIMATION_MYBALL00_DEAD + pml::PokeParty::MAX_MEMBERS,
        ANIMATION_ENBALL00_NORMAL = ANIMATION_MYBALL00_NULL + pml::PokeParty::MAX_MEMBERS,
        ANIMATION_ENBALL00_SICK = ANIMATION_ENBALL00_NORMAL + pml::PokeParty::MAX_MEMBERS,
        ANIMATION_ENBALL00_DEAD = ANIMATION_ENBALL00_SICK + pml::PokeParty::MAX_MEMBERS,
        ANIMATION_ENBALL00_NULL = ANIMATION_ENBALL00_DEAD + pml::PokeParty::MAX_MEMBERS,
        ANIMATION_NUM = ANIMATION_ENBALL00_NULL + pml::PokeParty::MAX_MEMBERS, // 
        ANIMATION_NULL,  // l
      };


      // LAj[Vԍ
      enum ShareAnimationIndex {
        SHARE_ANIMATION_MYBALL_NORMAL,
        SHARE_ANIMATION_MYBALL_SICK,
        SHARE_ANIMATION_MYBALL_DEAD,
        SHARE_ANIMATION_MYBALL_NULL,
        SHARE_ANIMATION_ENBALL_NORMAL,
        SHARE_ANIMATION_ENBALL_SICK,
        SHARE_ANIMATION_ENBALL_DEAD,
        SHARE_ANIMATION_ENBALL_NULL,
        SHARE_ANIMATION_NUM,
      };


      // LAj[VƂ̐ݒ
      struct ShareAnimationDesc {
        AnimationIndex start_animation_index;           // o^CfbNX
        AnimationDataIndex animation_data_index;        // L̃Aj[Vԍ
        u32 max_share_num;                              // ő勤L
        gfl::grp::g2d::LytPaneIndex share_group_index;  // VFAΏۂ̃O[v
        gfl::grp::g2d::LytPaneIndex share_pane_index;   // VFAΏۂ̃yC
      };


      // {[Ƃ̐ݒ
      struct BallDesc {
        AnimationIndex normal_animation_index;  // ʏ펞̃Aj[V
        AnimationIndex sick_animation_index;    // Ԉُ펞̃Aj[V
        AnimationIndex dead_animation_index;    // m̃Aj[V
        AnimationIndex null_animation_index;    // ̃Aj[V
      };


      // Ώۃ{^Ƃ̐ݒ
      struct TargetButtonDesc {
        BtlvPos btlv_pos;                      // \|P̌ڈʒu
        AnimationIndex alive_animation_index;  // |P퓬\ȏԂ̏ꍇ̃Aj[V
        AnimationIndex dead_animation_index;   // |P퓬s\ȏԂ̏ꍇ̃Aj[V
        gfl::grp::g2d::LytPaneIndex monsname_pane_index;  // X^[ZbgyC
        gfl::grp::g2d::LytPaneIndex pokeicon_pane_index;  // |PACR̃yC
        gfl::grp::g2d::LytPaneIndex sex_pane_index;       // ʂZbgyC
      };


      // J[\ʒuƂ̐ݒ
      struct CursorPosDesc {
        bool move_enable;                       // J[\ړ\ǂ
        BtlvPos btlv_pos;                       // Iۂ̃^[Qbgʒu
        TargetSelectBase::Result result;        // Iꂽۂ̓쌋
        AnimationIndex hold_animation_index;    // Ή{^ꂽۂ̃Aj[V
        AnimationIndex release_animation_index; // Ή{^ꂽۂ̃Aj[V
        AnimationIndex select_animation_index;  // Iۂ̃Aj[V
        AnimationIndex cursor_animation_index;  // J[\ZbgAj[V
      }; 


      // Žʔ͈͂Ƃ̐ݒ
      struct WazaRangeDesc {
        CursorPos cursor_init_pos;                        // J[\ʒu
        CursorPos cursor_pos_of_button[ BUTTON_NUM ];     // e{^Ɋ蓖ĂJ[\ʒu
        CursorPosDesc cursor_pos_desc[ CURSOR_POS_NUM ];  // J[\ʒuƂ̐ݒ
        ::app::tool::CursorManager::MOVE_DATA cursor_move_data[ CURSOR_POS_NUM ]; // J[\ړf[^
      };



      static const u32 APP_HEAPSIZE;     // AvP[Vq[ṽTCY
      static const u32 DEVICE_HEAPSIZE;  // foCXq[ṽTCY

      static const gfl::grp::g2d::LytWkSetUp LAYOUT_WORK_SETUP_DATA;
      static const gfl::grp::g2d::LytArcIndex ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUM ];
      static const gfl::grp::g2d::LytPaneIndex BUTTON_PANE[ BUTTON_NUM ];
      static const ShareAnimationDesc SHARE_ANIMATION_DESC[ SHARE_ANIMATION_NUM ];
      static const BallDesc MY_BALL_DESC[ pml::PokeParty::MAX_MEMBERS ];
      static const BallDesc ENEMY_BALL_DESC[ pml::PokeParty::MAX_MEMBERS ];
      static const TargetButtonDesc TARGET_BUTTON_DESC[ TARGET_BUTTON_NUM ];
      static const CursorPosDesc INVALID_CURSOR_POS_DESC;
      static const WazaRangeDesc WAZA_RANGE_DESC[ USER_POS_NUM_3VS3 ][ TargetSelectBase::WAZA_RANGE_NUM ];  // Žʔ͈͎̗͂ʒuňقȂ

      // Žʔ͈͂Ƃ̃f[^( TargetSelect3vs3_data.cpp Œ` )
      static const WazaRangeDesc WAZA_RANGE_DESC_OTHER_ONE[ USER_POS_NUM_3VS3 ];
      static const WazaRangeDesc WAZA_RANGE_DESC_OTHER_ONE_LONG[ USER_POS_NUM_3VS3 ];
      static const WazaRangeDesc WAZA_RANGE_DESC_ENEMY_ALL[ USER_POS_NUM_3VS3 ];
      static const WazaRangeDesc WAZA_RANGE_DESC_ENEMY_FIELD;
      static const WazaRangeDesc WAZA_RANGE_DESC_OTHER_ALL[ USER_POS_NUM_3VS3 ];
      static const WazaRangeDesc WAZA_RANGE_DESC_ALL;
      static const WazaRangeDesc WAZA_RANGE_DESC_USER[ USER_POS_NUM_3VS3 ];
      static const WazaRangeDesc WAZA_RANGE_DESC_FRIEND_ALL;
      static const WazaRangeDesc WAZA_RANGE_DESC_FRIEND_ONE;
      static const WazaRangeDesc WAZA_RANGE_DESC_FRIEND_OTHER_ONE[ USER_POS_NUM_3VS3 ];
      static const WazaRangeDesc WAZA_RANGE_DESC_ENEMY_ONE[ USER_POS_NUM_3VS3 ];

      CursorPos GetInitialCursorPos( void ) const;
      CursorPos GetCursorPos( ButtonIndex button_index ) const;
      const CursorPosDesc& GetCursorPosDesc( CursorPos cursor_pos ) const;
      const CursorPosDesc& GetCursorPosDesc( ButtonIndex button_index ) const;
      const ::app::tool::CursorManager::MOVE_DATA* GetCursorMoveData( void ) const;
      const WazaRangeDesc& GetWazaRangeDesc( void ) const;


      bool m_init_flag;
      Sequence m_seq;
      Sequence m_next_seq;
      ::app::tool::ButtonManager* m_button_manager;
      ::app::tool::CursorManager* m_cursor_manager;

      gfl::grp::g2d::LytWk* m_layout_work;
      gfl::grp::g2d::LytResID m_layout_resource_id;
      AnimationIndex m_wait_animation_index;


      void CreateLayoutWork( void );
      void CreateShareAnimation( void );
      void CreateCursorManager( void );
      void CreateButtonManager( void );
      void SetupButtonManager( void ); 
      void SetupFont( void );
      void InitializeGraphicsSystem( void );

      void DeleteLayoutWork( void );
      void DeleteCursorManager( void );
      void DeleteButtonManager( void );
      void FinalizeGraphicsSystem( void );

      void InitializeCursorPos( void );

      void SetupPlayerBalls( void );
      void SetupPlayerBall( u8 ball_index );
      void SetPlayerBallDisplay_Normal( u8 ball_index );
      void SetPlayerBallDisplay_Sick( u8 ball_index );
      void SetPlayerBallDisplay_Dead( u8 ball_index );
      void SetPlayerBallDisplay_Null( u8 ball_index );

      void SetupEnemyBalls( void );
      void SetupEnemyBall( u8 ball_index );
      void SetEnemyBallDisplay_Normal( u8 ball_index );
      void SetEnemyBallDisplay_Sick( u8 ball_index );
      void SetEnemyBallDisplay_Dead( u8 ball_index );
      void SetEnemyBallDisplay_Null( u8 ball_index );

      void SetupTargetButtonInfo( TargetButtonIndex button_index );
      void SetTargetButtonDisplay_Alive( TargetButtonIndex button_index );
      void SetTargetButtonDisplay_Dead( TargetButtonIndex button_index );
      void SetTargetButtonDisplay_MonsName( 
          TargetButtonIndex button_index, const pml::pokepara::PokemonParam* param );
      void SetTargetButtonDisplay_PokeIcon( 
          TargetButtonIndex button_index, const pml::pokepara::PokemonParam* param );
      void SetTargetButtonDisplay_Sex( 
          TargetButtonIndex button_index, const pml::pokepara::PokemonParam* param );

      void UpdateSequence( void );
      bool UpdateCursorMove( void );
      bool IsButtonHolding( void ) const;
      bool IsButtonSelected( void ) const;
      CursorPos GetSelectedCursorPosByButton( void ) const;
      CursorPos GetCurrentCursorPos( void ) const;
      CursorPos GetPrevCursorPos( void ) const;
      bool IsSelectEnable( CursorPos cursor_pos ) const;
      void SetResultByCursorPos( CursorPos cursor_pos );

      void StartSelectAnimation( CursorPos cursor_pos );
      bool IsSelectAnimationFinished( void ) const;
      void StartCursorMoveAnimation( CursorPos old_cursor_pos, CursorPos new_cursor_pos );
    };


  }  // namespace app
}  // namespace btl


#endif  // __TARGETSELECT3VS3_H__
