//======================================================================
/**
 * @file  battle_movie.cpp
 * @brief LeXgFog
 * @author  ariizumi
 * @data  11/05/16
 */
//======================================================================

#include <gflib.h>

#include "battle_ar_test.h"
#include "../ar_battle_test.h"
#include "../ar_battle_test_pane.h"
#include "ar_battle_test.gaix"


namespace test {
namespace ar_battle {

#define USE_EDGE_MAP 0

/*
		#define IMG_WIDTH		(512)
		#define IMG_HEIGHT	(256)
		//# define IMG_HEIGHT		(384)
		#define TRM_WIDTH		(400)
		#define TRM_HEIGHT	(240)

		#define	DEF_AR_NEAR	( 1.0f )
		#define	DEF_AR_FAR	( 10000.0f )

		#define	LEFT_CAMERA_POSITION	( gfl::math::VEC3(0.0f,0.0f,1.0f) )
//		#define	LEFT_CAMERA_TARGET		( gfl::math::VEC3(0.0f,0.0f,-1.0f) )
		#define	LEFT_CAMERA_TARGET		( gfl::math::VEC3(0.0f,0.0f,0.0f) )
		#define	RIGHT_CAMERA_POSITION	( gfl::math::VEC3(1.0f,0.0f,1.0f) )
//		#define	RIGHT_CAMERA_TARGET		( gfl::math::VEC3(1.0f,0.0f,-1.0f) )
		#define	RIGHT_CAMERA_TARGET		( gfl::math::VEC3(1.0f,0.0f,0.0f) )
*/
		// |PJ[h
		mw::nar::MarkerTemplate_st g_CubeMarker =
		{	// pokecard_def.bmp
			0,									// id
			0.708333333333333,	// aspect
			4.0,								// side length
			{
				-1, 5, 0, 8,14, 5,-13,-5, 1,-13,-9,-5,-13,-8,-3,-13,-9,-4,-12,-7,-2,-10,-6,-7,-3,-4,-8,-3,-3,-6,-6,-7,-5,-8,-8,-8,-9,-7,-5,14,13,-2, 3, 5, 3,
				-12,-7, 2,-11,-6, 0,-8,-5,-2,-12,-9,-3,-8,-3,-1,-11,-4, 0, 5, 5, 4,-8,-5,-2,-2,-2,-1,-10,-5,-1,-5,-4,-1,-10,-7,-4,-10,-5, 1,-11,-7,-2,-9,-7,-7,
				-12,-9,-4, 3, 2,-7,-9,-6,-4,-1,-1,-6,14, 9,-11,16,11,-15,-8,-6,-5,11, 6,-13,-3,-2,-5,15,10,-13, 7, 6,-8, 7, 7,-12,15,12,-15, 1, 2,-7,-10,-7,-6,
				-13,-10,-7,-14,-10,-8,14,10,-14,-8,-9,-4,-8,-8,-5,-5,-6,-5,-1, 0, 0,-2,-2, 0,13, 9, 4,-4,-4,-2,-1, 0,-5,-11,-10,-3,12, 9,-9,-11,-6,-1,-9,-7,-5,
				-13,-10,-6,-8,-6,-3,-3,-1, 2, 5,-3,-1,12, 3, 3,13, 1,-5,15,-2,-10,12,-6,-13,12, 1,-4, 5, 4,-3, 8, 9,10,-7,-3, 0,-6,-2, 1,-11,-6,-1,-8,-7,-7,
				-7,-5,-2,-5,-3, 1, 1, 0, 4, 8, 4, 8, 3,-8,-11,-4,-11,-13,-13,-13,-14,16,16,15,-13,-14,-15, 1,-9,-12, 6,11,12, 1,12,13,-1, 3, 8,-2, 0, 5,-5,-5,-5,
				-6,-7,-3, 0,-3, 2, 7, 3, 8, 9, 7,11,14,14,14,14,14,13,16,16,15,16,16,15,16,16,16,14,15,14,10,11,10, 8,15,16, 5,14,15,-1, 4,10,-5,-4,-3,
				-7,-8,-4,14, 6, 4,15, 6, 5,13, 9,12,11,12,12,13,14,14,14,15,14,16,16,16, 9, 9, 9, 9, 9, 9, 3, 5, 4, 6,12,15,13,10,14, 8,10,13,-4,-5,-5,
				-4,-3, 0, 0,-1, 3, 3, 0, 0, 8, 8, 6, 8,10, 6,15,16,16,16,16,16,16,16,16,15,14,14,13,10,10,13, 9,13,10, 7,12, 7, 8,13,-3, 1, 7,-5,-3,-2,
				-13,-9,-7,-13,-7,-2,-10,-6,-4,-3, 5,-8,-3, 7,-6, 4,12, 1, 6,13, 7,16,16,14,16,11,10,15,-1, 2,15, 3, 8,12, 3, 8, 0, 1, 8,-4,-1, 5,-6,-4,-1,
				-13,-12,-11,-12,-11,-7,-12,-8,-4,-10,-4,-1,-4, 2, 0,-2, 7, 2, 8,13, 9,16,16,16,16,12, 9,16, 0, 2,14,-4, 0, 5,-2, 3,-8,-3, 5,-11,-4, 4,-8,-7,-4,
				-14,-10,-6,-7,-7,-6, 3, 0,-10,-1,-3,-6, 9, 6,-12,-11,-7,-2,-7,-7,-4,10, 7,-6,-11,-9,-6,15,10,-13,15,11,-12,-7,-5, 2,16,13,-14,-12,-4, 1,-6,-8,-8,
				-14,-10,-7,16, 9,-15,15,10,-12, 7, 6,-7,12, 8,-11,16,10,-14,-9,-5,-4,-3,-3,-2,-5,-1, 1,15,12,-14,-4,-1,-3, 8, 9,-7, 7, 6,-6, 9,10,-5,-6,-5,-3,
				-12,-6,-3,-10,-2, 3,-13,-7, 0,-12,-5, 2,-12,-6,-2,-7,-7,-6,-3,-4,-1,-9,-5, 0, 3, 3, 7,-4, 0, 7,-6, 0, 8,-12,-3, 4,-13,-4, 3,-6, 1, 6,-7,-3, 2,
				9,10,11, 8,12,14,-12,-1, 5,-11,-3, 0,-8,-4,-3,-5,-6,-7,-1,-6,-6,-3,-5,-2,-13,-5, 0,-13,-8,-3,-12,-6,-1,-11,-3, 3,-12,-5, 0,16,16,14,-2,-1, 0,
				15,
				0.423703703703704,
				8.76472904153162,
			},
		};

  
//------------------------------------------------------------------
/**
 * @brief	  PROC̏s֐
 * @return	Result 삪I RES_FINISHԂĂ炤MainFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result Proc::InitFunc(gfl::proc::Manager* pManager)
{

  gfl::heap::HeapBase* heap_memory   = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
  gfl::heap::HeapBase* device_memory = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );
  
  mHeapMem = gfl::heap::Manager::CreateHeap( heap_memory, HEAPID_NAKAHIRO_TEST_APP, 0x570000, gfl::heap::HEAP_TYPE_EXP );
  mDevMem = gfl::heap::Manager::CreateHeap( device_memory,HEAPID_NAKAHIRO_TEST_DEVICE, 0x1b00000, gfl::heap::HEAP_TYPE_EXP );
//  mHeapMem = gfl::heap::Manager::CreateHeap( heap_memory, HEAPID_TEST_ARIIZUMI    , 0x580000  , gfl::heap::HEAP_TYPE_EXP );
//  mDevMem = gfl::heap::Manager::CreateHeap( device_memory,HEAPID_TEST_ARIIZUMI_DEV, 0x1480000 , gfl::heap::HEAP_TYPE_EXP );
	pHeapAllocator = GFL_NEW( mHeapMem ) gfl::heap::NwAllocator( mHeapMem );
	pDevAllocator = GFL_NEW( mDevMem ) gfl::heap::NwAllocator( mDevMem );

  mBattleProc = GFL_NEW(mHeapMem) btl::BattleMainProc();
  
  mBattleProc->SetGameProcManager( mpGameProcManager );
  
  //og̃ZbgAbv
  {
    gamesystem::GameData* gameData = mpGameProcManager->GetGameManager()->GetGameData();

    pml::bridge::CtrAllocator allocator( mHeapMem );
    m_btlEnemyParty = GFL_NEW(mHeapMem) pml::PokeParty( mHeapMem );

    // vC[莝
    for( int i=0;i<6;i++ )
    {
      m_btlSelfPoke[i] = NULL;
      m_btlEnemyPoke[i] = NULL;
    }
    pml::PokeParty* playerParty = gameData->GetPlayerParty();
    playerParty->Clear();
    m_btlEnemyParty->Clear();
    for( int i=0;i<5;i++ )
    {

      m_btlSelfPoke[i] = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, (MonsNo)(MONSNO_PIKATYUU+i), 20+i, 0 );
      playerParty->AddMember( *m_btlSelfPoke[i] );
      
    }
    for( int i=0;i<1;i++ )
    {
      m_btlEnemyPoke[i] = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, (MonsNo)(MONSNO_SIKIZIKA+i), 10+i, 0 );
      m_btlEnemyParty->AddMember( *m_btlEnemyPoke[i] );
    }

    BATTLE_SETUP_FIELD_SITUATION_Init( &m_btlFieldSit );
    //BATTLE_SETUP_Wild( &m_btlSetupParam, gameData, m_btlEnemyParty, &m_btlFieldSit, BTL_RULE_BAND, mHeapMem );
    BATTLE_SETUP_Wild( &m_btlSetupParam, gameData, m_btlEnemyParty, &m_btlFieldSit, BTL_RULE_SINGLE, mHeapMem );

    mBattleProc->SetupParam( &m_btlSetupParam, mHeapMem, mDevMem );
  }
  
  //og̃ZbgAbv܂


  //ARpZbgAbv
  mArData = &m_btlSetupParam.arData;
  
  mArData->is_enable = true;
  mArData->poke_pos[0].Set( 89.0f,0.0f, 220.0f);
  mArData->poke_pos[1].Set( 80.0f,0.0f,-66.0f);
  mArData->camera_pos.Set( 153.0f,  44.0f, 257.0f);
  mArData->camera_trg.Set( -38.0f,  11.0f, -74.0f);
	mArData->btlvCore = NULL;
  //ARpZbgAbv܂
 
  mBattleProc->InitFunc(pManager);

	arSetupSeq = 0;

/*
	CreateCamera();
	CreateLayoutSystem();
	CreateLayoutWork();
	CreateLayoutEnv();
*/

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̏Is֐
 * @return	Result 삪I RES_FINISHԂĂ炤ŏIƉ߂
 */
//------------------------------------------------------------------
gfl::proc::Result Proc::EndFunc(gfl::proc::Manager* pManager)
{
  GFL_UNUSED( pManager );

  mBattleProc->EndFunc(pManager);

	DeleteAR();
	DeleteLayoutEnv();
	DeleteLayoutWork();
	DeleteLayoutSystem();
	DeleteCamera();

  //oǧ㏈
  {
    gamesystem::GameData* gameData = mpGameProcManager->GetGameManager()->GetGameData();
    pml::PokeParty* playerParty = gameData->GetPlayerParty();
    
    playerParty->Clear();
    m_btlEnemyParty->Clear();
    GFL_DELETE( m_btlEnemyParty );
    m_btlEnemyParty = NULL;

    for( int i=0;i<6;i++ )
    {
      if( m_btlSelfPoke[i] )
      {
        pml::System::PokeParaFactory()->DeletePokemonParam( m_btlSelfPoke[i] );         
        m_btlSelfPoke[i] = NULL;
      }
      if( m_btlEnemyPoke[i] )
      {
        pml::System::PokeParaFactory()->DeletePokemonParam( m_btlEnemyPoke[i] );          
        m_btlEnemyPoke[i] = NULL;

      }
    }

    BATTLE_SETUP_Clear( &m_btlSetupParam );
  }
  //oǧ㏈܂

	GFL_DELETE pDevAllocator;
	GFL_DELETE pHeapAllocator;
  gfl::heap::Manager::DeleteHeap( mHeapMem );
  gfl::heap::Manager::DeleteHeap( mDevMem );

  return gfl::proc::RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃Cs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result Proc::UpdateFunc(gfl::proc::Manager* pManager)
{
	mBattleProc->UpdateFunc(pManager);

	switch( arSetupSeq ){
	case 0:
		if( mArData->btlvCore == NULL ){
			break;
		}
		arSetupSeq = 1;
	case 1:
		CreateCamera();
		CreateLayoutSystem();
		CreateLayoutWork();
		CreateLayoutEnv();
		CreateAR();
		arSetupSeq = 2;
		break;
	case 2:
		UpdateAR();
		break;
	}

	return gfl::proc::RES_CONTINUE;
}

//------------------------------------------------------------------
/**
 * @brief	  PROC̃Cs֐
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
//------------------------------------------------------------------
gfl::proc::Result Proc::NextFrameMainFunc(gfl::proc::Manager* pManager)
{

  mBattleProc->NextFrameMainFunc(pManager);
  return gfl::proc::RES_CONTINUE;
}

void Proc::DrawFunc(gfl::proc::Manager* pManager)
{
/*
	DrawAR( ar::narsys::AR_CAMERA_L );
	pG3dScene->Calculate();
	pG3dScene->SubmitView( pG3dCameraLeft );
	pG3dScene->Draw( pGraSystem, gfl::grp::DISPLAY_UPPER, pG3dCameraLeft );

	DrawAR( ar::narsys::AR_CAMERA_R );
	pG3dScene->Calculate();
	pG3dScene->SubmitView( pG3dCameraRight );
	pG3dScene->Draw( pGraSystem, gfl::grp::DISPLAY_UPPER_RIGHT, pG3dCameraRight );
*/

	if( arSetupSeq != 0 ){
		gamesystem::GameManager * gm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
		gfl::grp::GraphicsSystem * pGraSystem = gm->GetGraphicsSystem();

		gfl::grp::RenderTarget * upperFrame = pGraSystem->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER );
//		gfl::grp::RenderTarget * rightFrame = pGraSystem->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER_RIGHT );

		pLeftLayoutWork->Draw( pGraSystem, gfl::grp::DISPLAY_UPPER, upperFrame );
//		pRightLayoutWork->Draw( pGraSystem, gfl::grp::DISPLAY_UPPER_RIGHT, rightFrame );

		DrawAR( ar::narsys::AR_CAMERA_BASE );

		gfl::std::MemCopy( pCameraController[0]->GetImage(), pRgbDeviceBuffer[0], RgbDeviceBufferSize[0] );
//		gfl::std::MemCopy( pCameraController[1]->GetImage(), pRgbDeviceBuffer[1], RgbDeviceBufferSize[1] );
	}

  mBattleProc->DrawFunc(pManager);
}




// J
void Proc::CreateCamera(void)
{
//	gfl::device::camera::System::SetupParam	setup = gfl::device::camera::DefaultSettings_Stereo;
	gfl::device::camera::System::SetupParam	setup = gfl::device::camera::DefaultSettings_Single;
	setup.cameraParam[0].outputWidth = IMG_WIDTH;
	setup.cameraParam[0].outputHeight = IMG_HEIGHT;
//	setup.cameraParam[1].outputWidth = IMG_WIDTH;
//	setup.cameraParam[1].outputHeight = IMG_HEIGHT;
//	setup.pHeap       = mHeapMem;
	setup.pHeap       = mDevMem;
	setup.pDeviceHeap = mDevMem;
//	pCameraSystem = GFL_NEW( mHeapMem ) gfl::device::camera::System( setup );
	pCameraSystem = GFL_NEW( mDevMem ) gfl::device::camera::System( setup );

	pCameraController[0] = pCameraSystem->GetCameraController( gfl::device::camera::CAMERA_1 );
	pCameraController[0]->Activate();
	pCameraController[0]->StartCapture();
//	pCameraController[1] = pCameraSystem->GetCameraController( gfl::device::camera::CAMERA_2 );
//	pCameraController[1]->Activate();
//	pCameraController[1]->StartCapture();
}
void Proc::DeleteCamera(void)
{
	GFL_DELETE	pCameraSystem;
}

/*
			gamesystem::GameManager * gm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
			pGraSystem = gm->GetGraphicsSystem();
*/

// CAEgVXe
void Proc::CreateLayoutSystem(void)
{
/*
	const gfl::grp::g2d::LytSysSetUp setup = {
		128,		// Ǘ\[Xő吔
		10			// ǗCAEg[Nő吔
	};
//	pLayoutSystem = GFL_NEW( mHeapMem ) gfl::grp::g2d::LytSys( &setup, pHeapAllocator, pDevAllocator );
	pLayoutSystem = GFL_NEW( mDevMem ) gfl::grp::g2d::LytSys( &setup, pHeapAllocator, pDevAllocator );
*/
	pLayoutSystem = mArData->btlvCore->GetLayoutSys();

	// \[Xǂݍ
//	gfl::fs::ArcFile * af = GFL_NEW( mHeapMem ) gfl::fs::ArcFile( ARCID_AR_TEST );
	gfl::fs::ArcFile * af = GFL_NEW( mDevMem ) gfl::fs::ArcFile( ARCID_AR_BATTLE_TEST );
	layoutResID = pLayoutSystem->LoadLytRes( pDevAllocator, af, GARC_ar_battle_test_ar_battle_test_LYTDAT );
	GFL_DELETE af;

	// FCRAMɃeNX`]
	pLayoutSystem->TransferAllTexture( layoutResID, gfl::grp::MEMORY_AREA_FCRAM );
}
void Proc::DeleteLayoutSystem(void)
{
//	GFL_DELETE pLayoutSystem;
}

void Proc::CreateLayoutWork(void)
{
	const gfl::grp::g2d::LytWkSetUp setup[] =
	{
		{	// 
			gfl::math::VEC3(0,0,0),		// pos
			gfl::math::VEC2(1,1),			// scale
			gfl::math::VEC3(0,0,0),		// rotate
			1,												// priority
		},
		{	// 
			gfl::math::VEC3(0,-290,0),	// pos
			gfl::math::VEC2(1,1),				// scale
			gfl::math::VEC3(0,0,0),			// rotate
			1,													// priority
		}
	};

	pLeftLayoutWork  = pLayoutSystem->CreateLytWk(
											layoutResID, LYTRES_AR_BATTLE_TEST_DUMMY2_BCLYT, NULL, 0, 0, &setup[0] );
//	pRightLayoutWork = pLayoutSystem->CreateLytWk(
//											layoutResID, LYTRES_AR_BATTLE_TEST_DUMMY2_BCLYT, NULL, 0, 0, &setup[0] );
	pLeftLayoutWork->SetAutoDrawFlag( false );
//	pRightLayoutWork->SetAutoDrawFlag( false );

	// eNX`̕AhXύX
	ChangeTexturePhysicalAddress( pLeftLayoutWork,  0, PANENAME_DUMMY2_PANE_CAPTURE4_00 );
//	ChangeTexturePhysicalAddress( pRightLayoutWork, 1, PANENAME_DUMMY2_PANE_CAPTURE4_00 );
}
void Proc::DeleteLayoutWork(void)
{
	GflHeapFreeMemory( pRgbDeviceBuffer[0] );
//	GflHeapFreeMemory( pRgbDeviceBuffer[1] );
}

void Proc::CreateLayoutEnv(void)
{
	// ˉeݒiˉej
	const gfl::grp::ProjectionParam projection[] =
	{
		{	// 
			gfl::grp::PROJECTION_ORTHO,
			{ -200.0f, 200.0f, -120.0f, 120.0f },
			DEF_AR_NEAR,
			DEF_AR_FAR,
			gfl::math::PIVOT_UPSIDE_TO_TOP,
		},
		{	// 
			gfl::grp::PROJECTION_ORTHO,
			{ -160.0f, 160.0f, -120.0f, 120.0f },
			DEF_AR_NEAR,
			DEF_AR_FAR,
			gfl::math::PIVOT_UPSIDE_TO_TOP,
		}
	};

	// r[ݒ
	const gfl::grp::ViewParam view[] =
	{
		{	// ʁiځj
			LEFT_CAMERA_POSITION,			// JW
			gfl::math::VEC3(0,1,0),		// 
			LEFT_CAMERA_TARGET,				// ^[QbgW
		},
		{	// ʁiEځj
			RIGHT_CAMERA_POSITION,		// JW
			gfl::math::VEC3(0,1,0),		// 
			RIGHT_CAMERA_TARGET,			// ^[QbgW
		},
		{	// 
			gfl::math::VEC3(0,-290,1),	// JW
			gfl::math::VEC3(0,1,0),			// 
			gfl::math::VEC3(0,-290,0),	// ^[QbgW
		},
	};

	// 
//	pUpperLayoutEnv = GFL_NEW( mHeapMem ) gfl::grp::g2d::Env();
	pUpperLayoutEnv = GFL_NEW( mDevMem ) gfl::grp::g2d::Env();
	pUpperLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, projection[0], view[0] );
	pUpperLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, projection[0], view[1] );
	// 
//	pLowerLayoutEnv = GFL_NEW( mHeapMem ) gfl::grp::g2d::Env();
	pLowerLayoutEnv = GFL_NEW( mDevMem ) gfl::grp::g2d::Env();
	pLowerLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, projection[1], view[2] );
	pLowerLayoutEnv->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, projection[1], view[2] );

	// [NɊ֘At
	pLeftLayoutWork->SetUserEnv( pUpperLayoutEnv, pLowerLayoutEnv );
//	pRightLayoutWork->SetUserEnv( pUpperLayoutEnv, pLowerLayoutEnv );
}
void Proc::DeleteLayoutEnv(void)
{
	GFL_DELETE pUpperLayoutEnv;
	GFL_DELETE pLowerLayoutEnv;
}

void Proc::ChangeTexturePhysicalAddress( gfl::grp::g2d::LytWk * wk, int bufIdx, gfl::grp::g2d::LytPaneIndex paneIdx )
{
	RgbDeviceBufferSize[bufIdx] = pCameraController[bufIdx]->GetImageSize();
	pRgbDeviceBuffer[bufIdx] = GflHeapAllocMemoryAlign( mDevMem, RgbDeviceBufferSize[bufIdx], 64 );

	gfl::grp::g2d::LytMaterial* material = wk->GetMaterial( paneIdx );
	const nw::lyt::TexMap& tex_map = material->GetTexMap(0);
	uptr addr = nngxGetPhysicalAddr( reinterpret_cast<uptr>(pRgbDeviceBuffer[bufIdx]) );
	const_cast<nw::lyt::TexMap*>(&tex_map)->SetPhysicalAddress( addr );
}



// AR
void Proc::CreateAR(void)
{
	pARSystem = GFL_NEW( mHeapMem ) ar::narsys::System::System( ar::narsys::AR_CAMERA_MODE_SINGLE, pCameraSystem, mHeapMem, DEF_AR_NEAR, DEF_AR_FAR, TRM_WIDTH, TRM_HEIGHT );
	pARSystem->RegisterDatabase( g_CubeMarker, AR_BORDER_WHITE );
	pARSystem->RegisterDatabase( g_CubeMarker, AR_BORDER_BLACK );
}
void Proc::DeleteAR(void)
{
	GFL_DELETE	pARSystem;
}

void Proc::UpdateAR(void)
{
/*
	// Y: W̊px[hύX
	if( pButton->IsTrigger( gfl::ui::BUTTON_Y ) == true ){
		debugTopFlag ^= 1;
		SetTextBoxPaneStringFromMessageData( PANENAME_AR_TEST_LOWER_PANE_TEXTBOX_03, D_NAKAHIRO_STR_04+debugTopFlag );
		return;
	}

	// A: 
	if( pButton->IsTrigger( gfl::ui::BUTTON_A ) == true ){
		if( visible[0][0] == true && visible[0][1] == true ){
			pG3dModel[0]->SetVisible( true );
			pG3dModel[1]->SetVisible( true );

			pG3dCameraLeft->GetCameraAndTargetPosition( defPos[0], defTarget[0] );
			pG3dCameraLeft->GetUpVector( &defUpVector[0] );
			pG3dCameraRight->GetCameraAndTargetPosition( defPos[1], defTarget[1] );
			pG3dCameraRight->GetUpVector( &defUpVector[1] );

			CreateGyro();

			baseAngle = pGyroscope->GetAngle();

			SetTextBoxPaneStringFromMessageData( PANENAME_AR_TEST_LOWER_PANE_TEXTBOX_01, D_NAKAHIRO_STR_02 );
			mainSeq = 1;
			return;
		}
	}
*/
	pARSystem->UpdateAR();
}

void Proc::DrawAR( int prm )
{
	int	num = pARSystem->GetMarkerNum( prm );
	GFL_PRINT( "AR = %d\n", num );

/*
	u32	i;

	if( mainSeq == 0 ){
		for( i=0; i<2; i++ ){
			modelEnable[i] = pG3dModel[i]->IsVisible();
		}

		int	num = pARSystem->GetMarkerNum( prm );

		for( i=0; i<num; i++ ){
			if( i >= 2 ){ break; }

			gfl::math::MTX34   tmp;

			pARSystem->GetMarkerTransformationMTX34( prm, i, tmp );
			if( i == 0 ){
				baseMtx[prm][0] = tmp;
			}else{
				gfl::math::VEC4	ov4, nv4;

				ov4 = baseMtx[prm][0].GetRow( 0 );
				nv4 = tmp.GetRow( 0 );
				if( ov4.w > nv4.w ){
					baseMtx[prm][1] = baseMtx[prm][0];
					baseMtx[prm][0] = tmp;
				}else{
					baseMtx[prm][1] = tmp;
				}
			}
		}

		for( i=0; i<num; i++ ){
			if( i >= 2 ){ break; }
			pG3dModel[i]->SetTransformMatrix( baseMtx[prm][i] );

			if( modelEnable[i] == false ){
				pG3dModel[i]->SetVisible( true );
				ChangeModelAnime( 0 );
			}
		}

		for( i=num; i<2; i++ ){
			pG3dModel[i]->SetVisible( false );
		}

		for( i=0; i<2; i++ ){
			visible[prm][i] = pG3dModel[i]->IsVisible();
		}

	}else{
		for( i=0; i<2; i++ ){
			pG3dModel[i]->SetTransformMatrix( baseMtx[prm][i] );
		}
	}
*/
}



}		// ar_battle
}		// test
