//=======================================================================================
/**
 * @file TargetSelect2vs2_data.cpp
 * @brief ΏۑI( 2vs2 )̃f[^`
 * @author obata_toshihiro
 * @date 2011.08.09
 */
//=======================================================================================
#include <battle/btl_common.h>
#include "TargetSelectBase.h"
#include "TargetSelect2vs2.h"


namespace btl {
  namespace app {


    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_OTHER_ONE( ȊO1|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect2vs2::WazaRangeDesc TargetSelect2vs2::WAZA_RANGE_DESC_OTHER_ONE[ TargetSelect2vs2::USER_POS_NUM_2VS2 ] = 
    {
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_LT,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_LT,
          /* BUTTON_TARGET_RT */ CURSOR_POS_RT,
          /* BUTTON_TARGET_LB */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_RB */ CURSOR_POS_RB,
          /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LT,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_L_LT,
          },
          /* CURSOR_POS_RT */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_RT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_RT,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_RT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_L_RT,
          },
          /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RB */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_RB,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_RB,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_RB,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_L_RB,
          },
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RETURN */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_L_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_LT,         { CURSOR_POS_LT,     CURSOR_POS_RETURN, CURSOR_POS_LT,     CURSOR_POS_RT } },
          { CURSOR_POS_RT,         { CURSOR_POS_RT,     CURSOR_POS_RB,     CURSOR_POS_LT,     CURSOR_POS_RT } },
          { CURSOR_POS_LB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RB,         { CURSOR_POS_RT,     CURSOR_POS_RETURN, CURSOR_POS_RB,     CURSOR_POS_RB } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      }, 
      //----------------------
      // ʒuȄꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_LT,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_LT,
          /* BUTTON_TARGET_RT */ CURSOR_POS_RT,
          /* BUTTON_TARGET_LB */ CURSOR_POS_LB,
          /* BUTTON_TARGET_RB */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LT,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_R_LT,
          },
          /* CURSOR_POS_RT */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_RT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_RT,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_RT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_R_RT,
          },
          /* CURSOR_POS_LB */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LB,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LB,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LB,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_R_LB,
          },
          /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RETURN */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_R_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_LT,         { CURSOR_POS_LT,     CURSOR_POS_LB,     CURSOR_POS_LT,     CURSOR_POS_RT } },
          { CURSOR_POS_RT,         { CURSOR_POS_RT,     CURSOR_POS_RETURN, CURSOR_POS_LT,     CURSOR_POS_RT } },
          { CURSOR_POS_LB,         { CURSOR_POS_LT,     CURSOR_POS_RETURN, CURSOR_POS_LB,     CURSOR_POS_LB } },
          { CURSOR_POS_RB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_RT,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      },
    };








    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_OTHER_ALL( ȊȎS|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect2vs2::WazaRangeDesc TargetSelect2vs2::WAZA_RANGE_DESC_OTHER_ALL[ TargetSelect2vs2::USER_POS_NUM_2VS2 ] = 
    {
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_OTHER_ALL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_TARGET_RT */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_TARGET_LB */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_RB */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_PADDING_U */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ALL_HOLD_IN_L,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ALL_RELEASE_IN_L,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ALL_SELECT_IN_L,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_ALL_IN_L,
          },
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_ALL_IN_L_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                    down               left                  right  */
          { CURSOR_POS_LT,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RT,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_LB,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RB,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_OTHER_ALL, CURSOR_POS_RETURN, CURSOR_POS_OTHER_ALL, CURSOR_POS_OTHER_ALL } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_OTHER_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        },
      },
      //----------------------
      // ʒuȄꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_OTHER_ALL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_TARGET_RT */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_TARGET_LB */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_TARGET_RB */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_U */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_OTHER_ALL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ALL_HOLD_IN_R,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ALL_RELEASE_IN_R,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ALL_SELECT_IN_R,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_ALL_IN_R,
          },
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_ALL_IN_R_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                    down               left                  right  */
          { CURSOR_POS_LT,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RT,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_LB,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RB,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_OTHER_ALL, CURSOR_POS_RETURN, CURSOR_POS_OTHER_ALL, CURSOR_POS_OTHER_ALL } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_OTHER_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        },
      },
    };








    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_ENEMY_ONE( 葤1|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect2vs2::WazaRangeDesc TargetSelect2vs2::WAZA_RANGE_DESC_ENEMY_ONE[ TargetSelect2vs2::USER_POS_NUM_2VS2 ] = 
    {
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_LT,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_LT,
          /* BUTTON_TARGET_RT */ CURSOR_POS_RT,
          /* BUTTON_TARGET_LB */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_RB */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LT,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_SELECT_L,
          }, 
          /* CURSOR_POS_RT */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_RT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_RT,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_RT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_SELECT_R,
          }, 
          /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_SELECT_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_LT,         { CURSOR_POS_LT,     CURSOR_POS_RETURN, CURSOR_POS_LT,     CURSOR_POS_RT } },
          { CURSOR_POS_RT,         { CURSOR_POS_RT,     CURSOR_POS_RETURN, CURSOR_POS_LT,     CURSOR_POS_RT } },
          { CURSOR_POS_LB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_RT,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      },
      //----------------------
      // ʒuȄꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_LT,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_LT,
          /* BUTTON_TARGET_RT */ CURSOR_POS_RT,
          /* BUTTON_TARGET_LB */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_RB */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LT,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_SELECT_L,
          }, 
          /* CURSOR_POS_RT */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_RT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_RT,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_RT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_SELECT_R,
          }, 
          /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_SELECT_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_LT,         { CURSOR_POS_LT,     CURSOR_POS_RETURN, CURSOR_POS_LT,     CURSOR_POS_RT } },
          { CURSOR_POS_RT,         { CURSOR_POS_RT,     CURSOR_POS_RETURN, CURSOR_POS_LT,     CURSOR_POS_RT } },
          { CURSOR_POS_LB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_RT,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      },
    };












    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_ENEMY_ALL( 葤̑S|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect2vs2::WazaRangeDesc TargetSelect2vs2::WAZA_RANGE_DESC_ENEMY_ALL[ TargetSelect2vs2::USER_POS_NUM_2VS2 ] = 
    {
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_ENEMY_ALL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_TARGET_RT */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_TARGET_LB */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_RB */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_U */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ENEMY_ALL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ENEMY_ALL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_ENEMY_ALL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ALL,
          }, 
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ALL_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                    down               left                  right  */
          { CURSOR_POS_LT,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RT,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_LB,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RB,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_ENEMY_ALL, CURSOR_POS_ENEMY_ALL } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        },
      },
      //----------------------
      // ʒuȄꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_ENEMY_ALL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_TARGET_RT */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_TARGET_LB */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_RB */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_U */ CURSOR_POS_ENEMY_ALL,
          /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ENEMY_ALL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ENEMY_ALL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_ENEMY_ALL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ALL,
          }, 
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ALL_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                    down               left                  right  */
          { CURSOR_POS_LT,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RT,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_LB,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RB,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_ENEMY_ALL, CURSOR_POS_ENEMY_ALL } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
        },
      },
    };












    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_FRIEND_ONE( ܂, 1|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect2vs2::WazaRangeDesc TargetSelect2vs2::WAZA_RANGE_DESC_FRIEND_ONE[ TargetSelect2vs2::USER_POS_NUM_2VS2 ] = 
    {
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_LB,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_RT */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_LB */ CURSOR_POS_LB,
          /* BUTTON_TARGET_RB */ CURSOR_POS_RB,
          /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_LB */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LB,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LB,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LB,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_USER_SELECT_L,
          }, 
          /* CURSOR_POS_RB */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_RB,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_RB,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_RB,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_USER_SELECT_R,
          }, 
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_USER_SELECT_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_LT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_LB,         { CURSOR_POS_LB,     CURSOR_POS_RETURN, CURSOR_POS_LB,     CURSOR_POS_RB } },
          { CURSOR_POS_RB,         { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_LB,     CURSOR_POS_RB } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      },
      //----------------------
      // ʒuȄꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_LB,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_RT */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_LB */ CURSOR_POS_LB,
          /* BUTTON_TARGET_RB */ CURSOR_POS_RB,
          /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_LB */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LB,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LB,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LB,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_USER_SELECT_L,
          }, 
          /* CURSOR_POS_RB */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_RB,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_RB,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_RB,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_USER_SELECT_R,
          }, 
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_USER_SELECT_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_LT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_LB,         { CURSOR_POS_LB,     CURSOR_POS_RETURN, CURSOR_POS_LB,     CURSOR_POS_RB } },
          { CURSOR_POS_RB,         { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_LB,     CURSOR_POS_RB } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      },
    };












    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_FRIEND_OTHER_ONE( , 1|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect2vs2::WazaRangeDesc TargetSelect2vs2::WAZA_RANGE_DESC_FRIEND_OTHER_ONE[ TargetSelect2vs2::USER_POS_NUM_2VS2 ] = 
    {
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_RB,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_RT */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_LB */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_RB */ CURSOR_POS_RB,
          /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RB */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_2,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_RB,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_RB,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_RB,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_SELECT_IN_L,
          }, 
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_SELECT_IN_L_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_LT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_LB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RB,         { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_RB,     CURSOR_POS_RB } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      },
      //----------------------
      // ʒuȄꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_LB,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_RT */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_LB */ CURSOR_POS_LB,
          /* BUTTON_TARGET_RB */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_LB */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LB,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LB,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LB,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_SELECT_IN_R,
          }, 
          /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_SELECT_IN_R_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_LT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_LB,         { CURSOR_POS_LB,     CURSOR_POS_RETURN, CURSOR_POS_LB,     CURSOR_POS_LB } },
          { CURSOR_POS_RB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_LB,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      },
    };












    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_FRIEND_ALL( ܂, ̑S|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect2vs2::WazaRangeDesc TargetSelect2vs2::WAZA_RANGE_DESC_FRIEND_ALL[ TargetSelect2vs2::USER_POS_NUM_2VS2 ] = 
    {
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_FRIEND_ALL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_RT */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_LB */ CURSOR_POS_FRIEND_ALL,
          /* BUTTON_TARGET_RB */ CURSOR_POS_FRIEND_ALL,
          /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_D */ CURSOR_POS_FRIEND_ALL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_FRIEND_ALL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_FRIEND_ALL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_FRIEND_ALL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_ALL,
          }, 
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_ALL_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                     down               left                   right  */
          { CURSOR_POS_LT,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
          { CURSOR_POS_RT,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
          { CURSOR_POS_LB,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
          { CURSOR_POS_RB,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_FRIEND_ALL, CURSOR_POS_RETURN, CURSOR_POS_FRIEND_ALL, CURSOR_POS_FRIEND_ALL } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_FRIEND_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
        },
      },
      //----------------------
      // ʒuȄꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_FRIEND_ALL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_RT */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_LB */ CURSOR_POS_FRIEND_ALL,
          /* BUTTON_TARGET_RB */ CURSOR_POS_FRIEND_ALL,
          /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_D */ CURSOR_POS_FRIEND_ALL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_FRIEND_ALL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_FRIEND_ALL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_FRIEND_ALL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_ALL,
          }, 
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_ALL_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                     down               left                   right  */
          { CURSOR_POS_LT,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
          { CURSOR_POS_RT,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
          { CURSOR_POS_LB,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
          { CURSOR_POS_RB,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_FRIEND_ALL, CURSOR_POS_RETURN, CURSOR_POS_FRIEND_ALL, CURSOR_POS_FRIEND_ALL } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_FRIEND_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
        },
      },
    };












    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_ALL( ɂS|P )
    //-----------------------------------------------------------------------------------
    const TargetSelect2vs2::WazaRangeDesc TargetSelect2vs2::WAZA_RANGE_DESC_ALL[ TargetSelect2vs2::USER_POS_NUM_2VS2 ] = 
    {
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_ALL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_ALL,
          /* BUTTON_TARGET_RT */ CURSOR_POS_ALL,
          /* BUTTON_TARGET_LB */ CURSOR_POS_ALL,
          /* BUTTON_TARGET_RB */ CURSOR_POS_ALL,
          /* BUTTON_PADDING_U */ CURSOR_POS_ALL,
          /* BUTTON_PADDING_D */ CURSOR_POS_ALL,
          /* BUTTON_PADDING_L */ CURSOR_POS_ALL,
          /* BUTTON_PADDING_R */ CURSOR_POS_ALL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ALL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ALL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_ALL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ALL,
          }, 
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ALL_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_LT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_LB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_ALL,    CURSOR_POS_RETURN, CURSOR_POS_ALL,    CURSOR_POS_ALL } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_ALL,    CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      },
      //----------------------
      // ʒuȄꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_ALL,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_ALL,
          /* BUTTON_TARGET_RT */ CURSOR_POS_ALL,
          /* BUTTON_TARGET_LB */ CURSOR_POS_ALL,
          /* BUTTON_TARGET_RB */ CURSOR_POS_ALL,
          /* BUTTON_PADDING_U */ CURSOR_POS_ALL,
          /* BUTTON_PADDING_D */ CURSOR_POS_ALL,
          /* BUTTON_PADDING_L */ CURSOR_POS_ALL,
          /* BUTTON_PADDING_R */ CURSOR_POS_ALL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ALL_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ALL_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_ALL_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ALL,
          }, 
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_ALL_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_LT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_LB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_ALL,    CURSOR_POS_RETURN, CURSOR_POS_ALL,    CURSOR_POS_ALL } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_ALL,    CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      },
    };












    //-----------------------------------------------------------------------------------
    // WAZA_RANGE_USER( ̂ )
    //-----------------------------------------------------------------------------------
    const TargetSelect2vs2::WazaRangeDesc TargetSelect2vs2::WAZA_RANGE_DESC_USER[ TargetSelect2vs2::USER_POS_NUM_2VS2 ] = 
    {
      //----------------------
      // ʒȕꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_LB,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_RT */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_LB */ CURSOR_POS_LB,
          /* BUTTON_TARGET_RB */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_LB */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LB,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LB,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LB,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_USER_IN_L,
          }, 
          /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_USER_IN_L_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_LT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_LB,         { CURSOR_POS_LB,     CURSOR_POS_RETURN, CURSOR_POS_LB,     CURSOR_POS_LB } },
          { CURSOR_POS_RB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_LB,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      }, 
      //----------------------
      // ʒuȄꍇ
      //----------------------
      {
        /* J[\ʒu */ CURSOR_POS_RB,
        /* e{^Ɋ蓖ĂJ[\ʒu */
        {
          /* BUTTON_TARGET_LT */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_RT */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_LB */ CURSOR_POS_NULL,
          /* BUTTON_TARGET_RB */ CURSOR_POS_RB,
          /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
          /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
          /* BUTTON_RETURN */ CURSOR_POS_RETURN,
        },
        /* J[\ʒuƂ̐ݒ */
        {
          /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_RB */ 
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LB,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LB,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LB,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_USER_IN_R,
          }, 
          /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
          /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
          // CURSOR_POS_RETURN
          {
            /* J[\ړ\ǂ */ true,
            /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
            /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
            /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
            /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
            /* J[\ZbgAj[V */ ANIMATION_CURSOR_USER_IN_R_RET,
          }, 
        },
        /* J[\ړf[^ */
        {
          /*   id                    up                 down               left               right  */
          { CURSOR_POS_LT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_LB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RB,         { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_RB,     CURSOR_POS_RB } },
          { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN,     { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        },
      }, 
    };




  }  // namespace app
}  // namespace btl
