//=======================================================================================
/**
 * @file   test_obata_btl_TargetSelect.cpp
 * @brief  ogʂ̃eXgvZX
 * @author obata_toshihiro
 * @date   2011.08.06
 */
//=======================================================================================
#include <gflib.h>
#include <gamesystem/GameProc.h>
#include <battle/battle_MainProc.h>
#include <battle/btlv/app/AppBase.h>
#include <battle/btlv/app/TargetSelectBase.h>
#include <battle/btlv/app/TargetSelect2vs2.h>
#include "test_obata_btl_TargetSelect.h"

namespace test {
  namespace obata {



    //-----------------------------------------------------------------------------------
    // RXgN^
    //-----------------------------------------------------------------------------------
    TargetSelectTest::TargetSelectTest( void ) : 
      btl::BattleMainProc(),
      m_app( NULL ),
      m_app_count( 0 ),
      m_btl_wait_count( 0 ),
      m_app_test_finish( false ),
      m_set_next_proc( false )
    {
      gfl::heap::HeapBase* heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
      gfl::heap::HeapBase* device_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );
      gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      gamesystem::GameData* game_data = game_manager->GetGameData();
      pml::bridge::CtrAllocator allocator( heap ); 

      // p[eB쐬
      pml::PokeParty* player_party = game_data->GetPlayerParty(); 
      {
        pml::pokepara::PokemonParam* param;
        param = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_PIKATYUU, 5, 0 );
        player_party->ReplaceMember( 0, *param );
        pml::System::PokeParaFactory()->DeletePokemonParam( param );

        param = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_RAITYUU, 5, 0 );
        param->SetHp(0);
        player_party->ReplaceMember( 1, *param );
        pml::System::PokeParaFactory()->DeletePokemonParam( param );
      }

      // Gp[eB쐬
      m_enemy_party = GFL_NEW( heap ) pml::PokeParty( heap );
      {
        pml::pokepara::PokemonParam* param;
        param = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_BATAHURII, 5, 0 );
        m_enemy_party->AddMember( *param ); 
        pml::System::PokeParaFactory()->DeletePokemonParam( param );

        param = pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_BURAKKII, 5, 0 );
        m_enemy_party->AddMember( *param ); 
        pml::System::PokeParaFactory()->DeletePokemonParam( param );
      }


      // ogvZX̃ZbgAbv
      BATTLE_SETUP_FIELD_SITUATION_Init( &m_btl_field_situation );
      BATTLE_SETUP_Wild( &m_btl_param, game_data, 
          m_enemy_party, &m_btl_field_situation, BTL_RULE_DOUBLE, heap ); 
      this->SetupParam( &m_btl_param, heap, device_heap );

      // ogAvP[V̏
      btl::app::AppDrawUtil::Initialize( heap );
    }



    //-----------------------------------------------------------------------------------
    // fXgN^
    //----------------------------------------------------------------------------------- 
    TargetSelectTest::~TargetSelectTest( void )
    {
      btl::app::AppDrawUtil::Finalize();
      GFL_DELETE m_enemy_party;
    }






    //----------------------------------------------------------------------------------- 
    // XV
    //----------------------------------------------------------------------------------- 
    gfl::proc::Result TargetSelectTest::UpdateFunc( gfl::proc::Manager* pProcManager )
    {
      if( m_btl_wait_count++ < 100 ) {  // ogvZX̏܂ōXV
        btl::BattleMainProc::UpdateFunc( pProcManager );
        return gfl::proc::RES_CONTINUE;
      } 

      if( !m_app && !m_app_test_finish ) {
        this->CreateBattleApplication();
        m_app_count++;
      } 

      if( m_app ) {
        if( m_app->IsFinished() ) {
          this->DeleteBattleApplication();
        }
        else {
          m_app->Update(); 
        }
      }
      else {
        return btl::BattleMainProc::UpdateFunc( pProcManager );
      }
      return gfl::proc::RES_CONTINUE;
    }



    // ogʃAvP[V쐬
    void TargetSelectTest::CreateBattleApplication( void )
    {
      GFL_ASSERT( !m_app );
      gfl::heap::HeapBase* heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
      gfl::heap::HeapBase* device_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );
#if 0
      btl::BattleViewSystem* btlv_system = this->GetMainModule()->GetBattleViewSystem(); 
#else
      btl::BattleViewSystem* btlv_system = NULL;
#endif
      btl::app::TargetSelectBase::Setting settings;

      switch( m_app_count ) {
      case 0:
        GFL_PRINT( ": ȊO1|P\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_LEFT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_OTHER_ONE;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      case 1:
        GFL_PRINT( ": ȊȎS|P\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_LEFT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_OTHER_ALL;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      case 2:
        GFL_PRINT( ": 葤1|P\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_LEFT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_ENEMY_ONE;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      case 3:
        GFL_PRINT( ": 葤̑S|P\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_LEFT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_ENEMY_ALL;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      case 4:
        GFL_PRINT( ": 1|P\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_LEFT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_FRIEND_ONE;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      case 5:
        GFL_PRINT( ": ȊO1|P\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_LEFT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_FRIEND_OTHER_ONE;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      case 6:
        GFL_PRINT( ": ̑S|P\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_LEFT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_FRIEND_ALL;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      case 7:
        GFL_PRINT( ": ɂS|P\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_LEFT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_ALL;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      case 8:
        GFL_PRINT( ": ̂\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_LEFT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_USER;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      case 9:
        GFL_PRINT( "E: ȊO1|P\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_RIGHT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_OTHER_ONE;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      case 10:
        GFL_PRINT( "E: ȊȎS|P\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_RIGHT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_OTHER_ALL;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      case 11:
        GFL_PRINT( "E: 葤1|P\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_RIGHT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_ENEMY_ONE;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      case 12:
        GFL_PRINT( "E: 葤̑S|P\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_RIGHT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_ENEMY_ALL;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      case 13:
        GFL_PRINT( "E: 1|P\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_RIGHT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_FRIEND_ONE;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      case 14:
        GFL_PRINT( "E: ȊO1|P\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_RIGHT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_FRIEND_OTHER_ONE;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      case 15:
        GFL_PRINT( "E: ̑S|P\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_RIGHT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_FRIEND_ALL;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      case 16:
        GFL_PRINT( "E: ɂS|P\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_RIGHT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_ALL;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      case 17:
        GFL_PRINT( "E: ̂\n" );
        settings.player_balls_display = true;
        settings.enemy_balls_display = true;
        settings.user_pos= btl::app::TargetSelectBase::USER_POS_RIGHT;
        settings.waza_range = btl::app::TargetSelectBase::WAZA_RANGE_USER;
        m_app = GFL_NEW( heap ) btl::app::TargetSelect2vs2( heap, device_heap, btlv_system, settings );
        break;
      default:
        GFL_PRINT( "eXgI!!\n" );
        m_app_test_finish = true;
        break;
      }



      if( m_app ) {
        while(1) {
          btl::app::AppBase::InitResult res = m_app->Initialize();
          if( res == btl::app::AppBase::INIT_RESULT_FINISH ) {
            break;
          }
        }
      }
    }


    // ogʃAvP[V폜
    void TargetSelectTest::DeleteBattleApplication( void )
    {
      if( m_app ) {
        GFL_DELETE( m_app );
        m_app = NULL;
      }
    }




    //----------------------------------------------------------------------------------- 
    // `揈
    //----------------------------------------------------------------------------------- 
    void TargetSelectTest::DrawFunc( gfl::proc::Manager* pProcManager )
    {
      if( m_app ) {
          m_app->Draw();
      }
      else {
        btl::BattleMainProc::DrawFunc( pProcManager );
      }
    }




    //----------------------------------------------------------------------------------- 
    // I
    //----------------------------------------------------------------------------------- 
    gfl::proc::Result TargetSelectTest::EndFunc( gfl::proc::Manager* pProcManager )
    {
      if( !m_set_next_proc ) {
        m_set_next_proc = true;
        KUJIRA_PROC_SETNEXT<gamesystem::GameProcManager, test::obata::Proc>( 
            GFL_SINGLETON_INSTANCE( gamesystem::GameManager )->GetProcManager() );
        gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_DOUBLE, 10 );  // ʃtF[hCJn
      }
      return btl::BattleMainProc::EndFunc( pProcManager );
    }



  } // namespace obata
} // namespace test 

