//=======================================================================================
/**
 * @file TargetSelectBase.h
 * @brief ΏۑIʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.08.05
 */
//=======================================================================================
#ifndef __TARGETSELECTBASE_H__
#define __TARGETSELECTBASE_H__
#include <gflib.h>
#include <battle/btl_common.h>
#include "AppBase.h"


namespace btl {

  class BTL_PARTY;
  class BattleViewSystem;


  namespace app {

    class TargetSelectBase : public AppBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( TargetSelectBase );  // Rs[֎~

      public:

      // Zgp|P̗ʒu
      enum UserPos {
        USER_POS_LEFT,    // 
        USER_POS_RIGHT,   // E
        USER_POS_CENTER,  // 

        USER_POS_NUM_2VS2 = 2,  // 2vs2̗ʒu
        USER_POS_NUM_3VS3 = 3,  // 2vs2̗ʒu
      };


      // Žʔ͈
      enum WazaRange {
        WAZA_RANGE_OTHER_ONE,         // ȊO1|P
        WAZA_RANGE_OTHER_ALL,         // ȊȎS|P
        WAZA_RANGE_ENEMY_ONE,         // 葤1|P
        WAZA_RANGE_ENEMY_ALL,         // 葤̑S|P
        WAZA_RANGE_FRIEND_ONE,        // 1|P
        WAZA_RANGE_FRIEND_OTHER_ONE,  // ȊO1|P
        WAZA_RANGE_FRIEND_ALL,        // ȊȎS|P
        WAZA_RANGE_ALL,               // ܂ޑS|P
        WAZA_RANGE_USER,              // ̂
        WAZA_RANGE_NUM,
      };


      // ݒ
      struct Setting {
        bool player_balls_display;   // ̃{[ACR\邩ǂ
        bool enemy_balls_display;    // ̃{[ACR\邩ǂ
        UserPos user_pos;            // Zgp|P̗ʒu
        WazaRange waza_range;        // Žʔ͈
      };

      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap          gpAvP[Vq[v
       * @param app_heap_size     gpAvP[Vq[ṽTCY
       * @param device_heap       gpfoCXq[v
       * @param device_heap_size  gpfoCXq[ṽTCY
       * @param btlv_system       og`RAVXe
       * @param settings          ݒ
       */
      //---------------------------------------------------------------------------------
      TargetSelectBase( 
          gfl::heap::HeapBase* app_heap, u32 app_heap_size,
          gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
          BattleViewSystem* btlv_system, const Setting& settings );

      //---------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //---------------------------------------------------------------------------------
      virtual ~TargetSelectBase();




      // I
      enum Result {
        RESULT_RETURN,  //uǂvI
        RESULT_SELECT,  // ΏۂI
        RESULT_NULL,
      };

      //---------------------------------------------------------------------------------
      /**
       * @brief ʂ擾
       */
      //---------------------------------------------------------------------------------
      Result GetResult( void ) const;

      //---------------------------------------------------------------------------------
      /**
       * @brief IΏۂ̗ʒu擾
       */
      //---------------------------------------------------------------------------------
      BtlvPos GetSelectedTargetPos( void ) const;




      protected:
      const Setting& GetSetting( void ) const { return m_settings; }
      UserPos GetUserPos( void ) const { return m_settings.user_pos; }
      WazaRange GetWazaRange( void ) const { return m_settings.waza_range; }
      bool IsPlayerBallsDisplay( void ) const { return m_settings.player_balls_display; }
      bool IsEnemyBallsDisplay( void ) const { return m_settings.enemy_balls_display; }

      void SetResult( Result result ) { m_result = result; }
      void SetSelectedPos( BtlvPos pos ) { m_selected_pos = pos; } 


      private:
      Setting m_settings;
      Result m_result;
      BtlvPos m_selected_pos;
    };


  }  // namespace app
}  // namespace btl


#endif  // __TARGETSELECTBASE_H__
