//=======================================================================================
/**
 * @file TargetSelectBase.cpp
 * @brief ΏۑIʂ̊{NX
 * @author obata_toshihiro
 * @date 2011.08.08
 */
//=======================================================================================
#include <gflib.h>
#include <battle/btl_common.h>
#include <battle/btl_party.h>
#include <battle/btl_pokeparam.h>
#include <battle/btlv/btlv_core.h>
#include "AppBase.h"
#include "TargetSelectBase.h"


namespace btl {
  namespace app {


    //---------------------------------------------------------------------------------
    // RXgN^
    //---------------------------------------------------------------------------------
    TargetSelectBase::TargetSelectBase( 
        gfl::heap::HeapBase* app_heap, u32 app_heap_size,
        gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
        BattleViewSystem* btlv_system, const Setting& settings ) :
      AppBase( app_heap, app_heap_size, device_heap, device_heap_size, btlv_system ),
      m_settings( settings ),
      m_result( RESULT_NULL ),
      m_selected_pos( BTL_VPOS_ERROR )
    {
    }


    //---------------------------------------------------------------------------------
    // fXgN^
    //---------------------------------------------------------------------------------
    TargetSelectBase::~TargetSelectBase()
    {
    }



    //---------------------------------------------------------------------------------
    // ʂ擾
    //---------------------------------------------------------------------------------
    TargetSelectBase::Result TargetSelectBase::GetResult( void ) const
    {
      return m_result;
    }


    //---------------------------------------------------------------------------------
    // IΏۂ̗ʒu擾
    //---------------------------------------------------------------------------------
    BtlvPos TargetSelectBase::GetSelectedTargetPos( void ) const
    {
      return m_selected_pos;
    }



  }  // namespace app
}  // namespace btl
