//=======================================================================================
/**
 * @file TargetSelect2vs2.cpp
 * @brief ΏۑI( 2vs2 )
 * @author obata_toshihiro
 * @date 2011.08.08
 */
//=======================================================================================
#include <gflib.h>
#include <battle/btl_common.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include "AppDrawUtil.h"
#include "TargetSelectBase.h"
#include "TargetSelect2vs2.h"

#include <arc/arc_def.h>
#include <arc/btl_app.gaix>
#include <message/msg_btl_app.h>
#include "target_select_2vs2.h"
#include "target_select_2vs2_pane.h"


namespace btl {
  namespace app {


    // q[vTCY
    const u32 TargetSelect2vs2::APP_HEAPSIZE = 0x1800;
    const u32 TargetSelect2vs2::DEVICE_HEAPSIZE = 0x200000;



    // CAEg[ÑZbgAbvf[^
    const gfl::grp::g2d::LytWkSetUp TargetSelect2vs2::LAYOUT_WORK_SETUP_DATA = 
    {
      gfl::math::VEC3( 0, LAYOUT_DOWN_OFS, 0 ),  // pos
      gfl::math::VEC2( 1, 1 ),                   // scale
      gfl::math::VEC3( 0, 0, 0 ),                // rotate
      1,                                         // priority
    };



    // Aj[Vf[^̃e[u
    const gfl::grp::g2d::LytArcIndex TargetSelect2vs2::ANIMATION_DATA_TABLE[ TargetSelect2vs2::ANIMATION_DATA_NUM ] = 
    {
      /* ANIMATION_DATA_DUMMY_BALL_NORMAL */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_DUMMY_BALL_NORMAL_BCLAN,
      /* ANIMATION_DATA_DUMMY_BALL_SICK */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_DUMMY_BALL_SICK_BCLAN,
      /* ANIMATION_DATA_DUMMY_BALL_DEAD */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_DUMMY_BALL_DEAD_BCLAN,
      /* ANIMATION_DATA_DUMMY_BALL_NULL */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_DUMMY_BALL_NULL_BCLAN,
      /* ANIMATION_DATA_ENEMY_L_ALIVE */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_ENEMY_L_ALIVE_BCLAN,
      /* ANIMATION_DATA_ENEMY_L_DEAD */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_ENEMY_L_DEAD_BCLAN,
      /* ANIMATION_DATA_ENEMY_R_ALIVE */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_ENEMY_R_ALIVE_BCLAN,
      /* ANIMATION_DATA_ENEMY_R_DEAD */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_ENEMY_R_DEAD_BCLAN,
      /* ANIMATION_DATA_PLAYER_L_ALIVE */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_PLAYER_L_ALIVE_BCLAN,
      /* ANIMATION_DATA_PLAYER_L_DEAD */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_PLAYER_L_DEAD_BCLAN,
      /* ANIMATION_DATA_PLAYER_R_ALIVE */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_PLAYER_R_ALIVE_BCLAN,
      /* ANIMATION_DATA_PLAYER_R_DEAD */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_PLAYER_R_DEAD_BCLAN,
      /* ANIMATION_DATA_CURSOR_FLUCTUATE */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_FLUCTUATE_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_L_LT */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_OTHER_SELECT_INL_LT_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_L_RT */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_OTHER_SELECT_INL_RT_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_L_RB */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_OTHER_SELECT_INL_RB_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_L_RET */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_OTHER_SELECT_INL_RET_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_R_LT */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_OTHER_SELECT_INR_LT_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_R_RT */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_OTHER_SELECT_INR_RT_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_R_LB */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_OTHER_SELECT_INR_LB_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_SELECT_IN_R_RET */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_OTHER_SELECT_INR_RET_BCLAN,
      /* ANIMATION_DATA_CURSOR_ENEMY_ALL */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_ENEMY_ALL_BCLAN,
      /* ANIMATION_DATA_CURSOR_ENEMY_ALL_RET */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_ENEMY_ALL_RET_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_ALL_IN_L */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_OTHER_ALL_INL_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_ALL_IN_L_RET */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_OTHER_ALL_INL_RET_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_ALL_IN_R */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_OTHER_ALL_INR_BCLAN,
      /* ANIMATION_DATA_CURSOR_OTHER_ALL_IN_R_RET */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_OTHER_ALL_INR_RET_BCLAN,
      /* ANIMATION_DATA_CURSOR_ALL */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_ALL_BCLAN,
      /* ANIMATION_DATA_CURSOR_ALL_RET */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_ALL_RET_BCLAN,
      /* ANIMATION_DATA_CURSOR_USER_IN_L */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_USER_INL_BCLAN,
      /* ANIMATION_DATA_CURSOR_USER_IN_L_RET */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_USER_INL_RET_BCLAN,
      /* ANIMATION_DATA_CURSOR_USER_IN_R */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_USER_INR_BCLAN,
      /* ANIMATION_DATA_CURSOR_USER_IN_R_RET */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_USER_INR_RET_BCLAN,
      /* ANIMATION_DATA_CURSOR_FRIEND_ALL */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_FRIEND_ALL_BCLAN,
      /* ANIMATION_DATA_CURSOR_FRIEND_ALL_RET */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_FRIEND_ALL_RET_BCLAN,
      /* ANIMATION_DATA_CURSOR_FRIEND_SELECT_IN_L */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_FRIEND_SELECT_INL_BCLAN,
      /* ANIMATION_DATA_CURSOR_FRIEND_SELECT_IN_L_RET */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_FRIEND_SELECT_INL_RET_BCLAN,
      /* ANIMATION_DATA_CURSOR_FRIEND_SELECT_IN_R */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_FRIEND_SELECT_INR_BCLAN,
      /* ANIMATION_DATA_CURSOR_FRIEND_SELECT_IN_R_RET */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_FRIEND_SELECT_INR_RET_BCLAN,
      /* ANIMATION_DATA_CURSOR_FRIEND_USER_SELECT_L */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_FRIEND_USER_SELECT_L_BCLAN,
      /* ANIMATION_DATA_CURSOR_FRIEND_USER_SELECT_R */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_FRIEND_USER_SELECT_R_BCLAN,
      /* ANIMATION_DATA_CURSOR_FRIEND_USER_SELECT_RET */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_FRIEND_USER_SELECT_RET_BCLAN,
      /* ANIMATION_DATA_CURSOR_ENEMY_SELECT_L */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_ENEMY_SELECT_L_BCLAN,
      /* ANIMATION_DATA_CURSOR_ENEMY_SELECT_R */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_ENEMY_SELECT_R_BCLAN,
      /* ANIMATION_DATA_CURSOR_ENEMY_SELECT_RET */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_CURSOR_ENEMY_SELECT_RET_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ONE_HOLD_LT */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ONE_HOLD_LT_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ONE_RELEASE_LT */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ONE_RELEASE_LT_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ONE_SELECT_LT */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ONE_SELECT_LT_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ONE_HOLD_RT */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ONE_HOLD_RT_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ONE_RELEASE_RT */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ONE_RELEASE_RT_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ONE_SELECT_RT */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ONE_SELECT_RT_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ONE_HOLD_LB */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ONE_HOLD_LB_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ONE_RELEASE_LB */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ONE_RELEASE_LB_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ONE_SELECT_LB */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ONE_SELECT_LB_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ONE_HOLD_RB */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ONE_HOLD_RB_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ONE_RELEASE_RB */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ONE_RELEASE_RB_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ONE_SELECT_RB */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ONE_SELECT_RB_BCLAN,
      /* ANIMATION_DATA_BUTTON_RETURN_HOLD */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_RETURN_HOLD_BCLAN,
      /* ANIMATION_DATA_BUTTON_RETURN_RELEASE */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_RETURN_RELEASE_BCLAN,
      /* ANIMATION_DATA_BUTTON_RETURN_SELECT */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_RETURN_SELECT_BCLAN,
      /* ANIMATION_DATA_BUTTON_ENEMY_ALL_HOLD */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_ENEMY_ALL_HOLD_BCLAN,
      /* ANIMATION_DATA_BUTTON_ENEMY_ALL_RELEASE */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_ENEMY_ALL_RELEASE_BCLAN,
      /* ANIMATION_DATA_BUTTON_ENEMY_ALL_SELECT */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_ENEMY_ALL_SELECT_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ALL_HOLD_IN_L */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ALL_HOLD_INL_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ALL_RELEASE_IN_L */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ALL_RELEASE_INL_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ALL_SELECT_IN_L */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ALL_SELECT_INL_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ALL_HOLD_IN_R */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ALL_HOLD_INR_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ALL_RELEASE_IN_R */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ALL_RELEASE_INR_BCLAN,
      /* ANIMATION_DATA_BUTTON_OTHER_ALL_SELECT_IN_R */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_OTHER_ALL_SELECT_INR_BCLAN,
      /* ANIMATION_DATA_BUTTON_ALL_HOLD */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_ALL_HOLD_BCLAN,
      /* ANIMATION_DATA_BUTTON_ALL_RELEASE */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_ALL_RELEASE_BCLAN,
      /* ANIMATION_DATA_BUTTON_ALL_SELECT */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_ALL_SELECT_BCLAN,
      /* ANIMATION_DATA_BUTTON_FRIEND_ALL_HOLD */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_FRIEND_ALL_HOLD_BCLAN,
      /* ANIMATION_DATA_BUTTON_FRIEND_ALL_RELEASE */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_FRIEND_ALL_RELEASE_BCLAN,
      /* ANIMATION_DATA_BUTTON_FRIEND_ALL_SELECT */ LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BUTTON_FRIEND_ALL_SELECT_BCLAN,
    };



    // LAj[VƂ̐ݒ
    const TargetSelect2vs2::ShareAnimationDesc TargetSelect2vs2::SHARE_ANIMATION_DESC[ TargetSelect2vs2::SHARE_ANIMATION_NUM ] = 
    {
      /* SHARE_ANIMATION_MYBALL_NORMAL */
      {
        ANIMATION_MYBALL00_NORMAL, 
        ANIMATION_DATA_DUMMY_BALL_NORMAL,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_TARGET_SELECT_2VS2_GROUP_MY_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_MYBALL_SICK */
      {
        ANIMATION_MYBALL00_SICK, 
        ANIMATION_DATA_DUMMY_BALL_SICK,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_TARGET_SELECT_2VS2_GROUP_MY_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_MYBALL_DEAD */
      {
        ANIMATION_MYBALL00_DEAD, 
        ANIMATION_DATA_DUMMY_BALL_DEAD,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_TARGET_SELECT_2VS2_GROUP_MY_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_MYBALL_NULL */
      {
        ANIMATION_MYBALL00_NULL, 
        ANIMATION_DATA_DUMMY_BALL_NULL,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_TARGET_SELECT_2VS2_GROUP_MY_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_ENBALL_NORMAL */
      {
        ANIMATION_ENBALL00_NORMAL, 
        ANIMATION_DATA_DUMMY_BALL_NORMAL,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_TARGET_SELECT_2VS2_GROUP_EN_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_ENBALL_SICK */
      {
        ANIMATION_ENBALL00_SICK, 
        ANIMATION_DATA_DUMMY_BALL_SICK,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_TARGET_SELECT_2VS2_GROUP_EN_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_ENBALL_DEAD */
      {
        ANIMATION_ENBALL00_DEAD, 
        ANIMATION_DATA_DUMMY_BALL_DEAD,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_TARGET_SELECT_2VS2_GROUP_EN_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_ENBALL_NULL */
      {
        ANIMATION_ENBALL00_NULL, 
        ANIMATION_DATA_DUMMY_BALL_NULL,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_TARGET_SELECT_2VS2_GROUP_EN_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
    };






    // ̃{[Ƃ̐ݒ
    const TargetSelect2vs2::BallDesc TargetSelect2vs2::MY_BALL_DESC[ pml::PokeParty::MAX_MEMBERS ] = 
    {
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 0 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 0 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 0 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 0 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 1 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 1 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 1 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 1 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 2 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 2 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 2 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 2 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 3 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 3 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 3 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 3 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 4 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 4 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 4 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 4 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 5 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 5 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 5 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 5 ),
      },
    };




    // 葤̃{[Ƃ̐ݒ
    const TargetSelect2vs2::BallDesc TargetSelect2vs2::ENEMY_BALL_DESC[ pml::PokeParty::MAX_MEMBERS ] = 
    {
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 0 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 0 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 0 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 0 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 1 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 1 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 1 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 1 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 2 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 2 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 2 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 2 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 3 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 3 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 3 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 3 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 4 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 4 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 4 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 4 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 5 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 5 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 5 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 5 ),
      },
    };




    // Ώۃ{^Ƃ̐ݒ
    const TargetSelect2vs2::TargetButtonDesc TargetSelect2vs2::TARGET_BUTTON_DESC[ TargetSelect2vs2::TARGET_BUTTON_NUM ] = 
    {
      // TARGET_BUTTON_LT,
      {
        BTL_VPOS_FAR_1,
        ANIMATION_ENEMY_L_ALIVE,
        ANIMATION_ENEMY_L_DEAD,
        PANENAME_TARGET_SELECT_2VS2_PANE_EN_L_NAME,
        PANENAME_TARGET_SELECT_2VS2_PANE_EN_L_POKEICON,
        PANENAME_TARGET_SELECT_2VS2_PANE_EN_L_SEX,
      },
      // TARGET_BUTTON_RT,
      {
        BTL_VPOS_FAR_2,
        ANIMATION_ENEMY_R_ALIVE,
        ANIMATION_ENEMY_R_DEAD,
        PANENAME_TARGET_SELECT_2VS2_PANE_EN_R_NAME,
        PANENAME_TARGET_SELECT_2VS2_PANE_EN_R_POKEICON,
        PANENAME_TARGET_SELECT_2VS2_PANE_EN_R_SEX,
      },
      // TARGET_BUTTON_LB,
      {
        BTL_VPOS_NEAR_1,
        ANIMATION_PLAYER_L_ALIVE,
        ANIMATION_PLAYER_L_DEAD,
        PANENAME_TARGET_SELECT_2VS2_PANE_PL_L_NAME,
        PANENAME_TARGET_SELECT_2VS2_PANE_PL_L_POKEICON,
        PANENAME_TARGET_SELECT_2VS2_PANE_PL_L_SEX,
      },
      // TARGET_BUTTON_RB,
      {
        BTL_VPOS_NEAR_2,
        ANIMATION_PLAYER_R_ALIVE,
        ANIMATION_PLAYER_R_DEAD,
        PANENAME_TARGET_SELECT_2VS2_PANE_PL_R_NAME,
        PANENAME_TARGET_SELECT_2VS2_PANE_PL_R_POKEICON,
        PANENAME_TARGET_SELECT_2VS2_PANE_PL_R_SEX,
      },
    };






    // {^ƂĈyC
    const gfl::grp::g2d::LytPaneIndex TargetSelect2vs2::BUTTON_PANE[ TargetSelect2vs2::BUTTON_NUM ] = 
    {
      /* BUTTON_TARGET_LT */ PANENAME_TARGET_SELECT_2VS2_PANE_ENEMY_L,
      /* BUTTON_TARGET_RT */ PANENAME_TARGET_SELECT_2VS2_PANE_ENEMY_R,
      /* BUTTON_TARGET_LB */ PANENAME_TARGET_SELECT_2VS2_PANE_PLAYER_L,
      /* BUTTON_TARGET_RB */ PANENAME_TARGET_SELECT_2VS2_PANE_PLAYER_R,
      /* BUTTON_PADDING_U */ PANENAME_TARGET_SELECT_2VS2_PANE_PADDING_U,
      /* BUTTON_PADDING_D */ PANENAME_TARGET_SELECT_2VS2_PANE_PADDING_D,
      /* BUTTON_PADDING_L */ PANENAME_TARGET_SELECT_2VS2_PANE_PADDING_L,
      /* BUTTON_PADDING_R */ PANENAME_TARGET_SELECT_2VS2_PANE_PADDING_R,
      /* BUTTON_RETURN */ PANENAME_TARGET_SELECT_2VS2_PANE_RETURN_BUTTON,
    };






    // Ns\ȃJ[\ʒu̐ݒ
    const TargetSelect2vs2::CursorPosDesc TargetSelect2vs2::INVALID_CURSOR_POS_DESC = 
    {
      /* J[\ړ\ǂ */ false,
      /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
      /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
      /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_NULL,
      /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_NULL,
      /* Iۂ̃Aj[V */ ANIMATION_NULL,
      /* J[\ZbgAj[V */ ANIMATION_NULL,
    };



    // Žʔ͈͂Ƃ̐ݒ
    const TargetSelect2vs2::WazaRangeDesc TargetSelect2vs2::WAZA_RANGE_DESC[ TargetSelect2vs2::USER_POS_NUM_2VS2 ][ TargetSelect2vs2::WAZA_RANGE_NUM ] = 
    {
      //==================================================================================
      // USER_POS_LEFT
      //==================================================================================
      {
        //------------------------
        // WAZA_RANGE_OTHER_ONE
        //------------------------
        {
          /* J[\ʒu */ CURSOR_POS_LT,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_LT,
            /* BUTTON_TARGET_RT */ CURSOR_POS_RT,
            /* BUTTON_TARGET_LB */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_RB */ CURSOR_POS_RB,
            /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_1,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LT,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_L_LT,
            },
            /* CURSOR_POS_RT */
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_2,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_RT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_RT,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_RT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_L_RT,
            },
            /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RB */
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_2,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_RB,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_RB,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_RB,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_L_RB,
            },
            /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RETURN */
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_L_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                 down               left               right  */
            { CURSOR_POS_LT,         { CURSOR_POS_LT,     CURSOR_POS_RETURN, CURSOR_POS_LT,     CURSOR_POS_RT } },
            { CURSOR_POS_RT,         { CURSOR_POS_RT,     CURSOR_POS_RB,     CURSOR_POS_LT,     CURSOR_POS_RT } },
            { CURSOR_POS_LB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RB,         { CURSOR_POS_RT,     CURSOR_POS_RETURN, CURSOR_POS_RB,     CURSOR_POS_RB } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          },
        },

        //------------------------
        // WAZA_RANGE_OTHER_ALL
        //------------------------
        {
          /* J[\ʒu */ CURSOR_POS_OTHER_ALL,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_OTHER_ALL,
            /* BUTTON_TARGET_RT */ CURSOR_POS_OTHER_ALL,
            /* BUTTON_TARGET_LB */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_RB */ CURSOR_POS_OTHER_ALL,
            /* BUTTON_PADDING_U */ CURSOR_POS_OTHER_ALL,
            /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_R */ CURSOR_POS_OTHER_ALL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_OTHER_ALL */
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ALL_HOLD_IN_L,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ALL_RELEASE_IN_L,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ALL_SELECT_IN_L,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_ALL_IN_L,
            },
            /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
            // CURSOR_POS_RETURN
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_ALL_IN_L_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                    down               left                  right  */
            { CURSOR_POS_LT,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_RT,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_LB,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_RB,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_OTHER_ALL, CURSOR_POS_RETURN, CURSOR_POS_OTHER_ALL, CURSOR_POS_OTHER_ALL } },
            { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_OTHER_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          },
        },

        //------------------------
        // WAZA_RANGE_ENEMY_ONE
        //------------------------
        {
          /* J[\ʒu */ CURSOR_POS_LT,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_LT,
            /* BUTTON_TARGET_RT */ CURSOR_POS_RT,
            /* BUTTON_TARGET_LB */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_RB */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_1,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LT,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_SELECT_L,
            }, 
            /* CURSOR_POS_RT */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_2,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_RT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_RT,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_RT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_SELECT_R,
            }, 
            /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
            // CURSOR_POS_RETURN
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_SELECT_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                 down               left               right  */
            { CURSOR_POS_LT,         { CURSOR_POS_LT,     CURSOR_POS_RETURN, CURSOR_POS_LT,     CURSOR_POS_RT } },
            { CURSOR_POS_RT,         { CURSOR_POS_RT,     CURSOR_POS_RETURN, CURSOR_POS_LT,     CURSOR_POS_RT } },
            { CURSOR_POS_LB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_RT,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          },
        },

        //------------------------
        // WAZA_RANGE_ENEMY_ALL
        //------------------------
        {
          /* J[\ʒu */ CURSOR_POS_ENEMY_ALL,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_ENEMY_ALL,
            /* BUTTON_TARGET_RT */ CURSOR_POS_ENEMY_ALL,
            /* BUTTON_TARGET_LB */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_RB */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_U */ CURSOR_POS_ENEMY_ALL,
            /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ENEMY_ALL */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ENEMY_ALL_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ENEMY_ALL_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_ENEMY_ALL_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ALL,
            }, 
            /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
            // CURSOR_POS_RETURN
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ALL_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                    down               left                  right  */
            { CURSOR_POS_LT,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_RT,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_LB,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_RB,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_ENEMY_ALL, CURSOR_POS_ENEMY_ALL } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          },
        },

        //------------------------
        // WAZA_RANGE_FRIEND_ONE
        //------------------------
        {
          /* J[\ʒu */ CURSOR_POS_LB,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_RT */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_LB */ CURSOR_POS_LB,
            /* BUTTON_TARGET_RB */ CURSOR_POS_RB,
            /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_LB */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LB,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LB,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LB,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_USER_SELECT_L,
            }, 
            /* CURSOR_POS_RB */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_2,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_RB,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_RB,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_RB,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_USER_SELECT_R,
            }, 
            /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
            // CURSOR_POS_RETURN
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_USER_SELECT_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                 down               left               right  */
            { CURSOR_POS_LT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_LB,         { CURSOR_POS_LB,     CURSOR_POS_RETURN, CURSOR_POS_LB,     CURSOR_POS_RB } },
            { CURSOR_POS_RB,         { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_LB,     CURSOR_POS_RB } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          },
        },

        //-----------------------------
        // WAZA_RANGE_FRIEND_OTHER_ONE
        //-----------------------------
        {
          /* J[\ʒu */ CURSOR_POS_RB,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_RT */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_LB */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_RB */ CURSOR_POS_RB,
            /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RB */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_2,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_RB,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_RB,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_RB,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_SELECT_IN_L,
            }, 
            /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
            // CURSOR_POS_RETURN
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_SELECT_IN_L_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                 down               left               right  */
            { CURSOR_POS_LT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_LB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RB,         { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_RB,     CURSOR_POS_RB } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          },
        },

        //------------------------
        // WAZA_RANGE_FRIEND_ALL
        //------------------------
        {
          /* J[\ʒu */ CURSOR_POS_FRIEND_ALL,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_RT */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_LB */ CURSOR_POS_FRIEND_ALL,
            /* BUTTON_TARGET_RB */ CURSOR_POS_FRIEND_ALL,
            /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_D */ CURSOR_POS_FRIEND_ALL,
            /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_FRIEND_ALL */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_FRIEND_ALL_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_FRIEND_ALL_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_FRIEND_ALL_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_ALL,
            }, 
            /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
            // CURSOR_POS_RETURN
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_ALL_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                     down               left                   right  */
            { CURSOR_POS_LT,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
            { CURSOR_POS_RT,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
            { CURSOR_POS_LB,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
            { CURSOR_POS_RB,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_FRIEND_ALL, CURSOR_POS_RETURN, CURSOR_POS_FRIEND_ALL, CURSOR_POS_FRIEND_ALL } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
            { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_FRIEND_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
          },
        },

        //------------------------
        // WAZA_RANGE_ALL
        //------------------------
        {
          /* J[\ʒu */ CURSOR_POS_ALL,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_ALL,
            /* BUTTON_TARGET_RT */ CURSOR_POS_ALL,
            /* BUTTON_TARGET_LB */ CURSOR_POS_ALL,
            /* BUTTON_TARGET_RB */ CURSOR_POS_ALL,
            /* BUTTON_PADDING_U */ CURSOR_POS_ALL,
            /* BUTTON_PADDING_D */ CURSOR_POS_ALL,
            /* BUTTON_PADDING_L */ CURSOR_POS_ALL,
            /* BUTTON_PADDING_R */ CURSOR_POS_ALL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ALL */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ALL_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ALL_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_ALL_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_ALL,
            }, 
            // CURSOR_POS_RETURN
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_ALL_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                 down               left               right  */
            { CURSOR_POS_LT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_LB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ALL,        { CURSOR_POS_ALL,    CURSOR_POS_RETURN, CURSOR_POS_ALL,    CURSOR_POS_ALL } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_ALL,    CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          },
        },

        //------------------------
        // WAZA_RANGE_USER
        //------------------------
        {
          /* J[\ʒu */ CURSOR_POS_LB,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_RT */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_LB */ CURSOR_POS_LB,
            /* BUTTON_TARGET_RB */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_LB */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LB,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LB,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LB,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_USER_IN_L,
            }, 
            /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
            // CURSOR_POS_RETURN
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_USER_IN_L_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                 down               left               right  */
            { CURSOR_POS_LT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_LB,         { CURSOR_POS_LB,     CURSOR_POS_RETURN, CURSOR_POS_LB,     CURSOR_POS_LB } },
            { CURSOR_POS_RB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_LB,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          },
        }, 
      },

      //==================================================================================
      // USER_POS_RIGHT
      //==================================================================================
      {
        //------------------------
        // WAZA_RANGE_OTHER_ONE
        //------------------------
        {
          /* J[\ʒu */ CURSOR_POS_LT,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_LT,
            /* BUTTON_TARGET_RT */ CURSOR_POS_RT,
            /* BUTTON_TARGET_LB */ CURSOR_POS_LB,
            /* BUTTON_TARGET_RB */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_1,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LT,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_R_LT,
            },
            /* CURSOR_POS_RT */
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_2,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_RT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_RT,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_RT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_R_RT,
            },
            /* CURSOR_POS_LB */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LB,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LB,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LB,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_R_LB,
            },
            /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RETURN */
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_SELECT_IN_R_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                 down               left               right  */
            { CURSOR_POS_LT,         { CURSOR_POS_LT,     CURSOR_POS_LB,     CURSOR_POS_LT,     CURSOR_POS_RT } },
            { CURSOR_POS_RT,         { CURSOR_POS_RT,     CURSOR_POS_RETURN, CURSOR_POS_LT,     CURSOR_POS_RT } },
            { CURSOR_POS_LB,         { CURSOR_POS_LT,     CURSOR_POS_RETURN, CURSOR_POS_LB,     CURSOR_POS_LB } },
            { CURSOR_POS_RB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_RT,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          },
        },

        //------------------------
        // WAZA_RANGE_OTHER_ALL
        //------------------------
        {
          /* J[\ʒu */ CURSOR_POS_OTHER_ALL,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_OTHER_ALL,
            /* BUTTON_TARGET_RT */ CURSOR_POS_OTHER_ALL,
            /* BUTTON_TARGET_LB */ CURSOR_POS_OTHER_ALL,
            /* BUTTON_TARGET_RB */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_U */ CURSOR_POS_OTHER_ALL,
            /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_L */ CURSOR_POS_OTHER_ALL,
            /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_OTHER_ALL */
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ALL_HOLD_IN_R,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ALL_RELEASE_IN_R,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ALL_SELECT_IN_R,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_ALL_IN_R,
            },
            /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
            // CURSOR_POS_RETURN
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_OTHER_ALL_IN_R_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                    down               left                  right  */
            { CURSOR_POS_LT,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_RT,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_LB,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_RB,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_OTHER_ALL, CURSOR_POS_RETURN, CURSOR_POS_OTHER_ALL, CURSOR_POS_OTHER_ALL } },
            { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_OTHER_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          },
        },

        //------------------------
        // WAZA_RANGE_ENEMY_ONE
        //------------------------
        {
          /* J[\ʒu */ CURSOR_POS_LT,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_LT,
            /* BUTTON_TARGET_RT */ CURSOR_POS_RT,
            /* BUTTON_TARGET_LB */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_RB */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_1,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LT,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_SELECT_L,
            }, 
            /* CURSOR_POS_RT */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_FAR_2,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_RT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_RT,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_RT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_SELECT_R,
            }, 
            /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
            // CURSOR_POS_RETURN
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_SELECT_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                 down               left               right  */
            { CURSOR_POS_LT,         { CURSOR_POS_LT,     CURSOR_POS_RETURN, CURSOR_POS_LT,     CURSOR_POS_RT } },
            { CURSOR_POS_RT,         { CURSOR_POS_RT,     CURSOR_POS_RETURN, CURSOR_POS_LT,     CURSOR_POS_RT } },
            { CURSOR_POS_LB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_RT,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          },
        },

        //------------------------
        // WAZA_RANGE_ENEMY_ALL
        //------------------------
        {
          /* J[\ʒu */ CURSOR_POS_ENEMY_ALL,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_ENEMY_ALL,
            /* BUTTON_TARGET_RT */ CURSOR_POS_ENEMY_ALL,
            /* BUTTON_TARGET_LB */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_RB */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_U */ CURSOR_POS_ENEMY_ALL,
            /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ENEMY_ALL */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ENEMY_ALL_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ENEMY_ALL_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_ENEMY_ALL_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ALL,
            }, 
            /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
            // CURSOR_POS_RETURN
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_ENEMY_ALL_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                    down               left                  right  */
            { CURSOR_POS_LT,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_RT,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_LB,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_RB,         { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_ENEMY_ALL, CURSOR_POS_ENEMY_ALL } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,    CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_ENEMY_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,    CURSOR_POS_RETURN } },
          },
        },

        //------------------------
        // WAZA_RANGE_FRIEND_ONE
        //------------------------
        {
          /* J[\ʒu */ CURSOR_POS_LB,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_RT */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_LB */ CURSOR_POS_LB,
            /* BUTTON_TARGET_RB */ CURSOR_POS_RB,
            /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_LB */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LB,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LB,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LB,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_USER_SELECT_L,
            }, 
            /* CURSOR_POS_RB */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_2,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_RB,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_RB,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_RB,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_USER_SELECT_R,
            }, 
            /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
            // CURSOR_POS_RETURN
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_USER_SELECT_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                 down               left               right  */
            { CURSOR_POS_LT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_LB,         { CURSOR_POS_LB,     CURSOR_POS_RETURN, CURSOR_POS_LB,     CURSOR_POS_RB } },
            { CURSOR_POS_RB,         { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_LB,     CURSOR_POS_RB } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          },
        },

        //-----------------------------
        // WAZA_RANGE_FRIEND_OTHER_ONE
        //-----------------------------
        {
          /* J[\ʒu */ CURSOR_POS_LB,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_RT */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_LB */ CURSOR_POS_LB,
            /* BUTTON_TARGET_RB */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_LB */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LB,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LB,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LB,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_SELECT_IN_R,
            }, 
            /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
            // CURSOR_POS_RETURN
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_SELECT_IN_R_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                 down               left               right  */
            { CURSOR_POS_LT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_LB,         { CURSOR_POS_LB,     CURSOR_POS_RETURN, CURSOR_POS_LB,     CURSOR_POS_LB } },
            { CURSOR_POS_RB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_LB,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          },
        },

        //------------------------
        // WAZA_RANGE_FRIEND_ALL
        //------------------------
        {
          /* J[\ʒu */ CURSOR_POS_FRIEND_ALL,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_RT */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_LB */ CURSOR_POS_FRIEND_ALL,
            /* BUTTON_TARGET_RB */ CURSOR_POS_FRIEND_ALL,
            /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_D */ CURSOR_POS_FRIEND_ALL,
            /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_FRIEND_ALL */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_FRIEND_ALL_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_FRIEND_ALL_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_FRIEND_ALL_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_ALL,
            }, 
            /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
            // CURSOR_POS_RETURN
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_FRIEND_ALL_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                     down               left                   right  */
            { CURSOR_POS_LT,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
            { CURSOR_POS_RT,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
            { CURSOR_POS_LB,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
            { CURSOR_POS_RB,         { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_FRIEND_ALL, CURSOR_POS_RETURN, CURSOR_POS_FRIEND_ALL, CURSOR_POS_FRIEND_ALL } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
            { CURSOR_POS_ALL,        { CURSOR_POS_RETURN,     CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_FRIEND_ALL, CURSOR_POS_RETURN, CURSOR_POS_RETURN,     CURSOR_POS_RETURN } },
          },
        },

        //------------------------
        // WAZA_RANGE_ALL
        //------------------------
        {
          /* J[\ʒu */ CURSOR_POS_ALL,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_ALL,
            /* BUTTON_TARGET_RT */ CURSOR_POS_ALL,
            /* BUTTON_TARGET_LB */ CURSOR_POS_ALL,
            /* BUTTON_TARGET_RB */ CURSOR_POS_ALL,
            /* BUTTON_PADDING_U */ CURSOR_POS_ALL,
            /* BUTTON_PADDING_D */ CURSOR_POS_ALL,
            /* BUTTON_PADDING_L */ CURSOR_POS_ALL,
            /* BUTTON_PADDING_R */ CURSOR_POS_ALL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ALL */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ALL_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_ALL_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_ALL_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_ALL,
            }, 
            // CURSOR_POS_RETURN
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_ALL_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                 down               left               right  */
            { CURSOR_POS_LT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_LB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ALL,        { CURSOR_POS_ALL,    CURSOR_POS_RETURN, CURSOR_POS_ALL,    CURSOR_POS_ALL } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_ALL,    CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          },
        },

        //------------------------
        // WAZA_RANGE_USER
        //------------------------
        {
          /* J[\ʒu */ CURSOR_POS_RB,
          /* e{^Ɋ蓖ĂJ[\ʒu */
          {
            /* BUTTON_TARGET_LT */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_RT */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_LB */ CURSOR_POS_NULL,
            /* BUTTON_TARGET_RB */ CURSOR_POS_RB,
            /* BUTTON_PADDING_U */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_D */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_L */ CURSOR_POS_NULL,
            /* BUTTON_PADDING_R */ CURSOR_POS_NULL,
            /* BUTTON_RETURN */ CURSOR_POS_RETURN,
          },
          /* J[\ʒuƂ̐ݒ */
          {
            /* CURSOR_POS_LT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RT */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_LB */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_RB */ 
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_NEAR_1,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_SELECT,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_HOLD_LB,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_RELEASE_LB,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_OTHER_ONE_SELECT_LB,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_USER_IN_R,
            }, 
            /* CURSOR_POS_FRIEND_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ENEMY_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_OTHER_ALL */ INVALID_CURSOR_POS_DESC,
            /* CURSOR_POS_ALL */ INVALID_CURSOR_POS_DESC,
            // CURSOR_POS_RETURN
            {
              /* J[\ړ\ǂ */ true,
              /* Iۂ̃^[Qbgʒu */ btl::BTL_VPOS_ERROR,
              /* Iꂽۂ̓쌋 */ TargetSelectBase::RESULT_RETURN,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_HOLD,
              /* Ή{^ꂽۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_RELEASE,
              /* Iۂ̃Aj[V */ ANIMATION_BUTTON_RETURN_SELECT,
              /* J[\ZbgAj[V */ ANIMATION_CURSOR_USER_IN_R_RET,
            }, 
          },
          /* J[\ړf[^ */
          {
            /*   id                    up                 down               left               right  */
            { CURSOR_POS_LT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RT,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_LB,         { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RB,         { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_RB,     CURSOR_POS_RB } },
            { CURSOR_POS_FRIEND_ALL, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ENEMY_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_OTHER_ALL,  { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_ALL,        { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
            { CURSOR_POS_RETURN,     { CURSOR_POS_RB,     CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          },
        }, 
      },
    };








    // ÓIf[^ւ̃ANZbT\bh

    TargetSelect2vs2::CursorPos TargetSelect2vs2::GetInitialCursorPos( void ) const
    {
      const WazaRangeDesc& waza_range_desc = this->GetWazaRangeDesc();
      return waza_range_desc.cursor_init_pos;
    }


    TargetSelect2vs2::CursorPos 
      TargetSelect2vs2::GetCursorPos( TargetSelect2vs2::ButtonIndex button_index ) const
    {
      const WazaRangeDesc& waza_range_desc = this->GetWazaRangeDesc();
      return waza_range_desc.cursor_pos_of_button[ button_index ];
    }


    const TargetSelect2vs2::CursorPosDesc& 
      TargetSelect2vs2::GetCursorPosDesc( TargetSelect2vs2::ButtonIndex button_index ) const
    {
      CursorPos cursor_pos = this->GetCursorPos( button_index );
      return this->GetCursorPosDesc( cursor_pos );
    }


    const TargetSelect2vs2::CursorPosDesc& 
      TargetSelect2vs2::GetCursorPosDesc( TargetSelect2vs2::CursorPos cursor_pos ) const
    {
      const WazaRangeDesc& waza_range_desc = this->GetWazaRangeDesc();
      return waza_range_desc.cursor_pos_desc[ cursor_pos ];
    } 


    const ::app::tool::CursorManager::MOVE_DATA* TargetSelect2vs2::GetCursorMoveData( void ) const
    {
      const WazaRangeDesc& waza_range_desc = this->GetWazaRangeDesc();
      return waza_range_desc.cursor_move_data;
    }


    const TargetSelect2vs2::WazaRangeDesc& TargetSelect2vs2::GetWazaRangeDesc( void ) const
    {
      TargetSelectBase::UserPos user_pos = this->GetUserPos();
      TargetSelectBase::WazaRange waza_range = this->GetWazaRange();
      return WAZA_RANGE_DESC[ user_pos ][ waza_range ]; 
    }










    //---------------------------------------------------------------------------------
    // RXgN^
    //---------------------------------------------------------------------------------
    TargetSelect2vs2::TargetSelect2vs2( 
        gfl::heap::HeapBase* app_heap, gfl::heap::HeapBase* device_heap, 
        BattleViewSystem* btlv_system, const TargetSelectBase::Setting& base_settings ) : 
      TargetSelectBase( 
          app_heap, APP_HEAPSIZE, device_heap, DEVICE_HEAPSIZE, btlv_system, base_settings ),
      AppDrawUtil(),
      m_init_flag( false ),
      m_seq( SEQ_WAIT_INPUT ),
      m_next_seq( SEQ_WAIT_INPUT ),
      m_button_manager( NULL ),
      m_cursor_manager( NULL ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 ),
      m_wait_animation_index( ANIMATION_NULL )
    {
    }





    //---------------------------------------------------------------------------------
    // fXgN^
    //---------------------------------------------------------------------------------
    TargetSelect2vs2::~TargetSelect2vs2()
    {
      if( m_init_flag ) {
        this->DeleteCursorManager();
        this->DeleteButtonManager();
        this->DeleteLayoutWork();
        this->FinalizeGraphicsSystem();
      }
    }


    // J[\ǗIuWFNgj
    void TargetSelect2vs2::DeleteCursorManager( void )
    {
      GFL_DELETE m_cursor_manager;
    }


    // {^}l[Wj
    void TargetSelect2vs2::DeleteButtonManager( void )
    {
      if( m_button_manager ) {
        GFL_DELETE m_button_manager;
      }
    }


    // CAEg[Nj
    void TargetSelect2vs2::DeleteLayoutWork( void ) 
    {
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();
      layout_system->RemoveLytWk( m_layout_work );
      layout_system->ReleaseLytRes( m_layout_resource_id );
    }


    // OtBbNXVXȅI
    void TargetSelect2vs2::FinalizeGraphicsSystem( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->FinalizeApplicationMemory();
    }







    //---------------------------------------------------------------------------------
    // 
    //---------------------------------------------------------------------------------
    AppBase::InitResult TargetSelect2vs2::Initialize( void )
    {
      if( !m_init_flag ) {
        m_init_flag = true;
        this->InitializeGraphicsSystem();
        this->SetupFont();
        this->CreateLayoutWork();
        this->CreateShareAnimation();
        this->CreateCursorManager();
        this->CreateButtonManager();
        this->SetupButtonManager();
        this->SetupPlayerBalls();
        this->SetupEnemyBalls();
        this->SetupTargetButtonInfo( TARGET_BUTTON_LT );
        this->SetupTargetButtonInfo( TARGET_BUTTON_RT );
        this->SetupTargetButtonInfo( TARGET_BUTTON_LB );
        this->SetupTargetButtonInfo( TARGET_BUTTON_RB );
        this->InitializeCursorPos();
      }
      return AppBase::INIT_RESULT_FINISH;
    }



    // OtBbNXVXe
    void TargetSelect2vs2::InitializeGraphicsSystem( void )
    {
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->InitializeApplicationMemory( nw_device_allocator );
    }


    // tHg̏
    void TargetSelect2vs2::SetupFont( void )
    {
      gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), "cbf_std.bcfnt" );
    }


    // CAEg[N𐶐
    void TargetSelect2vs2::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::g2d::LytSys* layout_system = this->GetLayoutSystem();

      gfl::fs::ArcFile arc_file( ARCID_BATTLE_APP, heap );
      m_layout_resource_id = layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_btl_app_target_select_2vs2_LYTDAT );
      layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = layout_system->CreateLytWk(
          m_layout_resource_id,
          LYTRES_TARGET_SELECT_2VS2_TARGET_SELECT_2VS2_BCLYT,
          ANIMATION_DATA_TABLE, ANIMATION_DATA_NUM, ANIMATION_NUM,
          &LAYOUT_WORK_SETUP_DATA,
          false );  // Aj[VoChȂ

      m_layout_work->SetAutoDrawFlag( false );  // XV, `, jŊǗ
    }


    // LAj[V𐶐
    void TargetSelect2vs2::CreateShareAnimation( void )
    {
      for( u32 i=0; i<SHARE_ANIMATION_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIMATION_DESC[i].start_animation_index,
            ANIMATION_DATA_TABLE[ SHARE_ANIMATION_DESC[i].animation_data_index ],
            SHARE_ANIMATION_DESC[i].max_share_num,
            SHARE_ANIMATION_DESC[i].share_group_index,
            SHARE_ANIMATION_DESC[i].share_pane_index );
      }
    }


    // J[\ǗIuWFNg𐶐
    void TargetSelect2vs2::CreateCursorManager( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_cursor_manager = GFL_NEW( heap ) 
        ::app::tool::CursorManager(
            this->GetCursorMoveData(),
            CURSOR_POS_NUM, 
            heap, 
            this->GetInitialCursorPos() );
    }


    // {^}l[W𐶐
    void TargetSelect2vs2::CreateButtonManager( void )
    {
      const gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_button_manager = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, CURSOR_POS_NUM, ANIMATION_NULL );
    }


    // {^}l[WZbgAbv
    void TargetSelect2vs2::SetupButtonManager( void )
    {
      for( u32 i=0; i<BUTTON_NUM; i++ ) {
        ButtonIndex button_index = static_cast<ButtonIndex>(i);
        const CursorPosDesc& cursor_pos_desc = this->GetCursorPosDesc( button_index );
        m_button_manager->AddButton( 
            this->GetHeap(), 
            this->GetCursorPos( button_index ),  // ΉJ[\ʒuIDƂēo^
            m_layout_work,
            BUTTON_PANE[i],
            cursor_pos_desc.hold_animation_index,
            cursor_pos_desc.release_animation_index,
            cursor_pos_desc.select_animation_index,
            ANIMATION_NULL,  // activeAjȂ
            ANIMATION_NULL,  // passiveAjȂ
            NULL );  // R[obNȂ
      }
    }







    //---------------------------------------------------------------------------------
    // V[PXZbg
    //---------------------------------------------------------------------------------
    void TargetSelect2vs2::ResetSequence( void )
    {
      m_seq = SEQ_WAIT_INPUT;
      m_next_seq = SEQ_WAIT_INPUT;
      this->SetupPlayerBalls();
      this->SetupEnemyBalls();
      this->SetupTargetButtonInfo( TARGET_BUTTON_LT );
      this->SetupTargetButtonInfo( TARGET_BUTTON_RT );
      this->SetupTargetButtonInfo( TARGET_BUTTON_LB );
      this->SetupTargetButtonInfo( TARGET_BUTTON_RB );
      this->InitializeCursorPos();
    }




    // J[\ʒu
    void TargetSelect2vs2::InitializeCursorPos( void )
    {
      CursorPos cursor_pos = this->GetInitialCursorPos();
      const CursorPosDesc& cursor_pos_desc = this->GetCursorPosDesc( cursor_pos );
      m_cursor_manager->SetPos( cursor_pos );
      this->StartAnimation( m_layout_work, cursor_pos_desc.cursor_animation_index );
      this->StartAnimation( m_layout_work, ANIMATION_CURSOR_FLUCTUATE );
    }





    // ̃{[̃ZbgAbv
    void TargetSelect2vs2::SetupPlayerBalls( void )
    {
      for( u32 i=0; i<pml::PokeParty::MAX_MEMBERS; i++ ) {
        this->SetupPlayerBall(i);
      }
    }

    // w肵{[̕\XV
    void TargetSelect2vs2::SetupPlayerBall( u8 ball_index )
    {
      const btl::BTL_PARTY* btl_party = this->GetPlayerParty();
      u32 member_count = btl_party->GetMemberCount();

      if( member_count <= ball_index ) {
        this->SetPlayerBallDisplay_Null( ball_index );
      }
      else {
        const btl::BTL_POKEPARAM* btl_param = btl_party->GetMemberDataConst( ball_index );
        if( btl_param->IsDead() ) {
          this->SetPlayerBallDisplay_Dead( ball_index );
        }
        else if( btl_param->GetPokeSick() != pml::pokepara::SICK_NULL ) {
          this->SetPlayerBallDisplay_Sick( ball_index );
        }
        else {
          this->SetPlayerBallDisplay_Normal( ball_index );
        }
      }
    }

    // ̃{[ʏ̕\ɂ
    void TargetSelect2vs2::SetPlayerBallDisplay_Normal( u8 ball_index )
    {
      this->StartAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[Ԉُ̕\ɂ
    void TargetSelect2vs2::SetPlayerBallDisplay_Sick( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StartAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[m̕\ɂ
    void TargetSelect2vs2::SetPlayerBallDisplay_Dead( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StartAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[̕\ɂ
    void TargetSelect2vs2::SetPlayerBallDisplay_Null( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StartAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].null_animation_index );
    }








    // ̑S{[̕\XV
    void TargetSelect2vs2::SetupEnemyBalls( void )
    {
      if( this->IsEnemyBallsDisplay() ) {
        for( u32 i=0; i<pml::PokeParty::MAX_MEMBERS; i++ ) {
          this->SetupEnemyBall(i);
        }
      }
    }

    // w肵{[̕\XV
    void TargetSelect2vs2::SetupEnemyBall( u8 ball_index )
    {
      const btl::BTL_PARTY* btl_party = this->GetEnemyParty();
      u32 member_count = btl_party->GetMemberCount();

      if( member_count <= ball_index ) {
        this->SetEnemyBallDisplay_Null( ball_index );
      }
      else {
        const btl::BTL_POKEPARAM* btl_param = btl_party->GetMemberDataConst( ball_index );
        if( btl_param->IsDead() ) {
          this->SetEnemyBallDisplay_Dead( ball_index );
        }
        else if( btl_param->GetPokeSick() != pml::pokepara::SICK_NULL ) {
          this->SetEnemyBallDisplay_Sick( ball_index );
        }
        else {
          this->SetEnemyBallDisplay_Normal( ball_index );
        }
      }
    }


    // ̃{[ʏ̕\ɂ
    void TargetSelect2vs2::SetEnemyBallDisplay_Normal( u8 ball_index )
    {
      this->StartAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[Ԉُ̕\ɂ
    void TargetSelect2vs2::SetEnemyBallDisplay_Sick( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StartAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[m̕\ɂ
    void TargetSelect2vs2::SetEnemyBallDisplay_Dead( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StartAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[̕\ɂ
    void TargetSelect2vs2::SetEnemyBallDisplay_Null( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StartAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].null_animation_index );
    }









    // Ώۃ{^̏ZbgAbv
    void TargetSelect2vs2::SetupTargetButtonInfo( TargetButtonIndex button_index )
    {
      BtlvPos view_pos = TARGET_BUTTON_DESC[ button_index ].btlv_pos;
      const BTL_POKEPARAM* btl_param = this->GetBtlParam( view_pos );
      if( btl_param->IsDead() ) {
        this->SetTargetButtonDisplay_Dead( button_index );
      }
      else {
        const pml::pokepara::PokemonParam* pokeparam = this->GetPokeParam( view_pos );
        this->SetTargetButtonDisplay_Alive( button_index );
        this->SetTargetButtonDisplay_MonsName( button_index, pokeparam );
        this->SetTargetButtonDisplay_PokeIcon( button_index, pokeparam );
        this->SetTargetButtonDisplay_Sex( button_index, pokeparam );
      }
    }


    // Ώۃ|P퓬\ȏԂ̕\ɂ
    void TargetSelect2vs2::SetTargetButtonDisplay_Alive( TargetButtonIndex button_index )
    {
      this->StopAnimation( m_layout_work, TARGET_BUTTON_DESC[ button_index ].dead_animation_index );
      this->StartAnimation( m_layout_work, TARGET_BUTTON_DESC[ button_index ].alive_animation_index );
    }


    // Ώۃ|PmԂ̕\ɂ
    void TargetSelect2vs2::SetTargetButtonDisplay_Dead( TargetButtonIndex button_index )
    {
      this->StopAnimation( m_layout_work, TARGET_BUTTON_DESC[ button_index ].alive_animation_index );
      this->StartAnimation( m_layout_work, TARGET_BUTTON_DESC[ button_index ].dead_animation_index );
    }


    // Ώۃ{^ɃX^[Zbg
    void TargetSelect2vs2::SetTargetButtonDisplay_MonsName( 
        TargetButtonIndex button_index, const pml::pokepara::PokemonParam* param )
    {
      MonsNo monsno = param->GetMonsNo();
      this->SetTextboxPaneMonsName( m_layout_work, 
          TARGET_BUTTON_DESC[ button_index ].monsname_pane_index, monsno );
    }


    // Ώۃ{^Ƀ|PACRZbg
    void TargetSelect2vs2::SetTargetButtonDisplay_PokeIcon( 
      TargetButtonIndex button_index, const pml::pokepara::PokemonParam* param )
      {
        // @todo
      }


    // Ώۃ{^Ƀ|P̐ʂZbg
    void TargetSelect2vs2::SetTargetButtonDisplay_Sex( 
      TargetButtonIndex button_index, const pml::pokepara::PokemonParam* param )
    {
      pml::Sex sex = param->GetSex();
      this->SetTextboxPaneSex( m_layout_work, 
          TARGET_BUTTON_DESC[ button_index ].sex_pane_index, sex );
    }











    //---------------------------------------------------------------------------------
    // XV
    //---------------------------------------------------------------------------------
    void TargetSelect2vs2::Update( void )
    {
      m_button_manager->Update();
      this->UpdateSequence(); 
      m_layout_work->Update();
    }



    // V[PXXV
    void TargetSelect2vs2::UpdateSequence( void )
    {
      const gfl::ui::Button* ui_button = 
        this->GetUiDeviceManager()->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );

      switch( m_seq )
      {
      case SEQ_WAIT_INPUT:
        if( this->IsButtonSelected() ) {
          CursorPos cursor_pos = this->GetSelectedCursorPosByButton();
          if( this->IsSelectEnable( cursor_pos ) ) {
            this->SetResultByCursorPos( cursor_pos );
            this->StartSelectAnimation( cursor_pos );
            m_seq = SEQ_WAIT_ANIMATION;
            m_next_seq = SEQ_FINISH;
          }
        }
        else if( this->IsButtonHolding() ) {
          // do nothing
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
          CursorPos cursor_pos = this->GetCurrentCursorPos();
          if( this->IsSelectEnable( cursor_pos ) ) {
            this->SetResultByCursorPos( cursor_pos );
            this->StartSelectAnimation( cursor_pos );
            m_seq = SEQ_WAIT_ANIMATION;
            m_next_seq = SEQ_FINISH;
          }
        }
        else if( this->UpdateCursorMove() ) {  // J[\ړ
          CursorPos old_cursor_pos = this->GetPrevCursorPos();
          CursorPos new_cursor_pos = this->GetCurrentCursorPos();
          this->StartCursorMoveAnimation( old_cursor_pos, new_cursor_pos );
        }
        break;


      case SEQ_WAIT_ANIMATION:
        if( this->IsSelectAnimationFinished() ) {
          m_seq = m_next_seq;
        }
        break;


      default:
        GFL_ASSERT(0);
        // fall through

      case SEQ_FINISH:
        GFL_ASSERT( this->GetResult() != RESULT_NULL );
        this->Finish();
        break; 
      }
    }




    // {^Ă邩ǂ𒲂ׂ
    bool TargetSelect2vs2::IsButtonHolding( void ) const
    {
      return m_button_manager->IsButtonHolding();
    }

    // {^Iꂽǂ𒲂ׂ
    bool TargetSelect2vs2::IsButtonSelected( void ) const
    {
      return m_button_manager->IsButtonSelected();
    }

    // Iꂽ{^Ɋ֘AtĂJ[\ʒu擾
    TargetSelect2vs2::CursorPos TargetSelect2vs2::GetSelectedCursorPosByButton( void ) const
    {
      return static_cast<CursorPos>( m_button_manager->GetSelectedButtonId() );
    }



    // J[\̓XV
    bool TargetSelect2vs2::UpdateCursorMove( void )
    {
      ::app::tool::CursorManager::MOVE_RET move_result = m_cursor_manager->MainTrigger();
      return( move_result == ::app::tool::CursorManager::RET_MOVE ); // ړǂ
    } 


    // ݂̃J[\ʒu擾
    TargetSelect2vs2::CursorPos TargetSelect2vs2::GetCurrentCursorPos( void ) const
    {
      return static_cast<CursorPos>( m_cursor_manager->GetID() );
    } 


    // ÕJ[\ʒu擾
    TargetSelect2vs2::CursorPos TargetSelect2vs2::GetPrevCursorPos( void ) const
    {
      return static_cast<CursorPos>( m_cursor_manager->GetOldID() );
    }


    // J[\ړۂ̏
    void TargetSelect2vs2::StartCursorMoveAnimation( 
        TargetSelect2vs2::CursorPos old_cursor_pos, TargetSelect2vs2::CursorPos new_cursor_pos )
    {
      const CursorPosDesc& old_cursor_pos_desc = this->GetCursorPosDesc( old_cursor_pos );
      const CursorPosDesc& new_cursor_pos_desc = this->GetCursorPosDesc( new_cursor_pos );
      this->StopAnimation( m_layout_work, old_cursor_pos_desc.cursor_animation_index );
      this->StartAnimation( m_layout_work, new_cursor_pos_desc.cursor_animation_index );
    }





    // I\ǂ𒲂ׂ
    bool TargetSelect2vs2::IsSelectEnable( CursorPos cursor_pos ) const
    {
      if( cursor_pos < CURSOR_POS_NUM ) {
        const CursorPosDesc& cursor_pos_desc = this->GetCursorPosDesc( cursor_pos );
        return cursor_pos_desc.move_enable;
      }
      return false;
    }



    // J[\ʒu, 쌋ʂZbg
    void TargetSelect2vs2::SetResultByCursorPos( CursorPos cursor_pos )
    {
      const CursorPosDesc& cursor_pos_desc = this->GetCursorPosDesc( cursor_pos );
      this->SetResult( cursor_pos_desc.result );
      this->SetSelectedPos( cursor_pos_desc.btlv_pos );
    } 


    // ȊIAj[VJn
    void TargetSelect2vs2::StartSelectAnimation( CursorPos cursor_pos )
    {
      const CursorPosDesc& cursor_pos_desc = this->GetCursorPosDesc( cursor_pos );
      m_wait_animation_index = cursor_pos_desc.select_animation_index;
      this->StartAnimation( m_layout_work, m_wait_animation_index );
    }


    // ȊIAj[VIǂ𒲂ׂ
    bool TargetSelect2vs2::IsSelectAnimationFinished( void ) const
    {
      if( m_wait_animation_index < ANIMATION_NUM ) {
        return m_layout_work->IsAnimeEnd( m_wait_animation_index );
      }
      return true;  // Aj[Vo^ȂIƂɂ
    }








    //---------------------------------------------------------------------------------
    // `揈
    //---------------------------------------------------------------------------------
    void TargetSelect2vs2::Draw( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      gfl::grp::RenderTarget* lower_frame_buffer = graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
      m_layout_work->Draw( graphics_system, gfl::grp::DISPLAY_LOWER, lower_frame_buffer );
    }







  }  // namespace app
}  // namespace btl
