//================================================================================
/**
 * @file   test_ohno_p2p.cpp
 * @brief  Ⴂ̃f[^eXg
 * @author k.ohno
 * @date   2010.12.15
 */ 
//================================================================================
#include <nn.h>
#include <gflib.h>
#include <gamesystem/GameManager.h>
#include <gamesystem/GameProcManager.h>
#include "test_ohno_p2p.h"

namespace gflnet{
extern nn::nex::qInt GenericInit(nn::nex::qInt argc, nn::nex::qChar** argv,
                                 gfl::heap::HeapBase *systemHeap,gfl::ui::Button*);
extern nn::nex::qInt GenericMain(nn::nex::qInt argc, nn::nex::qChar** argv,
                                 gfl::heap::HeapBase *systemHeap,gfl::ui::Button*);
extern nn::nex::qInt GenericEnd(nn::nex::qInt argc, nn::nex::qChar** argv,
                                 gfl::heap::HeapBase *systemHeap,gfl::ui::Button*);
};

GFL_NAMESPACE_BEGIN(test)
GFL_NAMESPACE_BEGIN(ohno)




    //-----------------------------------------------------------------------------
    // RXgN^
    //-----------------------------------------------------------------------------
TestOhnoP2p::TestOhnoP2p( 
  gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
  gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allcator,
  gfl::grp::GraphicsSystem* graphics_system, gfl::ui::DeviceManager* ui_device_manager ) :
Base( heap, device_heap, heap_allocator, device_allcator, graphics_system, ui_device_manager )
{ 


  gflnet::p2p::NETWORK_CONFIG cfg = {
    0,//  u32 maxSilenceTime;
    1000,//  u32 keepAliveTimeout;
    0,//  u32 maxWindowMapSize;
    false,//  bool useUserDO;   //IuWFNg Duplicated Object̂
    // lbg[Ng|W֘AB
    nn::nex::NetworkTopology::Peer2Peer, //nn::nex::NetworkTopology::Mode networkTopology;  Peer2Peer
    false, // bool testRouting;

    // bZ[Woh֘A
    false, //  bool enableMessageBundle;
    0,//  u16  messageBundleFlushDelay;
    0,//  u16  messageBundleFlushCheckPeriod;

    // pPbgoh֘A
    false,//  bool enablePacketBundle;
    0,//  u32  packetBundleFlushDelay;
  };


  mpSsystemHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
  gfl::heap::HeapBase *devHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );

  // Q[}l[W
//  mpManager = GFL_NEW(systemHeap) gfl::proc::Manager(systemHeap);
 // pManager->Initialize();
  

  //PROCManager쐬
//  gamesystem::GameProcManager* pManager = pManager->GetProcManager();

  //GFLIB_PROC_CALL<gfl::proc::Manager, gflnet::proc::P2pInitProc>( mpManager );


 // mpUdsAdapter = GFL_NEW(systemHeap) gflnet::p2p::UdsAdapter(nnuds::FORCE_DIRECT_BC);
  

  //mpP2pManager = GFL_NEW(systemHeap) gflnet::p2p::P2pManager( systemHeap,  devHeap, systemHeap );

//  mpP2pManager->Init( &cfg );

  
  gflnet::GenericInit(1, 0,mpSsystemHeap,m_button);
}


//-----------------------------------------------------------------------------
// fXgN^
//-----------------------------------------------------------------------------
TestOhnoP2p::~TestOhnoP2p()
{

  gflnet::GenericEnd(1, 0,mpSsystemHeap,m_button);
}


//-----------------------------------------------------------------------------
// C
//-----------------------------------------------------------------------------
void TestOhnoP2p::UpdateTest( void )
{
//  mpManager->Main();

  gflnet::GenericMain(1, 0,mpSsystemHeap,m_button);
  
/*
  if( m_button->IsTrigger( gfl::ui::BUTTON_B ) ) {
    GFL_PRINT("CONNECT  \n");
    GFLIB_PROC_CALL<gfl::proc::Manager, gflnet::proc::P2pConnectProc>( mpManager );
  }
  if( m_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
    GFL_PRINT("e@  \n");
    GFLIB_PROC_CALL<gfl::proc::Manager, gflnet::proc::P2pCreateMasterProc>( mpManager );
  }
  if( m_button->IsTrigger( gfl::ui::BUTTON_X ) ) {
    GFL_PRINT("  \n");
    GFLIB_PROC_CALL<gfl::proc::Manager, gflnet::proc::P2pAutoScanProc>( mpManager );
  }
  if( m_button->IsTrigger( gfl::ui::BUTTON_Y ) ) {
    GFL_PRINT("  \n");
 //   GFLIB_PROC_CALL<gfl::proc::Manager, gflnet::proc::P2pConnectProc>( mpManager );
  }
  */
  // START {^ŏI
  if( m_button->IsTrigger( gfl::ui::BUTTON_START ) ) {
    this->End();
  }
} 



//-----------------------------------------------------------------------------
// `揈
//-----------------------------------------------------------------------------
void TestOhnoP2p::DrawTest( void )
{
//  mpManager->Draw();

}


GFL_NAMESPACE_END(ohno)
GFL_NAMESPACE_END(test)
