//=======================================================================================
/**
 * @file   test_obata_btl_WazaSelect.cpp
 * @brief  ogʂ̃eXgvZX
 * @author obata_toshihiro
 * @date   2011.08.06
 */
//=======================================================================================
#include <gflib.h>
#include <gamesystem/GameProc.h>
#include <battle/battle_MainProc.h>
#include <battle/btlv/app/AppBase.h>
#include <battle/btlv/app/SingleWazaSelect.h>
#include <battle/btlv/app/TripleWazaSelect.h>
#include <battle/btlv/app/RotationWazaSelect.h>
#include "test_obata_btl_WazaSelect.h"

namespace test {
  namespace obata {



    //-----------------------------------------------------------------------------------
    // RXgN^
    //-----------------------------------------------------------------------------------
    WazaSelectTest::WazaSelectTest( void ) : 
      btl::BattleMainProc(),
      m_app( NULL ),
      m_app_count( 0 ),
      m_app_test_finish( false )
    {
      gfl::heap::HeapBase* heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
      gfl::heap::HeapBase* device_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );
      gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      gamesystem::GameData* game_data = game_manager->GetGameData();
      pml::bridge::CtrAllocator allocator( heap ); 

      // p[eB쐬
      pml::PokeParty* player_party = game_data->GetPlayerParty(); 
      {
        pml::pokepara::PokemonParam* param = 
          pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_PIKATYUU, 5, 0 );
        player_party->ReplaceMember( 0, *param );
      }

      // Gp[eB쐬
      m_enemy_party = GFL_NEW( heap ) pml::PokeParty( heap );
      {
        pml::pokepara::PokemonParam* param = 
          pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_PIKATYUU, 5, 0 );
        m_enemy_party->AddMember( *param ); 
      }


      // ogvZX̃ZbgAbv
      BATTLE_SETUP_FIELD_SITUATION_Init( &m_btl_field_situation );
      BATTLE_SETUP_Wild( &m_btl_param, game_data, 
          m_enemy_party, &m_btl_field_situation, BTL_RULE_SINGLE, heap ); 
      this->SetupParam( &m_btl_param, heap, device_heap );

      // ogAvP[V̏
      btl::app::AppDrawerBase::Initialize( heap );
    }



    //-----------------------------------------------------------------------------------
    // fXgN^
    //----------------------------------------------------------------------------------- 
    WazaSelectTest::~WazaSelectTest( void )
    {
      btl::app::AppDrawerBase::Finalize();
      GFL_DELETE m_enemy_party;
    }






    //----------------------------------------------------------------------------------- 
    // XV
    //----------------------------------------------------------------------------------- 
    gfl::proc::Result WazaSelectTest::UpdateFunc( gfl::proc::Manager* pProcManager )
    {
      static u32 count = 0;
      if( count++ < 100 ) {  // ogvZX̏܂ōXV
        btl::BattleMainProc::UpdateFunc( pProcManager );
        return gfl::proc::RES_CONTINUE;
      } 

      if( !m_app && !m_app_test_finish ) {
        this->CreateBattleApplication();
        m_app_count++;
      } 

      if( m_app ) {
        if( m_app->IsFinished() ) {
          this->DeleteBattleApplication();
        }
        else {
          m_app->Update(); 
        }
      }
      else {
        return btl::BattleMainProc::UpdateFunc( pProcManager );
      }
      return gfl::proc::RES_CONTINUE;
    }



    // ogʃAvP[V쐬
    void WazaSelectTest::CreateBattleApplication( void )
    {
      GFL_ASSERT( !m_app );
      gfl::heap::HeapBase* heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
      gfl::heap::HeapBase* device_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );
#if 0
      btl::BattleViewSystem* btlv_system = this->GetMainModule()->GetBattleViewSystem(); 
#else
      btl::BattleViewSystem* btlv_system = NULL;
#endif
      btl::app::WazaSelectBase::Setting settings;

      switch( m_app_count ) {
      case 0:
        GFL_PRINT( "VO: K~, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        m_app = GFL_NEW( heap ) 
          btl::app::SingleWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 1:
        GFL_PRINT( "VO: K, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        m_app = GFL_NEW( heap ) 
          btl::app::SingleWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 2:
        GFL_PRINT( "VO: K, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        m_app = GFL_NEW( heap ) 
          btl::app::SingleWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 3:
        GFL_PRINT( "VO: K~, 邠\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        m_app = GFL_NEW( heap ) 
          btl::app::SingleWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 4:
        GFL_PRINT( "VO: K, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        m_app = GFL_NEW( heap ) 
          btl::app::SingleWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 5:
        GFL_PRINT( "VO: K, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        m_app = GFL_NEW( heap ) 
          btl::app::SingleWazaSelect( heap, device_heap, btlv_system, settings );
        break; 
      case 6:
        GFL_PRINT( "gv: ړ~, K~, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_center_enable = false; 
        m_app = GFL_NEW( heap ) 
          btl::app::TripleWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 7:
        GFL_PRINT( "gv: ړ~, K, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_center_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::TripleWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 8:
        GFL_PRINT( "gv: ړ~, K, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_center_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::TripleWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 9:
        GFL_PRINT( "gv: ړ, K~, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_center_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::TripleWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 10:
        GFL_PRINT( "gv: ړ, K, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_center_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::TripleWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 11:
        GFL_PRINT( "gv: ړ, K, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_center_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::TripleWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 12: 
        GFL_PRINT( "gv: ړ~, K~, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_center_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::TripleWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 13: 
        GFL_PRINT( "gv: ړ~, K, 邠\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_center_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::TripleWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 14: 
        GFL_PRINT( "gv: ړ~, K, 邠\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_center_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::TripleWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 15: 
        GFL_PRINT( "gv: ړ, K~, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_center_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::TripleWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 16: 
        GFL_PRINT( "gv: ړ, K, 邠\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_center_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::TripleWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 17: 
        GFL_PRINT( "gv: ړ, K, 邠\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_center_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::TripleWazaSelect( heap, device_heap, btlv_system, settings );
        break; 
      case 18: 
        GFL_PRINT( "[e[V: ~, E~, K~, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 19: 
        GFL_PRINT( "[e[V: ~, E~, K, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 20: 
        GFL_PRINT( "[e[V: ~, E~, K, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 21: 
        GFL_PRINT( "[e[V: ~, E, K~, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 22: 
        GFL_PRINT( "[e[V: ~, E, K, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 23: 
        GFL_PRINT( "[e[V: ~, E, K, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 24: 
        GFL_PRINT( "[e[V: ~, E, K~, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 25: 
        GFL_PRINT( "[e[V: ~, E, K, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 26: 
        GFL_PRINT( "[e[V: ~, E, K, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 27: 
        GFL_PRINT( "[e[V: , E~, K~, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 28: 
        GFL_PRINT( "[e[V: , E~, K, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 29: 
        GFL_PRINT( "[e[V: , E~, K, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 30: 
        GFL_PRINT( "[e[V: , E, K~, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 31: 
        GFL_PRINT( "[e[V: , E, K, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 32: 
        GFL_PRINT( "[e[V: , E, K, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 33: 
        GFL_PRINT( "[e[V: , E, K~, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 34: 
        GFL_PRINT( "[e[V: , E, K, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 35: 
        GFL_PRINT( "[e[V: , E, K, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true; 
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 36: 
        GFL_PRINT( "[e[V: , E~, K~, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 37: 
        GFL_PRINT( "[e[V: , E~, K, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 38: 
        GFL_PRINT( "[e[V: , E~, K, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 39: 
        GFL_PRINT( "[e[V: , E, K~, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 40: 
        GFL_PRINT( "[e[V: , E, K, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 41: 
        GFL_PRINT( "[e[V: , E, K, 莝Z\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 42: 
        GFL_PRINT( "[e[V: , E, K~, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 43: 
        GFL_PRINT( "[e[V: , E, K, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 44: 
        GFL_PRINT( "[e[V: , E, K, 莝Z\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true; 
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 45: 
        GFL_PRINT( "[e[V: ~, E~, K~, ZIs\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 46: 
        GFL_PRINT( "[e[V: ~, E~, K, ZIs\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 47: 
        GFL_PRINT( "[e[V: ~, E~, K, ZIs\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 48: 
        GFL_PRINT( "[e[V: ~, E, K~, ZIs\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 49: 
        GFL_PRINT( "[e[V: ~, E, K, ZIs\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 50: 
        GFL_PRINT( "[e[V: ~, E, K, ZIs\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 51: 
        GFL_PRINT( "[e[V: ~, E, K~, ZIs\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 52: 
        GFL_PRINT( "[e[V: ~, E, K, ZIs\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 53: 
        GFL_PRINT( "[e[V: ~, E, K, ZIs\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true; 
        settings.move_right_enable = true;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 54: 
        GFL_PRINT( "[e[V: , E~, K~, ZIs\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 55: 
        GFL_PRINT( "[e[V: , E~, K, ZIs\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 56: 
        GFL_PRINT( "[e[V: , E~, K, ZIs\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 57: 
        GFL_PRINT( "[e[V: , E, K~, ZIs\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 58: 
        GFL_PRINT( "[e[V: , E, K, ZIs\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 59: 
        GFL_PRINT( "[e[V: , E, K, ZIs\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 60: 
        GFL_PRINT( "[e[V: , E, K~, ZIs\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 61: 
        GFL_PRINT( "[e[V: , E, K, ZIs\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 62: 
        GFL_PRINT( "[e[V: , E, K, ZIs\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true; 
        settings.move_right_enable = true;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 63: 
        GFL_PRINT( "[e[V: , E~, K~, ZIs\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 64: 
        GFL_PRINT( "[e[V: , E~, K, ZIs\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 65: 
        GFL_PRINT( "[e[V: , E~, K, ZIs\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 66: 
        GFL_PRINT( "[e[V: , E, K~, ZIs\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 67: 
        GFL_PRINT( "[e[V: , E, K, ZIs\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 68: 
        GFL_PRINT( "[e[V: , E, K, ZIs\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 69: 
        GFL_PRINT( "[e[V: , E, K~, ZIs\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 70: 
        GFL_PRINT( "[e[V: , E, K, ZIs\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 71: 
        GFL_PRINT( "[e[V: , E, K, ZIs\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = false;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true; 
        settings.move_right_enable = true;
        settings.waza_select_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 72: 
        GFL_PRINT( "[e[V: ~, E~, K~, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 73: 
        GFL_PRINT( "[e[V: ~, E~, K, 邠\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 74: 
        GFL_PRINT( "[e[V: ~, E~, K, 邠\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 75: 
        GFL_PRINT( "[e[V: ~, E, K~, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 76: 
        GFL_PRINT( "[e[V: ~, E, K, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 77: 
        GFL_PRINT( "[e[V: ~, E, K, 邠\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 78: 
        GFL_PRINT( "[e[V: ~, E, K~, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 79: 
        GFL_PRINT( "[e[V: ~, E, K, 邠\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 80: 
        GFL_PRINT( "[e[V: ~, E, K, 邠\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = false;
        settings.move_left_enable = false;
        settings.move_right_exist = true; 
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 81: 
        GFL_PRINT( "[e[V: , E~, K~, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 82: 
        GFL_PRINT( "[e[V: , E~, K, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 83: 
        GFL_PRINT( "[e[V: , E~, K, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 84: 
        GFL_PRINT( "[e[V: , E, K~, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 85: 
        GFL_PRINT( "[e[V: , E, K, 邠\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 86: 
        GFL_PRINT( "[e[V: , E, K, 邠\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 87: 
        GFL_PRINT( "[e[V: , E, K~, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 88: 
        GFL_PRINT( "[e[V: , E, K, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 89: 
        GFL_PRINT( "[e[V: , E, K, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = false;
        settings.move_right_exist = true; 
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 90: 
        GFL_PRINT( "[e[V: , E~, K~, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 91: 
        GFL_PRINT( "[e[V: , E~, K, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 92: 
        GFL_PRINT( "[e[V: , E~, K, 邠\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = false;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 93: 
        GFL_PRINT( "[e[V: , E, K~, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 94: 
        GFL_PRINT( "[e[V: , E, K, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 95: 
        GFL_PRINT( "[e[V: , E, K, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true;
        settings.move_right_enable = false;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 96: 
        GFL_PRINT( "[e[V: , E, K~, 邠\n" );
        settings.enemy_balls_display = false;
        settings.mega_exist = false;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 97: 
        GFL_PRINT( "[e[V: , E, K, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = false;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      case 98:
        GFL_PRINT( "[e[V: , E, K, 邠\n" );
        settings.enemy_balls_display = true;
        settings.mega_exist = true;
        settings.mega_enable = true;
        settings.waruagaki_only = true;
        settings.poke_index = 0;
        settings.move_left_exist = true;
        settings.move_left_enable = true;
        settings.move_right_exist = true;
        settings.move_right_enable = true;
        settings.waza_select_enable = true;
        m_app = GFL_NEW( heap ) 
          btl::app::RotationWazaSelect( heap, device_heap, btlv_system, settings );
        break;
      default:
        GFL_PRINT( "eXgI!!\n" );
        m_app_test_finish = true;
        break;
      }



      if( m_app ) {
        while(1) {
          btl::app::AppBase::InitResult res = m_app->Initialize();
          if( res == btl::app::AppBase::INIT_RESULT_FINISH ) {
            break;
          }
        }
      }
    }


    // ogʃAvP[V폜
    void WazaSelectTest::DeleteBattleApplication( void )
    {
      if( m_app ) {
        GFL_DELETE( m_app );
        m_app = NULL;
      }
    }




    //----------------------------------------------------------------------------------- 
    // `揈
    //----------------------------------------------------------------------------------- 
    void WazaSelectTest::DrawFunc( gfl::proc::Manager* pProcManager )
    {
      if( m_app ) {
          m_app->Draw();
      }
      else {
        btl::BattleMainProc::DrawFunc( pProcManager );
      }
    }




    //----------------------------------------------------------------------------------- 
    // I
    //----------------------------------------------------------------------------------- 
    gfl::proc::Result WazaSelectTest::EndFunc( gfl::proc::Manager* pProcManager )
    {
      static bool set_next = false;
      if( !set_next ) {
        set_next = true;
        KUJIRA_PROC_SETNEXT<gamesystem::GameProcManager, test::obata::Proc>( 
            GFL_SINGLETON_INSTANCE( gamesystem::GameManager )->GetProcManager() );
        gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_DOUBLE, 10 );  // ʃtF[hCJn
      }
      return btl::BattleMainProc::EndFunc( pProcManager );
    }



  } // namespace obata
} // namespace test 

