//=======================================================================================
/**
 * @file   test_obata_btl_ActionSelect.h
 * @brief  ogʂ̃eXgvZX
 * @author obata_toshihiro
 * @date   2011.08.06
 */
//=======================================================================================
#include <gflib.h>
#include <gamesystem/GameProc.h>
#include <battle/battle_MainProc.h>
#include <battle/btlv/app/AppBase.h>
#include <battle/btlv/app/ActionSelect.h>
#include "test_obata_btl_ActionSelect.h"

namespace test {
  namespace obata {



    //-----------------------------------------------------------------------------------
    // RXgN^
    //-----------------------------------------------------------------------------------
    ActionSelectTest::ActionSelectTest( void ) : 
      btl::BattleMainProc(),
      m_app( NULL ),
      m_app_count( 0 ),
      m_app_test_finish( false )
    {
      gfl::heap::HeapBase* heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
      gfl::heap::HeapBase* device_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );
      gamesystem::GameManager* game_manager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      gamesystem::GameData* game_data = game_manager->GetGameData();
      pml::bridge::CtrAllocator allocator( heap ); 

      // p[eB쐬
      pml::PokeParty* player_party = game_data->GetPlayerParty(); 
      {
        pml::pokepara::PokemonParam* param = 
          pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_PIKATYUU, 5, 0 );
        player_party->ReplaceMember( 0, *param );
      }

      // Gp[eB쐬
      m_enemy_party = GFL_NEW( heap ) pml::PokeParty( heap );
      {
        pml::pokepara::PokemonParam* param = 
          pml::System::PokeParaFactory()->CreatePokemonParam( &allocator, MONSNO_PIKATYUU, 5, 0 );
        m_enemy_party->AddMember( *param ); 
      }


      // ogvZX̃ZbgAbv
      BATTLE_SETUP_FIELD_SITUATION_Init( &m_btl_field_situation );
      BATTLE_SETUP_Wild( &m_btl_param, game_data, 
          m_enemy_party, &m_btl_field_situation, BTL_RULE_SINGLE, heap ); 
      this->SetupParam( &m_btl_param, heap, device_heap );

      // ogAvP[V̏
      btl::app::AppDrawerBase::Initialize( heap );
    }



    //-----------------------------------------------------------------------------------
    // fXgN^
    //----------------------------------------------------------------------------------- 
    ActionSelectTest::~ActionSelectTest( void )
    {
      btl::app::AppDrawerBase::Finalize();
      GFL_DELETE m_enemy_party;
    }






    //----------------------------------------------------------------------------------- 
    // XV
    //----------------------------------------------------------------------------------- 
    gfl::proc::Result ActionSelectTest::UpdateFunc( gfl::proc::Manager* pProcManager )
    {
      static u32 count = 0;
      if( count++ < 100 ) {  // ogvZX̏܂ōXV
        btl::BattleMainProc::UpdateFunc( pProcManager );
        return gfl::proc::RES_CONTINUE;
      } 

      if( !m_app && !m_app_test_finish ) {
        this->CreateBattleApplication();
        m_app_count++;
      } 

      if( m_app ) {
        if( m_app->IsFinished() ) {
          this->DeleteBattleApplication();
        }
        else {
          m_app->Update(); 
        }
      }
      else {
        return btl::BattleMainProc::UpdateFunc( pProcManager );
      }
      return gfl::proc::RES_CONTINUE;
    }



    // ogʃAvP[V쐬
    void ActionSelectTest::CreateBattleApplication( void )
    {
      GFL_ASSERT( !m_app );
      gfl::heap::HeapBase* heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
      gfl::heap::HeapBase* device_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );
#if 0
      btl::BattleViewSystem* btlv_system = this->GetMainModule()->GetBattleViewSystem(); 
#else
      btl::BattleViewSystem* btlv_system = NULL;
#endif
      btl::app::ActionSelectBase::Setting settings;

      switch( m_app_count ) {
      case 0:
        settings.bag_button_enable = true;
        settings.bag_button_type = btl::app::ActionSelectBase::BAG_BUTTON_BAG;
        settings.run_button_type = btl::app::ActionSelectBase::RUN_BUTTON_RUN;
        settings.current_poke_index = 0;
        settings.battle_poke_count = 1;
        m_app = GFL_NEW( heap ) 
          btl::app::ActionSelect( heap, device_heap, btlv_system, settings );
        break;
      default:
        GFL_PRINT( "eXgI!!\n" );
        m_app_test_finish = true;
        break;
      } 


      if( m_app ) {
        while(1) {
          btl::app::AppBase::InitResult res = m_app->Initialize();
          if( res == btl::app::AppBase::INIT_RESULT_FINISH ) {
            break;
          }
        }
      }
    }


    // ogʃAvP[V폜
    void ActionSelectTest::DeleteBattleApplication( void )
    {
      if( m_app ) {
        GFL_DELETE( m_app );
        m_app = NULL;
      }
    }




    //----------------------------------------------------------------------------------- 
    // `揈
    //----------------------------------------------------------------------------------- 
    void ActionSelectTest::DrawFunc( gfl::proc::Manager* pProcManager )
    {
      if( m_app ) {
          m_app->Draw();
      }
      else {
        btl::BattleMainProc::DrawFunc( pProcManager );
      }
    }




    //----------------------------------------------------------------------------------- 
    // I
    //----------------------------------------------------------------------------------- 
    gfl::proc::Result ActionSelectTest::EndFunc( gfl::proc::Manager* pProcManager )
    {
      static bool set_next = false;
      if( !set_next ) {
        set_next = true;
        KUJIRA_PROC_SETNEXT<gamesystem::GameProcManager, test::obata::Proc>( 
            GFL_SINGLETON_INSTANCE( gamesystem::GameManager )->GetProcManager() );
        gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_DOUBLE, 10 );  // ʃtF[hCJn
      }
      return btl::BattleMainProc::EndFunc( pProcManager );
    }



  } // namespace obata
} // namespace test 
