#include "strinput_area.h"




namespace app {
namespace strinput {


InputArea::InputArea( gfl::grp::g2d::LytWk * lytwk, const gfl::grp::g2d::LytPaneIndex * tbl, u32 siz ) :
	flg( false ),
	start( 0 ),
	end( 0 )
{
	lytWk   = lytwk;
	areaTbl = tbl;
	tblSize = siz;
}

InputArea::~InputArea(void)
{
}

bool InputArea::CheckInputArea( gfl::ui::TouchPanel * tp )
{
	if( tp->IsTouchTrigger() == true ){
		u32	pos = InputArea::HitCheck( tp );
			GFL_PRINT( "input area touch\n" );
		if( pos != tblSize ){
			start = pos;
			end   = pos;
			flg   = true;
			GFL_PRINT( "input area start\n" );
			return true;
		}
	}else{
		if( flg == true ){
			if( tp->IsTouch() == true ){
				u32	pos = InputArea::HitCheck( tp );
				if( pos != tblSize ){
					end = pos;
				}
			}else{
				GFL_PRINT( "input area end\n" );
				flg = false;
			}
			return true;
		}
	}

	return false;
}

u32 InputArea::HitCheck( gfl::ui::TouchPanel * tp )
{
	gfl::grp::g2d::LytPaneIndex pane;
	u32	i;
	u16	x, y;

	tp->GetXY( &x, &y );
	pane = lytWk->GetHitPaneIndexAll( x, y, false );

	for( i=0; i<tblSize; i++ ){
		if( pane == areaTbl[i] ){
			break;
		}
	}
	return i;
}

void InputArea::GetAreaPos( u16 * start_pos, u16 * end_pos )
{
	*start_pos = start;
	*end_pos   = end;
}


}	// strinput
}	// app
