//=======================================================================================
/**
 * @file RotationWazaSelect.h
 * @brief 퓬 ZI( [e[Vog )
 * @author obata_toshihiro
 * @date 2011.08.01
 */
//=======================================================================================
#ifndef __ROTATIONWAZASELECT_H__
#define __ROTATIONWAZASELECT_H__
#include <gflib.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include "WazaSelectBase.h"
#include "AppDrawerBase.h"


namespace btl {
  namespace app {


    class RotationWazaSelect : public WazaSelectBase, public AppDrawerBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( RotationWazaSelect );  // Rs[֎~


      public:

      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap       gpAvP[Vq[v
       * @param device_heap    gpfoCXq[v
       * @param settings       ݒ
       * @param layout_system  `Ɏgp郌CAEgVXe
       */
      //---------------------------------------------------------------------------------
      RotationWazaSelect( 
          gfl::heap::HeapBase* app_heap, 
          gfl::heap::HeapBase* device_heap,
          const WazaSelectBase::Setting& base_settings,
          gfl::grp::g2d::LytSys* layout_system );

      //---------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //---------------------------------------------------------------------------------
      virtual ~RotationWazaSelect();

      //---------------------------------------------------------------------------------
      /**
       * @brief AvP[V̊{
       */
      //---------------------------------------------------------------------------------
      virtual AppBase::InitResult Initialize( void );
      virtual void Update( void );
      virtual void Draw( void );
      virtual void ResetSequence( void );




      private:

      // V[PX
      enum Sequence {
        SEQ_WAIT_INPUT,      // ͑҂
        SEQ_WAIT_ANIMATION,  // Aj[VI҂
        SEQ_FINISH,          // I
      };

      // J[\ʒu
      enum CursorPos {
        CURSOR_POS_WAZA0,       // 莝Z1
        CURSOR_POS_WAZA1,       // 莝Z2
        CURSOR_POS_WAZA2,       // 莝Z3
        CURSOR_POS_WAZA3,       // 莝Z4
        CURSOR_POS_LEFT,        // ֈړ
        CURSOR_POS_RIGHT,       // Eֈړ
        CURSOR_POS_MEGA,        // Ki
        CURSOR_POS_RETURN,      // ߂
        CURSOR_POS_WARUAGAKI,   // 邠
        CURSOR_POS_NUM,
      };

      // J[\ړp^[
      enum CursorMovePattern {
        // 莝Zgꍇ
        CURSOR_MOVE_PATTERN_LEFT,                       //                       ړ
        CURSOR_MOVE_PATTERN_RIGHT,                      //                               Eړ
        CURSOR_MOVE_PATTERN_LEFT_RIGHT,                 //                       ړ, Eړ
        CURSOR_MOVE_PATTERN_MEGA_LEFT,                  //             Ki, ړ, 
        CURSOR_MOVE_PATTERN_MEGA_RIGHT,                 //             Ki,         Eړ
        CURSOR_MOVE_PATTERN_MEGA_LEFT_RIGHT,            //             Ki, ړ, Eړ
        //u邠vgȂꍇ
        CURSOR_MOVE_PATTERN_WARUAGAKI_LEFT,             // 邠,           ړ, 
        CURSOR_MOVE_PATTERN_WARUAGAKI_RIGHT,            // 邠,                   Eړ
        CURSOR_MOVE_PATTERN_WARUAGAKI_LEFT_RIGHT,       // 邠,           ړ, Eړ
        CURSOR_MOVE_PATTERN_WARUAGAKI_MEGA_LEFT,        // 邠, Ki, ړ, 
        CURSOR_MOVE_PATTERN_WARUAGAKI_MEGA_RIGHT,       // 邠, Ki,         Eړ
        CURSOR_MOVE_PATTERN_WARUAGAKI_MEGA_LEFT_RIGHT,  // 邠, Ki, ړ, Eړ
        CURSOR_MOVE_PATTERN_NUM,
      };

      // Z{^
      enum WazaButtonIndex {
        WAZA_BUTTON_LT,         // 莝Z1
        WAZA_BUTTON_RT,         // 莝Z2
        WAZA_BUTTON_LB,         // 莝Z3
        WAZA_BUTTON_RB,         // 莝Z4
        WAZA_BUTTON_WARUAGAKI,  // 邠
        WAZA_BUTTON_NUM,
      };


      // Aj[Vf[^
      enum AnimationDataIndex {
        ANIMATION_DATA_DUMMY_BALL_NORMAL,
        ANIMATION_DATA_DUMMY_BALL_SICK,
        ANIMATION_DATA_DUMMY_BALL_DEAD,
        ANIMATION_DATA_DUMMY_BALL_NULL,
        ANIMATION_DATA_DUMMY_BUTTON_HOLD,
        ANIMATION_DATA_DUMMY_BUTTON_RELEASE,
        ANIMATION_DATA_DUMMY_BUTTON_SELECT,
        ANIMATION_DATA_CURSOR_ON_WAZA0,
        ANIMATION_DATA_CURSOR_ON_WAZA1,
        ANIMATION_DATA_CURSOR_ON_WAZA2,
        ANIMATION_DATA_CURSOR_ON_WAZA3,
        ANIMATION_DATA_CURSOR_ON_LEFT,
        ANIMATION_DATA_CURSOR_ON_RIGHT,
        ANIMATION_DATA_CURSOR_ON_MEGA,
        ANIMATION_DATA_CURSOR_ON_RETURN,
        ANIMATION_DATA_CURSOR_ON_WARUAGAKI,
        ANIMATION_DATA_WAZA0_TYPE,
        ANIMATION_DATA_WAZA0_EXIST,
        ANIMATION_DATA_WAZA0_NULL,
        ANIMATION_DATA_WAZA0_ACTIVE,
        ANIMATION_DATA_WAZA0_PASSIVE,
        ANIMATION_DATA_WAZA0_PP_FULL,
        ANIMATION_DATA_WAZA0_PP_HALF,
        ANIMATION_DATA_WAZA0_PP_LOW,
        ANIMATION_DATA_WAZA0_PP_ZERO,
        ANIMATION_DATA_WAZA1_TYPE,
        ANIMATION_DATA_WAZA1_EXIST,
        ANIMATION_DATA_WAZA1_NULL,
        ANIMATION_DATA_WAZA1_ACTIVE,
        ANIMATION_DATA_WAZA1_PASSIVE,
        ANIMATION_DATA_WAZA1_PP_FULL,
        ANIMATION_DATA_WAZA1_PP_HALF,
        ANIMATION_DATA_WAZA1_PP_LOW,
        ANIMATION_DATA_WAZA1_PP_ZERO,
        ANIMATION_DATA_WAZA2_TYPE,
        ANIMATION_DATA_WAZA2_EXIST,
        ANIMATION_DATA_WAZA2_NULL,
        ANIMATION_DATA_WAZA2_ACTIVE,
        ANIMATION_DATA_WAZA2_PASSIVE,
        ANIMATION_DATA_WAZA2_PP_FULL,
        ANIMATION_DATA_WAZA2_PP_HALF,
        ANIMATION_DATA_WAZA2_PP_LOW,
        ANIMATION_DATA_WAZA2_PP_ZERO,
        ANIMATION_DATA_WAZA3_TYPE,
        ANIMATION_DATA_WAZA3_EXIST,
        ANIMATION_DATA_WAZA3_NULL,
        ANIMATION_DATA_WAZA3_ACTIVE,
        ANIMATION_DATA_WAZA3_PASSIVE,
        ANIMATION_DATA_WAZA3_PP_FULL,
        ANIMATION_DATA_WAZA3_PP_HALF,
        ANIMATION_DATA_WAZA3_PP_LOW,
        ANIMATION_DATA_WAZA3_PP_ZERO,
        ANIMATION_DATA_WARUAGAKI_VISIBLE,
        ANIMATION_DATA_WARUAGAKI_INVISIBLE,
        ANIMATION_DATA_MEGA_VISIBLE,
        ANIMATION_DATA_MEGA_INVISIBLE,
        ANIMATION_DATA_MEGA_ACTIVE,
        ANIMATION_DATA_MEGA_PASSIVE,
        ANIMATION_DATA_LEFT_VISIBLE,
        ANIMATION_DATA_LEFT_INVISIBLE,
        ANIMATION_DATA_LEFT_ACTIVE,
        ANIMATION_DATA_LEFT_PASSIVE,
        ANIMATION_DATA_RIGHT_VISIBLE,
        ANIMATION_DATA_RIGHT_INVISIBLE,
        ANIMATION_DATA_RIGHT_ACTIVE,
        ANIMATION_DATA_RIGHT_PASSIVE,
        ANIMATION_DATA_NUM,
      };

      // Aj[Vԍ
      enum AnimationIndex {
        ANIMATION_DUMMY_BALL_NORMAL,
        ANIMATION_DUMMY_BALL_SICK,
        ANIMATION_DUMMY_BALL_DEAD,
        ANIMATION_DUMMY_BALL_NULL,
        ANIMATION_DUMMY_BUTTON_HOLD,
        ANIMATION_DUMMY_BUTTON_RELEASE,
        ANIMATION_DUMMY_BUTTON_SELECT,
        ANIMATION_CURSOR_ON_WAZA0,
        ANIMATION_CURSOR_ON_WAZA1,
        ANIMATION_CURSOR_ON_WAZA2,
        ANIMATION_CURSOR_ON_WAZA3,
        ANIMATION_CURSOR_ON_LEFT,
        ANIMATION_CURSOR_ON_RIGHT,
        ANIMATION_CURSOR_ON_MEGA,
        ANIMATION_CURSOR_ON_RETURN,
        ANIMATION_CURSOR_ON_WARUAGAKI,
        ANIMATION_WAZA0_TYPE,
        ANIMATION_WAZA0_EXIST,
        ANIMATION_WAZA0_NULL,
        ANIMATION_WAZA0_ACTIVE,
        ANIMATION_WAZA0_PASSIVE,
        ANIMATION_WAZA0_PP_FULL,
        ANIMATION_WAZA0_PP_HALF,
        ANIMATION_WAZA0_PP_LOW,
        ANIMATION_WAZA0_PP_ZERO,
        ANIMATION_WAZA1_TYPE,
        ANIMATION_WAZA1_EXIST,
        ANIMATION_WAZA1_NULL,
        ANIMATION_WAZA1_ACTIVE,
        ANIMATION_WAZA1_PASSIVE,
        ANIMATION_WAZA1_PP_FULL,
        ANIMATION_WAZA1_PP_HALF,
        ANIMATION_WAZA1_PP_LOW,
        ANIMATION_WAZA1_PP_ZERO,
        ANIMATION_WAZA2_TYPE,
        ANIMATION_WAZA2_EXIST,
        ANIMATION_WAZA2_NULL,
        ANIMATION_WAZA2_ACTIVE,
        ANIMATION_WAZA2_PASSIVE,
        ANIMATION_WAZA2_PP_FULL,
        ANIMATION_WAZA2_PP_HALF,
        ANIMATION_WAZA2_PP_LOW,
        ANIMATION_WAZA2_PP_ZERO,
        ANIMATION_WAZA3_TYPE,
        ANIMATION_WAZA3_EXIST,
        ANIMATION_WAZA3_NULL,
        ANIMATION_WAZA3_ACTIVE,
        ANIMATION_WAZA3_PASSIVE,
        ANIMATION_WAZA3_PP_FULL,
        ANIMATION_WAZA3_PP_HALF,
        ANIMATION_WAZA3_PP_LOW,
        ANIMATION_WAZA3_PP_ZERO,
        ANIMATION_WARUAGAKI_VISIBLE,
        ANIMATION_WARUAGAKI_INVISIBLE,
        ANIMATION_MEGA_VISIBLE,
        ANIMATION_MEGA_INVISIBLE,
        ANIMATION_MEGA_ACTIVE,
        ANIMATION_MEGA_PASSIVE,
        ANIMATION_LEFT_VISIBLE,
        ANIMATION_LEFT_INVISIBLE,
        ANIMATION_LEFT_ACTIVE,
        ANIMATION_LEFT_PASSIVE,
        ANIMATION_RIGHT_VISIBLE,
        ANIMATION_RIGHT_INVISIBLE,
        ANIMATION_RIGHT_ACTIVE,
        ANIMATION_RIGHT_PASSIVE,
        // ȉ, LAj[V
        ANIMATION_MYBALL00_NORMAL,
        ANIMATION_MYBALL00_SICK = ANIMATION_MYBALL00_NORMAL + pml::PokeParty::MAX_MEMBERS,
        ANIMATION_MYBALL00_DEAD = ANIMATION_MYBALL00_SICK + pml::PokeParty::MAX_MEMBERS,
        ANIMATION_MYBALL00_NULL = ANIMATION_MYBALL00_DEAD + pml::PokeParty::MAX_MEMBERS,
        ANIMATION_ENBALL00_NORMAL = ANIMATION_MYBALL00_NULL + pml::PokeParty::MAX_MEMBERS,
        ANIMATION_ENBALL00_SICK = ANIMATION_ENBALL00_NORMAL + pml::PokeParty::MAX_MEMBERS,
        ANIMATION_ENBALL00_DEAD = ANIMATION_ENBALL00_SICK + pml::PokeParty::MAX_MEMBERS,
        ANIMATION_ENBALL00_NULL = ANIMATION_ENBALL00_DEAD + pml::PokeParty::MAX_MEMBERS,
        ANIMATION_BUTTON_HOLD = ANIMATION_ENBALL00_NULL + pml::PokeParty::MAX_MEMBERS,
        ANIMATION_BUTTON_RELEASE = ANIMATION_BUTTON_HOLD + CURSOR_POS_NUM,
        ANIMATION_BUTTON_SELECT = ANIMATION_BUTTON_RELEASE + CURSOR_POS_NUM,
        ANIMATION_NUM = ANIMATION_BUTTON_SELECT + CURSOR_POS_NUM,  // 
        ANIMATION_NULL,  // l
      };

      // LAj[Vԍ
      enum ShareAnimationIndex {
        SHARE_ANIMATION_MYBALL_NORMAL,
        SHARE_ANIMATION_MYBALL_SICK,
        SHARE_ANIMATION_MYBALL_DEAD,
        SHARE_ANIMATION_MYBALL_NULL,
        SHARE_ANIMATION_ENBALL_NORMAL,
        SHARE_ANIMATION_ENBALL_SICK,
        SHARE_ANIMATION_ENBALL_DEAD,
        SHARE_ANIMATION_ENBALL_NULL,
        SHARE_ANIMATION_BUTTON_HOLD,
        SHARE_ANIMATION_BUTTON_RELEASE,
        SHARE_ANIMATION_BUTTON_SELECT,
        SHARE_ANIMATION_NUM,
      };


      // LAj[VƂ̐ݒ
      struct ShareAnimationDesc {
        AnimationIndex start_animation_index;           // o^CfbNX
        AnimationDataIndex animation_data_index;        // L̃Aj[Vԍ
        u32 max_share_num;                              // ő勤L
        gfl::grp::g2d::LytPaneIndex share_group_index;  // VFAΏۂ̃O[v
        gfl::grp::g2d::LytPaneIndex share_pane_index;   // VFAΏۂ̃yC
      };


      // {[Ƃ̐ݒ
      struct BallDesc {
        AnimationIndex normal_animation_index;  // ʏ펞̃Aj[V
        AnimationIndex sick_animation_index;    // Ԉُ펞̃Aj[V
        AnimationIndex dead_animation_index;    // m̃Aj[V
        AnimationIndex null_animation_index;    // ̃Aj[V
      };


      // {^Ƃ̐ݒ
      struct ButtonDesc {
        WazaSelectBase::Result result;            // Iꂽۂ̓쌋
        u8 waza_index;                            // ΉZCfbNX
        gfl::grp::g2d::LytPaneIndex pane_index;   // {^ƂĈyC
        AnimationIndex hold_animation_index;      // ꂽۂ̃Aj[V
        AnimationIndex release_animation_index;   // ꂽۂ̃Aj[V
        AnimationIndex select_animation_index;    // I΂ꂽۂ̃Aj[V
        AnimationIndex active_animation_index;    // {^Lȍۂ̃Aj[V
        AnimationIndex passive_animation_index;   // {^ȍۂ̃Aj[V
        AnimationIndex cursor_animation_index;    // J[\ZbgAj[V
      };


      // Z{^Ƃ̐ݒ
      struct WazaButtonDesc {
        u8 waza_index;                                      // ΉZCfbNX
        CursorPos cursor_pos;                               // ΉJ[\ʒu
        gfl::grp::g2d::LytPaneIndex waza_name_pane_index;   // Z̃yC
        gfl::grp::g2d::LytPaneIndex pp_label_pane_index;    // PPx̃yC
        gfl::grp::g2d::LytPaneIndex pp_value_pane_index;    // PPݒl̃yC
        gfl::grp::g2d::LytPaneIndex pp_max_pane_index;      // PPől̃yC
        AnimationIndex type_animation_index;                // ^CvύXAj[V
        AnimationIndex exist_animation_index;               // 킴LԂ̃Aj[V
        AnimationIndex null_animation_index;                // 킴Ԃ̃Aj[V
        AnimationIndex active_animation_index;              // {^Lȍۂ̃Aj[V
        AnimationIndex passive_animation_index;             // {^ȍۂ̃Aj[V
        AnimationIndex pp_full_animation_index;             // 50%<PPc<=100% ̏ꍇ̃Aj[V
        AnimationIndex pp_half_animation_index;             // 25%<PPc<=50% ̏ꍇ̃Aj[V
        AnimationIndex pp_low_animation_index;              // 0%<PPc<=25% ̏ꍇ̃Aj[V
        AnimationIndex pp_zero_animation_index;             // PPcʂ0%̏ꍇ̃Aj[V
      };

      // J[\ړp^[Ƃ̐ݒ
      struct CursorMovePatternDesc {
        CursorPos init_pos;                                                 // J[\ʒu
        ::app::tool::CursorManager::MOVE_DATA move_data[ CURSOR_POS_NUM ];  // ړf[^
      };


      static const u32 KETA_PP_VALUE;    // PPݒľ
      static const u32 KETA_PP_MAX;      // PPőľ
      static const u32 APP_HEAPSIZE;     // AvP[Vq[ṽTCY
      static const u32 DEVICE_HEAPSIZE;  // foCXq[ṽTCY

      static const gfl::grp::g2d::LytArcIndex ANIMATION_DATA_TABLE[ ANIMATION_DATA_NUM ];
      static const ShareAnimationDesc SHARE_ANIMATION_DESC[ SHARE_ANIMATION_NUM ];
      static const ButtonDesc BUTTON_DESC[ CURSOR_POS_NUM ];
      static const WazaButtonDesc WAZA_BUTTON_DESC[ WAZA_BUTTON_NUM ];
      static const BallDesc MY_BALL_DESC[ pml::PokeParty::MAX_MEMBERS ];
      static const BallDesc ENEMY_BALL_DESC[ pml::PokeParty::MAX_MEMBERS ];
      static const CursorMovePatternDesc CURSOR_MOVE_PATTERN_DESC[ CURSOR_MOVE_PATTERN_NUM ];



      bool m_init_flag;
      Sequence m_seq;
      Sequence m_next_seq;
      ::app::tool::ButtonManager* m_button_manager;
      ::app::tool::CursorManager* m_cursor_manager;

      gfl::grp::g2d::LytSys* m_layout_system;
      gfl::grp::g2d::LytWk* m_layout_work;
      gfl::grp::g2d::LytResID m_layout_resource_id;
      AnimationIndex m_wait_animation_index;


      void CreateCursorManager( void );
      void CreateLayoutWork( void );
      void CreateShareAnimation( void );
      void CreateButtonManager( void );
      void SetupButtonManager( void ); 
      void SetupFont( void );
      void InitializeGraphicsSystem( void );
      void InitializeCursorPos( void );

      void DeleteCursorManager( void );
      void DeleteButtonManager( void );
      void DeleteLayoutWork( void );
      void FinalizeGraphicsSystem( void );

      CursorMovePattern GetCursorMovePattern( void );

      void SetupWazaButtons( void );
      void SetupWazaButton( WazaButtonIndex waza_button_index );
      void SetWazaButtonDisplay_Strings( WazaButtonIndex waza_button_index );
      void SetWazaButtonDisplay_Type( WazaButtonIndex waza_button_index, pml::PokeType type );
      void SetWazaButtonDisplay_Exist( WazaButtonIndex waza_button_index );
      void SetWazaButtonDisplay_Null( WazaButtonIndex waza_button_index );
      void SetWazaButtonDisplay_PPColor( WazaButtonIndex waza_button_index );

      void SetupWaruagakiButton( void );
      void SetWaruagakiButtonDisplay_Visible( void );
      void SetWaruagakiButtonDisplay_Invisible( void );

      void SetupMegaButton( void );
      void SetMegaButtonDisplay_Visible( void );
      void SetMegaButtonDisplay_Invisible( void );

      void SetupLeftButton( void );
      void SetLeftButtonDisplay_Visible( void );
      void SetLeftButtonDisplay_Invisible( void );

      void SetupRightButton( void );
      void SetRightButtonDisplay_Visible( void );
      void SetRightButtonDisplay_Invisible( void );

      void SetupMyBalls( void );
      void SetupMyBall( u8 ball_index );
      void SetMyBallDisplay_Normal( u8 ball_index );
      void SetMyBallDisplay_Sick( u8 ball_index );
      void SetMyBallDisplay_Dead( u8 ball_index );
      void SetMyBallDisplay_Null( u8 ball_index );

      void SetupEnemyBalls( void );
      void SetupEnemyBall( u8 ball_index );
      void SetEnemyBallDisplay_Normal( u8 ball_index );
      void SetEnemyBallDisplay_Sick( u8 ball_index );
      void SetEnemyBallDisplay_Dead( u8 ball_index );
      void SetEnemyBallDisplay_Null( u8 ball_index ); 

      void UpdateSequence( void );
      bool UpdateCursorMove( void );
      CursorPos GetCurrentCursorPos( void ) const;
      CursorPos GetPrevCursorPos( void ) const;
      bool IsSelectEnable( CursorPos cursor_pos ) const;
      void SetResultByCursorPos( CursorPos cursor_pos );

      void StartSelectAnimation( CursorPos cursor_pos );
      bool IsSelectAnimationFinished( void ) const;
      void StartCursorMoveAnimation( CursorPos old_cursor_pos, CursorPos new_cursor_pos );
    };


  }  // namespace app
}  // namespace btl


#endif // __ROTATIONWAZASELECT_H__ 
