//=======================================================================================
/**
 * @file RotationWazaSelect.cpp
 * @brief 퓬 ZI( VOog )
 * @author obata_toshihiro
 * @date 2011.08.01
 */
//=======================================================================================
#include <gflib.h>
#include <battle/btl_party.h>
#include <app/tool/app_tool_ButtonManager.h>
#include <app/tool/app_tool_CursorManager.h>
#include "AppDrawerBase.h"
#include "WazaSelectBase.h"
#include "RotationWazaSelect.h"

#include <arc/arc_def.h>
#include <arc/btl_app.gaix>
#include <message/msg_btl_app.h>
#include "waza_select_rotation.h"
#include "waza_select_rotation_pane.h"


namespace btl {
  namespace app {



    // 
    const u32 RotationWazaSelect::KETA_PP_VALUE = 2;
    const u32 RotationWazaSelect::KETA_PP_MAX = 2;

    // q[vTCY
    const u32 RotationWazaSelect::APP_HEAPSIZE = 0x1800;
    const u32 RotationWazaSelect::DEVICE_HEAPSIZE = 0x200000;




    // J[\ړp^[Ƃ̐ݒ
    const RotationWazaSelect::CursorMovePatternDesc RotationWazaSelect::CURSOR_MOVE_PATTERN_DESC[ RotationWazaSelect::CURSOR_MOVE_PATTERN_NUM ] =
    {
      /* CURSOR_MOVE_PATTERN_LEFT */
      {
        // J[\ʒu
        CURSOR_POS_WAZA0,

        // ړf[^
        { 
          /*   id               up                down              left              right  */
          { CURSOR_POS_WAZA0, { CURSOR_POS_WAZA0, CURSOR_POS_WAZA2, CURSOR_POS_WAZA0, CURSOR_POS_WAZA1 } },
          { CURSOR_POS_WAZA1, { CURSOR_POS_WAZA1, CURSOR_POS_WAZA3, CURSOR_POS_WAZA0, CURSOR_POS_WAZA1 } },
          { CURSOR_POS_WAZA2, { CURSOR_POS_WAZA0, CURSOR_POS_LEFT, CURSOR_POS_WAZA2, CURSOR_POS_WAZA3 } },
          { CURSOR_POS_WAZA3, { CURSOR_POS_WAZA1, CURSOR_POS_RETURN, CURSOR_POS_WAZA2, CURSOR_POS_WAZA3 } },
          { CURSOR_POS_LEFT, { CURSOR_POS_WAZA2, CURSOR_POS_LEFT, CURSOR_POS_LEFT, CURSOR_POS_RETURN } },
          { CURSOR_POS_RIGHT, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_MEGA, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN, { CURSOR_POS_WAZA3, CURSOR_POS_RETURN, CURSOR_POS_LEFT, CURSOR_POS_RETURN } },
          { CURSOR_POS_WARUAGAKI, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        }
      },

      /* CURSOR_MOVE_PATTERN_RIGHT */
      {
        // J[\ʒu
        CURSOR_POS_WAZA0,

        // ړf[^
        { 
          /*   id               up                down              left              right  */
          { CURSOR_POS_WAZA0, { CURSOR_POS_WAZA0, CURSOR_POS_WAZA2, CURSOR_POS_WAZA0, CURSOR_POS_WAZA1 } },
          { CURSOR_POS_WAZA1, { CURSOR_POS_WAZA1, CURSOR_POS_WAZA3, CURSOR_POS_WAZA0, CURSOR_POS_WAZA1 } },
          { CURSOR_POS_WAZA2, { CURSOR_POS_WAZA0, CURSOR_POS_RIGHT, CURSOR_POS_WAZA2, CURSOR_POS_WAZA3 } },
          { CURSOR_POS_WAZA3, { CURSOR_POS_WAZA1, CURSOR_POS_RETURN, CURSOR_POS_WAZA2, CURSOR_POS_WAZA3 } },
          { CURSOR_POS_LEFT, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RIGHT, { CURSOR_POS_WAZA2, CURSOR_POS_RIGHT, CURSOR_POS_RIGHT, CURSOR_POS_RETURN } },
          { CURSOR_POS_MEGA, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN, { CURSOR_POS_WAZA3, CURSOR_POS_RETURN, CURSOR_POS_RIGHT, CURSOR_POS_RETURN } },
          { CURSOR_POS_WARUAGAKI, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        }
      },

      /* CURSOR_MOVE_PATTERN_LEFT_RIGHT */
      {
        // J[\ʒu
        CURSOR_POS_WAZA0,

        // ړf[^
        { 
          /*   id               up                down              left              right  */
          { CURSOR_POS_WAZA0, { CURSOR_POS_WAZA0, CURSOR_POS_WAZA2, CURSOR_POS_WAZA0, CURSOR_POS_WAZA1 } },
          { CURSOR_POS_WAZA1, { CURSOR_POS_WAZA1, CURSOR_POS_WAZA3, CURSOR_POS_WAZA0, CURSOR_POS_WAZA1 } },
          { CURSOR_POS_WAZA2, { CURSOR_POS_WAZA0, CURSOR_POS_LEFT, CURSOR_POS_WAZA2, CURSOR_POS_WAZA3 } },
          { CURSOR_POS_WAZA3, { CURSOR_POS_WAZA1, CURSOR_POS_RETURN, CURSOR_POS_WAZA2, CURSOR_POS_WAZA3 } },
          { CURSOR_POS_LEFT, { CURSOR_POS_WAZA2, CURSOR_POS_LEFT, CURSOR_POS_LEFT, CURSOR_POS_RIGHT } },
          { CURSOR_POS_RIGHT, { CURSOR_POS_WAZA2, CURSOR_POS_RIGHT, CURSOR_POS_LEFT, CURSOR_POS_RETURN } },
          { CURSOR_POS_MEGA, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN, { CURSOR_POS_WAZA3, CURSOR_POS_RETURN, CURSOR_POS_RIGHT, CURSOR_POS_RETURN } },
          { CURSOR_POS_WARUAGAKI, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        }
      }, 

      /* CURSOR_MOVE_PATTERN_MEGA_LEFT */
      {
        // J[\ʒu
        CURSOR_POS_WAZA0,

        // ړf[^
        { 
          /*   id               up                down              left              right  */
          { CURSOR_POS_WAZA0, { CURSOR_POS_WAZA0, CURSOR_POS_WAZA2, CURSOR_POS_WAZA0, CURSOR_POS_WAZA1 } },
          { CURSOR_POS_WAZA1, { CURSOR_POS_WAZA1, CURSOR_POS_WAZA3, CURSOR_POS_WAZA0, CURSOR_POS_WAZA1 } },
          { CURSOR_POS_WAZA2, { CURSOR_POS_WAZA0, CURSOR_POS_LEFT, CURSOR_POS_WAZA2, CURSOR_POS_WAZA3 } },
          { CURSOR_POS_WAZA3, { CURSOR_POS_WAZA1, CURSOR_POS_RETURN, CURSOR_POS_WAZA2, CURSOR_POS_WAZA3 } },
          { CURSOR_POS_LEFT, { CURSOR_POS_WAZA2, CURSOR_POS_LEFT, CURSOR_POS_LEFT, CURSOR_POS_MEGA } },
          { CURSOR_POS_RIGHT, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_MEGA, { CURSOR_POS_WAZA2, CURSOR_POS_MEGA, CURSOR_POS_LEFT, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN, { CURSOR_POS_WAZA3, CURSOR_POS_RETURN, CURSOR_POS_MEGA, CURSOR_POS_RETURN } },
          { CURSOR_POS_WARUAGAKI, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        }
      },

      /* CURSOR_MOVE_PATTERN_MEGA_RIGHT */
      {
        // J[\ʒu
        CURSOR_POS_WAZA0,

        // ړf[^
        { 
          /*   id               up                down              left              right  */
          { CURSOR_POS_WAZA0, { CURSOR_POS_WAZA0, CURSOR_POS_WAZA2, CURSOR_POS_WAZA0, CURSOR_POS_WAZA1 } },
          { CURSOR_POS_WAZA1, { CURSOR_POS_WAZA1, CURSOR_POS_WAZA3, CURSOR_POS_WAZA0, CURSOR_POS_WAZA1 } },
          { CURSOR_POS_WAZA2, { CURSOR_POS_WAZA0, CURSOR_POS_RIGHT, CURSOR_POS_WAZA2, CURSOR_POS_WAZA3 } },
          { CURSOR_POS_WAZA3, { CURSOR_POS_WAZA1, CURSOR_POS_RETURN, CURSOR_POS_WAZA2, CURSOR_POS_WAZA3 } },
          { CURSOR_POS_LEFT, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RIGHT, { CURSOR_POS_WAZA2, CURSOR_POS_RIGHT, CURSOR_POS_RIGHT, CURSOR_POS_MEGA } },
          { CURSOR_POS_MEGA, { CURSOR_POS_WAZA2, CURSOR_POS_MEGA, CURSOR_POS_RIGHT, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN, { CURSOR_POS_WAZA3, CURSOR_POS_RETURN, CURSOR_POS_MEGA, CURSOR_POS_RETURN } },
          { CURSOR_POS_WARUAGAKI, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        }
      },

      /* CURSOR_MOVE_PATTERN_MEGA_LEFT_RIGHT */
      {
        // J[\ʒu
        CURSOR_POS_WAZA0,

        // ړf[^
        { 
          /*   id               up                down              left              right  */
          { CURSOR_POS_WAZA0, { CURSOR_POS_WAZA0, CURSOR_POS_WAZA2, CURSOR_POS_WAZA0, CURSOR_POS_WAZA1 } },
          { CURSOR_POS_WAZA1, { CURSOR_POS_WAZA1, CURSOR_POS_WAZA3, CURSOR_POS_WAZA0, CURSOR_POS_WAZA1 } },
          { CURSOR_POS_WAZA2, { CURSOR_POS_WAZA0, CURSOR_POS_LEFT, CURSOR_POS_WAZA2, CURSOR_POS_WAZA3 } },
          { CURSOR_POS_WAZA3, { CURSOR_POS_WAZA1, CURSOR_POS_RETURN, CURSOR_POS_WAZA2, CURSOR_POS_WAZA3 } },
          { CURSOR_POS_LEFT, { CURSOR_POS_WAZA2, CURSOR_POS_LEFT, CURSOR_POS_LEFT, CURSOR_POS_RIGHT } },
          { CURSOR_POS_RIGHT, { CURSOR_POS_WAZA2, CURSOR_POS_RIGHT, CURSOR_POS_LEFT, CURSOR_POS_MEGA } },
          { CURSOR_POS_MEGA, { CURSOR_POS_WAZA2, CURSOR_POS_MEGA, CURSOR_POS_RIGHT, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN, { CURSOR_POS_WAZA3, CURSOR_POS_RETURN, CURSOR_POS_MEGA, CURSOR_POS_RETURN } },
          { CURSOR_POS_WARUAGAKI, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
        }
      },


      /* CURSOR_MOVE_PATTERN_WARUAGAKI_LEFT */
      {
        // J[\ʒu
        CURSOR_POS_WARUAGAKI,

        // ړf[^
        { 
          /*   id               up                down              left              right  */
          { CURSOR_POS_WAZA0, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA1, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA2, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA3, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_LEFT, { CURSOR_POS_WARUAGAKI, CURSOR_POS_LEFT, CURSOR_POS_LEFT, CURSOR_POS_RETURN } },
          { CURSOR_POS_RIGHT, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_MEGA, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN, { CURSOR_POS_WARUAGAKI, CURSOR_POS_RETURN, CURSOR_POS_LEFT, CURSOR_POS_RETURN } },
          { CURSOR_POS_WARUAGAKI, { CURSOR_POS_WARUAGAKI, CURSOR_POS_RETURN, CURSOR_POS_WARUAGAKI, CURSOR_POS_WARUAGAKI } },
        }
      },

      /* CURSOR_MOVE_PATTERN_WARUAGAKI_RIGHT */
      {
        // J[\ʒu
        CURSOR_POS_WARUAGAKI,

        // ړf[^
        { 
          /*   id               up                down              left              right  */
          { CURSOR_POS_WAZA0, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA1, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA2, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA3, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_LEFT, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RIGHT, { CURSOR_POS_WARUAGAKI, CURSOR_POS_RIGHT, CURSOR_POS_RIGHT, CURSOR_POS_RETURN } },
          { CURSOR_POS_MEGA, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN, { CURSOR_POS_WARUAGAKI, CURSOR_POS_RETURN, CURSOR_POS_RIGHT, CURSOR_POS_RETURN } },
          { CURSOR_POS_WARUAGAKI, { CURSOR_POS_WARUAGAKI, CURSOR_POS_RETURN, CURSOR_POS_WARUAGAKI, CURSOR_POS_WARUAGAKI } },
        }
      },

      /* CURSOR_MOVE_PATTERN_WARUAGAKI_LEFT_RIGHT */
      {
        // J[\ʒu
        CURSOR_POS_WARUAGAKI,

        // ړf[^
        { 
          /*   id               up                down              left              right  */
          { CURSOR_POS_WAZA0, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA1, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA2, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA3, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_LEFT, { CURSOR_POS_WARUAGAKI, CURSOR_POS_LEFT, CURSOR_POS_LEFT, CURSOR_POS_RIGHT } },
          { CURSOR_POS_RIGHT, { CURSOR_POS_WARUAGAKI, CURSOR_POS_RIGHT, CURSOR_POS_LEFT, CURSOR_POS_RETURN } },
          { CURSOR_POS_MEGA, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN, { CURSOR_POS_WARUAGAKI, CURSOR_POS_RETURN, CURSOR_POS_RIGHT, CURSOR_POS_RETURN } },
          { CURSOR_POS_WARUAGAKI, { CURSOR_POS_WARUAGAKI, CURSOR_POS_RETURN, CURSOR_POS_WARUAGAKI, CURSOR_POS_WARUAGAKI } },
        }
      }, 

      /* CURSOR_MOVE_PATTERN_WARUAGAKI_MEGA_LEFT */
      {
        // J[\ʒu
        CURSOR_POS_WARUAGAKI,

        // ړf[^
        { 
          /*   id               up                down              left              right  */
          { CURSOR_POS_WAZA0, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA1, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA2, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA3, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_LEFT, { CURSOR_POS_WARUAGAKI, CURSOR_POS_LEFT, CURSOR_POS_LEFT, CURSOR_POS_MEGA } },
          { CURSOR_POS_RIGHT, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_MEGA, { CURSOR_POS_WARUAGAKI, CURSOR_POS_MEGA, CURSOR_POS_LEFT, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN, { CURSOR_POS_WARUAGAKI, CURSOR_POS_RETURN, CURSOR_POS_MEGA, CURSOR_POS_RETURN } },
          { CURSOR_POS_WARUAGAKI, { CURSOR_POS_WARUAGAKI, CURSOR_POS_RETURN, CURSOR_POS_WARUAGAKI, CURSOR_POS_WARUAGAKI } },
        }
      },

      /* CURSOR_MOVE_PATTERN_WARUAGAKI_MEGA_RIGHT */
      {
        // J[\ʒu
        CURSOR_POS_WARUAGAKI,

        // ړf[^
        { 
          /*   id               up                down              left              right  */
          { CURSOR_POS_WAZA0, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA1, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA2, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA3, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_LEFT, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_RIGHT, { CURSOR_POS_WARUAGAKI, CURSOR_POS_RIGHT, CURSOR_POS_RIGHT, CURSOR_POS_MEGA } },
          { CURSOR_POS_MEGA, { CURSOR_POS_WARUAGAKI, CURSOR_POS_MEGA, CURSOR_POS_RIGHT, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN, { CURSOR_POS_WARUAGAKI, CURSOR_POS_RETURN, CURSOR_POS_MEGA, CURSOR_POS_RETURN } },
          { CURSOR_POS_WARUAGAKI, { CURSOR_POS_WARUAGAKI, CURSOR_POS_RETURN, CURSOR_POS_WARUAGAKI, CURSOR_POS_WARUAGAKI } },
        }
      },

      /* CURSOR_MOVE_PATTERN_WARUAGAKI_MEGA_LEFT_RIGHT */
      {
        // J[\ʒu
        CURSOR_POS_WARUAGAKI,

        // ړf[^
        { 
          /*   id               up                down              left              right  */
          { CURSOR_POS_WAZA0, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA1, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA2, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_WAZA3, { CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN, CURSOR_POS_RETURN } },
          { CURSOR_POS_LEFT, { CURSOR_POS_WARUAGAKI, CURSOR_POS_LEFT, CURSOR_POS_LEFT, CURSOR_POS_RIGHT } },
          { CURSOR_POS_RIGHT, { CURSOR_POS_WARUAGAKI, CURSOR_POS_RIGHT, CURSOR_POS_LEFT, CURSOR_POS_MEGA } },
          { CURSOR_POS_MEGA, { CURSOR_POS_WARUAGAKI, CURSOR_POS_MEGA, CURSOR_POS_RIGHT, CURSOR_POS_RETURN } },
          { CURSOR_POS_RETURN, { CURSOR_POS_WARUAGAKI, CURSOR_POS_RETURN, CURSOR_POS_MEGA, CURSOR_POS_RETURN } },
          { CURSOR_POS_WARUAGAKI, { CURSOR_POS_WARUAGAKI, CURSOR_POS_RETURN, CURSOR_POS_WARUAGAKI, CURSOR_POS_WARUAGAKI } },
        }
      },




    };






    // {^Ƃ̐ݒ
    const RotationWazaSelect::ButtonDesc RotationWazaSelect::BUTTON_DESC[ RotationWazaSelect::CURSOR_POS_NUM ] =
    {
      /* CURSOR_POS_WAZA0 */
      {
        WazaSelectBase::RESULT_SELECT, 
        0,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_00_PLATE,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + CURSOR_POS_WAZA0 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + CURSOR_POS_WAZA0 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + CURSOR_POS_WAZA0 ),
        static_cast<AnimationIndex>( ANIMATION_WAZA0_ACTIVE ),
        static_cast<AnimationIndex>( ANIMATION_WAZA0_PASSIVE ),
        static_cast<AnimationIndex>( ANIMATION_CURSOR_ON_WAZA0 ),
      }, 
      /* CURSOR_POS_WAZA1 */
      {
        WazaSelectBase::RESULT_SELECT, 
        1,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_01_PLATE,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + CURSOR_POS_WAZA1 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + CURSOR_POS_WAZA1 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + CURSOR_POS_WAZA1 ),
        static_cast<AnimationIndex>( ANIMATION_WAZA1_ACTIVE ),
        static_cast<AnimationIndex>( ANIMATION_WAZA1_PASSIVE ),
        static_cast<AnimationIndex>( ANIMATION_CURSOR_ON_WAZA1 ),
      }, 
      /* CURSOR_POS_WAZA2 */
      {
        WazaSelectBase::RESULT_SELECT, 
        2,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_02_PLATE,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + CURSOR_POS_WAZA2 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + CURSOR_POS_WAZA2 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + CURSOR_POS_WAZA2 ),
        static_cast<AnimationIndex>( ANIMATION_WAZA2_ACTIVE ),
        static_cast<AnimationIndex>( ANIMATION_WAZA2_PASSIVE ),
        static_cast<AnimationIndex>( ANIMATION_CURSOR_ON_WAZA2 ),
      }, 
      /* CURSOR_POS_WAZA3 */
      {
        WazaSelectBase::RESULT_SELECT, 
        3,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_03_PLATE,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + CURSOR_POS_WAZA3 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + CURSOR_POS_WAZA3 ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + CURSOR_POS_WAZA3 ),
        static_cast<AnimationIndex>( ANIMATION_WAZA3_ACTIVE ),
        static_cast<AnimationIndex>( ANIMATION_WAZA3_PASSIVE ),
        static_cast<AnimationIndex>( ANIMATION_CURSOR_ON_WAZA3 ),
      }, 
      /* CURSOR_POS_LEFT */
      {
        WazaSelectBase::RESULT_MOVE_LEFT,
        0,
        PANENAME_WAZA_SELECT_ROTATION_PANE_ROT_L_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + CURSOR_POS_LEFT ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + CURSOR_POS_LEFT ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + CURSOR_POS_LEFT ),
        static_cast<AnimationIndex>( ANIMATION_LEFT_ACTIVE ),
        static_cast<AnimationIndex>( ANIMATION_LEFT_PASSIVE ),
        static_cast<AnimationIndex>( ANIMATION_CURSOR_ON_LEFT ),
      }, 
      /* CURSOR_POS_RIGHT */
      {
        WazaSelectBase::RESULT_MOVE_RIGHT,
        0,
        PANENAME_WAZA_SELECT_ROTATION_PANE_ROT_R_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + CURSOR_POS_RIGHT ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + CURSOR_POS_RIGHT ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + CURSOR_POS_RIGHT ),
        static_cast<AnimationIndex>( ANIMATION_RIGHT_ACTIVE ),
        static_cast<AnimationIndex>( ANIMATION_RIGHT_PASSIVE ),
        static_cast<AnimationIndex>( ANIMATION_CURSOR_ON_RIGHT ),
      }, 
      /* CURSOR_POS_MEGA */
      {
        WazaSelectBase::RESULT_MEGA,
        0,
        PANENAME_WAZA_SELECT_ROTATION_PANE_MEGA_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + CURSOR_POS_MEGA ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + CURSOR_POS_MEGA ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + CURSOR_POS_MEGA ),
        static_cast<AnimationIndex>( ANIMATION_MEGA_ACTIVE ),
        static_cast<AnimationIndex>( ANIMATION_MEGA_PASSIVE ),
        static_cast<AnimationIndex>( ANIMATION_CURSOR_ON_MEGA ),
      }, 
      /* CURSOR_POS_RETURN */
      {
        WazaSelectBase::RESULT_RETURN,
        0,
        PANENAME_WAZA_SELECT_ROTATION_PANE_RETURN_BUTTON,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + CURSOR_POS_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + CURSOR_POS_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + CURSOR_POS_RETURN ),
        static_cast<AnimationIndex>( ANIMATION_NULL ),
        static_cast<AnimationIndex>( ANIMATION_NULL ),
        static_cast<AnimationIndex>( ANIMATION_CURSOR_ON_RETURN ),
      }, 
      /* CURSOR_POS_WARUAGAKI */
      {
        WazaSelectBase::RESULT_WARUAGAKI,
        0,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WARUAGAKI_PLATE,
        static_cast<AnimationIndex>( ANIMATION_BUTTON_HOLD + CURSOR_POS_WARUAGAKI ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_RELEASE + CURSOR_POS_WARUAGAKI ),
        static_cast<AnimationIndex>( ANIMATION_BUTTON_SELECT + CURSOR_POS_WARUAGAKI ),
        static_cast<AnimationIndex>( ANIMATION_NULL ),
        static_cast<AnimationIndex>( ANIMATION_NULL ),
        static_cast<AnimationIndex>( ANIMATION_CURSOR_ON_WARUAGAKI ),
      },
    };



    // Aj[Vf[^
    const gfl::grp::g2d::LytArcIndex RotationWazaSelect::ANIMATION_DATA_TABLE[ RotationWazaSelect::ANIMATION_DATA_NUM ] = 
    {
      /* ANIMATION_DATA_DUMMY_BALL_NORMAL */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_DUMMY_BALL_NORMAL_BCLAN,
      /* ANIMATION_DATA_DUMMY_BALL_SICK */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_DUMMY_BALL_SICK_BCLAN,
      /* ANIMATION_DATA_DUMMY_BALL_DEAD */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_DUMMY_BALL_DEAD_BCLAN,
      /* ANIMATION_DATA_DUMMY_BALL_NULL */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_DUMMY_BALL_NULL_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_HOLD */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_DUMMY_BUTTON_HOLD_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_RELEASE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_DUMMY_BUTTON_RELEASE_BCLAN,
      /* ANIMATION_DATA_DUMMY_BUTTON_SELECT */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_DUMMY_BUTTON_SELECT_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA0 */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_CURSOR_ON_WAZA_00_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA1 */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_CURSOR_ON_WAZA_01_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA2 */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_CURSOR_ON_WAZA_02_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WAZA3 */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_CURSOR_ON_WAZA_03_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_LEFT */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_CURSOR_ON_ROT_L_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_RIGHT */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_CURSOR_ON_ROT_R_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_MEGA */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_CURSOR_ON_MEGA_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_RETURN */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_CURSOR_ON_RETURN_BCLAN,
      /* ANIMATION_DATA_CURSOR_ON_WARUAGAKI */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_CURSOR_ON_WARUAGAKI_BCLAN,
      /* ANIMATION_DATA_WAZA0_TYPE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_00_TYPE_BCLAN,
      /* ANIMATION_DATA_WAZA0_EXIST */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_00_EXIST_BCLAN,
      /* ANIMATION_DATA_WAZA0_NULL */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_00_NULL_BCLAN,
      /* ANIMATION_DATA_WAZA0_ACTIVE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_00_ACTIVE_BCLAN,
      /* ANIMATION_DATA_WAZA0_PASSIVE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_00_PASSIVE_BCLAN, 
      /* ANIMATION_DATA_WAZA0_PP_FULL */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_00_PP_FULL_BCLAN, 
      /* ANIMATION_DATA_WAZA0_PP_HALF */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_00_PP_HALF_BCLAN, 
      /* ANIMATION_DATA_WAZA0_PP_LOW */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_00_PP_LOW_BCLAN, 
      /* ANIMATION_DATA_WAZA0_PP_ZERO */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_00_PP_ZERO_BCLAN, 
      /* ANIMATION_DATA_WAZA1_TYPE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_01_TYPE_BCLAN,
      /* ANIMATION_DATA_WAZA1_EXIST */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_01_EXIST_BCLAN,
      /* ANIMATION_DATA_WAZA1_NULL */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_01_NULL_BCLAN,
      /* ANIMATION_DATA_WAZA1_ACTIVE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_01_ACTIVE_BCLAN,
      /* ANIMATION_DATA_WAZA1_PASSIVE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_01_PASSIVE_BCLAN, 
      /* ANIMATION_DATA_WAZA1_PP_FULL */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_01_PP_FULL_BCLAN, 
      /* ANIMATION_DATA_WAZA1_PP_HALF */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_01_PP_HALF_BCLAN, 
      /* ANIMATION_DATA_WAZA1_PP_LOW */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_01_PP_LOW_BCLAN, 
      /* ANIMATION_DATA_WAZA1_PP_ZERO */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_01_PP_ZERO_BCLAN, 
      /* ANIMATION_DATA_WAZA2_TYPE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_02_TYPE_BCLAN,
      /* ANIMATION_DATA_WAZA2_EXIST */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_02_EXIST_BCLAN,
      /* ANIMATION_DATA_WAZA2_NULL */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_02_NULL_BCLAN,
      /* ANIMATION_DATA_WAZA2_ACTIVE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_02_ACTIVE_BCLAN,
      /* ANIMATION_DATA_WAZA2_PASSIVE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_02_PASSIVE_BCLAN, 
      /* ANIMATION_DATA_WAZA2_PP_FULL */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_02_PP_FULL_BCLAN, 
      /* ANIMATION_DATA_WAZA2_PP_HALF */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_02_PP_HALF_BCLAN, 
      /* ANIMATION_DATA_WAZA2_PP_LOW */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_02_PP_LOW_BCLAN, 
      /* ANIMATION_DATA_WAZA2_PP_ZERO */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_02_PP_ZERO_BCLAN, 
      /* ANIMATION_DATA_WAZA3_TYPE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_03_TYPE_BCLAN,
      /* ANIMATION_DATA_WAZA3_EXIST */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_03_EXIST_BCLAN,
      /* ANIMATION_DATA_WAZA3_NULL */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_03_NULL_BCLAN,
      /* ANIMATION_DATA_WAZA3_ACTIVE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_03_ACTIVE_BCLAN,
      /* ANIMATION_DATA_WAZA3_PASSIVE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_03_PASSIVE_BCLAN,
      /* ANIMATION_DATA_WAZA3_PP_FULL */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_03_PP_FULL_BCLAN, 
      /* ANIMATION_DATA_WAZA3_PP_HALF */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_03_PP_HALF_BCLAN, 
      /* ANIMATION_DATA_WAZA3_PP_LOW */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_03_PP_LOW_BCLAN, 
      /* ANIMATION_DATA_WAZA3_PP_ZERO */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WAZA_03_PP_ZERO_BCLAN, 
      /* ANIMATION_DATA_WARUAGAKI_VISIBLE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WARUAGAKI_VISIBLE_BCLAN,
      /* ANIMATION_DATA_WARUAGAKI_INVISIBLE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_WARUAGAKI_INVISIBLE_BCLAN,
      /* ANIMATION_DATA_MEGA_VISIBLE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_MEGA_BUTTON_VISIBLE_BCLAN,
      /* ANIMATION_DATA_MEGA_INVISIBLE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_MEGA_BUTTON_INVISIBLE_BCLAN,
      /* ANIMATION_DATA_MEGA_ACTIVE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_MEGA_BUTTON_ACTIVE_BCLAN,
      /* ANIMATION_DATA_MEGA_PASSIVE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_MEGA_BUTTON_PASSIVE_BCLAN,
      /* ANIMATION_DATA_LEFT_VISIBLE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_ROT_L_BUTTON_VISIBLE_BCLAN,
      /* ANIMATION_DATA_LEFT_INVISIBLE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_ROT_L_BUTTON_INVISIBLE_BCLAN,
      /* ANIMATION_DATA_LEFT_ACTIVE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_ROT_L_BUTTON_ACTIVE_BCLAN,
      /* ANIMATION_DATA_LEFT_PASSIVE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_ROT_L_BUTTON_PASSIVE_BCLAN,
      /* ANIMATION_DATA_RIGHT_VISIBLE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_ROT_R_BUTTON_VISIBLE_BCLAN,
      /* ANIMATION_DATA_RIGHT_INVISIBLE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_ROT_R_BUTTON_INVISIBLE_BCLAN,
      /* ANIMATION_DATA_RIGHT_ACTIVE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_ROT_R_BUTTON_ACTIVE_BCLAN,
      /* ANIMATION_DATA_RIGHT_PASSIVE */ LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_ROT_R_BUTTON_PASSIVE_BCLAN,
    };




    // LAj[V̐ݒ
    const RotationWazaSelect::ShareAnimationDesc RotationWazaSelect::SHARE_ANIMATION_DESC[ RotationWazaSelect::SHARE_ANIMATION_NUM ] = 
    {
      /* SHARE_ANIMATION_MYBALL_NORMAL */
      {
        ANIMATION_MYBALL00_NORMAL, 
        ANIMATION_DATA_DUMMY_BALL_NORMAL,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_WAZA_SELECT_ROTATION_GROUP_MY_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_MYBALL_SICK */
      {
        ANIMATION_MYBALL00_SICK, 
        ANIMATION_DATA_DUMMY_BALL_SICK,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_WAZA_SELECT_ROTATION_GROUP_MY_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_MYBALL_DEAD */
      {
        ANIMATION_MYBALL00_DEAD, 
        ANIMATION_DATA_DUMMY_BALL_DEAD,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_WAZA_SELECT_ROTATION_GROUP_MY_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_MYBALL_NULL */
      {
        ANIMATION_MYBALL00_NULL, 
        ANIMATION_DATA_DUMMY_BALL_NULL,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_WAZA_SELECT_ROTATION_GROUP_MY_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_ENBALL_NORMAL */
      {
        ANIMATION_ENBALL00_NORMAL, 
        ANIMATION_DATA_DUMMY_BALL_NORMAL,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_WAZA_SELECT_ROTATION_GROUP_EN_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_ENBALL_SICK */
      {
        ANIMATION_ENBALL00_SICK, 
        ANIMATION_DATA_DUMMY_BALL_SICK,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_WAZA_SELECT_ROTATION_GROUP_EN_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_ENBALL_DEAD */
      {
        ANIMATION_ENBALL00_DEAD, 
        ANIMATION_DATA_DUMMY_BALL_DEAD,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_WAZA_SELECT_ROTATION_GROUP_EN_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_ENBALL_NULL */
      {
        ANIMATION_ENBALL00_NULL, 
        ANIMATION_DATA_DUMMY_BALL_NULL,
        pml::PokeParty::MAX_MEMBERS,
        PANENAME_WAZA_SELECT_ROTATION_GROUP_EN_BALL,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_BUTTON_HOLD */
      {
        ANIMATION_BUTTON_HOLD, 
        ANIMATION_DATA_DUMMY_BUTTON_HOLD,
        CURSOR_POS_NUM,
        PANENAME_WAZA_SELECT_ROTATION_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_BUTTON_RELEASE */
      {
        ANIMATION_BUTTON_RELEASE, 
        ANIMATION_DATA_DUMMY_BUTTON_RELEASE,
        CURSOR_POS_NUM,
        PANENAME_WAZA_SELECT_ROTATION_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
      /* SHARE_ANIMATION_BUTTON_SELECT */
      {
        ANIMATION_BUTTON_SELECT, 
        ANIMATION_DATA_DUMMY_BUTTON_SELECT,
        CURSOR_POS_NUM,
        PANENAME_WAZA_SELECT_ROTATION_GROUP_BUTTON,
        gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,  // O[v̑SẴyCɓo^
      },
    };





    // Z{^Ƃ̏
    const RotationWazaSelect::WazaButtonDesc RotationWazaSelect::WAZA_BUTTON_DESC[ RotationWazaSelect::WAZA_BUTTON_NUM ] = 
    {
      /* WAZA_BUTTON_LT */
      {
        0,
        CURSOR_POS_WAZA0,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_00_NAME,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_00_PP,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_00_PP_VAL,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_00_PP_MAX,
        ANIMATION_WAZA0_TYPE,
        ANIMATION_WAZA0_EXIST,
        ANIMATION_WAZA0_NULL,
        ANIMATION_WAZA0_ACTIVE,
        ANIMATION_WAZA0_PASSIVE,
        ANIMATION_WAZA0_PP_FULL,
        ANIMATION_WAZA0_PP_HALF,
        ANIMATION_WAZA0_PP_LOW,
        ANIMATION_WAZA0_PP_ZERO,
      },
      /* WAZA_BUTTON_RT */
      {
        1,
        CURSOR_POS_WAZA1,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_01_NAME,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_01_PP,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_01_PP_VAL,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_01_PP_MAX,
        ANIMATION_WAZA1_TYPE,
        ANIMATION_WAZA1_EXIST,
        ANIMATION_WAZA1_NULL,
        ANIMATION_WAZA1_ACTIVE,
        ANIMATION_WAZA1_PASSIVE,
        ANIMATION_WAZA1_PP_FULL,
        ANIMATION_WAZA1_PP_HALF,
        ANIMATION_WAZA1_PP_LOW,
        ANIMATION_WAZA1_PP_ZERO,
      },
      /* WAZA_BUTTON_LB */
      {
        2,
        CURSOR_POS_WAZA2,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_02_NAME,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_02_PP,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_02_PP_VAL,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_02_PP_MAX,
        ANIMATION_WAZA2_TYPE,
        ANIMATION_WAZA2_EXIST,
        ANIMATION_WAZA2_NULL,
        ANIMATION_WAZA2_ACTIVE,
        ANIMATION_WAZA2_PASSIVE,
        ANIMATION_WAZA2_PP_FULL,
        ANIMATION_WAZA2_PP_HALF,
        ANIMATION_WAZA2_PP_LOW,
        ANIMATION_WAZA2_PP_ZERO,
      },
      /* WAZA_BUTTON_RB */
      {
        3,
        CURSOR_POS_WAZA3,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_03_NAME,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_03_PP,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_03_PP_VAL,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WAZA_03_PP_MAX,
        ANIMATION_WAZA3_TYPE,
        ANIMATION_WAZA3_EXIST,
        ANIMATION_WAZA3_NULL,
        ANIMATION_WAZA3_ACTIVE,
        ANIMATION_WAZA3_PASSIVE,
        ANIMATION_WAZA3_PP_FULL,
        ANIMATION_WAZA3_PP_HALF,
        ANIMATION_WAZA3_PP_LOW,
        ANIMATION_WAZA3_PP_ZERO,
      },
      /* WAZA_BUTTON_WARUAGAKI */
      {
        0,
        CURSOR_POS_WARUAGAKI,
        PANENAME_WAZA_SELECT_ROTATION_PANE_WARUAGAKI_NAME,
        0xffffffff,  // gpȂ
        0xffffffff,  // gpȂ
        0xffffffff,  // gpȂ
        ANIMATION_NULL,  // gpȂ
        ANIMATION_NULL,  // gpȂ
        ANIMATION_NULL,  // gpȂ
        ANIMATION_NULL,  // gpȂ
        ANIMATION_NULL,  // gpȂ
        ANIMATION_NULL,  // gpȂ
        ANIMATION_NULL,  // gpȂ
        ANIMATION_NULL,  // gpȂ
        ANIMATION_NULL,  // gpȂ
      },
    };





    // ̃{[Ƃ̐ݒ
    const RotationWazaSelect::BallDesc RotationWazaSelect::MY_BALL_DESC[ pml::PokeParty::MAX_MEMBERS ] = 
    {
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 0 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 0 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 0 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 0 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 1 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 1 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 1 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 1 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 2 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 2 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 2 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 2 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 3 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 3 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 3 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 3 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 4 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 4 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 4 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 4 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NORMAL + 5 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_SICK + 5 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_DEAD + 5 ),
        static_cast<AnimationIndex>( ANIMATION_MYBALL00_NULL + 5 ),
      },
    };



    // ̃{[Ƃ̐ݒ
    const RotationWazaSelect::BallDesc RotationWazaSelect::ENEMY_BALL_DESC[ pml::PokeParty::MAX_MEMBERS ] =
    {
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 0 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 0 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 0 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 0 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 1 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 1 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 1 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 1 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 2 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 2 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 2 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 2 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 3 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 3 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 3 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 3 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 4 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 4 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 4 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 4 ),
      },
      {
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NORMAL + 5 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_SICK + 5 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_DEAD + 5 ),
        static_cast<AnimationIndex>( ANIMATION_ENBALL00_NULL + 5 ),
      },
    };





    //---------------------------------------------------------------------------------
    // RXgN^
    //---------------------------------------------------------------------------------
    RotationWazaSelect::RotationWazaSelect( 
        gfl::heap::HeapBase* heap, 
        gfl::heap::HeapBase* device_heap, 
        const WazaSelectBase::Setting& settings, 
        gfl::grp::g2d::LytSys* layout_system ) :
      WazaSelectBase( heap, APP_HEAPSIZE, device_heap, DEVICE_HEAPSIZE, settings ),
      AppDrawerBase(),
      m_init_flag( false ),
      m_seq( SEQ_WAIT_INPUT ),
      m_next_seq( SEQ_WAIT_INPUT ),
      m_button_manager( NULL ),
      m_cursor_manager( NULL ),
      m_layout_system( layout_system ),
      m_layout_work( NULL ),
      m_layout_resource_id( 0 ),
      m_wait_animation_index( ANIMATION_NULL )
    {
      if( !this->IsMoveLeftExist() && !this->IsMoveRightExist() ) {
        GFL_ASSERT(0);  // E{^݂Ȃp^[NG
      }
    }



    //---------------------------------------------------------------------------------
    // 
    //---------------------------------------------------------------------------------
    AppBase::InitResult RotationWazaSelect::Initialize( void )
    {
      if( !m_init_flag ) {
        m_init_flag = true;
        this->CreateCursorManager();
        this->InitializeGraphicsSystem();
        this->SetupFont();
        this->CreateLayoutWork();
        this->CreateShareAnimation();
        this->CreateButtonManager();
        this->SetupButtonManager();
        this->SetupMyBalls();
        this->SetupEnemyBalls();
        this->SetupWazaButtons();
        this->SetupMegaButton();
        this->SetupLeftButton();
        this->SetupRightButton();
        this->SetupWaruagakiButton();
        this->InitializeCursorPos();
      }
      return AppBase::INIT_RESULT_FINISH;
    }


    // J[\ǗIuWFNg𐶐
    void RotationWazaSelect::CreateCursorManager( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      CursorMovePattern move_pattern = this->GetCursorMovePattern();
      m_cursor_manager = GFL_NEW( heap ) 
        ::app::tool::CursorManager(
            CURSOR_MOVE_PATTERN_DESC[ move_pattern ].move_data, CURSOR_POS_NUM, heap, 0 );
    }


    // J[\ʒu
    void RotationWazaSelect::InitializeCursorPos( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      CursorMovePattern move_pattern = this->GetCursorMovePattern();
      CursorPos init_pos = CURSOR_MOVE_PATTERN_DESC[ move_pattern ].init_pos;
      m_cursor_manager->SetPos( init_pos );
      m_cursor_manager->InitMoveEnable();

      // J[\Aj[VJn
      this->StartAnimation( m_layout_work, BUTTON_DESC[ init_pos ].cursor_animation_index );
    }


    // J[\ړp^[擾
    RotationWazaSelect::CursorMovePattern RotationWazaSelect::GetCursorMovePattern( void )
    {
      if( this->IsWaruagakiOnly() ) {
        if( this->IsMegaExist() ) {
          if( this->IsMoveLeftExist() && this->IsMoveRightExist() ) {
            return CURSOR_MOVE_PATTERN_WARUAGAKI_MEGA_LEFT_RIGHT;
          }
          else if( this->IsMoveLeftExist() ) {
            return CURSOR_MOVE_PATTERN_WARUAGAKI_MEGA_LEFT;
          }
          else {
            return CURSOR_MOVE_PATTERN_WARUAGAKI_MEGA_RIGHT;
          }
        }
        else {
          if( this->IsMoveLeftExist() && this->IsMoveRightExist() ) {
            return CURSOR_MOVE_PATTERN_WARUAGAKI_LEFT_RIGHT;
          }
          else if( this->IsMoveLeftExist() ) {
            return CURSOR_MOVE_PATTERN_WARUAGAKI_LEFT;
          }
          else {
            return CURSOR_MOVE_PATTERN_WARUAGAKI_RIGHT;
          }
        }
      }
      else {
        if( this->IsMegaExist() ) {
          if( this->IsMoveLeftExist() && this->IsMoveRightExist() ) {
            return CURSOR_MOVE_PATTERN_MEGA_LEFT_RIGHT;
          }
          else if( this->IsMoveLeftExist() ) {
            return CURSOR_MOVE_PATTERN_MEGA_LEFT;
          }
          else {
            return CURSOR_MOVE_PATTERN_MEGA_RIGHT;
          }
        }
        else {
          if( this->IsMoveLeftExist() && this->IsMoveRightExist() ) {
            return CURSOR_MOVE_PATTERN_LEFT_RIGHT;
          }
          else if( this->IsMoveLeftExist() ) {
            return CURSOR_MOVE_PATTERN_LEFT;
          }
          else {
            return CURSOR_MOVE_PATTERN_RIGHT;
          }
        }
      }
    }



    // OtBbNXVXe
    void RotationWazaSelect::InitializeGraphicsSystem( void )
    {
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->InitializeApplicationMemory( nw_device_allocator );
    }


    // tHg̏
    void RotationWazaSelect::SetupFont( void )
    {
      gfl::grp::g2d::LytSys::SetDefaultFont( SystemFont_GetFont(), "cbf_std.bcfnt" );
    }


    // CAEg[N𐶐
    void RotationWazaSelect::CreateLayoutWork( void )
    {
      gfl::heap::HeapBase* heap = this->GetHeap();
      gfl::heap::NwAllocator* nw_device_allocator = this->GetNwDeviceAllocator();

      gfl::fs::ArcFile arc_file( ARCID_BATTLE_APP, heap );
      m_layout_resource_id = m_layout_system->LoadLytRes( 
          nw_device_allocator, &arc_file, GARC_btl_app_waza_select_rotation_LYTDAT );
      m_layout_system->TransferAllTexture( m_layout_resource_id, gfl::grp::MEMORY_AREA_FCRAM );

      m_layout_work = m_layout_system->CreateLytWk(
          m_layout_resource_id,
          LYTRES_WAZA_SELECT_ROTATION_WAZA_SELECT_ROTATION_BCLYT,
          ANIMATION_DATA_TABLE, ANIMATION_DATA_NUM, ANIMATION_NUM,
          &gfl::grp::g2d::c_LytWkLowerDefaultSetUp,
          false );  // Aj[VoChȂ

      m_layout_work->SetAutoDrawFlag( false );  // XV, `, jŊǗ
    }


    // LAj[V𐶐
    void RotationWazaSelect::CreateShareAnimation( void )
    {
      for( u32 i=0; i<SHARE_ANIMATION_NUM; i++ ) {
        m_layout_work->CreateShareAnime( 
            SHARE_ANIMATION_DESC[i].start_animation_index,
            ANIMATION_DATA_TABLE[ SHARE_ANIMATION_DESC[i].animation_data_index ],
            SHARE_ANIMATION_DESC[i].max_share_num,
            SHARE_ANIMATION_DESC[i].share_group_index,
            SHARE_ANIMATION_DESC[i].share_pane_index );
      }
    }


    // {^}l[W𐶐
    void RotationWazaSelect::CreateButtonManager( void )
    {
      const gfl::ui::DeviceManager* ui_device_manager = this->GetUiDeviceManager(); 
      gfl::heap::HeapBase* heap = this->GetHeap();
      m_button_manager = GFL_NEW( heap ) 
        ::app::tool::ButtonManager( heap, ui_device_manager, CURSOR_POS_NUM, ANIMATION_NULL );
    }


    // {^}l[WZbgAbv
    void RotationWazaSelect::SetupButtonManager( void )
    {
      for( u32 i=0; i<CURSOR_POS_NUM; i++ ) {
        m_button_manager->AddButton( 
            GetHeap(), 
            i,
            m_layout_work,
            BUTTON_DESC[i].pane_index,
            BUTTON_DESC[i].hold_animation_index,
            BUTTON_DESC[i].release_animation_index,
            BUTTON_DESC[i].select_animation_index,
            BUTTON_DESC[i].active_animation_index,
            BUTTON_DESC[i].passive_animation_index,
            NULL );  // R[obNȂ
      }
    }









    //---------------------------------------------------------------------------------
    // fXgN^
    //---------------------------------------------------------------------------------
    RotationWazaSelect::~RotationWazaSelect()
    {
      if( m_init_flag ) {
        this->DeleteButtonManager();
        this->DeleteLayoutWork();
        this->FinalizeGraphicsSystem();
        this->DeleteCursorManager();
      }
    }

    // {^}l[Wj
    void RotationWazaSelect::DeleteButtonManager( void )
    {
      if( m_button_manager ) {
        GFL_DELETE m_button_manager;
      }
    }

    // CAEg[Nj
    void RotationWazaSelect::DeleteLayoutWork( void ) 
    {
      m_layout_system->RemoveLytWk( m_layout_work );
      m_layout_system->ReleaseLytRes( m_layout_resource_id );
    }

    // OtBbNXVXȅI
    void RotationWazaSelect::FinalizeGraphicsSystem( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      graphics_system->FinalizeApplicationMemory();
    }


    // J[\ǗIuWFNgj
    void RotationWazaSelect::DeleteCursorManager( void )
    {
      GFL_DELETE m_cursor_manager;
    }







    //---------------------------------------------------------------------------------
    // V[PXZbg
    //---------------------------------------------------------------------------------
    void RotationWazaSelect::ResetSequence( void )
    {
      m_seq = SEQ_WAIT_INPUT;
      m_next_seq = SEQ_WAIT_INPUT;
      this->SetupMyBalls();
      this->SetupEnemyBalls();
      this->SetupWazaButtons();
      this->SetupMegaButton();
      this->SetupLeftButton();
      this->SetupRightButton();
      this->SetupWaruagakiButton();
      this->InitializeCursorPos();
    }



    // SĂ̋Z{^̃ZbgAbv
    void RotationWazaSelect::SetupWazaButtons( void )
    {
      this->SetupWazaButton( WAZA_BUTTON_LT );
      this->SetupWazaButton( WAZA_BUTTON_RT );
      this->SetupWazaButton( WAZA_BUTTON_LB );
      this->SetupWazaButton( WAZA_BUTTON_RB );
    }


    // Z{^̃ZbgAbv
    void RotationWazaSelect::SetupWazaButton( WazaButtonIndex waza_button_index )
    {
      const pml::pokepara::PokemonParam* poke_param = this->GetMyPokeParam();
      u8 waza_index = WAZA_BUTTON_DESC[ waza_button_index ].waza_index;
      WazaNo wazano = poke_param->GetWazaNo( waza_index );
      CursorPos cursor_pos = WAZA_BUTTON_DESC[ waza_button_index ].cursor_pos;

      if( wazano == WAZANO_NULL ) {
        this->SetWazaButtonDisplay_Null( waza_button_index );
        m_button_manager->SetButtonPassive( cursor_pos );
      }
      else {
        pml::PokeType waza_type = pml::System::WazaDataSystem()->GetType( wazano );
        this->SetWazaButtonDisplay_Strings( waza_button_index );
        this->SetWazaButtonDisplay_Exist( waza_button_index );
        this->SetWazaButtonDisplay_Type( waza_button_index, waza_type );
        this->SetWazaButtonDisplay_PPColor( waza_button_index );
        if( !this->IsWazaSelectEnable() || this->IsWaruagakiOnly() ) {
          m_button_manager->SetButtonPassive( cursor_pos );
        }
        else {
          m_button_manager->SetButtonActive( cursor_pos );
        }
      }
    }


    // Z{^ɕZbg
    void RotationWazaSelect::SetWazaButtonDisplay_Strings( WazaButtonIndex waza_button_index )
    {
      const pml::pokepara::PokemonParam* poke_param = this->GetMyPokeParam();
      u8 waza_index = WAZA_BUTTON_DESC[ waza_button_index ].waza_index;
      WazaNo wazano = poke_param->GetWazaNo( waza_index ); 
      u16 pp_value = poke_param->GetWazaPP( waza_index );
      u16 pp_max = poke_param->GetWazaMaxPP( waza_index );
      this->SetTextboxPaneWazaName( m_layout_work,
          WAZA_BUTTON_DESC[ waza_button_index ].waza_name_pane_index, wazano );
      this->SetTextboxPaneMessage( m_layout_work, 
          WAZA_BUTTON_DESC[ waza_button_index ].pp_label_pane_index, STR_PP );
      this->SetTextboxPaneNumber( m_layout_work, 
          WAZA_BUTTON_DESC[ waza_button_index ].pp_value_pane_index, pp_value, KETA_PP_VALUE );
      this->SetTextboxPaneNumber( m_layout_work, 
          WAZA_BUTTON_DESC[ waza_button_index ].pp_max_pane_index, pp_max, KETA_PP_MAX );
    } 

    // Z{^Z݂Ԃɂ
    void RotationWazaSelect::SetWazaButtonDisplay_Exist( WazaButtonIndex waza_button_index )
    {
      this->StopAnimation( m_layout_work, 
          WAZA_BUTTON_DESC[ waza_button_index ].null_animation_index );
      this->StartAnimation( m_layout_work, 
          WAZA_BUTTON_DESC[ waza_button_index ].exist_animation_index );
    }

    // Z{^Z݂ȂԂɂ
    void RotationWazaSelect::SetWazaButtonDisplay_Null( WazaButtonIndex waza_button_index )
    {
      this->StopAnimation( m_layout_work, 
          WAZA_BUTTON_DESC[ waza_button_index ].exist_animation_index );
      this->StartAnimation( m_layout_work, 
          WAZA_BUTTON_DESC[ waza_button_index ].null_animation_index );
    } 

    // Z{^̃^CvZbg
    void RotationWazaSelect::SetWazaButtonDisplay_Type( WazaButtonIndex waza_button_index, pml::PokeType type )
    {
      AnimationIndex anime_index = WAZA_BUTTON_DESC[ waza_button_index ].type_animation_index;
      if( !m_layout_work->IsBindAnime( anime_index ) ) {
        m_layout_work->BindAnime( anime_index );
      }
      m_layout_work->SetAutoAnime( anime_index, false );
      m_layout_work->SetAnimeFrame( anime_index, type );  // t[ƃ^Cvlv
    }

    // PP̕\J[Zbg
    void RotationWazaSelect::SetWazaButtonDisplay_PPColor( WazaButtonIndex waza_button_index )
    {
      const pml::pokepara::PokemonParam* poke_param = this->GetMyPokeParam();
      u8 waza_index = WAZA_BUTTON_DESC[ waza_button_index ].waza_index;
      u16 pp_max = poke_param->GetWazaMaxPP( waza_index );
      u16 pp_value = poke_param->GetWazaPP( waza_index );
      f32 pp_rate = static_cast<f32>( pp_value ) / static_cast<f32>( pp_max );
      if( 0.5f < pp_rate ) {
        this->StartAnimation( m_layout_work, WAZA_BUTTON_DESC[ waza_button_index ].pp_full_animation_index );
        this->StopAnimation( m_layout_work, WAZA_BUTTON_DESC[ waza_button_index ].pp_half_animation_index );
        this->StopAnimation( m_layout_work, WAZA_BUTTON_DESC[ waza_button_index ].pp_low_animation_index );
        this->StopAnimation( m_layout_work, WAZA_BUTTON_DESC[ waza_button_index ].pp_zero_animation_index );
      }
      else if( 0.25f < pp_rate ) {
        this->StopAnimation( m_layout_work, WAZA_BUTTON_DESC[ waza_button_index ].pp_full_animation_index );
        this->StartAnimation( m_layout_work, WAZA_BUTTON_DESC[ waza_button_index ].pp_half_animation_index );
        this->StopAnimation( m_layout_work, WAZA_BUTTON_DESC[ waza_button_index ].pp_low_animation_index );
        this->StopAnimation( m_layout_work, WAZA_BUTTON_DESC[ waza_button_index ].pp_zero_animation_index );
      }
      else if( 0.0f < pp_rate ) {
        this->StopAnimation( m_layout_work, WAZA_BUTTON_DESC[ waza_button_index ].pp_full_animation_index );
        this->StopAnimation( m_layout_work, WAZA_BUTTON_DESC[ waza_button_index ].pp_half_animation_index );
        this->StartAnimation( m_layout_work, WAZA_BUTTON_DESC[ waza_button_index ].pp_low_animation_index );
        this->StopAnimation( m_layout_work, WAZA_BUTTON_DESC[ waza_button_index ].pp_zero_animation_index );
      }
      else {
        this->StopAnimation( m_layout_work, WAZA_BUTTON_DESC[ waza_button_index ].pp_full_animation_index );
        this->StopAnimation( m_layout_work, WAZA_BUTTON_DESC[ waza_button_index ].pp_half_animation_index );
        this->StopAnimation( m_layout_work, WAZA_BUTTON_DESC[ waza_button_index ].pp_low_animation_index );
        this->StartAnimation( m_layout_work, WAZA_BUTTON_DESC[ waza_button_index ].pp_zero_animation_index );
      }
    }





    //u邠v{^̃ZbgAbv
    void RotationWazaSelect::SetupWaruagakiButton( void )
    {
      if( this->IsWaruagakiOnly() ) {
        m_button_manager->SetButtonActive( CURSOR_POS_WARUAGAKI );
        this->SetWaruagakiButtonDisplay_Visible();
        this->SetTextboxPaneWazaName( m_layout_work,
            WAZA_BUTTON_DESC[ WAZA_BUTTON_WARUAGAKI ].waza_name_pane_index, WAZANO_WARUAGAKI );
      }
      else {
        m_button_manager->SetButtonPassive( CURSOR_POS_WARUAGAKI );
        this->SetWaruagakiButtonDisplay_Invisible();
      }
    }

    //u邠v{^\
    void RotationWazaSelect::SetWaruagakiButtonDisplay_Visible( void )
    {
      this->StartAnimation( m_layout_work, ANIMATION_WARUAGAKI_VISIBLE );
      this->StopAnimation( m_layout_work, ANIMATION_WARUAGAKI_INVISIBLE );
    }

    //u邠v{^\ɂ
    void RotationWazaSelect::SetWaruagakiButtonDisplay_Invisible( void )
    {
      this->StopAnimation( m_layout_work, ANIMATION_WARUAGAKI_VISIBLE );
      this->StartAnimation( m_layout_work, ANIMATION_WARUAGAKI_INVISIBLE );
    }





    //uKiv{^̃ZbgAbv
    void RotationWazaSelect::SetupMegaButton( void )
    {
      if( !this->IsMegaExist() ) {  // ݂Ȃ
        m_button_manager->SetButtonPassive( CURSOR_POS_MEGA );
        this->SetMegaButtonDisplay_Invisible();
      }
      else if( !this->IsMegaEnable() ) {  // 邯ǉȂ
        m_button_manager->SetButtonPassive( CURSOR_POS_MEGA );
        this->SetMegaButtonDisplay_Visible();
      }
      else {  // 
        m_button_manager->SetButtonActive( CURSOR_POS_MEGA );
        this->SetMegaButtonDisplay_Visible();
      }
    }

    //uKiv{^\
    void RotationWazaSelect::SetMegaButtonDisplay_Visible( void )
    {
      this->StartAnimation( m_layout_work, ANIMATION_MEGA_VISIBLE );
      this->StopAnimation( m_layout_work, ANIMATION_MEGA_INVISIBLE );
    }

    //uKiv{^\ɂ
    void RotationWazaSelect::SetMegaButtonDisplay_Invisible( void )
    {
      this->StopAnimation( m_layout_work, ANIMATION_MEGA_VISIBLE );
      this->StartAnimation( m_layout_work, ANIMATION_MEGA_INVISIBLE );
    }






    //uֈړv{^̃ZbgAbv
    void RotationWazaSelect::SetupLeftButton( void )
    {
      if( !this->IsMoveLeftExist() ) {  // ݂Ȃ
        m_button_manager->SetButtonPassive( CURSOR_POS_LEFT );
        this->SetLeftButtonDisplay_Invisible();
      }
      else if( !this->IsMoveLeftEnable() ) {  // 邯ǉȂ
        m_button_manager->SetButtonPassive( CURSOR_POS_LEFT );
        this->SetLeftButtonDisplay_Visible();
      }
      else {  // 
        m_button_manager->SetButtonActive( CURSOR_POS_LEFT );
        this->SetLeftButtonDisplay_Visible();
      }
    }

    //uֈړv{^\
    void RotationWazaSelect::SetLeftButtonDisplay_Visible( void )
    {
      this->StartAnimation( m_layout_work, ANIMATION_LEFT_VISIBLE );
      this->StopAnimation( m_layout_work, ANIMATION_LEFT_INVISIBLE );
    }

    //uֈړv{^\ɂ
    void RotationWazaSelect::SetLeftButtonDisplay_Invisible( void )
    {
      this->StopAnimation( m_layout_work, ANIMATION_LEFT_VISIBLE );
      this->StartAnimation( m_layout_work, ANIMATION_LEFT_INVISIBLE );
    }







    //uEֈړv{^̃ZbgAbv
    void RotationWazaSelect::SetupRightButton( void )
    {
      if( !this->IsMoveRightExist() ) {  // ݂Ȃ
        m_button_manager->SetButtonPassive( CURSOR_POS_RIGHT );
        this->SetRightButtonDisplay_Invisible();
      }
      else if( !this->IsMoveRightEnable() ) {  // 邯ǉȂ
        m_button_manager->SetButtonPassive( CURSOR_POS_RIGHT );
        this->SetRightButtonDisplay_Visible();
      }
      else {  // 
        m_button_manager->SetButtonActive( CURSOR_POS_RIGHT );
        this->SetRightButtonDisplay_Visible();
      }
    }

    //uEֈړv{^\
    void RotationWazaSelect::SetRightButtonDisplay_Visible( void )
    {
      this->StartAnimation( m_layout_work, ANIMATION_RIGHT_VISIBLE );
      this->StopAnimation( m_layout_work, ANIMATION_RIGHT_INVISIBLE );
    }

    //uEֈړv{^\ɂ
    void RotationWazaSelect::SetRightButtonDisplay_Invisible( void )
    {
      this->StopAnimation( m_layout_work, ANIMATION_RIGHT_VISIBLE );
      this->StartAnimation( m_layout_work, ANIMATION_RIGHT_INVISIBLE );
    }






    // ̃{[̃ZbgAbv
    void RotationWazaSelect::SetupMyBalls( void )
    {
      if( this->IsMyPartyExist() ) {
        for( u32 i=0; i<pml::PokeParty::MAX_MEMBERS; i++ ) {
          this->SetupMyBall(i);
        }
      }
    }

    // w肵{[̕\XV
    void RotationWazaSelect::SetupMyBall( u8 ball_index )
    {
      const btl::BTL_PARTY* btl_party = this->GetMyParyt();
      u32 member_count = btl_party->GetMemberCount();

      if( member_count <= ball_index ) {
        this->SetMyBallDisplay_Null( ball_index );
      }
      else {
        const btl::BTL_POKEPARAM* btl_param = btl_party->GetMemberDataConst( ball_index );
        if( btl_param->IsDead() ) {
          this->SetMyBallDisplay_Dead( ball_index );
        }
        else if( btl_param->GetPokeSick() != pml::pokepara::SICK_NULL ) {
          this->SetMyBallDisplay_Sick( ball_index );
        }
        else {
          this->SetMyBallDisplay_Normal( ball_index );
        }
      }
    }

    // ̃{[ʏ̕\ɂ
    void RotationWazaSelect::SetMyBallDisplay_Normal( u8 ball_index )
    {
      this->StartAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[Ԉُ̕\ɂ
    void RotationWazaSelect::SetMyBallDisplay_Sick( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StartAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[m̕\ɂ
    void RotationWazaSelect::SetMyBallDisplay_Dead( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StartAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[̕\ɂ
    void RotationWazaSelect::SetMyBallDisplay_Null( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StartAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, MY_BALL_DESC[ ball_index ].null_animation_index );
    }








    // ̑S{[̕\XV
    void RotationWazaSelect::SetupEnemyBalls( void )
    {
      if( this->IsEnemyPartyExist() ) {
        for( u32 i=0; i<pml::PokeParty::MAX_MEMBERS; i++ ) {
          this->SetupEnemyBall(i);
        }
      }
    }

    // w肵{[̕\XV
    void RotationWazaSelect::SetupEnemyBall( u8 ball_index )
    {
      const btl::BTL_PARTY* btl_party = this->GetEnemyParty();
      u32 member_count = btl_party->GetMemberCount();

      if( member_count <= ball_index ) {
        this->SetEnemyBallDisplay_Null( ball_index );
      }
      else {
        const btl::BTL_POKEPARAM* btl_param = btl_party->GetMemberDataConst( ball_index );
        if( btl_param->IsDead() ) {
          this->SetEnemyBallDisplay_Dead( ball_index );
        }
        else if( btl_param->GetPokeSick() != pml::pokepara::SICK_NULL ) {
          this->SetEnemyBallDisplay_Sick( ball_index );
        }
        else {
          this->SetEnemyBallDisplay_Normal( ball_index );
        }
      }
    }


    // ̃{[ʏ̕\ɂ
    void RotationWazaSelect::SetEnemyBallDisplay_Normal( u8 ball_index )
    {
      this->StartAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[Ԉُ̕\ɂ
    void RotationWazaSelect::SetEnemyBallDisplay_Sick( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StartAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[m̕\ɂ
    void RotationWazaSelect::SetEnemyBallDisplay_Dead( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StartAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].null_animation_index );
    }

    // ̃{[̕\ɂ
    void RotationWazaSelect::SetEnemyBallDisplay_Null( u8 ball_index )
    {
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].normal_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].sick_animation_index );
      this->StartAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].dead_animation_index );
      this->StopAnimation( m_layout_work, ENEMY_BALL_DESC[ ball_index ].null_animation_index );
    }











    //---------------------------------------------------------------------------------
    // XV
    //---------------------------------------------------------------------------------
    void RotationWazaSelect::Update( void )
    { 
      m_button_manager->Update(); 
      this->UpdateSequence(); 
      m_layout_work->Update();
    }



    // V[PXXV
    void RotationWazaSelect::UpdateSequence( void )
    {
      const gfl::ui::Button* ui_button = 
        this->GetUiDeviceManager()->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );

      switch( m_seq )
      {
      case SEQ_WAIT_INPUT:
        if( m_button_manager->IsButtonSelected() ) {
          CursorPos cursor_pos = static_cast<CursorPos>( m_button_manager->GetSelectedButtonId() );
          if( this->IsSelectEnable( cursor_pos ) ) {
            this->SetResultByCursorPos( cursor_pos );
            this->StartSelectAnimation( cursor_pos );
            m_seq = SEQ_WAIT_ANIMATION;
            m_next_seq = SEQ_FINISH;
          }
        }
        else if( m_button_manager->IsButtonHolding() ) {
          // do nothing
        }
        else if( ui_button->IsTrigger( gfl::ui::BUTTON_A ) ) {
          CursorPos cursor_pos = this->GetCurrentCursorPos();
          if( this->IsSelectEnable( cursor_pos ) ) {
            this->SetResultByCursorPos( cursor_pos );
            this->StartSelectAnimation( cursor_pos );
            m_seq = SEQ_WAIT_ANIMATION;
            m_next_seq = SEQ_FINISH;
          }
        }
        else if( this->UpdateCursorMove() ) {  // J[\ړ
          CursorPos old_cursor_pos = this->GetPrevCursorPos();
          CursorPos new_cursor_pos = this->GetCurrentCursorPos();
          this->StartCursorMoveAnimation( old_cursor_pos, new_cursor_pos );
        }
        break;


      case SEQ_WAIT_ANIMATION:
        if( this->IsSelectAnimationFinished() ) {
          m_seq = m_next_seq;
        }
        break;


      default:
        GFL_ASSERT(0);
        // fall through

      case SEQ_FINISH:
        GFL_ASSERT( this->GetResult() != RESULT_NULL );
        this->Finish();
        break; 
      }
    }





    // J[\̓XV
    bool RotationWazaSelect::UpdateCursorMove( void )
    {
      ::app::tool::CursorManager::MOVE_RET move_result = m_cursor_manager->MainTrigger();
      return( move_result == ::app::tool::CursorManager::RET_MOVE ); // ړǂ
    } 


    // ݂̃J[\ʒu擾
    RotationWazaSelect::CursorPos RotationWazaSelect::GetCurrentCursorPos( void ) const
    {
      return static_cast<CursorPos>( m_cursor_manager->GetID() );
    } 


    // ÕJ[\ʒu擾
    RotationWazaSelect::CursorPos RotationWazaSelect::GetPrevCursorPos( void ) const
    {
      return static_cast<CursorPos>( m_cursor_manager->GetOldID() );
    }


    // J[\ړۂ̏
    void RotationWazaSelect::StartCursorMoveAnimation( 
        RotationWazaSelect::CursorPos old_cursor_pos, RotationWazaSelect::CursorPos new_cursor_pos )
    {
      this->StopAnimation( m_layout_work, BUTTON_DESC[ old_cursor_pos ].cursor_animation_index );
      this->StartAnimation( m_layout_work, BUTTON_DESC[ new_cursor_pos ].cursor_animation_index );
    }






    // I\ǂ𒲂ׂ
    bool RotationWazaSelect::IsSelectEnable( CursorPos cursor_pos ) const
    {
      bool button_activity = m_button_manager->IsButtonActive( cursor_pos );
      if( ( cursor_pos == CURSOR_POS_WAZA0 ) || ( cursor_pos == CURSOR_POS_WAZA1 ) ||
          ( cursor_pos == CURSOR_POS_WAZA2 ) || ( cursor_pos == CURSOR_POS_WAZA3 ) ) { 
        if( button_activity ) {
          const pml::pokepara::PokemonParam* poke_param = this->GetMyPokeParam();
          u8 waza_index = WAZA_BUTTON_DESC[ cursor_pos ].waza_index;
          u16 pp_value = poke_param->GetWazaPP( waza_index );
          return ( 0 < pp_value );  // 莝ZPP[ȂIs
        }
      }
      return button_activity;  // {^̗LɈˑ
    }


    // Iڂ, 쌋ʂZbg
    void RotationWazaSelect::SetResultByCursorPos( CursorPos cursor_pos )
    {
      this->SetResult( BUTTON_DESC[ cursor_pos ].result );
      this->SetSelectedWazaIndex( BUTTON_DESC[ cursor_pos ].waza_index );
    } 


    // {^̑IAj[VJn
    void RotationWazaSelect::StartSelectAnimation( CursorPos cursor_pos )
    {
      m_wait_animation_index = BUTTON_DESC[ cursor_pos ].select_animation_index;
      this->StartAnimation( m_layout_work, m_wait_animation_index );
    }


    // {^IAj[VIǂ𒲂ׂ
    bool RotationWazaSelect::IsSelectAnimationFinished( void ) const
    {
      if( m_wait_animation_index < ANIMATION_NUM ) {
        return m_layout_work->IsAnimeEnd( m_wait_animation_index );
      }
      return true;  // Aj[Vo^ȂIƂɂ
    }







    //-----------------------------------------------------------------------------------
    // `揈
    //-----------------------------------------------------------------------------------
    void RotationWazaSelect::Draw( void )
    {
      gfl::grp::GraphicsSystem* graphics_system = this->GetGraphicsSystem();
      gfl::grp::RenderTarget* lower_frame_buffer = graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
      m_layout_work->Draw( graphics_system, gfl::grp::DISPLAY_LOWER, lower_frame_buffer );
    }



  }  // namespace app
}  // namespace btl
