//=================================================================================================
/**
 * @file WazaSelectBase.h
 * @brief 퓬 > ZI > {`NX
 * @author obata_toshihiro
 * @date 2011.08.01
 */
//=================================================================================================
#ifndef __WAZASELECTBASE_H__
#define __WAZASELECTBASE_H__
#include <gflib.h>
#include "AppBase.h"


namespace btl {

  class BTL_PARTY;


  namespace app {

    class WazaSelectBase : public AppBase
    {
      GFL_FORBID_COPY_AND_ASSIGN( WazaSelectBase );  // Rs[֎~

      public:


      // ݒ
      struct Setting {
        bool mega_exist;            //uKiv{^̗L
        bool mega_enable;           //uKivI\ǂ
        bool waruagaki_only;        //u邠v݂̂ǂ
        bool move_center_enable;    //uւ̈ړv\ǂ
        bool move_left_enable;      //uւ̈ړv\ǂ
        bool move_right_enable;     //uEւ̈ړv\ǂ
        const BTL_PARTY* my_party;  // ̃|Pp[eB
        const BTL_PARTY* en_party;  // ̃|Pp[eB
        u8 poke_index;              // Ԗڂ̃|P
      };

      //---------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       * @param app_heap          gpAvP[Vq[v
       * @param app_heap_size     gpAvP[Vq[ṽTCY
       * @param device_heap       gpfoCXq[v
       * @param device_heap_size  gpfoCXq[ṽTCY
       * @param settings          ݒ
       */
      //---------------------------------------------------------------------------------
      WazaSelectBase( 
          gfl::heap::HeapBase* app_heap, u32 app_heap_size,
          gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
          const Setting& settings );

      //---------------------------------------------------------------------------------
      /**
       * @brief fXgN^
       */
      //---------------------------------------------------------------------------------
      virtual ~WazaSelectBase();




      // I
      enum Result {
        RESULT_RETURN,       //uǂvI
        RESULT_SELECT,       // 킴I
        RESULT_WARUAGAKI,    //u邠vI
        RESULT_MEGA,         //uKivI
        RESULT_MOVE_CENTER,  //uɈړvI
        RESULT_MOVE_LEFT,    //uɈړvI
        RESULT_MOVE_RIGHT,   //uEɈړvI
        RESULT_NULL,
      };
      //---------------------------------------------------------------------------------
      /**
       * @brief ʂ擾
       */
      //---------------------------------------------------------------------------------
      Result GetResult( void ) const;

      //---------------------------------------------------------------------------------
      /**
       * @brief IZ̃CfbNX擾
       */
      //---------------------------------------------------------------------------------
      u8 GetSelectedWazaIndex( void ) const;




      protected:
      const Setting& GetSetting( void ) const { return m_settings; }
      bool IsMegaExist( void ) const { return m_settings.mega_exist; }
      bool IsMegaEnable( void ) const { return m_settings.mega_enable; }
      bool IsWaruagakiOnly( void ) const { return m_settings.waruagaki_only; }
      bool IsMyPartyExist( void ) const { return ( m_settings.my_party != NULL ); }
      bool IsEnemyPartyExist( void ) const { return ( m_settings.en_party != NULL ); }
      const BTL_PARTY* GetMyParyt( void ) const { return m_settings.my_party; }
      const BTL_PARTY* GetEnemyParty( void ) const { return m_settings.en_party; }
      const pml::pokepara::PokemonParam* GetMyPokeParam( void ) const;

      void SetResult( Result result ) { m_result = result; }
      void SetSelectedWazaIndex( u8 index ) { m_selected_waza_index = index; } 


      private:
      Setting m_settings;
      Result m_result;
      u8 m_selected_waza_index;
    };


  }  // namespace app
}  // namespace btl


#endif // __WAZASELECTBASE_H__ 
