//=================================================================================================
/**
 * @file WazaSelectBase.cpp
 * @brief 퓬 ZI
 * @author obata_toshihiro
 * @date 2011.08.01
 */
//=================================================================================================
#include <gflib.h>
#include <battle/btl_party.h>
#include <battle/btl_pokeparam.h>
#include "AppBase.h"
#include "WazaSelectBase.h"


namespace btl {
  namespace app {


    //---------------------------------------------------------------------------------
    // RXgN^
    //---------------------------------------------------------------------------------
    WazaSelectBase::WazaSelectBase( 
        gfl::heap::HeapBase* app_heap, u32 app_heap_size,
        gfl::heap::HeapBase* device_heap, u32 device_heap_size, 
        const Setting& settings ) : 
      AppBase( app_heap, app_heap_size, device_heap, device_heap_size ),
      m_settings( settings ),
      m_result( RESULT_NULL ),
      m_selected_waza_index( 0 )
    {
    } 


    //---------------------------------------------------------------------------------
    // fXgN^
    //---------------------------------------------------------------------------------
    WazaSelectBase::~WazaSelectBase()
    {
    }



    //---------------------------------------------------------------------------------
    // ʂ擾
    //---------------------------------------------------------------------------------
    WazaSelectBase::Result WazaSelectBase::GetResult( void ) const
    {
      return m_result;
    }


    //---------------------------------------------------------------------------------
    // IZ̃CfbNX擾
    //---------------------------------------------------------------------------------
    u8 WazaSelectBase::GetSelectedWazaIndex( void ) const
    {
      return m_selected_waza_index;
    } 



    //=================================================================================
    // \Ώۂ̃|Pp[^擾
    //=================================================================================
    const pml::pokepara::PokemonParam* WazaSelectBase::GetMyPokeParam( void ) const
    {
      const BTL_PARTY* btl_party = m_settings.my_party;
      const BTL_POKEPARAM* btl_param = btl_party->GetMemberDataConst( m_settings.poke_index );
      return btl_param->GetSrcData();
    }



  }  // namespace app
}  // namespace btl
