//==============================================================================
/**
 * @file	MainDialog.cpp
 * @brief	
 * @author	kimura_shin
 * @data	2011/03/25, 10:22
 */
// =============================================================================

#include "MainDialog.h"

//==============================================================================
//==============================================================================
MainDialog::MainDialog( QWidget* parent ) : QDialog( parent )
{
	//	setAttribute( Qt::WA_DeleteOnClose );

	setWindowTitle( "킢eXg" );
	//	QWidget* wid = new QWidget;

	QVBoxLayout* layout = new QVBoxLayout;

	QComboBox* cbx = new QComboBox;
#define SET_CHARA(name,text) cbx->addItem(text);
#include "../Character.h"
	layout->addWidget( cbx );
	connect( cbx, SIGNAL( activated( int ) ), this, SLOT( ChangeCharacter( int ) ) );
	m_pLoveList = cbx = new QComboBox;
	//	cbx->setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Preferred );
#define SET_LOVE(name,label)	cbx->addItem( label );
#include "../LoveDef.h"
	connect( cbx, SIGNAL( activated( int ) ), this, SLOT( ChangeLove( int ) ) );
	layout->addWidget( cbx );

	QPushButton* pb = new QPushButton( "eXg" );
	connect( pb, SIGNAL( clicked( ) ), this, SLOT( Test( ) ) );
	layout->addWidget( pb );

	pb = new QPushButton( "eXg" );
	connect( pb, SIGNAL( clicked( ) ), this, SLOT( QuitTest( ) ) );
	layout->addWidget( pb );

#ifdef CLIENT_OF_3DS
	ClientBase::Initialize( );

	m_pClientRead = new ClientRead;
	m_pClientWrite = new ClientWrite;

	m_pClientRead->start( );
	m_pClientWrite->start( );
#endif

	setLayout( layout );

	//	resize( sizeHint( ).width( ) + 32, sizeHint( ).height( ) );
	show( );
}

//==============================================================================
//==============================================================================
MainDialog::~MainDialog( void )
{
#ifdef CLIENT_OF_3DS
	delete m_pClientRead;
	delete m_pClientWrite;
#endif
}

//==============================================================================
//==============================================================================
void MainDialog::ChangeLove( int id )
{
#ifdef CLIENT_OF_3DS
	m_pClientWrite->SendMes( QString( "CreateLove %1" ).arg( id ) );
#elif defined(GFL_PLATFORM_PC)
	kawaigari::Player::GetInstance( )->CreateLove( id, this );
#endif
}

//==============================================================================
//==============================================================================
void MainDialog::ChangeCharacter( int id )
{
#ifdef CLIENT_OF_3DS
	m_pClientWrite->SendMes( QString( "ChangeCharacter %1" ).arg( id ) );
#elif defined(GFL_PLATFORM_PC)
	kawaigari::Player::DestroyInstance( );

	static const char* RESOURCE_MODEL_FILES[] = {
#    define SET_CHARA(name,text) #name,
#    include "../Character.h"
	};
	c8 fname[0x100];
	strcpy( fname, "kawaigari/" );
	strcat( fname, RESOURCE_MODEL_FILES[id] );
	strcat( fname, ".gmp" );
	kawaigari::Player* pl = kawaigari::Player::CreateInstance( 0 );
	pl->Initialize( id, fname, 0 );
	if( id ){
		pl->m_LoveCoe = 1.8f;
		pl->m_LoveLimitCoe = 0.5f;
	} else {
		pl->m_LoveCoe = 1.0f;
		pl->m_LoveLimitCoe = 1.0f;
	}
#endif
}

//==============================================================================
//==============================================================================
void MainDialog::Test( void )
{
#ifdef CLIENT_OF_3DS
	m_pClientWrite->SendMes( "TestLove 0" );
#elif defined(GFL_PLATFORM_PC)
	kawaigari::LoveBase* lv = kawaigari::Player::GetInstance( )->GetLove( );
	if( !lv ){
		kawaigari::Player::GetInstance( )->CreateLove( m_pLoveList->currentIndex( ) );
	}
#endif
}
//==============================================================================
//==============================================================================
void MainDialog::QuitTest( void )
{
#ifdef CLIENT_OF_3DS
	//	m_pClientWrite->SendMes( "TestLove 0" );
#elif defined(GFL_PLATFORM_PC)
	kawaigari::Player::GetInstance( )->SetTouching(false);
//	kawaigari::Player::GetInstance( )->DestroyLove( );
#endif
}
