//======================================================================
/**
 * @file	seqfile.cpp
 * @brief	SequenceEditorXNvgt@C
 * @author	ariizumi
 * @data	11/8/1
 */
//======================================================================

#include <gflib.h>
#include "tool/seqeditor/seq_editor.h"
#include "tool/seqeditor/seq_file.h"

namespace tool
{
namespace seqeditor
{

SeqFile::SeqFile( SeqSystem *system , gfl::heap::HeapBase *heapMem , gfl::fs::ArcFile *arc , gfl::fs::ArcFile::ARCDATID arcId )
:mSystem(system)
{
  const size_t size = arc->GetDataSize( arcId ); 
  mSeqData = GflHeapAllocMemory( heapMem , size );
  
  arc->LoadData( arcId , mSeqData );
#if SEQ_EDITOR_DEBUG 
  GFL_PRINT("SeqEditor LoadFile size[%x]\n",size);
#endif

  InitLoadData();
  LoadHeader();

}

SeqFile::SeqFile( SeqSystem *system , gfl::heap::HeapBase *heapMem , wchar_t *path )
:mSystem(system)
{
  gfl::fs::HioFile file;
  
  const bool ret = file.Open( path , gfl::fs::OPEN_MODE_READ );
  if( ret )
  {
    const size_t size = file.GetSize();
    mSeqData = GflHeapAllocMemory( heapMem , size );
    
    file.Read( mSeqData , size );
#if SEQ_EDITOR_DEBUG 
    GFL_PRINT("SeqEditor LoadPcFile size[%x]\n",size);
#endif
    
    file.Close();
    
    InitLoadData();
    LoadHeader();
  }
}

SeqFile::~SeqFile()
{
  if( mSeqData )
  {
    GflHeapFreeMemory( mSeqData );
  }
}

void SeqFile::InitLoadData(void)
{
  mLoadPos = (char*)mSeqData;

  mFrame = 0;
  mIsFinish = false;
}

void SeqFile::LoadHeader(void)
{
  char fileHeader[5] = {0};
  int mainVer,subVer;
  
  gfl::std::MemCopy( mLoadPos , fileHeader , 4 );
  mLoadPos += 4;
  LoadDataInt( &mainVer );
  LoadDataInt( &subVer );

#if SEQ_EDITOR_DEBUG 
  GFL_PRINT("SeqEditor Header[%4s] Version[%d.%d]\n",fileHeader,mainVer,subVer);
#endif
  
}

void SeqFile::UpdateFrame()
{
  if( !mIsFinish )
  {
    int frame;
    const SEQEDITOR_COMMAND_FUNC *comTbl = mSystem->GetCommandTable();
    const int comNum = mSystem->GetCommandNum();
    
    do
    {
      LoadDataInt( &frame , false );
      if( frame == mFrame )
      {
        s32 sFrame,eFrame;
        u16 comNo;
        LoadDataInt( &sFrame );
        LoadDataInt( &eFrame );
        LoadDatau16( &comNo );
        
        if( comNo < comNum )
        {
          const CommandParam param =
          {
            sFrame,
            eFrame,
            0
          };
          comTbl[comNo](this,mUserWork,param);
        }
      }
      if( frame == -1 )
      {
        mIsFinish = true;
        break;
      }
      
      
    }while( frame == mFrame );
    
    mFrame++;
    
  }
}

void SeqFile::LoadDataInt( int *data , bool isStep )
{
  gfl::std::MemCopy( mLoadPos , data , 4 );
  if(isStep)
  {
    mLoadPos += 4;
  }
}

void SeqFile::LoadDatau16( u16 *data , bool isStep )
{
  gfl::std::MemCopy( mLoadPos , data , 2 );
  if(isStep)
  {
    mLoadPos += 2;
  }
}

};
};

